*pbp_Section_C_CSR.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_Section_C_CSR;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_c_csr_outpt_group_num_id     $2
	pbp_c_csr_outpt_bendesc_cats     $47
	pbp_c_csr_group_lbl              $40
	pbp_c_csr_outpt_coins_yn         $1
	pbp_c_csr_outpt_coins_cov        $1
	pbp_c_csr_outpt_copay_yn         $1
	pbp_c_csr_outpt_ded_yn           $1
;

infile '.\pbp\pbp_Section_C_CSR.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_c_csr_outpt_group_num_id
	pbp_c_csr_outpt_bendesc_cats
	pbp_c_csr_group_lbl
	pbp_c_csr_outpt_coins_yn
	pbp_c_csr_outpt_coins_min_pct
	pbp_c_csr_outpt_coins_max_pct
	pbp_c_csr_outpt_coins_cov
	pbp_c_csr_outpt_copay_yn
	pbp_c_csr_outpt_copay_min_amt
	pbp_c_csr_outpt_copay_max_amt
	pbp_c_csr_outpt_ded_yn
	pbp_c_csr_outpt_ded_amt
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_c_csr_outpt_group_num_id     = 'CSR Group ID'
	pbp_c_csr_outpt_bendesc_cats     = 'CSR Out Pt Benefit Cats'
	pbp_c_csr_group_lbl              = 'CSR Group Label'
	pbp_c_csr_outpt_coins_yn         = 'CSR Out Pt Coinsurance YN'
	pbp_c_csr_outpt_coins_min_pct    = 'CSR Out Pt Min Coins Pct'
	pbp_c_csr_outpt_coins_max_pct    = 'CSR Out Pt Max Coins Pct'
	pbp_c_csr_outpt_coins_cov        = 'CSR Out Pt Coins Cov'
	pbp_c_csr_outpt_copay_yn         = 'CSR Out Pt Copay YN'
	pbp_c_csr_outpt_copay_min_amt    = 'CSR Out Pt Copayment Min Amt'
	pbp_c_csr_outpt_copay_max_amt    = 'CSR Out Pt Copayment Max Amt'
	pbp_c_csr_outpt_ded_yn           = 'CSR Out Pt Deductible YN'
	pbp_c_csr_outpt_ded_amt          = 'CSR Out Pt Deductible Amt'
;

run;

proc sort data = pbp_Section_C_CSR out=out.pbp_Section_C_CSR;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_Section_C_CSR(obs = 10);
  title 'pbp_Section_C_CSR file ';
run;

proc means data = out.pbp_Section_C_CSR;
  title 'pbp_Section_C_CSR file ';
run;

proc freq data = out.pbp_Section_C_CSR;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_c_csr_outpt_group_num_id
	pbp_c_csr_outpt_coins_yn
	pbp_c_csr_outpt_coins_cov
	pbp_c_csr_outpt_copay_yn
	pbp_c_csr_outpt_ded_yn
/ missing;
run;

proc contents data = out.pbp_Section_C_CSR;
  title 'pbp_Section_C_CSR data';
run;
