*pbp_Section_D.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_Section_D;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_d_comb_deduct_yn             $1
	pbp_d_comb_deduct_all_svcs_yn    $1
	pbp_d_comb_deduct_services       $51
	pbp_d_comb_deduct_type           $1
	pbp_d_inn_deduct_yn              $1
	pbp_d_inn_deduct_all_svcs_yn     $1
	pbp_d_inn_deduct_services        $51
	pbp_d_inn_deduct_type            $1
	pbp_d_oon_deduct_yn              $1
	pbp_d_oon_deduct_all_svcs_yn     $1
	pbp_d_oon_deduct_services        $51
	pbp_d_oon_deduct_type            $1
	pbp_d_comb_max_enr_amt_yn        $1
	pbp_d_comb_max_enr_period        $1
	pbp_d_comb_max_enr_all_svcs_yn   $1
	pbp_d_comb_max_enr_services      $51
	pbp_d_comb_max_enr_type          $1
	pbp_d_comb_max_mc_only_flag      $1
	pbp_d_out_pocket_mc_only_flag    $1
	pbp_d_out_pocket_amt_yn          $1
	pbp_d_out_pocket_period          $1
	pbp_d_out_pocket_all_svcs_yn     $1
	pbp_d_out_pocket_services        $52
	pbp_d_out_pocket_type            $1
	pbp_d_max_plan_ben_cov_yn        $1
	pbp_d_max_plan_period            $1
	pbp_d_max_plan_ben_all_svcs_yn   $1
	pbp_d_max_plan_ben_services      $51
	pbp_d_mco_pay_reduct_yn          $1
;

infile '.\pbp\pbp_Section_D.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_d_comb_deduct_yn
	pbp_d_comb_deduct_amt
	pbp_d_comb_deduct_all_svcs_yn
	pbp_d_comb_deduct_services
	pbp_d_comb_deduct_type
	pbp_d_comb_mc_ben_only_amt
	pbp_d_inn_deduct_yn
	pbp_d_inn_deduct_amt
	pbp_d_inn_deduct_all_svcs_yn
	pbp_d_inn_deduct_services
	pbp_d_inn_deduct_type
	pbp_d_inn_mc_ben_only_amt
	pbp_d_oon_deduct_yn
	pbp_d_oon_deduct_amt
	pbp_d_oon_deduct_all_svcs_yn
	pbp_d_oon_deduct_services
	pbp_d_oon_deduct_type
	pbp_d_oon_mc_ben_only_amt
	pbp_d_msa_ded_amt
	pbp_d_msa_annual_amt
	pbp_d_comb_max_enr_amt_yn
	pbp_d_comb_max_enr_amt
	pbp_d_comb_max_enr_period
	pbp_d_comb_max_enr_all_svcs_yn
	pbp_d_comb_max_enr_services
	pbp_d_comb_max_enr_type
	pbp_d_comb_max_enr_mc_only_amt
	pbp_d_comb_max_mc_only_flag
	pbp_d_out_pocket_mc_only_flag
	pbp_d_out_pocket_amt_yn
	pbp_d_out_pocket_amt
	pbp_d_out_pocket_period
	pbp_d_out_pocket_all_svcs_yn
	pbp_d_out_pocket_services
	pbp_d_out_pocket_type
	pbp_d_out_pocket_mc_only_amt
	pbp_d_max_plan_ben_cov_yn
	pbp_d_max_plan_ben_cov
	pbp_d_max_plan_period
	pbp_d_max_plan_ben_all_svcs_yn
	pbp_d_max_plan_ben_services
	pbp_d_mplusc_premium
	pbp_d_mplusc_bonly_premium
	pbp_d_mco_pay_reduct_yn
	pbp_d_mco_pay_reduct_amt
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_d_comb_deduct_yn             = 'Plan Deductible YN'
	pbp_d_comb_deduct_amt            = 'Plan Deductible Amt'
	pbp_d_comb_deduct_all_svcs_yn    = 'Plan Dedct Apply All Servs YN'
	pbp_d_comb_deduct_services       = 'Serv Cats Plan Deduct'
	pbp_d_comb_deduct_type           = 'Deduct Type for Serv Cats'
	pbp_d_comb_mc_ben_only_amt       = 'Med Ben only amt'
	pbp_d_inn_deduct_yn              = 'In- Ntwk Plan Deductible YN'
	pbp_d_inn_deduct_amt             = 'In-Ntwk Plan Deductible Amt'
	pbp_d_inn_deduct_all_svcs_yn     = 'Plan Dedct Apply All Servs YN'
	pbp_d_inn_deduct_services        = 'Serv Cats Plan Deduct'
	pbp_d_inn_deduct_type            = 'Deduct Type for Serv Cats'
	pbp_d_inn_mc_ben_only_amt        = 'Med Ben only amt'
	pbp_d_oon_deduct_yn              = 'Plan Deductible YN'
	pbp_d_oon_deduct_amt             = 'Plan Deductible Amt'
	pbp_d_oon_deduct_all_svcs_yn     = 'Plan Dedct Apply All Servs YN'
	pbp_d_oon_deduct_services        = 'Serv Cats Plan Deduct'
	pbp_d_oon_deduct_type            = 'Deduct Type for Serv Cats'
	pbp_d_oon_mc_ben_only_amt        = 'Med Ben only amt'
	pbp_d_msa_ded_amt                = 'MSA Ded Amt'
	pbp_d_msa_annual_amt             = 'Annual MSA Deposit Amt'
	pbp_d_comb_max_enr_amt_yn        = 'Max Enr Amt YN'
	pbp_d_comb_max_enr_amt           = 'Max Enr Amt'
	pbp_d_comb_max_enr_period        = 'Max Enr Per (non-POS)'
	pbp_d_comb_max_enr_all_svcs_yn   = 'Max Enr Cost Apply All Svcs'
	pbp_d_comb_max_enr_services      = 'Max Enr Cost Serv Cats'
	pbp_d_comb_max_enr_type          = 'Max Enr Type for Serv Cats'
	pbp_d_comb_max_enr_mc_only_amt   = 'Max Enr Out Pocket Amt Med Ben'
	pbp_d_comb_max_mc_only_flag      = 'Max Enr MC Amt Edit Flag'
	pbp_d_out_pocket_mc_only_flag    = 'Max Enr MC Amt Edit Flag'
	pbp_d_out_pocket_amt_yn          = 'Max Enr Amt YN'
	pbp_d_out_pocket_amt             = 'Max Enr Amt'
	pbp_d_out_pocket_period          = 'Max Enr Per (non-POS)'
	pbp_d_out_pocket_all_svcs_yn     = 'Max Enr Cost Apply All Svcs'
	pbp_d_out_pocket_services        = 'Max Enr Cost Serv Cats'
	pbp_d_out_pocket_type            = 'Max Enr Type for Serv Cats'
	pbp_d_out_pocket_mc_only_amt     = 'Max Enr Out Pocket Amt Med Ben'
	pbp_d_max_plan_ben_cov_yn        = 'Max Plan YN'
	pbp_d_max_plan_ben_cov           = 'Max Plan Amt (non-POS)'
	pbp_d_max_plan_period            = 'Max Plan Per (non-POS)'
	pbp_d_max_plan_ben_all_svcs_yn   = 'Max Plan All Serv YN'
	pbp_d_max_plan_ben_services      = 'Max Plan Bene Cov Applctn'
	pbp_d_mplusc_premium             = 'Indicate Plan Premium Amt (AB)'
	pbp_d_mplusc_bonly_premium       = 'Indicate Plan Premium Amt (B)'
	pbp_d_mco_pay_reduct_yn          = 'MA Reduce Part B Premium YN'
	pbp_d_mco_pay_reduct_amt         = 'Part B Premium Reduction Amt'
;

run;

proc sort data = pbp_Section_D out=out.pbp_Section_D;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_Section_D(obs = 10);
  title 'pbp_Section_D file ';
run;

proc means data = out.pbp_Section_D;
  title 'pbp_Section_D file ';
run;

proc freq data = out.pbp_Section_D;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_d_comb_deduct_yn
	pbp_d_comb_deduct_all_svcs_yn
	pbp_d_comb_deduct_type
	pbp_d_inn_deduct_yn
	pbp_d_inn_deduct_all_svcs_yn
	pbp_d_inn_deduct_type
	pbp_d_oon_deduct_yn
	pbp_d_oon_deduct_all_svcs_yn
	pbp_d_oon_deduct_type
	pbp_d_comb_max_enr_amt_yn
	pbp_d_comb_max_enr_period
	pbp_d_comb_max_enr_all_svcs_yn
	pbp_d_comb_max_enr_type
	pbp_d_comb_max_mc_only_flag
	pbp_d_out_pocket_mc_only_flag
	pbp_d_out_pocket_amt_yn
	pbp_d_out_pocket_period
	pbp_d_out_pocket_all_svcs_yn
	pbp_d_out_pocket_type
	pbp_d_max_plan_ben_cov_yn
	pbp_d_max_plan_period
	pbp_d_max_plan_ben_all_svcs_yn
	pbp_d_mco_pay_reduct_yn
/ missing;
run;

proc contents data = out.pbp_Section_D;
  title 'pbp_Section_D data';
run;
