*pbp_mrx.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	mrx_b_max_oop_yn                 $1
	mrx_b_max_oop_per                $1
	mrx_b_coins_yn                   $1
	mrx_b_coins_covbasis             $2
	mrx_b_ded_yn                     $1
	mrx_b_copay_yn                   $1
	mrx_b_auth_yn                    $1
	mrx_drug_ben_yn                  $1
	mrx_formulary_yn                 $1
	mrx_quantity_limits              $1
	mrx_auth_ynba                    $1
	mrx_step_ther_drugs_yn           $1
	mrx_first_fill                   $1
	mrx_benefit_type                 $1
	mrx_demo_yn                      $1
	mrx_demo_type                    $1
	mrx_partd_network_loc            $5
	mrx_ae_copay_lesser_yn           $1
	mrx_ae_oon_cstshr_struct         $1
	mrx_ae_cstshr_apply              $1
	mrx_ae_ooptcs_apply              $1
	mrx_alt_ded_charge               $1
	mrx_alt_ded_type_yn              $1
	mrx_alt_copay_lesser_yn          $1
	mrx_alt_gen_cstshr_struct        $1
	mrx_alt_oon_cstshr_struct        $1
	mrx_alt_excl_drugs_yn            $1
	mrx_alt_excl_drugs_maxplan_yn    $1
	mrx_alt_red_cost_sharing         $1
	mrx_alt_red_cost_sharing_items   $4
	mrx_alt_pre_icl_cost_share       $1
	mrx_alt_cov_lmt_yn               $1
	mrx_alt_gap_covg_yn              $1
	mrx_alt_cstshr_post_oopt         $1
	mrx_gen_loc                      $21
;

infile '.\pbp\pbp_mrx.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	mrx_b_max_oop_yn
	mrx_b_max_oop_amt
	mrx_b_max_oop_per
	mrx_b_coins_yn
	mrx_b_coins_pct
	mrx_b_coins_covbasis
	mrx_b_coins_prp_disc
	mrx_b_coins_min_dispfee
	mrx_b_coins_max_dispfee
	mrx_b_coins_awp_disc
	mrx_b_coins_amt_maacqcost
	mrx_b_ded_yn
	mrx_b_ded_amt
	mrx_b_copay_yn
	mrx_b_copay_min_amt
	mrx_b_copay_max_amt
	mrx_b_auth_yn
	mrx_drug_ben_yn
	mrx_formulary_yn
	mrx_formulary_tiers_num
	mrx_quantity_limits
	mrx_auth_ynba
	mrx_step_ther_drugs_yn
	mrx_first_fill
	mrx_benefit_type
	mrx_demo_yn
	mrx_demo_type
	mrx_partd_network_loc
	mrx_ae_copay_lesser_yn
	mrx_ae_oon_cstshr_struct
	mrx_ae_cstshr_apply
	mrx_ae_ooptcs_apply
	mrx_alt_ded_charge
	mrx_alt_ded_amount
	mrx_alt_ded_type_yn
	mrx_alt_copay_lesser_yn
	mrx_alt_gen_cstshr_struct
	mrx_alt_oon_cstshr_struct
	mrx_alt_gen_coins_pct
	mrx_alt_gen_copay_amt
	mrx_alt_excl_drugs_yn
	mrx_alt_excl_drugs_maxplan_yn
	mrx_alt_excl_max_plan_amt
	mrx_alt_red_cost_sharing
	mrx_alt_red_cost_sharing_items
	mrx_alt_pre_icl_cost_share
	mrx_alt_cov_lmt_yn
	mrx_alt_cov_lmt_amt
	mrx_alt_gap_covg_yn
	mrx_alt_cstshr_post_oopt
	mrx_gen_loc
	mrx_gen_inp_1m
	mrx_gen_inp_3m
	mrx_gen_inp_os
	mrx_gen_inpp_1m
	mrx_gen_inpp_3m
	mrx_gen_inpp_os
	mrx_gen_innpp_1m
	mrx_gen_innpp_3m
	mrx_gen_innpp_os
	mrx_gen_oonp_1m
	mrx_gen_oonp_3m
	mrx_gen_oonp_os
	mrx_gen_mo_1m
	mrx_gen_mo_3m
	mrx_gen_mo_os
	mrx_gen_mopp_1m
	mrx_gen_mopp_3m
	mrx_gen_mopp_os
	mrx_gen_monpp_1m
	mrx_gen_monpp_3m
	mrx_gen_monpp_os
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	mrx_b_max_oop_yn                 = 'Part AB Max OOP YN'
	mrx_b_max_oop_amt                = 'Part AB Max OOP Amt'
	mrx_b_max_oop_per                = 'Part AB Max OOP Periodicity'
	mrx_b_coins_yn                   = 'Part AB Coinsurance YN'
	mrx_b_coins_pct                  = 'Part AB Coinsurance Pct'
	mrx_b_coins_covbasis             = 'Part AB Coins Coverage Basis'
	mrx_b_coins_prp_disc             = 'A/B Coins Pub Ret Price Disc'
	mrx_b_coins_min_dispfee          = 'A/B Coins Min Dispense Fee'
	mrx_b_coins_max_dispfee          = 'A/B Coins Max Dispense Fee'
	mrx_b_coins_awp_disc             = 'A/B Coins AWP Disc'
	mrx_b_coins_amt_maacqcost        = 'A/B Coins Amt Over MA Cost'
	mrx_b_ded_yn                     = 'Part AB Deductible YN'
	mrx_b_ded_amt                    = 'Part AB Deductible Amt'
	mrx_b_copay_yn                   = 'Part AB Copayment YN'
	mrx_b_copay_min_amt              = 'Part AB Copay Min Amt'
	mrx_b_copay_max_amt              = 'Part AB Copay Max Amt'
	mrx_b_auth_yn                    = 'Part AB Authorization YN'
	mrx_drug_ben_yn                  = 'MRX DRUG BEN YN'
	mrx_formulary_yn                 = 'Formulary YN'
	mrx_formulary_tiers_num          = 'Formulary Tiers Num'
	mrx_quantity_limits              = 'Quantity limits YN'
	mrx_auth_ynba                    = 'Authorization YN'
	mrx_step_ther_drugs_yn           = 'Step Therapy Drugs YN'
	mrx_first_fill                   = 'MRx First Fill'
	mrx_benefit_type                 = 'Drug Benefit Type'
	mrx_demo_yn                      = 'MRx Demo YN'
	mrx_demo_type                    = 'MRx Demo Type'
	mrx_partd_network_loc            = 'MRx PartD Network Location'
	mrx_ae_copay_lesser_yn           = 'MRx AE Copay lesser YN'
	mrx_ae_oon_cstshr_struct         = 'MRx AE Cstshr Structure'
	mrx_ae_cstshr_apply              = 'AE Cost Share Pre-Intl Cov Lmt'
	mrx_ae_ooptcs_apply              = 'AE OOP Threshold Application'
	mrx_alt_ded_charge               = 'BA Deductible Charged YN'
	mrx_alt_ded_amount               = 'MRx Alt Deductible Amount'
	mrx_alt_ded_type_yn              = 'BA Ded Type YN'
	mrx_alt_copay_lesser_yn          = 'MRx BA Copay lesser YN'
	mrx_alt_gen_cstshr_struct        = 'MRx BA Cstshr Structure'
	mrx_alt_oon_cstshr_struct        = 'BA DON Cost Share Structure'
	mrx_alt_gen_coins_pct            = 'MRx Alt Coins Pct'
	mrx_alt_gen_copay_amt            = 'MRx Alt Copay Amt'
	mrx_alt_excl_drugs_yn            = 'Excluded supp drugs'
	mrx_alt_excl_drugs_maxplan_yn    = 'NONPD_MAXPLAN_YN'
	mrx_alt_excl_max_plan_amt        = 'MRx Alt Max Plan Amt Exc Drugs'
	mrx_alt_red_cost_sharing         = 'MRx Red Cost Sharing'
	mrx_alt_red_cost_sharing_items   = 'MRx Red Cost Sharing Items'
	mrx_alt_pre_icl_cost_share       = 'EA Cost Share Pre-Intl Cov Lmt'
	mrx_alt_cov_lmt_yn               = 'MRx Alt Cov Lmt YN'
	mrx_alt_cov_lmt_amt              = 'MRx Alt Cov Lmt Amt'
	mrx_alt_gap_covg_yn              = 'MRx Alt Gap Covg YN'
	mrx_alt_cstshr_post_oopt         = 'MRx Alt Cstshr Post OOPT'
	mrx_gen_loc                      = 'General Location'
	mrx_gen_inp_1m                   = 'Gen INP 1M Supply Days'
	mrx_gen_inp_3m                   = 'Gen INP 3M Supply Days'
	mrx_gen_inp_os                   = 'Gen INP Oth Supply Days'
	mrx_gen_inpp_1m                  = 'Gen INPP 1M Supply Days'
	mrx_gen_inpp_3m                  = 'Gen INPP 3M Supply Days'
	mrx_gen_inpp_os                  = 'Gen INPP Oth Supply Days'
	mrx_gen_innpp_1m                 = 'Gen INNPP 1M Supply Days'
	mrx_gen_innpp_3m                 = 'Gen INNPP 3M Supply Days'
	mrx_gen_innpp_os                 = 'Gen INNPP Oth Supply Days'
	mrx_gen_oonp_1m                  = 'Gen OONP 1M Supply Days'
	mrx_gen_oonp_3m                  = 'Gen OONP 3M Supply Days'
	mrx_gen_oonp_os                  = 'Gen OONP Oth Supply Days'
	mrx_gen_mo_1m                    = 'Gen MO 1M Supply Days'
	mrx_gen_mo_3m                    = 'Gen MO 3M Supply Days'
	mrx_gen_mo_os                    = 'Gen MO Oth Supply Days'
	mrx_gen_mopp_1m                  = 'Gen MOPP 1M Supply Days'
	mrx_gen_mopp_3m                  = 'Gen MOPP 3M Supply Days'
	mrx_gen_mopp_os                  = 'Gen MOPP Oth Supply Days'
	mrx_gen_monpp_1m                 = 'Gen MONPP 1M Supply Days'
	mrx_gen_monpp_3m                 = 'Gen MONPP 3M Supply Days'
	mrx_gen_monpp_os                 = 'Gen MONPP Oth Supply Days'
;

run;

proc sort data = pbp_mrx out=out.pbp_mrx;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx(obs = 10);
  title 'pbp_mrx file ';
run;

proc means data = out.pbp_mrx;
  title 'pbp_mrx file ';
run;

proc freq data = out.pbp_mrx;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	mrx_b_max_oop_yn
	mrx_b_max_oop_per
	mrx_b_coins_yn
	mrx_b_coins_covbasis
	mrx_b_ded_yn
	mrx_b_copay_yn
	mrx_b_auth_yn
	mrx_drug_ben_yn
	mrx_formulary_yn
	mrx_quantity_limits
	mrx_auth_ynba
	mrx_step_ther_drugs_yn
	mrx_first_fill
	mrx_benefit_type
	mrx_demo_yn
	mrx_demo_type
	mrx_partd_network_loc
	mrx_ae_copay_lesser_yn
	mrx_ae_oon_cstshr_struct
	mrx_ae_cstshr_apply
	mrx_ae_ooptcs_apply
	mrx_alt_ded_charge
	mrx_alt_ded_type_yn
	mrx_alt_copay_lesser_yn
	mrx_alt_gen_cstshr_struct
	mrx_alt_oon_cstshr_struct
	mrx_alt_excl_drugs_yn
	mrx_alt_excl_drugs_maxplan_yn
	mrx_alt_red_cost_sharing
	mrx_alt_red_cost_sharing_items
	mrx_alt_pre_icl_cost_share
	mrx_alt_cov_lmt_yn
	mrx_alt_gap_covg_yn
	mrx_alt_cstshr_post_oopt
/ missing;
run;

proc contents data = out.pbp_mrx;
  title 'pbp_mrx data';
run;
