*pbp_mrx_tier.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx_tier;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	mrx_tier_id                      $2
	mrx_tier_type_id                 $2
	mrx_tier_lbl                     $50
	mrx_tier_drug_type               $6
	mrx_tier_includes                $1
	mrx_tier_spec_yn                 $1
	mrx_tier_lbl_5                   $50
	mrx_tier_locat                   $21
	mrx_tier_lbl_4                   $50
	mrx_tier_ref_price_yn            $1
	mrx_tier_cstshr_struct_type      $1
	mrx_tier_locat_coins             $21
	mrx_tier_locat_copay             $21
	mrx_tier_lbl_2                   $50
	mrx_tier_lbl_6                   $50
	mrx_tier_gap_cost_share          $1
	mrx_tier_benefit_type            $1
;

infile '.\pbp\pbp_mrx_tier.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	mrx_tier_id
	mrx_tier_type_id
	mrx_tier_lbl
	mrx_tier_drug_type
	mrx_tier_includes
	mrx_tier_spec_yn
	mrx_tier_lbl_5
	mrx_tier_locat
	mrx_tier_inp_1m_num
	mrx_tier_inp_3m_num
	mrx_tier_inp_othnum
	mrx_tier_inpp_1m_num
	mrx_tier_inpp_3m_num
	mrx_tier_inpp_othnum
	mrx_tier_innpp_1m_num
	mrx_tier_innpp_3m_num
	mrx_tier_innpp_othnum
	mrx_tier_oonp_1m_num
	mrx_tier_oonp_3m_num
	mrx_tier_oonp_othnumn
	mrx_tier_mo_1m_num
	mrx_tier_mo_3m_num
	mrx_tier_mo_othnum
	mrx_tier_mopp_1m_num
	mrx_tier_mopp_3m_num
	mrx_tier_mopp_othnum
	mrx_tier_monpp_1m_num
	mrx_tier_monpp_3m_num
	mrx_tier_monpp_othnum
	mrx_tier_lbl_4
	mrx_tier_ref_price_yn
	mrx_tier_cstshr_struct_type
	mrx_tier_locat_coins
	mrx_tier_locat_copay
	mrx_tier_lbl_2
	mrx_tier_inp_coins_1m
	mrx_tier_inp_coins_3m
	mrx_tier_inp_coins_othnum
	mrx_tier_inpp_coins_1m
	mrx_tier_inpp_coins_3m
	mrx_tier_inpp_coins_othnum
	mrx_tier_innpp_coins_1m
	mrx_tier_innpp_coins_3m
	mrx_tier_innpp_coins_othnum
	mrx_tier_oonp_coins_1m
	mrx_tier_oonp_coins_3m
	mrx_tier_oonp_coins_othnum
	mrx_tier_mo_coins_1m
	mrx_tier_mo_coins_3m
	mrx_tier_mo_coins_othnum
	mrx_tier_mopp_coins_1m
	mrx_tier_mopp_coins_3m
	mrx_tier_mopp_coins_othnum
	mrx_tier_monpp_coins_1m
	mrx_tier_monpp_coins_3m
	mrx_tier_monpp_coins_othnum
	mrx_tier_lbl_6
	mrx_tier_inp_copay_1m
	mrx_tier_inp_copay_3m
	mrx_tier_inp_copay_othnum
	mrx_tier_inpp_copay_1m
	mrx_tier_inpp_copay_3m
	mrx_tier_inpp_copay_othnum
	mrx_tier_innpp_copay_1m
	mrx_tier_innpp_copay_3m
	mrx_tier_innpp_copay_othnum
	mrx_tier_oonp_copay_1m
	mrx_tier_oonp_copay_3m
	mrx_tier_oonp_copay_othnum
	mrx_tier_mo_copay_1m
	mrx_tier_mo_copay_3m
	mrx_tier_mo_copay_othnum
	mrx_tier_mopp_copay_1m
	mrx_tier_mopp_copay_3m
	mrx_tier_mopp_copay_othnum
	mrx_tier_monpp_copay_1m
	mrx_tier_monpp_copay_3m
	mrx_tier_monpp_copay_othnum
	mrx_tier_gap_cost_share
	mrx_tier_benefit_type
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	mrx_tier_id                      = 'Tier ID'
	mrx_tier_type_id                 = 'Tier Type ID'
	mrx_tier_lbl                     = 'Grp Tier Label'
	mrx_tier_drug_type               = 'Tier Drug Types'
	mrx_tier_includes                = 'MRX Tier Includes'
	mrx_tier_spec_yn                 = 'Specialty Tier'
	mrx_tier_lbl_5                   = 'Medicare Rx Tier Label'
	mrx_tier_locat                   = 'Group Location'
	mrx_tier_inp_1m_num              = 'Tier INP 1M Supply Days'
	mrx_tier_inp_3m_num              = 'Tier INP 3M Supply Days'
	mrx_tier_inp_othnum              = 'Tier INP Oth Supply Days'
	mrx_tier_inpp_1m_num             = 'Tier INPP 1M Supply Days'
	mrx_tier_inpp_3m_num             = 'Tier INPP 3M Supply Days'
	mrx_tier_inpp_othnum             = 'Tier INPP Oth Supply Days'
	mrx_tier_innpp_1m_num            = 'Tier INNPP 1M Supply Days'
	mrx_tier_innpp_3m_num            = 'Tier INNPP 3M Supply Days'
	mrx_tier_innpp_othnum            = 'Tier INNPP Oth Supply Days'
	mrx_tier_oonp_1m_num             = 'Tier OONP 1M Supply Days'
	mrx_tier_oonp_3m_num             = 'Tier OONP 3M Supply Days'
	mrx_tier_oonp_othnumn            = 'Tier OONP Oth Supply Days'
	mrx_tier_mo_1m_num               = 'Tier MO 1M Supply Days'
	mrx_tier_mo_3m_num               = 'Tier MO 3M Supply Days'
	mrx_tier_mo_othnum               = 'Tier MO Oth Supply Days'
	mrx_tier_mopp_1m_num             = 'Tier MOPP 1M Supply Days'
	mrx_tier_mopp_3m_num             = 'Tier MOPP 3M Supply Days'
	mrx_tier_mopp_othnum             = 'Tier MOPP Oth Supply Days'
	mrx_tier_monpp_1m_num            = 'Tier MONPP 1M Supply Days'
	mrx_tier_monpp_3m_num            = 'Tier MONPP 3M Supply Days'
	mrx_tier_monpp_othnum            = 'Tier MONPP Oth Supply Days'
	mrx_tier_lbl_4                   = 'Medicare Rx Grp Tier Label'
	mrx_tier_ref_price_yn            = 'MRx Ref prcng YN'
	mrx_tier_cstshr_struct_type      = 'MRx Cost Share Tier Struct'
	mrx_tier_locat_coins             = 'Group Location Coinsurance'
	mrx_tier_locat_copay             = 'Group Location Copayment'
	mrx_tier_lbl_2                   = 'Medicare Rx Grp Tier Label'
	mrx_tier_inp_coins_1m            = 'Tier INP Coins 1M'
	mrx_tier_inp_coins_3m            = 'Tier INP Coins 3M'
	mrx_tier_inp_coins_othnum        = 'Tier INP Coins Oth'
	mrx_tier_inpp_coins_1m           = 'Tier INPP Coins 1M'
	mrx_tier_inpp_coins_3m           = 'Tier INPP Coins 3M'
	mrx_tier_inpp_coins_othnum       = 'Tier INPP Coins Oth'
	mrx_tier_innpp_coins_1m          = 'Tier INNPP Coins 1M'
	mrx_tier_innpp_coins_3m          = 'Tier INNPP Coins 3M'
	mrx_tier_innpp_coins_othnum      = 'Tier INNPP Coins Oth'
	mrx_tier_oonp_coins_1m           = 'Tier OONP Coins 1M'
	mrx_tier_oonp_coins_3m           = 'Tier OONP Coins 3M'
	mrx_tier_oonp_coins_othnum       = 'Tier OONP Coins Oth'
	mrx_tier_mo_coins_1m             = 'Tier MO Coins 1M'
	mrx_tier_mo_coins_3m             = 'Tier MO Coins 3M'
	mrx_tier_mo_coins_othnum         = 'Tier MO Coins Oth'
	mrx_tier_mopp_coins_1m           = 'Tier MOPP Coins 1M'
	mrx_tier_mopp_coins_3m           = 'Tier MOPP Coins 3M'
	mrx_tier_mopp_coins_othnum       = 'Tier MOPP Coins Oth'
	mrx_tier_monpp_coins_1m          = 'Tier MONPP Coins 1M'
	mrx_tier_monpp_coins_3m          = 'Tier MONPP Coins 3M'
	mrx_tier_monpp_coins_othnum      = 'Tier MONPP Coins Oth'
	mrx_tier_lbl_6                   = 'Medicare Rx Tier Label'
	mrx_tier_inp_copay_1m            = 'Tier INP Copay 1M'
	mrx_tier_inp_copay_3m            = 'Tier INP Copay 3M'
	mrx_tier_inp_copay_othnum        = 'Tier INP Copay Oth'
	mrx_tier_inpp_copay_1m           = 'Tier INPP Copay 1M'
	mrx_tier_inpp_copay_3m           = 'Tier INPP Copay 3M'
	mrx_tier_inpp_copay_othnum       = 'Tier INPP Copay Oth'
	mrx_tier_innpp_copay_1m          = 'Tier INNPP Copay 1M'
	mrx_tier_innpp_copay_3m          = 'Tier INNPP Copay 3M'
	mrx_tier_innpp_copay_othnum      = 'Tier INNPP Copay Oth'
	mrx_tier_oonp_copay_1m           = 'Tier OONP Copay 1M'
	mrx_tier_oonp_copay_3m           = 'Tier OONP Copay 3M'
	mrx_tier_oonp_copay_othnum       = 'Tier OONP Copay Oth'
	mrx_tier_mo_copay_1m             = 'Tier MO Copay 1M'
	mrx_tier_mo_copay_3m             = 'Tier MO Copay 3M'
	mrx_tier_mo_copay_othnum         = 'Tier MO Copay Oth'
	mrx_tier_mopp_copay_1m           = 'Tier MOPP Copay 1M'
	mrx_tier_mopp_copay_3m           = 'Tier MOPP Copay 3M'
	mrx_tier_mopp_copay_othnum       = 'Tier MOPP Copay Oth'
	mrx_tier_monpp_copay_1m          = 'Tier MONPP Copay 1M'
	mrx_tier_monpp_copay_3m          = 'Tier MONPP Copay 3M'
	mrx_tier_monpp_copay_othnum      = 'Tier MONPP Copay Oth'
	mrx_tier_gap_cost_share          = 'MRX Gap Cost Share'
	mrx_tier_benefit_type            = 'Drug Benefit Type - Tier'
;

run;

proc sort data = pbp_mrx_tier out=out.pbp_mrx_tier;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx_tier(obs = 10);
  title 'pbp_mrx_tier file ';
run;

proc means data = out.pbp_mrx_tier;
  title 'pbp_mrx_tier file ';
run;

proc freq data = out.pbp_mrx_tier;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	mrx_tier_id
	mrx_tier_type_id
	mrx_tier_includes
	mrx_tier_spec_yn
	mrx_tier_ref_price_yn
	mrx_tier_cstshr_struct_type
	mrx_tier_gap_cost_share
	mrx_tier_benefit_type
/ missing;
run;

proc contents data = out.pbp_mrx_tier;
  title 'pbp_mrx_tier data';
run;
