*pbp_Section_C_2.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_Section_C_2;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_c_vt_us_coins_snf_yn         $1
	pbp_c_csr_coins_snf_yn           $1
	pbp_c_vt_us_coins_snf_int_num    $1
	pbp_c_csr_coins_snf_intrvl_num   $1
	pbp_c_vt_us_coins_snf_cov        $1
	pbp_c_csr_coins_snf_cov          $1
	pbp_c_vt_us_copay_snf_yn         $1
	pbp_c_csr_copay_snf_yn           $1
	pbp_c_vt_us_copay_snf_int_num    $1
	pbp_c_csr_copay_snf_intrvl_num   $1
	pbp_c_vt_us_snf_ded_yn           $1
	pbp_c_csr_snf_ded_yn             $1
	pbp_c_csr_yn                     $1
	pbp_c_csr_bendesc_subcats        $51
	pbp_c_csr_coins_ihs_ben_type     $2
	pbp_c_csr_coins_ihs_yn           $1
	pbp_c_csr_coins_iha_intrvl_num   $1
	pbp_c_csr_coins_iph_intrvl_num   $1
	pbp_c_csr_copay_ihs_yn           $1
	pbp_c_csr_copay_ihs_ben_type     $2
	pbp_c_csr_copay_iha_intrvl_num   $1
	pbp_c_csr_copay_iph_intrvl_num   $1
	pbp_c_csr_ihs_ded_yn             $1
	pbp_c_csr_ihs_ded_cost_type      $3
	pbp_c_vt_yn                      $1
	pbp_c_vt_mo                      $1
	pbp_c_vt_us_yn                   $1
	pbp_c_vt_us_bendesc_subcats      $51
	pbp_c_vt_us_maxplan_yn           $1
	pbp_c_vt_us_maxplan_subcats      $51
	pbp_c_vt_us_maxplan_per          $1
	pbp_c_vt_us_maxplan_cov          $1
	pbp_c_vt_us_auth_yn              $1
	pbp_c_vt_us_auth_subcats         $51
	pbp_c_vt_us_auth                 $5
	pbp_c_vt_us_referral_yn          $1
	pbp_c_vt_us_referral_subcats     $51
	pbp_c_vt_us_coins_ihs_yn         $1
	pbp_c_vt_us_coins_ihs_ben_type   $2
	pbp_c_vt_us_coins_iha_int_num    $1
	pbp_c_vt_us_coins_iha_cov        $1
	pbp_c_vt_us_coins_iph_int_num    $1
	pbp_c_vt_us_coins_iph_cov        $1
	pbp_c_vt_us_copay_ihs_yn         $1
	pbp_c_vt_us_copay_ihs_ben_type   $2
	pbp_c_vt_us_copay_iha_int_num    $1
	pbp_c_vt_us_copay_iph_int_num    $1
;

infile '.\pbp\pbp_Section_C_2.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_c_csr_coins_snf_yn
	pbp_c_vt_us_coins_snf_yn
	pbp_c_csr_coins_snf_pct
	pbp_c_vt_us_coins_snf_pct
	pbp_c_vt_us_coins_snf_int_num
	pbp_c_csr_coins_snf_intrvl_num
	pbp_c_csr_coins_snf_pct_i1
	pbp_c_vt_us_coins_snf_pct_i1
	pbp_c_csr_coins_snf_bgnd_i1
	pbp_c_vt_us_coins_snf_bgnd_i1
	pbp_c_csr_coins_snf_endd_i1
	pbp_c_vt_us_coins_snf_endd_i1
	pbp_c_vt_us_coins_snf_pct_i2
	pbp_c_csr_coins_snf_pct_i2
	pbp_c_vt_us_coins_snf_bgnd_i2
	pbp_c_csr_coins_snf_bgnd_i2
	pbp_c_vt_us_coins_snf_endd_i2
	pbp_c_csr_coins_snf_endd_i2
	pbp_c_vt_us_coins_snf_pct_i3
	pbp_c_csr_coins_snf_pct_i3
	pbp_c_vt_us_coins_snf_bgnd_i3
	pbp_c_csr_coins_snf_bgnd_i3
	pbp_c_vt_us_coins_snf_endd_i3
	pbp_c_csr_coins_snf_endd_i3
	pbp_c_csr_coins_snf_cov
	pbp_c_vt_us_coins_snf_cov
	pbp_c_csr_copay_snf_yn
	pbp_c_vt_us_copay_snf_yn
	pbp_c_vt_us_copay_snf_amt
	pbp_c_csr_copay_snf_amt
	pbp_c_csr_copay_snf_intrvl_num
	pbp_c_vt_us_copay_snf_int_num
	pbp_c_vt_us_copay_snf_amt_i1
	pbp_c_csr_copay_snf_amt_i1
	pbp_c_vt_us_copay_snf_bgnd_i1
	pbp_c_csr_copay_snf_bgnd_i1
	pbp_c_csr_copay_snf_endd_i1
	pbp_c_vt_us_copay_snf_endd_i1
	pbp_c_vt_us_copay_snf_amt_i2
	pbp_c_csr_copay_snf_amt_i2
	pbp_c_vt_us_copay_snf_bgnd_i2
	pbp_c_csr_copay_snf_bgnd_i2
	pbp_c_vt_us_copay_snf_endd_i2
	pbp_c_csr_copay_snf_endd_i2
	pbp_c_csr_copay_snf_amt_i3
	pbp_c_vt_us_copay_snf_amt_i3
	pbp_c_csr_copay_snf_bgnd_i3
	pbp_c_vt_us_copay_snf_bgnd_i3
	pbp_c_vt_us_copay_snf_endd_i3
	pbp_c_csr_copay_snf_endd_i3
	pbp_c_csr_snf_ded_yn
	pbp_c_vt_us_snf_ded_yn
	pbp_c_vt_us_snf_ded_amt
	pbp_c_csr_snf_ded_amt
	pbp_c_csr_yn
	pbp_c_csr_bendesc_subcats
	pbp_c_csr_coins_ihs_ben_type
	pbp_c_csr_coins_ihs_yn
	pbp_c_csr_coins_iha_pct
	pbp_c_csr_coins_iha_intrvl_num
	pbp_c_csr_coins_iha_pct_i1
	pbp_c_csr_coins_iha_bgnd_i1
	pbp_c_csr_coins_iha_endd_i1
	pbp_c_csr_coins_iha_pct_i2
	pbp_c_csr_coins_iha_bgnd_i2
	pbp_c_csr_coins_iha_endd_i2
	pbp_c_csr_coins_iha_pct_i3
	pbp_c_csr_coins_iha_bgnd_i3
	pbp_c_csr_coins_iha_endd_i3
	pbp_c_csr_coins_iph_pct
	pbp_c_csr_coins_iph_intrvl_num
	pbp_c_csr_coins_iph_pct_i1
	pbp_c_csr_coins_iph_bgnd_i1
	pbp_c_csr_coins_iph_endd_i1
	pbp_c_csr_coins_iph_pct_i2
	pbp_c_csr_coins_iph_bgnd_i2
	pbp_c_csr_coins_iph_endd_i2
	pbp_c_csr_coins_iph_pct_i3
	pbp_c_csr_coins_iph_bgnd_i3
	pbp_c_csr_coins_iph_endd_i3
	pbp_c_csr_copay_ihs_yn
	pbp_c_csr_copay_ihs_ben_type
	pbp_c_csr_copay_iha_ps_amt
	pbp_c_csr_copay_iha_intrvl_num
	pbp_c_csr_copay_iha_amt_i1
	pbp_c_csr_copay_iha_bgnd_i1
	pbp_c_csr_copay_iha_endd_i1
	pbp_c_csr_copay_iha_amt_i2
	pbp_c_csr_copay_iha_bgnd_i2
	pbp_c_csr_copay_iha_endd_i2
	pbp_c_csr_copay_iha_amt_i3
	pbp_c_csr_copay_iha_bgnd_i3
	pbp_c_csr_copay_iha_endd_i3
	pbp_c_csr_copay_iph_ps_amt
	pbp_c_csr_copay_iph_intrvl_num
	pbp_c_csr_copay_iph_amt_i1
	pbp_c_csr_copay_iph_bgnd_i1
	pbp_c_csr_copay_iph_endd_i1
	pbp_c_csr_copay_iph_amt_i2
	pbp_c_csr_copay_iph_bgnd_i2
	pbp_c_csr_copay_iph_endd_i2
	pbp_c_csr_copay_iph_amt_i3
	pbp_c_csr_copay_iph_bgnd_i3
	pbp_c_csr_copay_iph_endd_i3
	pbp_c_csr_ihs_ded_yn
	pbp_c_csr_ihs_ded_cost_type
	pbp_c_csr_ihs_ded_acu_amt
	pbp_c_csr_ihs_ded_psyc_amt
	pbp_c_csr_ihs_ded_comb_amt
	pbp_c_vt_yn
	pbp_c_vt_mo
	pbp_c_vt_us_yn
	pbp_c_vt_us_bendesc_subcats
	pbp_c_vt_us_maxplan_yn
	pbp_c_vt_us_maxplan_subcats
	pbp_c_vt_us_maxplan_amt
	pbp_c_vt_us_maxplan_per
	pbp_c_vt_us_maxplan_cov
	pbp_c_vt_us_auth_yn
	pbp_c_vt_us_auth_subcats
	pbp_c_vt_us_auth
	pbp_c_vt_us_referral_yn
	pbp_c_vt_us_referral_subcats
	pbp_c_vt_us_coins_ihs_yn
	pbp_c_vt_us_coins_ihs_ben_type
	pbp_c_vt_us_coins_iha_pct
	pbp_c_vt_us_coins_iha_int_num
	pbp_c_vt_us_coins_iha_pct_int1
	pbp_c_vt_us_coins_iha_bgnd_i1
	pbp_c_vt_us_coins_iha_endd_i1
	pbp_c_vt_us_coins_iha_pct_int2
	pbp_c_vt_us_coins_iha_bgnd_i2
	pbp_c_vt_us_coins_iha_endd_i2
	pbp_c_vt_us_coins_iha_pct_int3
	pbp_c_vt_us_coins_iha_bgnd_i3
	pbp_c_vt_us_coins_iha_endd_i3
	pbp_c_vt_us_coins_iha_cov
	pbp_c_vt_us_coins_iph_pct
	pbp_c_vt_us_coins_iph_int_num
	pbp_c_vt_us_coins_iph_pct_int1
	pbp_c_vt_us_coins_iph_bgnd_i1
	pbp_c_vt_us_coins_iph_endd_i1
	pbp_c_vt_us_coins_iph_pct_int2
	pbp_c_vt_us_coins_iph_bgnd_i2
	pbp_c_vt_us_coins_iph_endd_i2
	pbp_c_vt_us_coins_iph_pct_int3
	pbp_c_vt_us_coins_iph_bgnd_i3
	pbp_c_vt_us_coins_iph_endd_i3
	pbp_c_vt_us_coins_iph_cov
	pbp_c_vt_us_copay_ihs_yn
	pbp_c_vt_us_copay_ihs_ben_type
	pbp_c_vt_us_copay_iha_ps_amt
	pbp_c_vt_us_copay_iha_int_num
	pbp_c_vt_us_copay_iha_amt_int1
	pbp_c_vt_us_copay_iha_bgnd_i1
	pbp_c_vt_us_copay_iha_endd_i1
	pbp_c_vt_us_copay_iha_amt_int2
	pbp_c_vt_us_copay_iha_bgnd_i2
	pbp_c_vt_us_copay_iha_endd_i2
	pbp_c_vt_us_copay_iha_amt_int3
	pbp_c_vt_us_copay_iha_bgnd_i3
	pbp_c_vt_us_copay_iha_endd_i3
	pbp_c_vt_us_copay_iph_ps_amt
	pbp_c_vt_us_copay_iph_int_num
	pbp_c_vt_us_copay_iph_amt_int1
	pbp_c_vt_us_copay_iph_bgnd_i1
	pbp_c_vt_us_copay_iph_endd_i1
	pbp_c_vt_us_copay_iph_amt_int2
	pbp_c_vt_us_copay_iph_bgnd_i2
	pbp_c_vt_us_copay_iph_endd_i2
	pbp_c_vt_us_copay_iph_amt_int3
	pbp_c_vt_us_copay_iph_bgnd_i3
	pbp_c_vt_us_copay_iph_endd_i3
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_c_vt_us_coins_snf_yn         = 'V/T US Benefit SNF Coinsurance'
	pbp_c_csr_coins_snf_yn           = 'CSR Benefit SNF Coinsurance YN'
	pbp_c_csr_coins_snf_pct          = 'CSR Benefit SNF Coins Pct'
	pbp_c_vt_us_coins_snf_pct        = 'V/T US Benefit SNF Coins Pct'
	pbp_c_vt_us_coins_snf_int_num    = 'V/T US SNF Coins Interval Num'
	pbp_c_csr_coins_snf_intrvl_num   = 'CSR SNF Coins Interval Num'
	pbp_c_vt_us_coins_snf_pct_i1     = 'V/T US SNF Coins Pct Intrvl 1'
	pbp_c_csr_coins_snf_pct_i1       = 'CSR SNF Coins Pct Intrvl 1'
	pbp_c_csr_coins_snf_bgnd_i1      = 'CSR SNF Coins BgnD Intrvl 1'
	pbp_c_vt_us_coins_snf_bgnd_i1    = 'V/T US SNF Coins BgnD Intrvl 1'
	pbp_c_csr_coins_snf_endd_i1      = 'CSR SNF Coins EndD Intrvl 1'
	pbp_c_vt_us_coins_snf_endd_i1    = 'V/T US SNF Coins EndD Intrvl 1'
	pbp_c_csr_coins_snf_pct_i2       = 'CSR SNF Coins Pct Intrvl 2'
	pbp_c_vt_us_coins_snf_pct_i2     = 'V/T US SNF Coins Pct Intrvl 2'
	pbp_c_csr_coins_snf_bgnd_i2      = 'CSR SNF Coins BgnD Intrvl 2'
	pbp_c_vt_us_coins_snf_bgnd_i2    = 'V/T US SNF Coins BgnD Intrvl 2'
	pbp_c_vt_us_coins_snf_endd_i2    = 'V/T US SNF Coins EndD Intrvl 2'
	pbp_c_csr_coins_snf_endd_i2      = 'CSR SNF Coins EndD Intrvl 2'
	pbp_c_vt_us_coins_snf_pct_i3     = 'V/T US SNF Coins Pct Intrvl 3'
	pbp_c_csr_coins_snf_pct_i3       = 'CSR SNF Coins Pct Intrvl 3'
	pbp_c_csr_coins_snf_bgnd_i3      = 'CSR SNF Coins BgnD Intrvl 3'
	pbp_c_vt_us_coins_snf_bgnd_i3    = 'V/T US SNF Coins BgnD Intrvl 3'
	pbp_c_csr_coins_snf_endd_i3      = 'CSR SNF Coins EndD Intrvl 3'
	pbp_c_vt_us_coins_snf_endd_i3    = 'V/T US SNF Coins EndD Intrvl 3'
	pbp_c_vt_us_coins_snf_cov        = 'V/T US SNF Coins Cov'
	pbp_c_csr_coins_snf_cov          = 'CSR SNF Coins Cov'
	pbp_c_vt_us_copay_snf_yn         = 'V/T US Benefit SNF Copayment Y'
	pbp_c_csr_copay_snf_yn           = 'CSR Benefit SNF Copayment YN'
	pbp_c_vt_us_copay_snf_amt        = 'V/T US Benefit SNF Copay PS Am'
	pbp_c_csr_copay_snf_amt          = 'CSR Benefit SNF Copay PS Amt'
	pbp_c_vt_us_copay_snf_int_num    = 'V/T US SNF Copay Interval Num'
	pbp_c_csr_copay_snf_intrvl_num   = 'CSR SNF Copay Interval Num'
	pbp_c_csr_copay_snf_amt_i1       = 'CSR SNF Copay Amt Intrvl 1'
	pbp_c_vt_us_copay_snf_amt_i1     = 'V/T US SNF Copay Amt Intrvl 1'
	pbp_c_csr_copay_snf_bgnd_i1      = 'CSR SNF Copay BgnD Intrvl 1'
	pbp_c_vt_us_copay_snf_bgnd_i1    = 'V/T US SNF Copay BgnD Intrvl 1'
	pbp_c_csr_copay_snf_endd_i1      = 'CSR SNF Copay EndD Intrvl 1'
	pbp_c_vt_us_copay_snf_endd_i1    = 'V/T US SNF Copay EndD Intrvl 1'
	pbp_c_csr_copay_snf_amt_i2       = 'CSR SNF Copay Amt Intrvl 2'
	pbp_c_vt_us_copay_snf_amt_i2     = 'V/T US SNF Copay Amt Intrvl 2'
	pbp_c_vt_us_copay_snf_bgnd_i2    = 'V/T US SNF Copay BgnD Intrvl 2'
	pbp_c_csr_copay_snf_bgnd_i2      = 'CSR SNF Copay BgnD Intrvl 2'
	pbp_c_csr_copay_snf_endd_i2      = 'CSR SNF Copay EndD Intrvl 2'
	pbp_c_vt_us_copay_snf_endd_i2    = 'V/T US SNF Copay EndD Intrvl 2'
	pbp_c_csr_copay_snf_amt_i3       = 'CSR SNF Copay Amt Intrvl 3'
	pbp_c_vt_us_copay_snf_amt_i3     = 'V/T US SNF Copay Amt Intrvl 3'
	pbp_c_csr_copay_snf_bgnd_i3      = 'CSR SNF Copay BgnD Intrvl 3'
	pbp_c_vt_us_copay_snf_bgnd_i3    = 'V/T US SNF Copay BgnD Intrvl 3'
	pbp_c_csr_copay_snf_endd_i3      = 'CSR SNF Copay EndD Intrvl 3'
	pbp_c_vt_us_copay_snf_endd_i3    = 'V/T US SNF Copay EndD Intrvl 3'
	pbp_c_vt_us_snf_ded_yn           = 'V/T US SNF Deductible YN'
	pbp_c_csr_snf_ded_yn             = 'CSR SNF Deductible YN'
	pbp_c_vt_us_snf_ded_amt          = 'V/T US SNF Deductible Acute Am'
	pbp_c_csr_snf_ded_amt            = 'CSR SNF Deductible Acute Amt'
	pbp_c_csr_yn                     = 'CSR YN'
	pbp_c_csr_bendesc_subcats        = 'CSR Ben Subsrvc Categories'
	pbp_c_csr_coins_ihs_ben_type     = 'CSR Benefit IHS Coins Type'
	pbp_c_csr_coins_ihs_yn           = 'CSR Ben IHS Coinsurance YN'
	pbp_c_csr_coins_iha_pct          = 'CSR Benefit IHA Coins Pct'
	pbp_c_csr_coins_iha_intrvl_num   = 'CSR IHA Coins Interval Num'
	pbp_c_csr_coins_iha_pct_i1       = 'CSR IHA Coins Pct Intrvl 1'
	pbp_c_csr_coins_iha_bgnd_i1      = 'CSR IHA Coins BgnD Intrvl 1'
	pbp_c_csr_coins_iha_endd_i1      = 'CSR IHA Coins EndD Intrvl 1'
	pbp_c_csr_coins_iha_pct_i2       = 'CSR IHA Coins Pct Intrvl 2'
	pbp_c_csr_coins_iha_bgnd_i2      = 'CSR IHA Coins BgnD Intrvl 2'
	pbp_c_csr_coins_iha_endd_i2      = 'CSR IHA Coins EndD Intrvl 2'
	pbp_c_csr_coins_iha_pct_i3       = 'CSR IHA Coins Pct Intrvl 3'
	pbp_c_csr_coins_iha_bgnd_i3      = 'CSR IHA Coins BgnD Intrvl 3'
	pbp_c_csr_coins_iha_endd_i3      = 'CSR IHA Coins EndD Intrvl 3'
	pbp_c_csr_coins_iph_pct          = 'CSR Benefit IPH Coins Pct'
	pbp_c_csr_coins_iph_intrvl_num   = 'CSR IPH Coins Interval Num'
	pbp_c_csr_coins_iph_pct_i1       = 'CSR IPH Coins Pct Intrvl 1'
	pbp_c_csr_coins_iph_bgnd_i1      = 'CSR IPH Coins BgnD Intrvl 1'
	pbp_c_csr_coins_iph_endd_i1      = 'CSR IPH Coins EndD Intrvl 1'
	pbp_c_csr_coins_iph_pct_i2       = 'CSR IPH Coins Pct Intrvl 2'
	pbp_c_csr_coins_iph_bgnd_i2      = 'CSR IPH Coins BgnD Intrvl 2'
	pbp_c_csr_coins_iph_endd_i2      = 'CSR IPH Coins EndD Intrvl 2'
	pbp_c_csr_coins_iph_pct_i3       = 'CSR IPH Coins Pct Intrvl 3'
	pbp_c_csr_coins_iph_bgnd_i3      = 'CSR IPH Coins BgnD Intrvl 3'
	pbp_c_csr_coins_iph_endd_i3      = 'CSR IPH Coins EndD Intrvl 3'
	pbp_c_csr_copay_ihs_yn           = 'CSR Benefit IHS Copayment YN'
	pbp_c_csr_copay_ihs_ben_type     = 'CSR Benefit IHS Copay Type'
	pbp_c_csr_copay_iha_ps_amt       = 'CSR Benefit IHA Copay PS Amt'
	pbp_c_csr_copay_iha_intrvl_num   = 'CSR IHA Copay Interval Num'
	pbp_c_csr_copay_iha_amt_i1       = 'CSR IHA Copay Amt Intrvl 1'
	pbp_c_csr_copay_iha_bgnd_i1      = 'CSR IHA Copay BgnD Intrvl 1'
	pbp_c_csr_copay_iha_endd_i1      = 'CSR IHA Copay EndD Intrvl 1'
	pbp_c_csr_copay_iha_amt_i2       = 'CSR IHA Copay Amt Intrvl 2'
	pbp_c_csr_copay_iha_bgnd_i2      = 'CSR IHA Copay BgnD Intrvl 2'
	pbp_c_csr_copay_iha_endd_i2      = 'CSR IHA Copay EndD Intrvl 2'
	pbp_c_csr_copay_iha_amt_i3       = 'CSR IHA Copay Amt Intrvl 3'
	pbp_c_csr_copay_iha_bgnd_i3      = 'CSR IHA Copay BgnD Intrvl 3'
	pbp_c_csr_copay_iha_endd_i3      = 'CSR IHA Copay EndD Intrvl 3'
	pbp_c_csr_copay_iph_ps_amt       = 'CSR Benefit IPH Copay PS Amt'
	pbp_c_csr_copay_iph_intrvl_num   = 'CSR IPH Copay Interval Num'
	pbp_c_csr_copay_iph_amt_i1       = 'CSR IPH Copay Amt Intrvl 1'
	pbp_c_csr_copay_iph_bgnd_i1      = 'CSR IPH Copay BgnD Intrvl 1'
	pbp_c_csr_copay_iph_endd_i1      = 'CSR IPH Copay EndD Intrvl 1'
	pbp_c_csr_copay_iph_amt_i2       = 'CSR IPH Copay Amt Intrvl 2'
	pbp_c_csr_copay_iph_bgnd_i2      = 'CSR IPH Copay BgnD Intrvl 2'
	pbp_c_csr_copay_iph_endd_i2      = 'CSR IPH Copay EndD Intrvl 2'
	pbp_c_csr_copay_iph_amt_i3       = 'CSR IPH Copay Amt Intrvl 3'
	pbp_c_csr_copay_iph_bgnd_i3      = 'CSR IPH Copay BgnD Intrvl 3'
	pbp_c_csr_copay_iph_endd_i3      = 'CSR IPH Copay EndD Intrvl 3'
	pbp_c_csr_ihs_ded_yn             = 'CSR IHS Ded YN'
	pbp_c_csr_ihs_ded_cost_type      = 'CSR IHS Deductible Cost Type'
	pbp_c_csr_ihs_ded_acu_amt        = 'CSR IHS Deductible Acute Amt'
	pbp_c_csr_ihs_ded_psyc_amt       = 'CSR IHS Deductible Psyc Amt'
	pbp_c_csr_ihs_ded_comb_amt       = 'CSR IHS Deductible Combo Amt'
	pbp_c_vt_yn                      = 'V/T YN'
	pbp_c_vt_mo                      = 'V/T Benefit MO'
	pbp_c_vt_us_yn                   = 'V/T US YN'
	pbp_c_vt_us_bendesc_subcats      = 'V/T US Benefit Subsrvc Cats'
	pbp_c_vt_us_maxplan_yn           = 'V/T US Benefit Max Plan YN'
	pbp_c_vt_us_maxplan_subcats      = 'V/T US Max Plan Subsvc Cats'
	pbp_c_vt_us_maxplan_amt          = 'V/T US Max Plan Amt'
	pbp_c_vt_us_maxplan_per          = 'V/T US Benefit Max Plan Per'
	pbp_c_vt_us_maxplan_cov          = 'V/T US Benefit Max Plan Cov'
	pbp_c_vt_us_auth_yn              = 'V/T US Benefit Auth Req YN'
	pbp_c_vt_us_auth_subcats         = 'V/T US Auth Subsrvc Categories'
	pbp_c_vt_us_auth                 = 'V/T US Benefit Auth'
	pbp_c_vt_us_referral_yn          = 'V/T US Referral Required YN'
	pbp_c_vt_us_referral_subcats     = 'V/T US Referral Subsvc Cats'
	pbp_c_vt_us_coins_ihs_yn         = 'V/T US Benefit IHS Coins YN'
	pbp_c_vt_us_coins_ihs_ben_type   = 'V/T US Benefit IHS Coins Type'
	pbp_c_vt_us_coins_iha_pct        = 'V/T US IHA Coins Pct'
	pbp_c_vt_us_coins_iha_int_num    = 'V/T US IHA Coins Int Num'
	pbp_c_vt_us_coins_iha_pct_int1   = 'V/T US IHA Coins Pct Int 1'
	pbp_c_vt_us_coins_iha_bgnd_i1    = 'V/T US IHA Coins BgnD Int 1'
	pbp_c_vt_us_coins_iha_endd_i1    = 'V/T US IHA Coins EndD Int 1'
	pbp_c_vt_us_coins_iha_pct_int2   = 'V/T US IHA Coins Pct Int 2'
	pbp_c_vt_us_coins_iha_bgnd_i2    = 'V/T US IHA Coins BgnD Int 2'
	pbp_c_vt_us_coins_iha_endd_i2    = 'V/T US IHA Coins EndD Int 2'
	pbp_c_vt_us_coins_iha_pct_int3   = 'V/T US IHA Coins Pct Int 3'
	pbp_c_vt_us_coins_iha_bgnd_i3    = 'V/T US IHA Coins BgnD Int 3'
	pbp_c_vt_us_coins_iha_endd_i3    = 'V/T US IHA Coins EndD Int 3'
	pbp_c_vt_us_coins_iha_cov        = 'V/T US IHA Coins Cov'
	pbp_c_vt_us_coins_iph_pct        = 'V/T US IPH Coins Pct'
	pbp_c_vt_us_coins_iph_int_num    = 'V/T US IPH Coins Interval Num'
	pbp_c_vt_us_coins_iph_pct_int1   = 'V/T US IPH Coins Pct Int 1'
	pbp_c_vt_us_coins_iph_bgnd_i1    = 'V/T US IPH Coins BgnD Int 1'
	pbp_c_vt_us_coins_iph_endd_i1    = 'V/T US IPH Coins EndD Int 1'
	pbp_c_vt_us_coins_iph_pct_int2   = 'V/T US IPH Coins Pct Int 2'
	pbp_c_vt_us_coins_iph_bgnd_i2    = 'V/T US IPH Coins BgnD Int 2'
	pbp_c_vt_us_coins_iph_endd_i2    = 'V/T US IPH Coins EndD Int 2'
	pbp_c_vt_us_coins_iph_pct_int3   = 'V/T US IPH Coins Pct Int 3'
	pbp_c_vt_us_coins_iph_bgnd_i3    = 'V/T US IPH Coins BgnD Int 3'
	pbp_c_vt_us_coins_iph_endd_i3    = 'V/T US IPH Coins EndD Int 3'
	pbp_c_vt_us_coins_iph_cov        = 'V/T US IPH Coins Cov'
	pbp_c_vt_us_copay_ihs_yn         = 'V/T US Bene IHS Copayment YN'
	pbp_c_vt_us_copay_ihs_ben_type   = 'V/T US Benefit IHS Copay Type'
	pbp_c_vt_us_copay_iha_ps_amt     = 'V/T US Bene IHA Copay PS Amt'
	pbp_c_vt_us_copay_iha_int_num    = 'V/T US IHA Copay Int Num'
	pbp_c_vt_us_copay_iha_amt_int1   = 'V/T US IHA Copay Amt Int 1'
	pbp_c_vt_us_copay_iha_bgnd_i1    = 'V/T US IHA Copay BgnD Int 1'
	pbp_c_vt_us_copay_iha_endd_i1    = 'V/T US IHA Copay EndD Int 1'
	pbp_c_vt_us_copay_iha_amt_int2   = 'V/T US IHA Copay Amt Int 2'
	pbp_c_vt_us_copay_iha_bgnd_i2    = 'V/T US IHA Copay BgnD Int 2'
	pbp_c_vt_us_copay_iha_endd_i2    = 'V/T US IHA Copay EndD Int 2'
	pbp_c_vt_us_copay_iha_amt_int3   = 'V/T US IHA Copay Amt Int 3'
	pbp_c_vt_us_copay_iha_bgnd_i3    = 'V/T US IHA Copay BgnD Int 3'
	pbp_c_vt_us_copay_iha_endd_i3    = 'V/T US IHA Copay EndD Int 3'
	pbp_c_vt_us_copay_iph_ps_amt     = 'V/T US IPH Copay PS Amt'
	pbp_c_vt_us_copay_iph_int_num    = 'V/T US IPH Copay Int Num'
	pbp_c_vt_us_copay_iph_amt_int1   = 'V/T US IPH Copay Amt Int 1'
	pbp_c_vt_us_copay_iph_bgnd_i1    = 'V/T US IPH Copay BgnD Int 1'
	pbp_c_vt_us_copay_iph_endd_i1    = 'V/T US IPH Copay EndD Int 1'
	pbp_c_vt_us_copay_iph_amt_int2   = 'V/T US IPH Copay Amt Intl 2'
	pbp_c_vt_us_copay_iph_bgnd_i2    = 'V/T US IPH Copay BgnD Int 2'
	pbp_c_vt_us_copay_iph_endd_i2    = 'V/T US IPH Copay EndD Int 2'
	pbp_c_vt_us_copay_iph_amt_int3   = 'V/T US IPH Copay Amt Int 3'
	pbp_c_vt_us_copay_iph_bgnd_i3    = 'V/T US IPH Copay BgnD Int 3'
	pbp_c_vt_us_copay_iph_endd_i3    = 'V/T US IPH Copay EndD Int 3'
;

run;

proc sort data = pbp_Section_C_2 out=out.pbp_Section_C_2;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_Section_C_2(obs = 10);
  title 'pbp_Section_C_2 file ';
run;

proc means data = out.pbp_Section_C_2;
  title 'pbp_Section_C_2 file ';
run;

proc freq data = out.pbp_Section_C_2;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_c_vt_us_coins_snf_yn
	pbp_c_csr_coins_snf_yn
	pbp_c_vt_us_coins_snf_int_num
	pbp_c_csr_coins_snf_intrvl_num
	pbp_c_vt_us_coins_snf_cov
	pbp_c_csr_coins_snf_cov
	pbp_c_vt_us_copay_snf_yn
	pbp_c_csr_copay_snf_yn
	pbp_c_vt_us_copay_snf_int_num
	pbp_c_csr_copay_snf_intrvl_num
	pbp_c_vt_us_snf_ded_yn
	pbp_c_csr_snf_ded_yn
	pbp_c_csr_yn
	pbp_c_csr_coins_ihs_ben_type
	pbp_c_csr_coins_ihs_yn
	pbp_c_csr_coins_iha_intrvl_num
	pbp_c_csr_coins_iph_intrvl_num
	pbp_c_csr_copay_ihs_yn
	pbp_c_csr_copay_ihs_ben_type
	pbp_c_csr_copay_iha_intrvl_num
	pbp_c_csr_copay_iph_intrvl_num
	pbp_c_csr_ihs_ded_yn
	pbp_c_csr_ihs_ded_cost_type
	pbp_c_vt_yn
	pbp_c_vt_mo
	pbp_c_vt_us_yn
	pbp_c_vt_us_maxplan_yn
	pbp_c_vt_us_maxplan_per
	pbp_c_vt_us_maxplan_cov
	pbp_c_vt_us_auth_yn
	pbp_c_vt_us_auth
	pbp_c_vt_us_referral_yn
	pbp_c_vt_us_coins_ihs_yn
	pbp_c_vt_us_coins_ihs_ben_type
	pbp_c_vt_us_coins_iha_int_num
	pbp_c_vt_us_coins_iha_cov
	pbp_c_vt_us_coins_iph_int_num
	pbp_c_vt_us_coins_iph_cov
	pbp_c_vt_us_copay_ihs_yn
	pbp_c_vt_us_copay_ihs_ben_type
	pbp_c_vt_us_copay_iha_int_num
	pbp_c_vt_us_copay_iph_int_num
/ missing;
run;

proc contents data = out.pbp_Section_C_2;
  title 'pbp_Section_C_2 data';
run;
