*pbp_Section_D.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_Section_D;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_d_comb_deduct_inn_m_yn       $1
	pbp_d_comb_deduct_partb_yn       $1
	pbp_d_comb_deduct_yn             $1
	pbp_d_comb_deduct_inn_nm_yn      $1
	pbp_d_comb_deduct_inn_m_cats     $42
	pbp_d_comb_deduct_inn_nm_cats    $12
	pbp_d_comb_deduct_bens           $4
	pbp_d_comb_deduct_oon_nm_yn      $1
	pbp_d_comb_deduct_oon_m_cats     $43
	pbp_d_comb_deduct_oon_m_yn       $1
	pbp_d_comb_deduct_oon_nm_cats    $12
	pbp_d_inn_deduct_yn              $1
	pbp_d_non_deduct_yn              $1
	pbp_d_inn_deduct_partb_yn        $1
	pbp_d_non_deduct_partb_yn        $1
	pbp_d_inn_deduct_nm_yn           $1
	pbp_d_non_deduct_nm_yn           $1
	pbp_d_inn_deduct_m_yn            $1
	pbp_d_non_deduct_m_yn            $1
	pbp_d_inn_deduct_m_cats          $42
	pbp_d_non_deduct_m_cats          $42
	pbp_d_inn_deduct_nm_cats         $12
	pbp_d_non_deduct_nm_cats         $12
	pbp_d_inn_deduct_bens            $2
	pbp_d_non_deduct_bens            $2
	pbp_d_oon_deduct_partb_yn        $1
	pbp_d_oon_deduct_nm_yn           $1
	pbp_d_oon_deduct_m_yn            $1
	pbp_d_oon_deduct_yn              $1
	pbp_d_oon_deduct_m_cats          $43
	pbp_d_oon_deduct_nm_cats         $12
	pbp_d_oon_deduct_bens            $2
	pbp_d_comb_max_enr_inn_m_yn      $1
	pbp_d_comb_max_enr_inn_nm_yn     $1
	pbp_d_comb_max_enr_amt_yn        $1
	pbp_d_comb_max_enr_inn_nm_cats   $12
	pbp_d_comb_max_enr_inn_m_cats    $43
	pbp_d_comb_max_enr_oopc_bens     $4
	pbp_d_comb_max_enr_oon_m_yn      $1
	pbp_d_comb_max_enr_oon_nm_yn     $1
	pbp_d_comb_max_enr_oon_nm_cats   $12
	pbp_d_comb_max_enr_oon_m_cats    $43
	pbp_d_inn_max_enr_nm_yn          $1
	pbp_d_maxenr_oopc_nm_cats_yn     $1
	pbp_d_inn_max_enr_m_yn           $1
	pbp_d_maxenr_oopc_m_cats_yn      $1
	pbp_d_maxenr_oopc_yn             $1
	pbp_d_out_pocket_amt_yn          $1
	pbp_d_inn_max_enr_nm_cats        $12
	pbp_d_maxenr_oopc_nm_cats        $12
	pbp_d_inn_max_enr_oopc_bens      $2
	pbp_d_maxenr_oopc_bens           $2
	pbp_d_inn_max_enr_m_cats         $43
	pbp_d_maxenr_oopc_m_cats         $43
	pbp_d_oon_max_enr_nm_yn          $1
	pbp_d_oon_max_enr_oopc_yn        $1
	pbp_d_oon_max_enr_m_yn           $1
	pbp_d_max_plan_bens              $2
	pbp_d_oon_max_enr_oopc_bens      $2
	pbp_d_oon_max_enr_m_cats         $43
	pbp_d_oon_max_enr_nm_cats        $12
	pbp_d_oon_maxplan_nm_yn          $1
	pbp_d_inn_maxplan_nm_yn          $1
	pbp_d_non_maxplan_nm_yn          $1
	pbp_d_max_plan_ben_cov_yn        $1
	pbp_d_non_maxplan_yn             $1
	pbp_d_max_plan_period            $1
	pbp_d_non_maxplan_per            $1
	pbp_d_inn_maxplan_nm_cats        $12
	pbp_d_non_maxplan_nm_cats        $12
	pbp_d_oon_maxplan_nm_cats        $12
	pbp_d_mco_pay_reduct_yn          $1
	pbp_d_balbill_yn                 $1
	pbp_d_balbill_prov_cats          $52
	pbp_d_prev_svcs_pre_ded_yn       $1
	pbp_d_prev_svcs_pre_ded_cats     $11
	pbp_d_prev_svcs_vary_yn          $1
;

infile '.\pbp\pbp_Section_D.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_d_comb_deduct_inn_m_yn
	pbp_d_comb_deduct_partb_yn
	pbp_d_comb_deduct_yn
	pbp_d_comb_deduct_inn_nm_yn
	pbp_d_comb_deduct_amt
	pbp_d_comb_deduct_inn_m_cats
	pbp_d_comb_deduct_inn_nm_cats
	pbp_d_comb_deduct_bens
	pbp_d_comb_deduct_oon_nm_yn
	pbp_d_comb_deduct_oon_m_cats
	pbp_d_comb_deduct_oon_m_yn
	pbp_d_comb_deduct_oon_nm_cats
	pbp_d_non_deduct_yn
	pbp_d_inn_deduct_yn
	pbp_d_inn_deduct_partb_yn
	pbp_d_non_deduct_partb_yn
	pbp_d_non_deduct_nm_yn
	pbp_d_inn_deduct_nm_yn
	pbp_d_non_deduct_m_yn
	pbp_d_inn_deduct_m_yn
	pbp_d_inn_deduct_amt
	pbp_d_non_deduct_amt
	pbp_d_non_deduct_m_cats
	pbp_d_inn_deduct_m_cats
	pbp_d_non_deduct_nm_cats
	pbp_d_inn_deduct_nm_cats
	pbp_d_inn_deduct_bens
	pbp_d_non_deduct_bens
	pbp_d_oon_deduct_partb_yn
	pbp_d_oon_deduct_nm_yn
	pbp_d_oon_deduct_m_yn
	pbp_d_oon_deduct_yn
	pbp_d_oon_deduct_amt
	pbp_d_oon_deduct_m_cats
	pbp_d_oon_deduct_nm_cats
	pbp_d_oon_deduct_bens
	pbp_d_comb_max_enr_inn_m_yn
	pbp_d_comb_max_enr_inn_nm_yn
	pbp_d_comb_max_enr_amt_yn
	pbp_d_comb_max_enr_amt
	pbp_d_comb_max_enr_inn_nm_cats
	pbp_d_comb_max_enr_inn_m_cats
	pbp_d_comb_max_enr_oopc_bens
	pbp_d_comb_max_enr_oon_m_yn
	pbp_d_comb_max_enr_oon_nm_yn
	pbp_d_comb_max_enr_oon_nm_cats
	pbp_d_comb_max_enr_oon_m_cats
	pbp_d_inn_max_enr_nm_yn
	pbp_d_maxenr_oopc_nm_cats_yn
	pbp_d_inn_max_enr_m_yn
	pbp_d_maxenr_oopc_m_cats_yn
	pbp_d_out_pocket_amt_yn
	pbp_d_maxenr_oopc_yn
	pbp_d_out_pocket_amt
	pbp_d_maxenr_oopc_amt
	pbp_d_inn_max_enr_nm_cats
	pbp_d_maxenr_oopc_nm_cats
	pbp_d_inn_max_enr_oopc_bens
	pbp_d_maxenr_oopc_bens
	pbp_d_inn_max_enr_m_cats
	pbp_d_maxenr_oopc_m_cats
	pbp_d_oon_max_enr_nm_yn
	pbp_d_oon_max_enr_oopc_yn
	pbp_d_oon_max_enr_m_yn
	pbp_d_oon_max_enr_oopc_amt  :comma9.
	pbp_d_oon_max_enr_oopc_bens
	pbp_d_max_plan_bens
	pbp_d_oon_max_enr_m_cats
	pbp_d_oon_max_enr_nm_cats
	pbp_d_oon_maxplan_nm_yn
	pbp_d_non_maxplan_nm_yn
	pbp_d_inn_maxplan_nm_yn
	pbp_d_non_maxplan_yn
	pbp_d_max_plan_ben_cov_yn
	pbp_d_non_maxplan_amt
	pbp_d_max_plan_ben_cov
	pbp_d_non_maxplan_per
	pbp_d_max_plan_period
	pbp_d_non_maxplan_nm_cats
	pbp_d_inn_maxplan_nm_cats
	pbp_d_oon_maxplan_nm_cats
	pbp_d_mplusc_premium
	pbp_d_mplusc_bonly_premium
	pbp_d_mco_pay_reduct_yn
	pbp_d_mco_pay_reduct_amt
	pbp_d_balbill_yn
	pbp_d_balbill_min_pct
	pbp_d_balbill_max_pct
	pbp_d_balbill_prov_cats
	pbp_d_msa_ded_amt
	pbp_d_msa_annual_amt
	pbp_d_prev_svcs_pre_ded_yn
	pbp_d_prev_svcs_pre_ded_cats
	pbp_d_prev_svcs_vary_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_d_comb_deduct_inn_m_yn       = 'Ded Comb All Inn Mdcr YN'
	pbp_d_comb_deduct_partb_yn       = 'Ded Comb Mdcr PartB YN'
	pbp_d_comb_deduct_yn             = 'Plan Deductible YN'
	pbp_d_comb_deduct_inn_nm_yn      = 'Ded Comb All Inn NM YN'
	pbp_d_comb_deduct_amt            = 'Plan Deductible Amt'
	pbp_d_comb_deduct_inn_m_cats     = 'Serv Cats Plan Deduct'
	pbp_d_comb_deduct_inn_nm_cats    = 'Serv Cats Plan Deduct'
	pbp_d_comb_deduct_bens           = 'Comb Ded benefit'
	pbp_d_comb_deduct_oon_nm_yn      = 'Ded Comb All OON NM YN'
	pbp_d_comb_deduct_oon_m_cats     = 'Serv Cats Plan Deduct'
	pbp_d_comb_deduct_oon_m_yn       = 'Ded Comb All OON Mdcr YN'
	pbp_d_comb_deduct_oon_nm_cats    = 'Serv Cats Plan Deduct'
	pbp_d_inn_deduct_yn              = 'In- Ntwk Plan Deductible YN'
	pbp_d_non_deduct_yn              = 'Plan Deductible YN'
	pbp_d_inn_deduct_partb_yn        = 'Ded In-Net Mdcr PartB YN'
	pbp_d_non_deduct_partb_yn        = 'Ded In-Net Mdcr PartB YN'
	pbp_d_inn_deduct_nm_yn           = 'Ded In-Net All Inn NM YN'
	pbp_d_non_deduct_nm_yn           = 'Ded All Inn NM YN'
	pbp_d_inn_deduct_m_yn            = 'Ded In-Net All Inn Mdcr YN'
	pbp_d_non_deduct_m_yn            = 'Ded All Inn Mdcr YN'
	pbp_d_inn_deduct_amt             = 'In-Ntwk Plan Deductible Amt'
	pbp_d_non_deduct_amt             = 'Plan Deductible Amt'
	pbp_d_inn_deduct_m_cats          = 'Serv Cats Plan Deduct'
	pbp_d_non_deduct_m_cats          = 'Serv Cats Plan Deduct'
	pbp_d_inn_deduct_nm_cats         = 'Serv Cats Plan Deduct'
	pbp_d_non_deduct_nm_cats         = 'Serv Cats Plan Deduct'
	pbp_d_inn_deduct_bens            = 'In Net Ded benefit'
	pbp_d_non_deduct_bens            = 'In Net Ded benefit'
	pbp_d_oon_deduct_partb_yn        = 'Ded OON Mdcr PartB YN'
	pbp_d_oon_deduct_nm_yn           = 'Ded OON All OON NM YN'
	pbp_d_oon_deduct_m_yn            = 'Ded OON All OON Mdcr YN'
	pbp_d_oon_deduct_yn              = 'Plan Deductible YN'
	pbp_d_oon_deduct_amt             = 'Plan Deductible Amt'
	pbp_d_oon_deduct_m_cats          = 'Serv Cats Plan Deduct'
	pbp_d_oon_deduct_nm_cats         = 'Serv Cats Plan Deduct'
	pbp_d_oon_deduct_bens            = 'OON Ded benefit'
	pbp_d_comb_max_enr_inn_m_yn      = 'Maxenr Comb All Inn Mdcr YN'
	pbp_d_comb_max_enr_inn_nm_yn     = 'Maxenr Comb All Inn Mdcr YN'
	pbp_d_comb_max_enr_amt_yn        = 'Max Enr Amt YN'
	pbp_d_comb_max_enr_amt           = 'Max Enr Amt'
	pbp_d_comb_max_enr_inn_nm_cats   = 'Serv Cats'
	pbp_d_comb_max_enr_inn_m_cats    = 'Maxenr Comb INN M Cats'
	pbp_d_comb_max_enr_oopc_bens     = 'Comb Max Enr benefit'
	pbp_d_comb_max_enr_oon_m_yn      = 'Maxenr Comb All Inn Mdcr YN'
	pbp_d_comb_max_enr_oon_nm_yn     = 'Maxenr Comb All Inn Mdcr YN'
	pbp_d_comb_max_enr_oon_nm_cats   = 'Maxenr Comb OON NM Cats'
	pbp_d_comb_max_enr_oon_m_cats    = 'Maxenr Comb OON M Cats'
	pbp_d_inn_max_enr_nm_yn          = 'Maxenr Inn All Inn NM YN'
	pbp_d_maxenr_oopc_nm_cats_yn     = 'Maxenr OOP All NM YN'
	pbp_d_inn_max_enr_m_yn           = 'Maxenr Inn All Inn Mdcr YN'
	pbp_d_maxenr_oopc_m_cats_yn      = 'Maxenr OOP All Mdcr YN'
	pbp_d_maxenr_oopc_yn             = 'Max Enr Amt YN'
	pbp_d_out_pocket_amt_yn          = 'Max Enr Amt YN'
	pbp_d_maxenr_oopc_amt            = 'Max Enr Amt'
	pbp_d_out_pocket_amt             = 'Max Enr Amt'
	pbp_d_inn_max_enr_nm_cats        = 'Serv Cats'
	pbp_d_maxenr_oopc_nm_cats        = 'Serv Cats'
	pbp_d_inn_max_enr_oopc_bens      = 'In Net Max Enr benefit'
	pbp_d_maxenr_oopc_bens           = 'Non Net PFFS Max Enr benefit'
	pbp_d_inn_max_enr_m_cats         = 'Maxenr Inn Inn M Cats'
	pbp_d_maxenr_oopc_m_cats         = 'Maxenr M Cats'
	pbp_d_oon_max_enr_nm_yn          = 'Maxenr OON All OON NM YN'
	pbp_d_oon_max_enr_oopc_yn        = 'MaxEnr OON Amt YN'
	pbp_d_oon_max_enr_m_yn           = 'Maxenr OON All OON Mdcr YN'
	pbp_d_oon_max_enr_oopc_amt       = 'Max Enr Amt'
	pbp_d_max_plan_bens              = 'Max Plan Ben Cov benefit'
	pbp_d_oon_max_enr_oopc_bens      = 'OON Max Enr benefit'
	pbp_d_oon_max_enr_m_cats         = 'Maxenr OON OON M Cats'
	pbp_d_oon_max_enr_nm_cats        = 'Serv Cats'
	pbp_d_oon_maxplan_nm_yn          = 'Maxenr Inn All Inn Mdcr YN'
	pbp_d_inn_maxplan_nm_yn          = 'Maxenr Inn All Inn Mdcr YN'
	pbp_d_non_maxplan_nm_yn          = 'Maxenr All NM YN'
	pbp_d_max_plan_ben_cov_yn        = 'Max Plan YN'
	pbp_d_non_maxplan_yn             = 'Max Plan YN'
	pbp_d_max_plan_ben_cov           = 'Max Plan Amt (non-POS)'
	pbp_d_non_maxplan_amt            = 'Max Plan Amt (non-POS)'
	pbp_d_max_plan_period            = 'Max Plan Per (non-POS)'
	pbp_d_non_maxplan_per            = 'Max Plan Per (non-POS)'
	pbp_d_inn_maxplan_nm_cats        = 'Serv Cats'
	pbp_d_non_maxplan_nm_cats        = 'Serv Cats'
	pbp_d_oon_maxplan_nm_cats        = 'Serv Cats'
	pbp_d_mplusc_premium             = 'Indicate Plan Premium Amt (AB)'
	pbp_d_mplusc_bonly_premium       = 'Indicate Plan Premium Amt (B)'
	pbp_d_mco_pay_reduct_yn          = 'MA Reduce Part B Premium YN'
	pbp_d_mco_pay_reduct_amt         = 'Part B Premium Reduction Amt'
	pbp_d_balbill_yn                 = 'Balance Bill YN'
	pbp_d_balbill_min_pct            = 'Balance Bill Min'
	pbp_d_balbill_max_pct            = 'Balance Bill Max'
	pbp_d_balbill_prov_cats          = 'Serv Cats Plan Deduct'
	pbp_d_msa_ded_amt                = 'MSA Ded Amt'
	pbp_d_msa_annual_amt             = 'Annual MSA Deposit Amt'
	pbp_d_prev_svcs_pre_ded_yn       = 'Prev Svcs pre-ded YN'
	pbp_d_prev_svcs_pre_ded_cats     = 'Prev Svcs cats'
	pbp_d_prev_svcs_vary_yn          = 'Prev Svcs pre-ded vary'
;

run;

proc sort data = pbp_Section_D out=out.pbp_Section_D;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_Section_D(obs = 10);
  title 'pbp_Section_D file ';
run;

proc means data = out.pbp_Section_D;
  title 'pbp_Section_D file ';
run;

proc freq data = out.pbp_Section_D;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_d_comb_deduct_inn_m_yn
	pbp_d_comb_deduct_partb_yn
	pbp_d_comb_deduct_yn
	pbp_d_comb_deduct_inn_nm_yn
	pbp_d_comb_deduct_bens
	pbp_d_comb_deduct_oon_nm_yn
	pbp_d_comb_deduct_oon_m_yn
	pbp_d_inn_deduct_yn
	pbp_d_non_deduct_yn
	pbp_d_inn_deduct_partb_yn
	pbp_d_non_deduct_partb_yn
	pbp_d_inn_deduct_nm_yn
	pbp_d_non_deduct_nm_yn
	pbp_d_inn_deduct_m_yn
	pbp_d_non_deduct_m_yn
	pbp_d_inn_deduct_bens
	pbp_d_non_deduct_bens
	pbp_d_oon_deduct_partb_yn
	pbp_d_oon_deduct_nm_yn
	pbp_d_oon_deduct_m_yn
	pbp_d_oon_deduct_yn
	pbp_d_oon_deduct_bens
	pbp_d_comb_max_enr_inn_m_yn
	pbp_d_comb_max_enr_inn_nm_yn
	pbp_d_comb_max_enr_amt_yn
	pbp_d_comb_max_enr_oopc_bens
	pbp_d_comb_max_enr_oon_m_yn
	pbp_d_comb_max_enr_oon_nm_yn
	pbp_d_inn_max_enr_nm_yn
	pbp_d_maxenr_oopc_nm_cats_yn
	pbp_d_inn_max_enr_m_yn
	pbp_d_maxenr_oopc_m_cats_yn
	pbp_d_maxenr_oopc_yn
	pbp_d_out_pocket_amt_yn
	pbp_d_inn_max_enr_oopc_bens
	pbp_d_maxenr_oopc_bens
	pbp_d_oon_max_enr_nm_yn
	pbp_d_oon_max_enr_oopc_yn
	pbp_d_oon_max_enr_m_yn
	pbp_d_max_plan_bens
	pbp_d_oon_max_enr_oopc_bens
	pbp_d_oon_maxplan_nm_yn
	pbp_d_inn_maxplan_nm_yn
	pbp_d_non_maxplan_nm_yn
	pbp_d_max_plan_ben_cov_yn
	pbp_d_non_maxplan_yn
	pbp_d_max_plan_period
	pbp_d_non_maxplan_per
	pbp_d_mco_pay_reduct_yn
	pbp_d_balbill_yn
	pbp_d_prev_svcs_pre_ded_yn
	pbp_d_prev_svcs_vary_yn
/ missing;
run;

proc contents data = out.pbp_Section_D;
  title 'pbp_Section_D data';
run;
