*pbp_b1b.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b1b;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b1b_bendesc_yn               $1
	pbp_b1b_bendesc_ad_nmcs          $2
	pbp_b1b_bendesc_amo_ad           $1
	pbp_b1b_bendesc_lim_ad           $1
	pbp_b1b_bendesc_amo_nmcs         $1
	pbp_b1b_maxenr_yn                $1
	pbp_b1b_maxenr_type              $1
	pbp_b1b_maxenr_per               $1
	pbp_b1b_coins_yn                 $1
	pbp_b1b_coins_mcs_intrvl_num     $1
	pbp_b1b_coins_cov_mcs            $1
	pbp_b1b_mdcr_coins_cstshrs_yn    $1
	pbp_b1b_coins_lrd_intrvl_num     $1
	pbp_b1b_coins_cov_lrd            $1
	pbp_b1b_coins_ad_intrvl_num      $1
	pbp_b1b_coins_cov_ad             $1
	pbp_b1b_coins_nmcs_struc_yn      $1
	pbp_b1b_coins_nmcs_intrvl_num    $1
	pbp_b1b_coins_cov_nmcs           $1
	pbp_b1b_ded_yn                   $1
	pbp_b1b_copay_yn                 $1
	pbp_b1b_copay_mcs_intrvl_num     $1
	pbp_b1b_mdcr_copay_cstshrs_yn    $1
	pbp_b1b_copay_lrd_intrvl_num     $1
	pbp_b1b_copay_ad_intrvl_num      $1
	pbp_b1b_copay_nmcs_struc_yn      $1
	pbp_b1b_copay_nmcs_intrvl_num    $1
	pbp_b1b_cost_share_vary_yn       $1
	pbp_b1b_auth                     $5
	pbp_b1b_refer_yn                 $1
	pbp_b1b_bendesc_yn_bonly         $1
	pbp_b1b_bendesc_amo_bonly        $1
	pbp_b1b_bendesc_lim_bonly        $1
	pbp_b1b_bendesc_per_bonly        $1
	pbp_b1b_maxplan_yn_bonly         $1
	pbp_b1b_maxplan_type_bonly       $1
	pbp_b1b_maxplan_per_bonly        $1
	pbp_b1b_maxplan_cov_bonly        $1
	pbp_b1b_maxenr_yn_bonly          $1
	pbp_b1b_maxenr_type_bonly        $1
	pbp_b1b_maxenr_per_bonly         $1
	pbp_b1b_coins_yn_bonly           $1
	pbp_b1b_coins_ps_num_bonly       $1
	pbp_b1b_coins_cov_bonly          $1
	pbp_b1b_ded_yn_bonly             $1
	pbp_b1b_copay_yn_bonly           $1
	pbp_b1b_copay_ps_num_bonly       $1
	pbp_b1b_auth_bonly               $5
	pbp_b1b_refer_yn_bonly           $1
;

infile '.\pbp\pbp_b1b_inpat_hosp.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b1b_bendesc_yn
	pbp_b1b_bendesc_ad_nmcs
	pbp_b1b_bendesc_amo_ad
	pbp_b1b_bendesc_lim_ad
	pbp_b1b_bendesc_amt_ad
	pbp_b1b_bendesc_amo_nmcs
	pbp_b1b_maxenr_yn
	pbp_b1b_maxenr_type
	pbp_b1b_maxenr_amt
	pbp_b1b_maxenr_per
	pbp_b1b_coins_yn
	pbp_b1b_coins_pct_mcs
	pbp_b1b_coins_mcs_intrvl_num
	pbp_b1b_coins_mcs_pct_intrvl1
	pbp_b1b_coins_mcs_bgnd_intrvl1
	pbp_b1b_coins_mcs_endd_intrvl1
	pbp_b1b_coins_mcs_pct_intrvl2
	pbp_b1b_coins_mcs_bgnd_intrvl2
	pbp_b1b_coins_mcs_endd_intrvl2
	pbp_b1b_coins_mcs_pct_intrvl3
	pbp_b1b_coins_mcs_bgnd_intrvl3
	pbp_b1b_coins_mcs_endd_intrvl3
	pbp_b1b_coins_cov_mcs
	pbp_b1b_mdcr_coins_cstshrs_yn
	pbp_b1b_coins_lrd_intrvl_num
	pbp_b1b_coins_lrd_pct_intrvl1
	pbp_b1b_coins_lrd_bgnd_intrvl1
	pbp_b1b_coins_lrd_endd_intrvl1
	pbp_b1b_coins_lrd_pct_intrvl2
	pbp_b1b_coins_lrd_bgnd_intrvl2
	pbp_b1b_coins_lrd_endd_intrvl2
	pbp_b1b_coins_lrd_pct_intrvl3
	pbp_b1b_coins_lrd_bgnd_intrvl3
	pbp_b1b_coins_lrd_endd_intrvl3
	pbp_b1b_coins_cov_lrd
	pbp_b1b_coins_ad_intrvl_num
	pbp_b1b_coins_ad_pct_intrvl1
	pbp_b1b_coins_ad_bgnd_intrvl1
	pbp_b1b_coins_ad_endd_intrvl1
	pbp_b1b_coins_ad_pct_intrvl2
	pbp_b1b_coins_ad_bgnd_intrvl2
	pbp_b1b_coins_ad_endd_intrvl2
	pbp_b1b_coins_ad_pct_intrvl3
	pbp_b1b_coins_ad_bgnd_intrvl3
	pbp_b1b_coins_ad_endd_intrvl3
	pbp_b1b_coins_cov_ad
	pbp_b1b_coins_nmcs_struc_yn
	pbp_b1b_coins_pct_nmcs
	pbp_b1b_coins_nmcs_intrvl_num
	pbp_b1b_coins_nmcs_pct_intrvl1
	pbp_b1b_coins_nmcs_bgnd_ntrvl1
	pbp_b1b_coins_nmcs_endd_ntrvl1
	pbp_b1b_coins_nmcs_pct_intrvl2
	pbp_b1b_coins_nmcs_bgnd_ntrvl2
	pbp_b1b_coins_nmcs_endd_ntrvl2
	pbp_b1b_coins_nmcs_pct_intrvl3
	pbp_b1b_coins_nmcs_bgnd_ntrvl3
	pbp_b1b_coins_nmcs_endd_ntrvl3
	pbp_b1b_coins_cov_nmcs
	pbp_b1b_ded_yn
	pbp_b1b_ded_amt
	pbp_b1b_copay_yn
	pbp_b1b_copay_mcs_amt
	pbp_b1b_copay_mcs_intrvl_num
	pbp_b1b_copay_mcs_amt_intrvl1
	pbp_b1b_copay_mcs_bgnd_intrvl1
	pbp_b1b_copay_mcs_endd_intrvl1
	pbp_b1b_copay_mcs_amt_intrvl2
	pbp_b1b_copay_mcs_bgnd_intrvl2
	pbp_b1b_copay_mcs_endd_intrvl2
	pbp_b1b_copay_mcs_amt_intrvl3
	pbp_b1b_copay_mcs_bgnd_intrvl3
	pbp_b1b_copay_mcs_endd_intrvl3
	pbp_b1b_mdcr_copay_cstshrs_yn
	pbp_b1b_copay_lrd_intrvl_num
	pbp_b1b_copay_lrd_amt_intrvl1
	pbp_b1b_copay_lrd_bgnd_intrvl1
	pbp_b1b_copay_lrd_endd_intrvl1
	pbp_b1b_copay_lrd_amt_intrvl2
	pbp_b1b_copay_lrd_bgnd_intrvl2
	pbp_b1b_copay_lrd_endd_intrvl2
	pbp_b1b_copay_lrd_amt_intrvl3
	pbp_b1b_copay_lrd_bgnd_intrvl3
	pbp_b1b_copay_lrd_endd_intrvl3
	pbp_b1b_copay_ad_intrvl_num
	pbp_b1b_copay_ad_amt_intrvl1
	pbp_b1b_copay_ad_bgnd_intrvl1
	pbp_b1b_copay_ad_endd_intrvl1
	pbp_b1b_copay_ad_amt_intrvl2
	pbp_b1b_copay_ad_bgnd_intrvl2
	pbp_b1b_copay_ad_endd_intrvl2
	pbp_b1b_copay_ad_amt_intrvl3
	pbp_b1b_copay_ad_bgnd_intrvl3
	pbp_b1b_copay_ad_endd_intrvl3
	pbp_b1b_copay_nmcs_struc_yn
	pbp_b1b_copay_nmcs_amt
	pbp_b1b_copay_nmcs_intrvl_num
	pbp_b1b_copay_nmcs_amt_intrvl1
	pbp_b1b_copay_nmcs_bgnd_ntrvl1
	pbp_b1b_copay_nmcs_endd_ntrvl1
	pbp_b1b_copay_nmcs_amt_intrvl2
	pbp_b1b_copay_nmcs_bgnd_ntrvl2
	pbp_b1b_copay_nmcs_endd_ntrvl2
	pbp_b1b_copay_nmcs_amt_intrvl3
	pbp_b1b_copay_nmcs_bgnd_ntrvl3
	pbp_b1b_copay_nmcs_endd_ntrvl3
	pbp_b1b_cost_share_vary_yn
	pbp_b1b_auth
	pbp_b1b_refer_yn
	pbp_b1b_pffs_copay_amt
	pbp_b1b_pffs_maxenr_amt
	pbp_b1b_bendesc_yn_bonly
	pbp_b1b_bendesc_amo_bonly
	pbp_b1b_bendesc_lim_bonly
	pbp_b1b_bendesc_amt_bonly
	pbp_b1b_bendesc_per_bonly
	pbp_b1b_maxplan_yn_bonly
	pbp_b1b_maxplan_type_bonly
	pbp_b1b_maxplan_amt_bonly
	pbp_b1b_maxplan_per_bonly
	pbp_b1b_maxplan_cov_bonly
	pbp_b1b_maxenr_yn_bonly
	pbp_b1b_maxenr_type_bonly
	pbp_b1b_maxenr_amt_bonly
	pbp_b1b_maxenr_per_bonly
	pbp_b1b_coins_yn_bonly
	pbp_b1b_coins_pct_bonly
	pbp_b1b_coins_ps_num_bonly
	pbp_b1b_coins_ps_pct1_bonly
	pbp_b1b_coins_ps_bgnd1_bonly
	pbp_b1b_coins_ps_endd1_bonly
	pbp_b1b_coins_ps_pct2_bonly
	pbp_b1b_coins_ps_bgnd2_bonly
	pbp_b1b_coins_ps_endd2_bonly
	pbp_b1b_coins_ps_pct3_bonly
	pbp_b1b_coins_ps_bgnd3_bonly
	pbp_b1b_coins_ps_endd3_bonly
	pbp_b1b_coins_cov_bonly
	pbp_b1b_ded_yn_bonly
	pbp_b1b_ded_amt_bonly
	pbp_b1b_copay_yn_bonly
	pbp_b1b_copay_amt_ps_bonly
	pbp_b1b_copay_ps_num_bonly
	pbp_b1b_copay_ps_amt1_bonly
	pbp_b1b_copay_ps_bgnd1_bonly
	pbp_b1b_copay_ps_endd1_bonly
	pbp_b1b_copay_ps_amt2_bonly
	pbp_b1b_copay_ps_bgnd2_bonly
	pbp_b1b_copay_ps_endd2_bonly
	pbp_b1b_copay_ps_amt3_bonly
	pbp_b1b_copay_ps_bgnd3_bonly
	pbp_b1b_copay_ps_endd3_bonly
	pbp_b1b_auth_bonly
	pbp_b1b_refer_yn_bonly
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b1b_bendesc_yn               = 'IPH Ben Desc YN'
	pbp_b1b_bendesc_ad_nmcs          = 'IPH Ben Desc AD/NMCS'
	pbp_b1b_bendesc_amo_ad           = 'IPH AD Ben Desc AMO'
	pbp_b1b_bendesc_lim_ad           = 'IPH AD Ben Desc Lim YN'
	pbp_b1b_bendesc_amt_ad           = 'IPH AD Ben Desc Amt'
	pbp_b1b_bendesc_amo_nmcs         = 'IPH NMCS Ben Desc AMO'
	pbp_b1b_maxenr_yn                = 'IPH Max Enr YN'
	pbp_b1b_maxenr_type              = 'IPH Max Enr Type'
	pbp_b1b_maxenr_amt               = 'IPH Max Enr Amt'
	pbp_b1b_maxenr_per               = 'IPH Max Enr Per'
	pbp_b1b_coins_yn                 = 'IPH Coinsurance YN'
	pbp_b1b_coins_pct_mcs            = 'IPH MCS Coins Pct'
	pbp_b1b_coins_mcs_intrvl_num     = 'IPH MCS Coins Interval Num'
	pbp_b1b_coins_mcs_pct_intrvl1    = 'IPH MCS Coins Pct Intrvl 1'
	pbp_b1b_coins_mcs_bgnd_intrvl1   = 'IPH MCS Coins Bgn Day Intrvl 1'
	pbp_b1b_coins_mcs_endd_intrvl1   = 'IPH MCS Coins End Day Intrvl 1'
	pbp_b1b_coins_mcs_pct_intrvl2    = 'IPH MCS Coins Pct Intrvl 2'
	pbp_b1b_coins_mcs_bgnd_intrvl2   = 'IPH MCS Coins Bgn Day Intrvl 2'
	pbp_b1b_coins_mcs_endd_intrvl2   = 'IPH MCS Coins End Day Intrvl 2'
	pbp_b1b_coins_mcs_pct_intrvl3    = 'IPH MCS Coins Pct Intrvl 3'
	pbp_b1b_coins_mcs_bgnd_intrvl3   = 'IPH MCS Coins Bgn Day Intrvl 3'
	pbp_b1b_coins_mcs_endd_intrvl3   = 'IPH MCS Coins End Day Intrvl 3'
	pbp_b1b_coins_cov_mcs            = 'IPH MCS Coins Cov'
	pbp_b1b_mdcr_coins_cstshrs_yn    = 'Med Def Coins Cost Shares YN'
	pbp_b1b_coins_lrd_intrvl_num     = 'IHA LRD Coins Interval Num'
	pbp_b1b_coins_lrd_pct_intrvl1    = 'IHA AD Coins Pct Intrvl 1'
	pbp_b1b_coins_lrd_bgnd_intrvl1   = 'IHA LRD Coins Bgn Day Intrvl 1'
	pbp_b1b_coins_lrd_endd_intrvl1   = 'IHA LRD Coins End Day Intrvl 1'
	pbp_b1b_coins_lrd_pct_intrvl2    = 'IHA AD Coins Pct Intrvl 2'
	pbp_b1b_coins_lrd_bgnd_intrvl2   = 'IHA LRD Coins Bgn Day Intrvl 2'
	pbp_b1b_coins_lrd_endd_intrvl2   = 'IHA LRD Coins End Day Intrvl 2'
	pbp_b1b_coins_lrd_pct_intrvl3    = 'IHA AD Coins Pct Intrvl 3'
	pbp_b1b_coins_lrd_bgnd_intrvl3   = 'IHA LRD Coins Bgn Day Intrvl 3'
	pbp_b1b_coins_lrd_endd_intrvl3   = 'IHA LRD Coins End Day Intrvl 3'
	pbp_b1b_coins_cov_lrd            = 'IHA LRD Coins Cov'
	pbp_b1b_coins_ad_intrvl_num      = 'IPH AD Coins Interval Num'
	pbp_b1b_coins_ad_pct_intrvl1     = 'IPH AD Coins Pct Intrvl 1'
	pbp_b1b_coins_ad_bgnd_intrvl1    = 'IPH AD Coins Bgn Day Intrvl 1'
	pbp_b1b_coins_ad_endd_intrvl1    = 'IPH AD Coins End Day Intrvl 1'
	pbp_b1b_coins_ad_pct_intrvl2     = 'IPH AD Coins Pct Intrvl 2'
	pbp_b1b_coins_ad_bgnd_intrvl2    = 'IPH AD Coins Bgn Day Intrvl 2'
	pbp_b1b_coins_ad_endd_intrvl2    = 'IPH AD Coins End Day Intrvl 2'
	pbp_b1b_coins_ad_pct_intrvl3     = 'IPH AD Coins Pct Intrvl 3'
	pbp_b1b_coins_ad_bgnd_intrvl3    = 'IPH AD Coins Bgn Day Intrvl 3'
	pbp_b1b_coins_ad_endd_intrvl3    = 'IPH AD Coins End Day Intrvl 3'
	pbp_b1b_coins_cov_ad             = 'IPH AD Coins Cov'
	pbp_b1b_coins_nmcs_struc_yn      = 'IPH NMCS Coins Structure YN'
	pbp_b1b_coins_pct_nmcs           = 'IPH NMCS Coins Pct'
	pbp_b1b_coins_nmcs_intrvl_num    = 'IPH NMCS Coins Interval Num'
	pbp_b1b_coins_nmcs_pct_intrvl1   = 'IPH NMCS Coins Pct Intrvl 1'
	pbp_b1b_coins_nmcs_bgnd_ntrvl1   = 'IPH NMCS Coins BgnDay Intrvl 1'
	pbp_b1b_coins_nmcs_endd_ntrvl1   = 'IPH NMCS Coins EndDay Intrvl 1'
	pbp_b1b_coins_nmcs_pct_intrvl2   = 'IPH NMCS Coins Pct Intrvl 2'
	pbp_b1b_coins_nmcs_bgnd_ntrvl2   = 'IPH NMCS Coins BgnDay Intrvl 2'
	pbp_b1b_coins_nmcs_endd_ntrvl2   = 'IPH NMCS Coins EndDay Intrvl 2'
	pbp_b1b_coins_nmcs_pct_intrvl3   = 'IPH NMCS Coins Pct Intrvl 3'
	pbp_b1b_coins_nmcs_bgnd_ntrvl3   = 'IPH NMCS Coins BgnDay Intrvl 3'
	pbp_b1b_coins_nmcs_endd_ntrvl3   = 'IPH NMCS Coins EndDay Intrvl 3'
	pbp_b1b_coins_cov_nmcs           = 'IPH NMCS Coins Cov'
	pbp_b1b_ded_yn                   = 'IPH Deductible YN'
	pbp_b1b_ded_amt                  = 'IPH Deductible Amt'
	pbp_b1b_copay_yn                 = 'IPH Copayment YN'
	pbp_b1b_copay_mcs_amt            = 'IPH MCS Copay Amt'
	pbp_b1b_copay_mcs_intrvl_num     = 'IPH MCS Copay Interval Num'
	pbp_b1b_copay_mcs_amt_intrvl1    = 'IPH MCS Copay Amt Interval 1'
	pbp_b1b_copay_mcs_bgnd_intrvl1   = 'IPH MCS Copay Bgn Day Intrvl 1'
	pbp_b1b_copay_mcs_endd_intrvl1   = 'IPH MCS Copay End Day Intrvl 1'
	pbp_b1b_copay_mcs_amt_intrvl2    = 'IPH MCS Copay Amt Interval 2'
	pbp_b1b_copay_mcs_bgnd_intrvl2   = 'IPH MCS Copay Bgn Day Intrvl 2'
	pbp_b1b_copay_mcs_endd_intrvl2   = 'IPH MCS Copay End Day Intrvl 2'
	pbp_b1b_copay_mcs_amt_intrvl3    = 'IPH MCS Copay Amt Interval 3'
	pbp_b1b_copay_mcs_bgnd_intrvl3   = 'IPH MCS Copay Bgn Day Intrvl 3'
	pbp_b1b_copay_mcs_endd_intrvl3   = 'IPH MCS Copay End Day Intrvl 3'
	pbp_b1b_mdcr_copay_cstshrs_yn    = 'Med Def Copay Cost Shares YN'
	pbp_b1b_copay_lrd_intrvl_num     = 'IHA LRD Copay Interval Num'
	pbp_b1b_copay_lrd_amt_intrvl1    = 'IHA LRD Copay Amt Interval 1'
	pbp_b1b_copay_lrd_bgnd_intrvl1   = 'IHA LRD Copay Bgn Day Intrvl 1'
	pbp_b1b_copay_lrd_endd_intrvl1   = 'IHA LRD Copay End Day Intrvl 1'
	pbp_b1b_copay_lrd_amt_intrvl2    = 'IHA LRD Copay Amt Interval 2'
	pbp_b1b_copay_lrd_bgnd_intrvl2   = 'IHA LRD Copay Bgn Day Intrvl 2'
	pbp_b1b_copay_lrd_endd_intrvl2   = 'IHA LRD Copay End Day Intrvl 2'
	pbp_b1b_copay_lrd_amt_intrvl3    = 'IHA LRD Copay Amt Interval 3'
	pbp_b1b_copay_lrd_bgnd_intrvl3   = 'IHA LRD Copay Bgn Day Intrvl 3'
	pbp_b1b_copay_lrd_endd_intrvl3   = 'IHA LRD Copay End Day Intrvl 3'
	pbp_b1b_copay_ad_intrvl_num      = 'IPH AD Copay Interval Num'
	pbp_b1b_copay_ad_amt_intrvl1     = 'IPH AD Copay Amt Interval 1'
	pbp_b1b_copay_ad_bgnd_intrvl1    = 'IPH AD Copay Bgn Day Intrvl 1'
	pbp_b1b_copay_ad_endd_intrvl1    = 'IPH AD Copay End Day Intrvl 1'
	pbp_b1b_copay_ad_amt_intrvl2     = 'IPH AD Copay Amt Interval 2'
	pbp_b1b_copay_ad_bgnd_intrvl2    = 'IPH AD Copay Bgn Day Intrvl 2'
	pbp_b1b_copay_ad_endd_intrvl2    = 'IPH AD Copay End Day Intrvl 2'
	pbp_b1b_copay_ad_amt_intrvl3     = 'IPH AD Copay Amt Interval 3'
	pbp_b1b_copay_ad_bgnd_intrvl3    = 'IPH AD Copay Bgn Day Intrvl 3'
	pbp_b1b_copay_ad_endd_intrvl3    = 'IPH AD Copay End Day Intrvl 3'
	pbp_b1b_copay_nmcs_struc_yn      = 'IPH NMCS Copay Structure YN'
	pbp_b1b_copay_nmcs_amt           = 'IPH NMCS Copay Amt'
	pbp_b1b_copay_nmcs_intrvl_num    = 'IPH NMCS Copay Interval Num'
	pbp_b1b_copay_nmcs_amt_intrvl1   = 'IPH NMCS Copay Amt Interval 1'
	pbp_b1b_copay_nmcs_bgnd_ntrvl1   = 'IPH NMCS Copay BgnDay Intrvl 1'
	pbp_b1b_copay_nmcs_endd_ntrvl1   = 'IPH NMCS Copay EndDay Intrvl 1'
	pbp_b1b_copay_nmcs_amt_intrvl2   = 'IPH NMCS Copay Amt Interval 2'
	pbp_b1b_copay_nmcs_bgnd_ntrvl2   = 'IPH NMCS Copay BgnDay Intrvl 2'
	pbp_b1b_copay_nmcs_endd_ntrvl2   = 'IPH NMCS Copay EndDay Intrvl 2'
	pbp_b1b_copay_nmcs_amt_intrvl3   = 'IPH NMCS Copay Amt Interval 3'
	pbp_b1b_copay_nmcs_bgnd_ntrvl3   = 'IPH NMCS Copay BgnDay Intrvl 3'
	pbp_b1b_copay_nmcs_endd_ntrvl3   = 'IPH NMCS Copay EndDay Intrvl 3'
	pbp_b1b_cost_share_vary_yn       = 'IHP Cost Share Vary YN'
	pbp_b1b_auth                     = 'IPH Auth'
	pbp_b1b_refer_yn                 = 'IPH Referral YN'
	pbp_b1b_pffs_copay_amt           = 'PFFS Add''l Copayments - B1B'
	pbp_b1b_pffs_maxenr_amt          = 'MPPF Max OOP - B1B'
	pbp_b1b_bendesc_yn_bonly         = 'IPH Ben Desc YN'
	pbp_b1b_bendesc_amo_bonly        = 'IPH Ben Desc AMO'
	pbp_b1b_bendesc_lim_bonly        = 'IPH Ben Desc Lim YN'
	pbp_b1b_bendesc_amt_bonly        = 'IPH Ben Desc Amt'
	pbp_b1b_bendesc_per_bonly        = 'IPH Ben Desc Per'
	pbp_b1b_maxplan_yn_bonly         = 'IPH Max Plan YN'
	pbp_b1b_maxplan_type_bonly       = 'IPH Max Plan Type'
	pbp_b1b_maxplan_amt_bonly        = 'IPH Max Plan Amt'
	pbp_b1b_maxplan_per_bonly        = 'IPH Max Plan Per'
	pbp_b1b_maxplan_cov_bonly        = 'IPH Max Plan Cov'
	pbp_b1b_maxenr_yn_bonly          = 'IPH Max Enr YN'
	pbp_b1b_maxenr_type_bonly        = 'IPH Max Enr Type'
	pbp_b1b_maxenr_amt_bonly         = 'IPH Max Enr Amt'
	pbp_b1b_maxenr_per_bonly         = 'IPH Max Enr Per'
	pbp_b1b_coins_yn_bonly           = 'IPH Coinsurance YN'
	pbp_b1b_coins_pct_bonly          = 'IPH PS Coins Pct'
	pbp_b1b_coins_ps_num_bonly       = 'IPH PS Coins Interval Num'
	pbp_b1b_coins_ps_pct1_bonly      = 'IPH PS Coins Pct Intrvl 1'
	pbp_b1b_coins_ps_bgnd1_bonly     = 'IPH PS Coins Bgn Day Intrvl 1'
	pbp_b1b_coins_ps_endd1_bonly     = 'IPH PS Coins End Day Intrvl 1'
	pbp_b1b_coins_ps_pct2_bonly      = 'IPH PS Coins Pct Intrvl 2'
	pbp_b1b_coins_ps_bgnd2_bonly     = 'IPH PS Coins Bgn Day Intrvl 2'
	pbp_b1b_coins_ps_endd2_bonly     = 'IPH PS Coins End Day Intrvl 2'
	pbp_b1b_coins_ps_pct3_bonly      = 'IPH PS Coins Pct Intrvl 3'
	pbp_b1b_coins_ps_bgnd3_bonly     = 'IPH PS Coins Bgn Day Intrvl 3'
	pbp_b1b_coins_ps_endd3_bonly     = 'IPH PS Coins End Day Intrvl 3'
	pbp_b1b_coins_cov_bonly          = 'IPH PS Coins Cov'
	pbp_b1b_ded_yn_bonly             = 'IPH Deductible YN'
	pbp_b1b_ded_amt_bonly            = 'IPH Deductible Amt'
	pbp_b1b_copay_yn_bonly           = 'IPH Copayment YN'
	pbp_b1b_copay_amt_ps_bonly       = 'IPH PS Copay Amt'
	pbp_b1b_copay_ps_num_bonly       = 'IPH PS Copay Interval Num'
	pbp_b1b_copay_ps_amt1_bonly      = 'IPH PS Copay Amt Interval 1'
	pbp_b1b_copay_ps_bgnd1_bonly     = 'IPH PS Copay Bgn Day Intrvl 1'
	pbp_b1b_copay_ps_endd1_bonly     = 'IPH PS Copay End Day Intrvl 1'
	pbp_b1b_copay_ps_amt2_bonly      = 'IPH PS Copay Amt Interval 2'
	pbp_b1b_copay_ps_bgnd2_bonly     = 'IPH PS Copay Bgn Day Intrvl 2'
	pbp_b1b_copay_ps_endd2_bonly     = 'IPH PS Copay End Day Intrvl 2'
	pbp_b1b_copay_ps_amt3_bonly      = 'IPH PS Copay Amt Interval 3'
	pbp_b1b_copay_ps_bgnd3_bonly     = 'IPH PS Copay Bgn Day Intrvl 3'
	pbp_b1b_copay_ps_endd3_bonly     = 'IPH PS Copay End Day Intrvl 3'
	pbp_b1b_auth_bonly               = 'IPH Auth'
	pbp_b1b_refer_yn_bonly           = 'IPH Referral YN'
;

run;

proc sort data = pbp_b1b out=out.pbp_b1b;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b1b(obs = 10);
  title 'pbp_b1b_inpat_hosp file ';
run;

proc means data = out.pbp_b1b;
  title 'pbp_b1b_inpat_hosp file ';
run;

proc freq data = out.pbp_b1b;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b1b_bendesc_yn
	pbp_b1b_bendesc_ad_nmcs
	pbp_b1b_bendesc_amo_ad
	pbp_b1b_bendesc_lim_ad
	pbp_b1b_bendesc_amo_nmcs
	pbp_b1b_maxenr_yn
	pbp_b1b_maxenr_type
	pbp_b1b_maxenr_per
	pbp_b1b_coins_yn
	pbp_b1b_coins_mcs_intrvl_num
	pbp_b1b_coins_cov_mcs
	pbp_b1b_mdcr_coins_cstshrs_yn
	pbp_b1b_coins_lrd_intrvl_num
	pbp_b1b_coins_cov_lrd
	pbp_b1b_coins_ad_intrvl_num
	pbp_b1b_coins_cov_ad
	pbp_b1b_coins_nmcs_struc_yn
	pbp_b1b_coins_nmcs_intrvl_num
	pbp_b1b_coins_cov_nmcs
	pbp_b1b_ded_yn
	pbp_b1b_copay_yn
	pbp_b1b_copay_mcs_intrvl_num
	pbp_b1b_mdcr_copay_cstshrs_yn
	pbp_b1b_copay_lrd_intrvl_num
	pbp_b1b_copay_ad_intrvl_num
	pbp_b1b_copay_nmcs_struc_yn
	pbp_b1b_copay_nmcs_intrvl_num
	pbp_b1b_cost_share_vary_yn
	pbp_b1b_auth
	pbp_b1b_refer_yn
	pbp_b1b_bendesc_yn_bonly
	pbp_b1b_bendesc_amo_bonly
	pbp_b1b_bendesc_lim_bonly
	pbp_b1b_bendesc_per_bonly
	pbp_b1b_maxplan_yn_bonly
	pbp_b1b_maxplan_type_bonly
	pbp_b1b_maxplan_per_bonly
	pbp_b1b_maxplan_cov_bonly
	pbp_b1b_maxenr_yn_bonly
	pbp_b1b_maxenr_type_bonly
	pbp_b1b_maxenr_per_bonly
	pbp_b1b_coins_yn_bonly
	pbp_b1b_coins_ps_num_bonly
	pbp_b1b_coins_cov_bonly
	pbp_b1b_ded_yn_bonly
	pbp_b1b_copay_yn_bonly
	pbp_b1b_copay_ps_num_bonly
	pbp_b1b_auth_bonly
	pbp_b1b_refer_yn_bonly
/ missing;
run;

proc contents data = out.pbp_b1b;
  title 'pbp_b1b data';
run;
