*pbp_mrx.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	mrx_drug_ben_yn                  $1
	mrx_benefit_type                 $1
	mrx_demo_yn                      $1
	mrx_demo_type                    $1
	mrx_partd_network_loc            $6
	mrx_quantity_limits              $1
	mrx_auth_ynba                    $1
	mrx_step_ther_drugs_yn           $1
	mrx_nat_rx_cov_yn                $1
	mrx_first_fill                   $1
	mrx_free_gnrc_yn                 $1
	mrx_sp_access_yn                 $1
	mrx_otc_meds_pay_ump_yn          $1
	mrx_ae_oon_cstshr_struct         $1
	mrx_ae_cstshr_apply              $1
	mrx_ae_ooptcs_apply              $1
	mrx_alt_ded_charge               $1
	mrx_alt_ded_type_yn              $1
	mrx_alt_gen_cstshr_struct        $1
	mrx_alt_oon_cstshr_struct        $1
	mrx_alt_excl_drugs_yn            $1
	mrx_alt_excl_drugs_maxplan_yn    $1
	mrx_alt_red_cost_sharing         $1
	mrx_alt_red_cost_sharing_items   $4
	mrx_alt_pre_icl_cost_share       $1
	mrx_alt_cov_lmt_yn               $1
	mrx_alt_gap_covg_yn              $1
	mrx_alt_post_icl_yn              $1
	mrx_alt_gap_drug_type            $7
	mrx_alt_drug_type                $7
	mrx_alt_cstshr_post_oopt         $1
	mrx_gen_loc                      $21
;

infile '.\pbp\pbp_mrx.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	mrx_drug_ben_yn
	mrx_benefit_type
	mrx_formulary_tiers_num
	mrx_demo_yn
	mrx_demo_type
	mrx_partd_network_loc
	mrx_quantity_limits
	mrx_auth_ynba
	mrx_step_ther_drugs_yn
	mrx_nat_rx_cov_yn
	mrx_first_fill
	mrx_free_gnrc_yn
	mrx_free_gnrc_max_amt
	mrx_sp_access_yn
	mrx_otc_meds_pay_ump_yn
	mrx_ae_oon_cstshr_struct
	mrx_ae_cstshr_apply
	mrx_ae_ooptcs_apply
	mrx_alt_ded_charge
	mrx_alt_ded_amount
	mrx_alt_ded_type_yn
	mrx_alt_gen_cstshr_struct
	mrx_alt_oon_cstshr_struct
	mrx_alt_gen_coins_pct
	mrx_alt_gen_copay_amt
	mrx_alt_excl_drugs_yn
	mrx_alt_excl_drugs_maxplan_yn
	mrx_alt_excl_max_plan_amt
	mrx_alt_red_cost_sharing
	mrx_alt_red_cost_sharing_items
	mrx_alt_pre_icl_cost_share
	mrx_alt_cov_lmt_yn
	mrx_alt_cov_lmt_amt
	mrx_alt_gap_covg_yn
	mrx_alt_post_icl_yn
	mrx_alt_lim_amt
	mrx_alt_gap_drug_type
	mrx_alt_drug_type
	mrx_alt_cstshr_post_oopt
	mrx_gen_loc
	mrx_gen_inp_1m
	mrx_gen_inp_3m
	mrx_gen_inp_os
	mrx_gen_inpp_1m
	mrx_gen_inpp_3m
	mrx_gen_inpp_os
	mrx_gen_innpp_1m
	mrx_gen_innpp_3m
	mrx_gen_innpp_os
	mrx_gen_oonp_1m
	mrx_gen_oonp_os
	mrx_gen_mo_1m
	mrx_gen_mo_3m
	mrx_gen_mo_os
	mrx_gen_mopp_1m
	mrx_gen_mopp_3m
	mrx_gen_mopp_os
	mrx_gen_monpp_1m
	mrx_gen_monpp_3m
	mrx_gen_monpp_os
	mrx_gen_ltcp_1m
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	mrx_drug_ben_yn                  = 'MRX DRUG BEN YN'
	mrx_benefit_type                 = 'Drug Benefit Type'
	mrx_formulary_tiers_num          = 'Formulary Tiers Num'
	mrx_demo_yn                      = 'MRx Demo YN'
	mrx_demo_type                    = 'MRx Demo Type'
	mrx_partd_network_loc            = 'MRx PartD Network Location'
	mrx_quantity_limits              = 'Quantity limits YN'
	mrx_auth_ynba                    = 'Authorization YN'
	mrx_step_ther_drugs_yn           = 'Step Therapy Drugs YN'
	mrx_nat_rx_cov_yn                = 'MRx Nat Prescrip Cvg'
	mrx_first_fill                   = 'MRx First Fill'
	mrx_free_gnrc_yn                 = 'MRx Free Generic Fill'
	mrx_free_gnrc_max_amt            = 'MRx Gnrc fill max amt'
	mrx_sp_access_yn                 = 'MRX SP Access'
	mrx_otc_meds_pay_ump_yn          = 'MRx Util Mngmt Program'
	mrx_ae_oon_cstshr_struct         = 'MRx AE Cstshr Structure'
	mrx_ae_cstshr_apply              = 'AE Cost Share Pre-Intl Cov Lmt'
	mrx_ae_ooptcs_apply              = 'AE OOP Threshold Application'
	mrx_alt_ded_charge               = 'BA Deductible Charged YN'
	mrx_alt_ded_amount               = 'MRx Alt Deductible Amount'
	mrx_alt_ded_type_yn              = 'BA Ded Type YN'
	mrx_alt_gen_cstshr_struct        = 'MRx BA Cstshr Structure'
	mrx_alt_oon_cstshr_struct        = 'BA DON Cost Share Structure'
	mrx_alt_gen_coins_pct            = 'MRx Alt Coins Pct'
	mrx_alt_gen_copay_amt            = 'MRx Alt Copay Amt'
	mrx_alt_excl_drugs_yn            = 'Excluded supp drugs'
	mrx_alt_excl_drugs_maxplan_yn    = 'NONPD_MAXPLAN_YN'
	mrx_alt_excl_max_plan_amt        = 'MRx Alt Max Plan Amt Exc Drugs'
	mrx_alt_red_cost_sharing         = 'MRx Red Cost Sharing'
	mrx_alt_red_cost_sharing_items   = 'MRx Red Cost Sharing Items'
	mrx_alt_pre_icl_cost_share       = 'EA Cost Share Pre-Intl Cov Lmt'
	mrx_alt_cov_lmt_yn               = 'MRx Alt Cov Lmt YN'
	mrx_alt_cov_lmt_amt              = 'MRx Alt Cov Lmt Amt'
	mrx_alt_gap_covg_yn              = 'MRx Alt Gap Covg YN'
	mrx_alt_post_icl_yn              = 'MRx Alt Gap Covg YN'
	mrx_alt_lim_amt                  = 'MRx Max Gap Covg Amt'
	mrx_alt_gap_drug_type            = 'Gap Drug Types'
	mrx_alt_drug_type                = 'MRx Lim Ben Types'
	mrx_alt_cstshr_post_oopt         = 'MRx Alt Cstshr Post OOPT'
	mrx_gen_loc                      = 'General Location'
	mrx_gen_inp_1m                   = 'Gen INP 1M Supply Days'
	mrx_gen_inp_3m                   = 'Gen INP 3M Supply Days'
	mrx_gen_inp_os                   = 'Gen INP Oth Supply Days'
	mrx_gen_inpp_1m                  = 'Gen INPP 1M Supply Days'
	mrx_gen_inpp_3m                  = 'Gen INPP 3M Supply Days'
	mrx_gen_inpp_os                  = 'Gen INPP Oth Supply Days'
	mrx_gen_innpp_1m                 = 'Gen INNPP 1M Supply Days'
	mrx_gen_innpp_3m                 = 'Gen INNPP 3M Supply Days'
	mrx_gen_innpp_os                 = 'Gen INNPP Oth Supply Days'
	mrx_gen_oonp_1m                  = 'Gen OONP 1M Supply Days'
	mrx_gen_oonp_os                  = 'Gen OONP Oth Supply Days'
	mrx_gen_mo_1m                    = 'Gen MO 1M Supply Days'
	mrx_gen_mo_3m                    = 'Gen MO 3M Supply Days'
	mrx_gen_mo_os                    = 'Gen MO Oth Supply Days'
	mrx_gen_mopp_1m                  = 'Gen MOPP 1M Supply Days'
	mrx_gen_mopp_3m                  = 'Gen MOPP 3M Supply Days'
	mrx_gen_mopp_os                  = 'Gen MOPP Oth Supply Days'
	mrx_gen_monpp_1m                 = 'Gen MONPP 1M Supply Days'
	mrx_gen_monpp_3m                 = 'Gen MONPP 3M Supply Days'
	mrx_gen_monpp_os                 = 'Gen MONPP Oth Supply Days'
	mrx_gen_ltcp_1m                  = 'Gen LTCP 1M Supply Days'
;

run;

proc sort data = pbp_mrx out=out.pbp_mrx;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx(obs = 10);
  title 'pbp_mrx file ';
run;

proc means data = out.pbp_mrx;
  title 'pbp_mrx file ';
run;

proc freq data = out.pbp_mrx;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	mrx_drug_ben_yn
	mrx_benefit_type
	mrx_demo_yn
	mrx_demo_type
	mrx_quantity_limits
	mrx_auth_ynba
	mrx_step_ther_drugs_yn
	mrx_nat_rx_cov_yn
	mrx_first_fill
	mrx_free_gnrc_yn
	mrx_sp_access_yn
	mrx_otc_meds_pay_ump_yn
	mrx_ae_oon_cstshr_struct
	mrx_ae_cstshr_apply
	mrx_ae_ooptcs_apply
	mrx_alt_ded_charge
	mrx_alt_ded_type_yn
	mrx_alt_gen_cstshr_struct
	mrx_alt_oon_cstshr_struct
	mrx_alt_excl_drugs_yn
	mrx_alt_excl_drugs_maxplan_yn
	mrx_alt_red_cost_sharing
	mrx_alt_red_cost_sharing_items
	mrx_alt_pre_icl_cost_share
	mrx_alt_cov_lmt_yn
	mrx_alt_gap_covg_yn
	mrx_alt_post_icl_yn
	mrx_alt_cstshr_post_oopt
/ missing;
run;

proc contents data = out.pbp_mrx;
  title 'pbp_mrx data';
run;
