*pbp_Section_C_3.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_Section_C_3;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_c_vt_fn_yn                   $1
	pbp_c_vt_fn_mo                   $1
	pbp_c_vt_fn_bendesc_subcats      $50
	pbp_c_vt_fn_maxplan_yn           $1
	pbp_c_vt_fn_maxplan_subcats      $50
	pbp_c_vt_fn_maxplan_per          $1
	pbp_c_vt_fn_deduct_yn            $1
	pbp_c_vt_fn_deduct_subcats       $50
	pbp_c_vt_fn_auth_yn              $1
	pbp_c_vt_fn_auth_subcats         $50
	pbp_c_vt_fn_auth                 $5
	pbp_c_vt_fn_referral_yn          $1
	pbp_c_vt_fn_referral_subcats     $50
	pbp_c_vt_fn_cstshr_ihs_yn        $1
	pbp_c_vt_fn_coins_ihs_yn         $1
	pbp_c_vt_fn_coins_ihs_ben_type   $2
	pbp_c_vt_fn_coins_iha_mcost_yn   $1
	pbp_c_vt_fn_coins_iha_int_num    $1
	pbp_c_vt_fn_coins_iph_mcost_yn   $1
	pbp_c_vt_fn_coins_iph_int_num    $1
	pbp_c_vt_fn_copay_ihs_yn         $1
	pbp_c_vt_fn_copay_ihs_ben_type   $2
	pbp_c_vt_fn_copay_iha_mcost_yn   $1
	pbp_c_vt_fn_copay_iha_int_num    $1
	pbp_c_vt_fn_copay_iph_mcost_yn   $1
	pbp_c_vt_fn_copay_iph_int_num    $1
	pbp_c_vt_fn_cstshr_snf_yn        $1
	pbp_c_vt_fn_coins_snf_yn         $1
	pbp_c_vt_fn_coins_snf_mcost_yn   $1
	pbp_c_vt_fn_coins_snf_int_num    $1
	pbp_c_vt_fn_copay_snf_yn         $1
	pbp_c_vt_fn_copay_snf_mcost_yn   $1
	pbp_c_vt_fn_copay_snf_int_num    $1
	pbp_c_vt_fn_snf_ded_yn           $1
;

infile '.\pbp\pbp_Section_C_3.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_c_vt_fn_yn
	pbp_c_vt_fn_mo
	pbp_c_vt_fn_bendesc_subcats
	pbp_c_vt_fn_maxplan_yn
	pbp_c_vt_fn_maxplan_subcats
	pbp_c_vt_fn_maxplan_amt
	pbp_c_vt_fn_maxplan_per
	pbp_c_vt_fn_deduct_yn
	pbp_c_vt_fn_deduct_subcats
	pbp_c_vt_fn_deduct_amt
	pbp_c_vt_fn_auth_yn
	pbp_c_vt_fn_auth_subcats
	pbp_c_vt_fn_auth
	pbp_c_vt_fn_referral_yn
	pbp_c_vt_fn_referral_subcats
	pbp_c_vt_fn_cstshr_ihs_yn
	pbp_c_vt_fn_coins_ihs_yn
	pbp_c_vt_fn_coins_ihs_ben_type
	pbp_c_vt_fn_coins_iha_mcost_yn
	pbp_c_vt_fn_coins_iha_pct
	pbp_c_vt_fn_coins_iha_int_num
	pbp_c_vt_fn_coins_iha_pct_int1
	pbp_c_vt_fn_coins_iha_bgnd_i1
	pbp_c_vt_fn_coins_iha_endd_i1
	pbp_c_vt_fn_coins_iha_pct_int2
	pbp_c_vt_fn_coins_iha_bgnd_i2
	pbp_c_vt_fn_coins_iha_endd_i2
	pbp_c_vt_fn_coins_iha_pct_int3
	pbp_c_vt_fn_coins_iha_bgnd_i3
	pbp_c_vt_fn_coins_iha_endd_i3
	pbp_c_vt_fn_coins_iph_mcost_yn
	pbp_c_vt_fn_coins_iph_pct
	pbp_c_vt_fn_coins_iph_int_num
	pbp_c_vt_fn_coins_iph_pct_int1
	pbp_c_vt_fn_coins_iph_bgnd_i1
	pbp_c_vt_fn_coins_iph_endd_i1
	pbp_c_vt_fn_coins_iph_pct_int2
	pbp_c_vt_fn_coins_iph_bgnd_i2
	pbp_c_vt_fn_coins_iph_endd_i2
	pbp_c_vt_fn_coins_iph_pct_int3
	pbp_c_vt_fn_coins_iph_bgnd_i3
	pbp_c_vt_fn_coins_iph_endd_i3
	pbp_c_vt_fn_copay_ihs_yn
	pbp_c_vt_fn_copay_ihs_ben_type
	pbp_c_vt_fn_copay_iha_mcost_yn
	pbp_c_vt_fn_copay_iha_ps_amt
	pbp_c_vt_fn_copay_iha_int_num
	pbp_c_vt_fn_copay_iha_amt_int1
	pbp_c_vt_fn_copay_iha_bgnd_i1
	pbp_c_vt_fn_copay_iha_endd_i1
	pbp_c_vt_fn_copay_iha_amt_int2
	pbp_c_vt_fn_copay_iha_bgnd_i2
	pbp_c_vt_fn_copay_iha_endd_i2
	pbp_c_vt_fn_copay_iha_amt_int3
	pbp_c_vt_fn_copay_iha_bgnd_i3
	pbp_c_vt_fn_copay_iha_endd_i3
	pbp_c_vt_fn_copay_iph_mcost_yn
	pbp_c_vt_fn_copay_iph_ps_amt
	pbp_c_vt_fn_copay_iph_int_num
	pbp_c_vt_fn_copay_iph_amt_int1
	pbp_c_vt_fn_copay_iph_bgnd_i1
	pbp_c_vt_fn_copay_iph_endd_i1
	pbp_c_vt_fn_copay_iph_amt_int2
	pbp_c_vt_fn_copay_iph_bgnd_i2
	pbp_c_vt_fn_copay_iph_endd_i2
	pbp_c_vt_fn_copay_iph_amt_int3
	pbp_c_vt_fn_copay_iph_bgnd_i3
	pbp_c_vt_fn_copay_iph_endd_i3
	pbp_c_vt_fn_cstshr_snf_yn
	pbp_c_vt_fn_coins_snf_yn
	pbp_c_vt_fn_coins_snf_mcost_yn
	pbp_c_vt_fn_coins_snf_pct
	pbp_c_vt_fn_coins_snf_int_num
	pbp_c_vt_fn_coins_snf_pct_i1
	pbp_c_vt_fn_coins_snf_bgnd_i1
	pbp_c_vt_fn_coins_snf_endd_i1
	pbp_c_vt_fn_coins_snf_pct_i2
	pbp_c_vt_fn_coins_snf_bgnd_i2
	pbp_c_vt_fn_coins_snf_endd_i2
	pbp_c_vt_fn_coins_snf_pct_i3
	pbp_c_vt_fn_coins_snf_bgnd_i3
	pbp_c_vt_fn_coins_snf_endd_i3
	pbp_c_vt_fn_copay_snf_yn
	pbp_c_vt_fn_copay_snf_mcost_yn
	pbp_c_vt_fn_copay_snf_amt
	pbp_c_vt_fn_copay_snf_int_num
	pbp_c_vt_fn_copay_snf_amt_i1
	pbp_c_vt_fn_copay_snf_bgnd_i1
	pbp_c_vt_fn_copay_snf_endd_i1
	pbp_c_vt_fn_copay_snf_amt_i2
	pbp_c_vt_fn_copay_snf_bgnd_i2
	pbp_c_vt_fn_copay_snf_endd_i2
	pbp_c_vt_fn_copay_snf_amt_i3
	pbp_c_vt_fn_copay_snf_bgnd_i3
	pbp_c_vt_fn_copay_snf_endd_i3
	pbp_c_vt_fn_snf_ded_yn
	pbp_c_vt_fn_snf_ded_amt
	pbp_c_vt_fn_outpt_group_num
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_c_vt_fn_yn                   = 'V/T Frgn YN'
	pbp_c_vt_fn_mo                   = 'V/T Frgn Benefit MO'
	pbp_c_vt_fn_bendesc_subcats      = 'V/T Frgn Bene Subsrvc Cats'
	pbp_c_vt_fn_maxplan_yn           = 'V/T Frgn Benefit Max Plan YN'
	pbp_c_vt_fn_maxplan_subcats      = 'V/T Frgn Max Plan Subsvc Cats'
	pbp_c_vt_fn_maxplan_amt          = 'V/T Frgn Benefit Max Plan Amt'
	pbp_c_vt_fn_maxplan_per          = 'V/T Frgn Benefit Max Plan Per'
	pbp_c_vt_fn_deduct_yn            = 'V/T Frgn Benefit Deduct YN'
	pbp_c_vt_fn_deduct_subcats       = 'V/T Frgn Deduct Subsrvc Cats'
	pbp_c_vt_fn_deduct_amt           = 'V/T Frgn Deduct Amt'
	pbp_c_vt_fn_auth_yn              = 'V/T Frgn Bene Auth Required YN'
	pbp_c_vt_fn_auth_subcats         = 'V/T Frgn Auth Subsrvc Cats'
	pbp_c_vt_fn_auth                 = 'V/T Frgn Benefit Auth'
	pbp_c_vt_fn_referral_yn          = 'V/T Frgn Referral Req YN'
	pbp_c_vt_fn_referral_subcats     = 'V/T Frgn Referral Subsvc Cats'
	pbp_c_vt_fn_cstshr_ihs_yn        = 'V/T Frgn IHS CstShr YN'
	pbp_c_vt_fn_coins_ihs_yn         = 'V/T Frgn IHS Coins YN'
	pbp_c_vt_fn_coins_ihs_ben_type   = 'V/T Frgn IHS Coins Type'
	pbp_c_vt_fn_coins_iha_mcost_yn   = 'V/T Frgn IHA Med Coin Cstsh YN'
	pbp_c_vt_fn_coins_iha_pct        = 'V/T Frgn IHA Coins Pct'
	pbp_c_vt_fn_coins_iha_int_num    = 'V/T Frgn IHA Coins Int Num'
	pbp_c_vt_fn_coins_iha_pct_int1   = 'V/T Frgn IHA Coins Pct Int 1'
	pbp_c_vt_fn_coins_iha_bgnd_i1    = 'V/T Frgn IHA Coins BgnD Int 1'
	pbp_c_vt_fn_coins_iha_endd_i1    = 'V/T Frgn IHA Coins EndD Int 1'
	pbp_c_vt_fn_coins_iha_pct_int2   = 'V/T Frgn IHA Coins Pct Int 2'
	pbp_c_vt_fn_coins_iha_bgnd_i2    = 'V/T Frgn IHA Coins BgnD Int 2'
	pbp_c_vt_fn_coins_iha_endd_i2    = 'V/T Frgn IHA Coins EndD Int 2'
	pbp_c_vt_fn_coins_iha_pct_int3   = 'V/T Frgn IHA Coins Pct Int 3'
	pbp_c_vt_fn_coins_iha_bgnd_i3    = 'V/T Frgn IHA Coins BgnD Int 3'
	pbp_c_vt_fn_coins_iha_endd_i3    = 'V/T Frgn IHA Coins EndD Int 3'
	pbp_c_vt_fn_coins_iph_mcost_yn   = 'V/T Frgn IPH Med Coin Cstsh YN'
	pbp_c_vt_fn_coins_iph_pct        = 'V/T Frgn IPH Coins Pct'
	pbp_c_vt_fn_coins_iph_int_num    = 'V/T Frgn IPH Coins Int Num'
	pbp_c_vt_fn_coins_iph_pct_int1   = 'V/T Frgn IPH Coins Pct Int1'
	pbp_c_vt_fn_coins_iph_bgnd_i1    = 'V/T Frgn IPH Coins BgnD Int 1'
	pbp_c_vt_fn_coins_iph_endd_i1    = 'V/T Frgn IPH Coins EndD Int 1'
	pbp_c_vt_fn_coins_iph_pct_int2   = 'V/T Frgn IPH Coins Pct Int 2'
	pbp_c_vt_fn_coins_iph_bgnd_i2    = 'V/T Frgn IPH Coins BgnD Int 2'
	pbp_c_vt_fn_coins_iph_endd_i2    = 'V/T Frgn IPH Coins EndD Int 2'
	pbp_c_vt_fn_coins_iph_pct_int3   = 'V/T Frgn IPH Coins Pct Int 3'
	pbp_c_vt_fn_coins_iph_bgnd_i3    = 'V/T Frgn IPH Coins BgnD Int 3'
	pbp_c_vt_fn_coins_iph_endd_i3    = 'V/T Frgn IPH Coins EndD Int 3'
	pbp_c_vt_fn_copay_ihs_yn         = 'V/T Frgn IHS Copay YN'
	pbp_c_vt_fn_copay_ihs_ben_type   = 'V/T Frgn IHS Copay Type'
	pbp_c_vt_fn_copay_iha_mcost_yn   = 'V/T Frgn IHA Med Coin Cstsh YN'
	pbp_c_vt_fn_copay_iha_ps_amt     = 'V/T Frgn IHA Copay PS Amt'
	pbp_c_vt_fn_copay_iha_int_num    = 'V/T Frgn IHA Copay Int Num'
	pbp_c_vt_fn_copay_iha_amt_int1   = 'V/T Frgn IHA Copay Amt Int 1'
	pbp_c_vt_fn_copay_iha_bgnd_i1    = 'V/T Frgn IHA Copay BgnD Int 1'
	pbp_c_vt_fn_copay_iha_endd_i1    = 'V/T Frgn IHA Copay EndD Int 1'
	pbp_c_vt_fn_copay_iha_amt_int2   = 'V/T Frgn IHA Copay Amt Int 2'
	pbp_c_vt_fn_copay_iha_bgnd_i2    = 'V/T Frgn IHA Copay BgnD Int 2'
	pbp_c_vt_fn_copay_iha_endd_i2    = 'V/T Frgn IHA Copay EndD Int 2'
	pbp_c_vt_fn_copay_iha_amt_int3   = 'V/T Frgn IHA Copay Amt Int 3'
	pbp_c_vt_fn_copay_iha_bgnd_i3    = 'V/T Frgn IHA Copay BgnD Int 3'
	pbp_c_vt_fn_copay_iha_endd_i3    = 'V/T Frgn IHA Copay EndD Int 3'
	pbp_c_vt_fn_copay_iph_mcost_yn   = 'V/T Frgn IPH Med Coin Cstsh YN'
	pbp_c_vt_fn_copay_iph_ps_amt     = 'V/T Frgn IPH Copay PS Amt'
	pbp_c_vt_fn_copay_iph_int_num    = 'V/T Frgn IPH Copay Int Num'
	pbp_c_vt_fn_copay_iph_amt_int1   = 'V/T Frgn IPH Copay Amt Int 1'
	pbp_c_vt_fn_copay_iph_bgnd_i1    = 'V/T Frgn IPH Copay BgnD Int 1'
	pbp_c_vt_fn_copay_iph_endd_i1    = 'V/T Frgn IPH Copay EndD Int 1'
	pbp_c_vt_fn_copay_iph_amt_int2   = 'V/T Frgn IPH Copay Amt Int 2'
	pbp_c_vt_fn_copay_iph_bgnd_i2    = 'V/T Frgn IPH Copay BgnD Int 2'
	pbp_c_vt_fn_copay_iph_endd_i2    = 'V/T Frgn IPH Copay EndD Int 2'
	pbp_c_vt_fn_copay_iph_amt_int3   = 'V/T Frgn IPH Copay Amt Int 3'
	pbp_c_vt_fn_copay_iph_bgnd_i3    = 'V/T Frgn IPH Copay BgnD Int 3'
	pbp_c_vt_fn_copay_iph_endd_i3    = 'V/T Frgn IPH Copay EndD Int 3'
	pbp_c_vt_fn_cstshr_snf_yn        = 'V/T FN SNF CstShr YN'
	pbp_c_vt_fn_coins_snf_yn         = 'V/T FN SNF Coinsurance'
	pbp_c_vt_fn_coins_snf_mcost_yn   = 'V/T FN SNF Med Coin Cstsh YN'
	pbp_c_vt_fn_coins_snf_pct        = 'V/T FN SNF Coins Pct'
	pbp_c_vt_fn_coins_snf_int_num    = 'V/T FN SNF Coins Interval Num'
	pbp_c_vt_fn_coins_snf_pct_i1     = 'V/T FN SNF Coins Pct Intrvl 1'
	pbp_c_vt_fn_coins_snf_bgnd_i1    = 'V/T FN SNF Coins BgnD Intrvl 1'
	pbp_c_vt_fn_coins_snf_endd_i1    = 'V/T FN SNF Coins EndD Intrvl 1'
	pbp_c_vt_fn_coins_snf_pct_i2     = 'V/T FN SNF Coins Pct Intrvl 2'
	pbp_c_vt_fn_coins_snf_bgnd_i2    = 'V/T FN SNF Coins BgnD Intrvl 2'
	pbp_c_vt_fn_coins_snf_endd_i2    = 'V/T FN SNF Coins EndD Intrvl 2'
	pbp_c_vt_fn_coins_snf_pct_i3     = 'V/T FN SNF Coins Pct Intrvl 3'
	pbp_c_vt_fn_coins_snf_bgnd_i3    = 'V/T FN SNF Coins BgnD Intrvl 3'
	pbp_c_vt_fn_coins_snf_endd_i3    = 'V/T FN SNF Coins EndD Intrvl 3'
	pbp_c_vt_fn_copay_snf_yn         = 'V/T FN SNF Copayment Y'
	pbp_c_vt_fn_copay_snf_mcost_yn   = 'V/T FN SNF Medicare Cst Shares'
	pbp_c_vt_fn_copay_snf_amt        = 'V/T FN SNF Copay PS Am'
	pbp_c_vt_fn_copay_snf_int_num    = 'V/T FN SNF Copay Interval Num'
	pbp_c_vt_fn_copay_snf_amt_i1     = 'V/T FN SNF Copay Amt Intrvl 1'
	pbp_c_vt_fn_copay_snf_bgnd_i1    = 'V/T FN SNF Copay BgnD Intrvl 1'
	pbp_c_vt_fn_copay_snf_endd_i1    = 'V/T FN SNF Copay EndD Intrvl 1'
	pbp_c_vt_fn_copay_snf_amt_i2     = 'V/T FN SNF Copay Amt Intrvl 2'
	pbp_c_vt_fn_copay_snf_bgnd_i2    = 'V/T FN SNF Copay BgnD Intrvl 2'
	pbp_c_vt_fn_copay_snf_endd_i2    = 'V/T FN SNF Copay EndD Intrvl 2'
	pbp_c_vt_fn_copay_snf_amt_i3     = 'V/T FN SNF Copay Amt Intrvl 3'
	pbp_c_vt_fn_copay_snf_bgnd_i3    = 'V/T FN SNF Copay BgnD Intrvl 3'
	pbp_c_vt_fn_copay_snf_endd_i3    = 'V/T FN SNF Copay EndD Intrvl 3'
	pbp_c_vt_fn_snf_ded_yn           = 'V/T FN SNF Deductible YN'
	pbp_c_vt_fn_snf_ded_amt          = 'V/T FN SNF Deductible Acute Am'
	pbp_c_vt_fn_outpt_group_num      = 'V/T Frgn Out Pt Group Num'
;

run;

proc sort data = pbp_Section_C_3 out=out.pbp_Section_C_3;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_Section_C_3(obs = 10);
  title 'pbp_Section_C_3 file ';
run;

proc means data = out.pbp_Section_C_3;
  title 'pbp_Section_C_3 file ';
run;

proc freq data = out.pbp_Section_C_3;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_c_vt_fn_yn
	pbp_c_vt_fn_mo
	pbp_c_vt_fn_maxplan_yn
	pbp_c_vt_fn_maxplan_per
	pbp_c_vt_fn_deduct_yn
	pbp_c_vt_fn_auth_yn
	pbp_c_vt_fn_auth
	pbp_c_vt_fn_referral_yn
	pbp_c_vt_fn_cstshr_ihs_yn
	pbp_c_vt_fn_coins_ihs_yn
	pbp_c_vt_fn_coins_ihs_ben_type
	pbp_c_vt_fn_coins_iha_mcost_yn
	pbp_c_vt_fn_coins_iha_int_num
	pbp_c_vt_fn_coins_iph_mcost_yn
	pbp_c_vt_fn_coins_iph_int_num
	pbp_c_vt_fn_copay_ihs_yn
	pbp_c_vt_fn_copay_ihs_ben_type
	pbp_c_vt_fn_copay_iha_mcost_yn
	pbp_c_vt_fn_copay_iha_int_num
	pbp_c_vt_fn_copay_iph_mcost_yn
	pbp_c_vt_fn_copay_iph_int_num
	pbp_c_vt_fn_cstshr_snf_yn
	pbp_c_vt_fn_coins_snf_yn
	pbp_c_vt_fn_coins_snf_mcost_yn
	pbp_c_vt_fn_coins_snf_int_num
	pbp_c_vt_fn_copay_snf_yn
	pbp_c_vt_fn_copay_snf_mcost_yn
	pbp_c_vt_fn_copay_snf_int_num
	pbp_c_vt_fn_snf_ded_yn
/ missing;
run;

proc contents data = out.pbp_Section_C_3;
  title 'pbp_Section_C_3 data';
run;
