*pbp_b14ad.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b14ad;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b14a_bendesc_yn              $1
	pbp_b14a_bendesc_ehc             $7
	pbp_b14a_bendesc_amo_hec         $1
	pbp_b14a_bendesc_amo_ntv         $1
	pbp_b14a_bendesc_amo_ntb         $1
	pbp_b14a_bendesc_amo_sc          $1
	pbp_b14a_bendesc_amo_mhc         $1
	pbp_b14a_bendesc_amo_nhl         $1
	pbp_b14a_bendesc_amo_oth         $1
	pbp_b14a_maxplan_yn              $1
	pbp_b14a_maxplan_per             $1
	pbp_b14a_maxenr_yn               $1
	pbp_b14a_maxenr_per              $1
	pbp_b14a_coins_yn                $1
	pbp_b14a_ded_yn                  $1
	pbp_b14a_copay_yn                $1
	pbp_b14a_auth                    $5
	pbp_b14a_refer_yn                $1
	pbp_b14b_bendesc_yn              $1
	pbp_b14b_bendesc                 $1
	pbp_b14b_bendesc_amo             $1
	pbp_b14b_maxenr_yn               $1
	pbp_b14b_maxenr_type             $1
	pbp_b14b_maxenr_per              $1
	pbp_b14b_coins_yn                $1
	pbp_b14b_ded_yn                  $1
	pbp_b14b_copay_yn                $1
	pbp_b14b_cost_share              $1
	pbp_b14b_auth                    $5
	pbp_b14b_refer_yn                $1
	pbp_b14c_bendesc_yn              $1
	pbp_b14c_bendesc_enhan           $1
	pbp_b14c_bendesc_amo             $1
	pbp_b14c_bendesc_lim             $1
	pbp_b14c_bendesc_per             $1
	pbp_b14c_maxplan_yn              $1
	pbp_b14c_maxplan_type            $1
	pbp_b14c_maxplan_per             $1
	pbp_b14c_maxenr_yn               $1
	pbp_b14c_maxenr_type             $1
	pbp_b14c_maxenr_per              $1
	pbp_b14c_coins_yn                $1
	pbp_b14c_ded_yn                  $1
	pbp_b14c_copay_yn                $1
	pbp_b14c_cost_share              $1
	pbp_b14c_auth                    $5
	pbp_b14c_refer_yn                $1
	pbp_b14d_bendesc_yn              $1
	pbp_b14d_bendesc_enhan           $2
	pbp_b14d_bendesc_amo_ps          $1
	pbp_b14d_bendesc_lim_aps_yn      $1
	pbp_b14d_bendesc_ps_per          $1
	pbp_b14d_bendesc_amo_pe          $1
	pbp_b14d_bendesc_lim_ape_yn      $1
	pbp_b14d_bendesc_pe_per          $1
	pbp_b14d_maxplan_yn              $1
	pbp_b14d_maxplan_type            $1
	pbp_b14d_maxplan_per             $1
	pbp_b14d_maxenr_yn               $1
	pbp_b14d_maxenr_type             $1
	pbp_b14d_maxenr_per              $1
	pbp_b14d_coins_yn                $1
	pbp_b14d_ded_yn                  $1
	pbp_b14d_copay_yn                $1
	pbp_b14d_cost_share_yn           $1
	pbp_b14d_auth                    $5
	pbp_b14d_refer_yn                $1
;

infile '.\pbp\pbp_b14_preventive_1.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b14a_bendesc_yn
	pbp_b14a_bendesc_ehc
	pbp_b14a_bendesc_amo_hec
	pbp_b14a_bendesc_amo_ntv
	pbp_b14a_bendesc_amo_ntb
	pbp_b14a_bendesc_amo_sc
	pbp_b14a_bendesc_amo_mhc
	pbp_b14a_bendesc_amo_nhl
	pbp_b14a_bendesc_amo_oth
	pbp_b14a_maxplan_yn
	pbp_b14a_maxplan_amt
	pbp_b14a_maxplan_per
	pbp_b14a_maxenr_yn
	pbp_b14a_maxenr_amt
	pbp_b14a_maxenr_per
	pbp_b14a_coins_yn
	pbp_b14a_coins_sc_mdcr_pct_min
	pbp_b14a_coins_sc_mdcr_pct_max
	pbp_b14a_coins_pct_hec
	pbp_b14a_coins_pct_max_hec
	pbp_b14a_coins_pct_ntb
	pbp_b14a_coins_pct_ntv
	pbp_b14a_coins_pct_sc
	pbp_b14a_coins_pct_mhc
	pbp_b14a_coins_pct_max_mhc
	pbp_b14a_coins_pct_nhl
	pbp_b14a_coins_pct_oth
	pbp_b14a_coins_pct_max_oth
	pbp_b14a_ded_yn
	pbp_b14a_ded_amt
	pbp_b14a_copay_yn
	pbp_b14a_copay_sc_mdcr_amt_min
	pbp_b14a_copay_sc_mdcr_amt_max
	pbp_b14a_copay_hec_amt
	pbp_b14a_copay_ntv_amt
	pbp_b14a_copay_ntb_amt
	pbp_b14a_copay_sc_amt
	pbp_b14a_copay_mhc_amt
	pbp_b14a_copay_mhc_max_amt
	pbp_b14a_copay_nhl_amt
	pbp_b14a_copay_oth_amt
	pbp_b14a_copay_oth_max_amt
	pbp_b14a_auth
	pbp_b14a_refer_yn
	pbp_b14b_bendesc_yn
	pbp_b14b_bendesc
	pbp_b14b_bendesc_amo
	pbp_b14b_maxenr_yn
	pbp_b14b_maxenr_type
	pbp_b14b_maxenr_amt
	pbp_b14b_maxenr_per
	pbp_b14b_coins_yn
	pbp_b14b_coins_pct_mc
	pbp_b14b_coins_pct_oi
	pbp_b14b_coins_pct_maxoi
	pbp_b14b_ded_yn
	pbp_b14b_ded_amt
	pbp_b14b_copay_yn
	pbp_b14b_copay_mc_amt
	pbp_b14b_copay_oi_amt
	pbp_b14b_copay_oi_max_amt
	pbp_b14b_cost_share
	pbp_b14b_auth
	pbp_b14b_refer_yn
	pbp_b14c_bendesc_yn
	pbp_b14c_bendesc_enhan
	pbp_b14c_bendesc_amo
	pbp_b14c_bendesc_lim
	pbp_b14c_bendesc_numv
	pbp_b14c_bendesc_per
	pbp_b14c_maxplan_yn
	pbp_b14c_maxplan_type
	pbp_b14c_maxplan_amt
	pbp_b14c_maxplan_per
	pbp_b14c_maxenr_yn
	pbp_b14c_maxenr_type
	pbp_b14c_maxenr_amt
	pbp_b14c_maxenr_per
	pbp_b14c_coins_yn
	pbp_b14c_mc_coins_pct
	pbp_b14c_coins_pct
	pbp_b14c_ded_yn
	pbp_b14c_ded_amt
	pbp_b14c_copay_yn
	pbp_b14c_mc_copay_amt
	pbp_b14c_copay_amt
	pbp_b14c_cost_share
	pbp_b14c_auth
	pbp_b14c_refer_yn
	pbp_b14d_bendesc_yn
	pbp_b14d_bendesc_enhan
	pbp_b14d_bendesc_amo_ps
	pbp_b14d_bendesc_lim_aps_yn
	pbp_b14d_bendesc_numps
	pbp_b14d_bendesc_ps_per
	pbp_b14d_bendesc_amo_pe
	pbp_b14d_bendesc_lim_ape_yn
	pbp_b14d_bendesc_numpe
	pbp_b14d_bendesc_pe_per
	pbp_b14d_maxplan_yn
	pbp_b14d_maxplan_type
	pbp_b14d_maxplan_amt
	pbp_b14d_maxplan_per
	pbp_b14d_maxenr_yn
	pbp_b14d_maxenr_type
	pbp_b14d_maxenr_amt
	pbp_b14d_maxenr_per
	pbp_b14d_coins_yn
	pbp_b14d_coins_pct_mcpap
	pbp_b14d_coins_pct_pap
	pbp_b14d_coins_pct_mcpe
	pbp_b14d_coins_pct_pe
	pbp_b14d_ded_yn
	pbp_b14d_ded_amt
	pbp_b14d_copay_yn
	pbp_b14d_copay_amt_mcpap
	pbp_b14d_copay_amt_pap
	pbp_b14d_copay_amt_mcpe
	pbp_b14d_copay_amt_pe
	pbp_b14d_cost_share_yn
	pbp_b14d_auth
	pbp_b14d_refer_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b14a_bendesc_yn              = 'Health Ed Ben Desc YN'
	pbp_b14a_bendesc_ehc             = 'Health Ed Ben Desc Enhance'
	pbp_b14a_bendesc_amo_hec         = 'Health Ed HEC Ben Desc MO'
	pbp_b14a_bendesc_amo_ntv         = 'Health Ed NTV Ben Desc MO'
	pbp_b14a_bendesc_amo_ntb         = 'Health Ed NTB Ben Desc MO'
	pbp_b14a_bendesc_amo_sc          = 'Health Ed SC Ben Desc MO'
	pbp_b14a_bendesc_amo_mhc         = 'Health Ed MHC Ben Desc MO'
	pbp_b14a_bendesc_amo_nhl         = 'Health Ed NHL Ben Desc MO'
	pbp_b14a_bendesc_amo_oth         = 'Health Ed OTH Ben Desc MO'
	pbp_b14a_maxplan_yn              = 'Health Ed Max Plan YN'
	pbp_b14a_maxplan_amt             = 'Health Ed Max Plan Amt'
	pbp_b14a_maxplan_per             = 'Health Ed Max Plan Per'
	pbp_b14a_maxenr_yn               = 'Health Ed Max Enr YN'
	pbp_b14a_maxenr_amt              = 'Health Ed Max Enr Amt'
	pbp_b14a_maxenr_per              = 'Health Ed Max Enr Per'
	pbp_b14a_coins_yn                = 'Health Ed Coinsurance YN'
	pbp_b14a_coins_sc_mdcr_pct_min   = 'Health Ed Min Smoke Cess Coins'
	pbp_b14a_coins_sc_mdcr_pct_max   = 'Health Ed Max Smoke Cess Coins'
	pbp_b14a_coins_pct_hec           = 'Health Ed HEC Min Coins Pct'
	pbp_b14a_coins_pct_max_hec       = 'Health Ed HEC Max Coins Pct'
	pbp_b14a_coins_pct_ntb           = 'Health Ed NTB Coins Pct'
	pbp_b14a_coins_pct_ntv           = 'Health Ed NTV Coins Pct'
	pbp_b14a_coins_pct_sc            = 'Health Ed SC Coins Pct'
	pbp_b14a_coins_pct_mhc           = 'Health Ed MHC Min Coins Pct'
	pbp_b14a_coins_pct_max_mhc       = 'Health Ed MHC Max Coins Pct'
	pbp_b14a_coins_pct_nhl           = 'Health Ed NHL Coins Pct'
	pbp_b14a_coins_pct_oth           = 'Health Ed OTH Min Coins Pct'
	pbp_b14a_coins_pct_max_oth       = 'Health Ed OTH Max Coins Pct'
	pbp_b14a_ded_yn                  = 'Health Ed Deductible YN'
	pbp_b14a_ded_amt                 = 'Health Ed Deductible Amt'
	pbp_b14a_copay_yn                = 'Health Ed Copayment YN'
	pbp_b14a_copay_sc_mdcr_amt_min   = 'Health Ed Min Copay SC Amt'
	pbp_b14a_copay_sc_mdcr_amt_max   = 'Health Ed Max Copay SC Amt'
	pbp_b14a_copay_hec_amt           = 'Health Ed HEC Copay Min Amt'
	pbp_b14a_copay_ntv_amt           = 'Health Ed NTV Copay Amt'
	pbp_b14a_copay_ntb_amt           = 'Health Ed NTB Copay Amt'
	pbp_b14a_copay_sc_amt            = 'Health Ed SC Copay Amt'
	pbp_b14a_copay_mhc_amt           = 'Health Ed MHC Min Copay Amt'
	pbp_b14a_copay_mhc_max_amt       = 'Health Ed MHC Max Copay Amt'
	pbp_b14a_copay_nhl_amt           = 'Health Ed NHL Copay Amt'
	pbp_b14a_copay_oth_amt           = 'Health Ed OTH Min Copay Amt'
	pbp_b14a_copay_oth_max_amt       = 'Health Ed OTH Max Copay Amt'
	pbp_b14a_auth                    = 'Health Ed Enrollee Auth'
	pbp_b14a_refer_yn                = 'Health Ed Referral YN'
	pbp_b14b_bendesc_yn              = 'Immunizations Ben Desc YN'
	pbp_b14b_bendesc                 = 'Immunizations Ben Desc Enhance'
	pbp_b14b_bendesc_amo             = 'Immunizations Ben Desc MO'
	pbp_b14b_maxenr_yn               = 'Immunizations Max Enr YN'
	pbp_b14b_maxenr_type             = 'Immunizations Max Enr Type'
	pbp_b14b_maxenr_amt              = 'Immunizations Max Enr Amt'
	pbp_b14b_maxenr_per              = 'Immunizations Max Enr Per'
	pbp_b14b_coins_yn                = 'Immunizations Coinsurance YN'
	pbp_b14b_coins_pct_mc            = 'Immunizations MC Coins Pct'
	pbp_b14b_coins_pct_oi            = 'Immunizations OI Min Coins Pct'
	pbp_b14b_coins_pct_maxoi         = 'Immunizations OI Max Coins Pct'
	pbp_b14b_ded_yn                  = 'Immunizations Deductible YN'
	pbp_b14b_ded_amt                 = 'Immunizations Deductible Amt'
	pbp_b14b_copay_yn                = 'Immunizations Copayment YN'
	pbp_b14b_copay_mc_amt            = 'Immunizations MC Copay Amt'
	pbp_b14b_copay_oi_amt            = 'Immunizations OI Min Copay Amt'
	pbp_b14b_copay_oi_max_amt        = 'Immunizations OI Max Copay Amt'
	pbp_b14b_cost_share              = 'Immunizations Cost Share'
	pbp_b14b_auth                    = 'Immunizations Enrollee Auth'
	pbp_b14b_refer_yn                = 'Immunizations Referral YN'
	pbp_b14c_bendesc_yn              = 'Routine Phys Ben Desc YN'
	pbp_b14c_bendesc_enhan           = 'Routine Phys Ben Desc Enhance'
	pbp_b14c_bendesc_amo             = 'Routine Phys Ben Desc MO'
	pbp_b14c_bendesc_lim             = 'Routine Phys Ben Desc Lim YN'
	pbp_b14c_bendesc_numv            = 'Routine Phys Ben Desc Num'
	pbp_b14c_bendesc_per             = 'Routine Phys Ben Desc Per'
	pbp_b14c_maxplan_yn              = 'Routine Phys Max Plan YN'
	pbp_b14c_maxplan_type            = 'Routine Phys Max Plan Type'
	pbp_b14c_maxplan_amt             = 'Routine Phys Max Plan Amt'
	pbp_b14c_maxplan_per             = 'Routine Phys Max Plan Per'
	pbp_b14c_maxenr_yn               = 'Routine Phys Max Enr YN'
	pbp_b14c_maxenr_type             = 'Routine Phys Max Enr Type'
	pbp_b14c_maxenr_amt              = 'Routine Phys Max Enr Amt'
	pbp_b14c_maxenr_per              = 'Routine Phys Max Enr Per'
	pbp_b14c_coins_yn                = 'Routine Phys Coinsurance YN'
	pbp_b14c_mc_coins_pct            = 'Routine Phys MC Coins Pct'
	pbp_b14c_coins_pct               = 'Routine Phys Coins Pct'
	pbp_b14c_ded_yn                  = 'Routine Phys Deductible YN'
	pbp_b14c_ded_amt                 = 'Routine Phys Deductible Amt'
	pbp_b14c_copay_yn                = 'Routine Phys Copayment YN'
	pbp_b14c_mc_copay_amt            = 'Routine Phys MC Copayment Amt'
	pbp_b14c_copay_amt               = 'Routine Phys Copay Amt'
	pbp_b14c_cost_share              = 'Routine Phys Cost Share'
	pbp_b14c_auth                    = 'Routine Phys Enrollee Auth'
	pbp_b14c_refer_yn                = 'Routine Phys Referral YN'
	pbp_b14d_bendesc_yn              = 'Pap/Pelvic Ben Desc YN'
	pbp_b14d_bendesc_enhan           = 'Pap/Pelvic Ben Desc Enhance'
	pbp_b14d_bendesc_amo_ps          = 'Pap Smears Ben Desc MO'
	pbp_b14d_bendesc_lim_aps_yn      = 'Pap Smears Ben Desc Lim YN'
	pbp_b14d_bendesc_numps           = 'Pap Smears Ben Desc Num'
	pbp_b14d_bendesc_ps_per          = 'Pap Smears Ben Desc Per'
	pbp_b14d_bendesc_amo_pe          = 'Pelvic Exams Ben Desc MO'
	pbp_b14d_bendesc_lim_ape_yn      = 'Pelvic Exm Ben Desc Lim YN'
	pbp_b14d_bendesc_numpe           = 'Pelvic Exams Ben Desc Num'
	pbp_b14d_bendesc_pe_per          = 'Pelvic Exams Ben Desc Per'
	pbp_b14d_maxplan_yn              = 'Pap/Pelvic Max Plan YN'
	pbp_b14d_maxplan_type            = 'Pap/Pelvic Max Plan Type'
	pbp_b14d_maxplan_amt             = 'Pap/Pelvic Max Plan Amt'
	pbp_b14d_maxplan_per             = 'Pap/Pelvic Max Plan Per'
	pbp_b14d_maxenr_yn               = 'Pap/Pelvic Max Enr YN'
	pbp_b14d_maxenr_type             = 'Pap/Pelvic Max Enr Type'
	pbp_b14d_maxenr_amt              = 'Pap/Pelvic Max Enr Amt'
	pbp_b14d_maxenr_per              = 'Pap/Pelvic Max Enr Per'
	pbp_b14d_coins_yn                = 'Pap/Pelvic Coinsurance YN'
	pbp_b14d_coins_pct_mcpap         = 'Pap Smears MC Coins Pct'
	pbp_b14d_coins_pct_pap           = 'Pap Smears Coins Pct'
	pbp_b14d_coins_pct_mcpe          = 'Pelvic Exams MC Coins Pct'
	pbp_b14d_coins_pct_pe            = 'Pelvic Exams Coins Pct'
	pbp_b14d_ded_yn                  = 'Pap/Pelvic Deductible YN'
	pbp_b14d_ded_amt                 = 'Pap/Pelvic Deductible Amt'
	pbp_b14d_copay_yn                = 'Pap/Pelvic Copayment YN'
	pbp_b14d_copay_amt_mcpap         = 'Pap Smears MC Copay Amt'
	pbp_b14d_copay_amt_pap           = 'Pap Smears Copay Amt'
	pbp_b14d_copay_amt_mcpe          = 'Pelvic Exams MC Copay Amt'
	pbp_b14d_copay_amt_pe            = 'Pelvic Exams Copay Amt'
	pbp_b14d_cost_share_yn           = 'Pap/Pelvic Cost Share'
	pbp_b14d_auth                    = 'Pap/Pelvic Enrollee Auth'
	pbp_b14d_refer_yn                = 'Pap/Pelvic Referral YN'
;

run;

proc sort data = pbp_b14ad out=out.pbp_b14ad;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b14ad(obs = 10);
  title 'pbp_b14_preventive_1 file ';
run;

proc means data = out.pbp_b14ad;
  title 'pbp_b14_preventive_1 file ';
run;

proc freq data = out.pbp_b14ad;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b14a_bendesc_yn
	pbp_b14a_bendesc_amo_hec
	pbp_b14a_bendesc_amo_ntv
	pbp_b14a_bendesc_amo_ntb
	pbp_b14a_bendesc_amo_sc
	pbp_b14a_bendesc_amo_mhc
	pbp_b14a_bendesc_amo_nhl
	pbp_b14a_bendesc_amo_oth
	pbp_b14a_maxplan_yn
	pbp_b14a_maxplan_per
	pbp_b14a_maxenr_yn
	pbp_b14a_maxenr_per
	pbp_b14a_coins_yn
	pbp_b14a_ded_yn
	pbp_b14a_copay_yn
	pbp_b14a_auth
	pbp_b14a_refer_yn
	pbp_b14b_bendesc_yn
	pbp_b14b_bendesc
	pbp_b14b_bendesc_amo
	pbp_b14b_maxenr_yn
	pbp_b14b_maxenr_type
	pbp_b14b_maxenr_per
	pbp_b14b_coins_yn
	pbp_b14b_ded_yn
	pbp_b14b_copay_yn
	pbp_b14b_cost_share
	pbp_b14b_auth
	pbp_b14b_refer_yn
	pbp_b14c_bendesc_yn
	pbp_b14c_bendesc_enhan
	pbp_b14c_bendesc_amo
	pbp_b14c_bendesc_lim
	pbp_b14c_bendesc_per
	pbp_b14c_maxplan_yn
	pbp_b14c_maxplan_type
	pbp_b14c_maxplan_per
	pbp_b14c_maxenr_yn
	pbp_b14c_maxenr_type
	pbp_b14c_maxenr_per
	pbp_b14c_coins_yn
	pbp_b14c_ded_yn
	pbp_b14c_copay_yn
	pbp_b14c_cost_share
	pbp_b14c_auth
	pbp_b14c_refer_yn
	pbp_b14d_bendesc_yn
	pbp_b14d_bendesc_enhan
	pbp_b14d_bendesc_amo_ps
	pbp_b14d_bendesc_lim_aps_yn
	pbp_b14d_bendesc_ps_per
	pbp_b14d_bendesc_amo_pe
	pbp_b14d_bendesc_lim_ape_yn
	pbp_b14d_bendesc_pe_per
	pbp_b14d_maxplan_yn
	pbp_b14d_maxplan_type
	pbp_b14d_maxplan_per
	pbp_b14d_maxenr_yn
	pbp_b14d_maxenr_type
	pbp_b14d_maxenr_per
	pbp_b14d_coins_yn
	pbp_b14d_ded_yn
	pbp_b14d_copay_yn
	pbp_b14d_cost_share_yn
	pbp_b14d_auth
	pbp_b14d_refer_yn
/ missing;
run;

proc contents data = out.pbp_b14ad;
  title 'pbp_b14ad data';
run;
