*pbp_b14ej.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b14ej;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b14e_bendesc_yn              $1
	pbp_b14e_bendesc                 $1
	pbp_b14e_bendesc_amo             $1
	pbp_b14e_bendesc_lim_ps_yn       $1
	pbp_b14e_bendesc_as_per          $1
	pbp_b14e_maxplan_yn              $1
	pbp_b14e_maxplan_type            $1
	pbp_b14e_maxplan_per             $1
	pbp_b14e_maxenr_yn               $1
	pbp_b14e_maxenr_type             $1
	pbp_b14e_maxenr_per              $1
	pbp_b14e_coins_yn                $1
	pbp_b14e_ded_yn                  $1
	pbp_b14e_copay_yn                $1
	pbp_b14e_cost_share_yn           $1
	pbp_b14e_auth                    $5
	pbp_b14e_refer_yn                $1
	pbp_b14f_bendesc_yn              $1
	pbp_b14f_bendesc                 $1
	pbp_b14f_bendesc_amo             $1
	pbp_b14f_bendesc_lim_cs_yn       $1
	pbp_b14f_bendesc_as_per          $1
	pbp_b14f_maxplan_yn              $1
	pbp_b14f_maxplan_type            $1
	pbp_b14f_maxplan_per             $1
	pbp_b14f_maxenr_yn               $1
	pbp_b14f_maxenr_type             $1
	pbp_b14f_maxenr_per              $1
	pbp_b14f_coins_yn                $1
	pbp_b14f_ded_yn                  $1
	pbp_b14f_copay_yn                $1
	pbp_b14f_cost_share_yn           $1
	pbp_b14f_auth                    $5
	pbp_b14f_refer_yn                $1
	pbp_b14g_maxenr_yn               $1
	pbp_b14g_maxenr_type             $1
	pbp_b14g_maxenr_per              $1
	pbp_b14g_coins_yn                $1
	pbp_b14g_ded_yn                  $1
	pbp_b14g_copay_yn                $1
	pbp_b14g_cost_share_yn           $1
	pbp_b14g_auth                    $5
	pbp_b14g_refer_yn                $1
	pbp_b14h_bendesc_yn              $1
	pbp_b14h_bendesc                 $1
	pbp_b14h_bendesc_amo             $1
	pbp_b14h_bendesc_lim_ms_yn       $1
	pbp_b14h_bendesc_as_per          $1
	pbp_b14h_maxplan_yn              $1
	pbp_b14h_maxplan_type            $1
	pbp_b14h_maxplan_per             $1
	pbp_b14h_maxenr_yn               $1
	pbp_b14h_maxenr_type             $1
	pbp_b14h_maxenr_per              $1
	pbp_b14h_coins_yn                $1
	pbp_b14h_ded_yn                  $1
	pbp_b14h_copay_yn                $1
	pbp_b14h_cost_share_yn           $1
	pbp_b14h_auth                    $5
	pbp_b14h_refer_yn                $1
	pbp_b14i_maxenr_yn               $1
	pbp_b14i_maxenr_type             $1
	pbp_b14i_maxenr_per              $1
	pbp_b14i_coins_yn                $1
	pbp_b14i_ded_yn                  $1
	pbp_b14i_copay_yn                $1
	pbp_b14i_cost_share              $1
	pbp_b14i_auth                    $5
	pbp_b14i_refer_yn                $1
	pbp_b14j_maxenr_yn               $1
	pbp_b14j_maxenr_type             $1
	pbp_b14j_maxenr_per              $1
	pbp_b14j_coins_yn                $1
	pbp_b14j_ded_yn                  $1
	pbp_b14j_copay_yn                $1
	pbp_b14j_auth                    $5
	pbp_b14j_refer_yn                $1
;

infile '.\pbp\pbp_b14_preventive_2.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b14e_bendesc_yn
	pbp_b14e_bendesc
	pbp_b14e_bendesc_amo
	pbp_b14e_bendesc_lim_ps_yn
	pbp_b14e_bendesc_numps
	pbp_b14e_bendesc_as_per
	pbp_b14e_maxplan_yn
	pbp_b14e_maxplan_type
	pbp_b14e_maxplan_amt
	pbp_b14e_maxplan_per
	pbp_b14e_maxenr_yn
	pbp_b14e_maxenr_type
	pbp_b14e_maxenr_amt
	pbp_b14e_maxenr_per
	pbp_b14e_coins_yn
	pbp_b14e_coins_pct
	pbp_b14e_ad_coins_pct
	pbp_b14e_ded_yn
	pbp_b14e_ded_amt
	pbp_b14e_copay_yn
	pbp_b14e_copay_amt
	pbp_b14e_as_copay_amt
	pbp_b14e_cost_share_yn
	pbp_b14e_auth
	pbp_b14e_refer_yn
	pbp_b14f_bendesc_yn
	pbp_b14f_bendesc
	pbp_b14f_bendesc_amo
	pbp_b14f_bendesc_lim_cs_yn
	pbp_b14f_bendesc_numps
	pbp_b14f_bendesc_as_per
	pbp_b14f_maxplan_yn
	pbp_b14f_maxplan_type
	pbp_b14f_maxplan_amt
	pbp_b14f_maxplan_per
	pbp_b14f_maxenr_yn
	pbp_b14f_maxenr_type
	pbp_b14f_maxenr_amt
	pbp_b14f_maxenr_per
	pbp_b14f_coins_yn
	pbp_b14f_coins_pct
	pbp_b14f_coins_max_pct
	pbp_b14f_as_coins_pct
	pbp_b14f_as_coins_max_pct
	pbp_b14f_ded_yn
	pbp_b14f_ded_amt
	pbp_b14f_copay_yn
	pbp_b14f_copay_mc_min_amt
	pbp_b14f_copay_mc_max_amt
	pbp_b14f_copay_as_min_amt
	pbp_b14f_copay_as_max_amt
	pbp_b14f_cost_share_yn
	pbp_b14f_auth
	pbp_b14f_refer_yn
	pbp_b14g_maxenr_yn
	pbp_b14g_maxenr_type
	pbp_b14g_maxenr_amt
	pbp_b14g_maxenr_per
	pbp_b14g_coins_yn
	pbp_b14g_coins_pct_min
	pbp_b14g_coins_pct_max
	pbp_b14g_ded_yn
	pbp_b14g_ded_amt
	pbp_b14g_copay_yn
	pbp_b14g_copay_amt_min
	pbp_b14g_copay_amt_max
	pbp_b14g_cost_share_yn
	pbp_b14g_auth
	pbp_b14g_refer_yn
	pbp_b14h_bendesc_yn
	pbp_b14h_bendesc
	pbp_b14h_bendesc_amo
	pbp_b14h_bendesc_lim_ms_yn
	pbp_b14h_bendesc_numps
	pbp_b14h_bendesc_as_per
	pbp_b14h_maxplan_yn
	pbp_b14h_maxplan_type
	pbp_b14h_maxplan_amt
	pbp_b14h_maxplan_per
	pbp_b14h_maxenr_yn
	pbp_b14h_maxenr_type
	pbp_b14h_maxenr_amt
	pbp_b14h_maxenr_per
	pbp_b14h_coins_yn
	pbp_b14h_coins_pct
	pbp_b14h_ad_coins_pct
	pbp_b14h_ded_yn
	pbp_b14h_ded_amt
	pbp_b14h_copay_yn
	pbp_b14h_copay_min_amt
	pbp_b14h_copay_max_amt
	pbp_b14h_as_copay_amt
	pbp_b14h_cost_share_yn
	pbp_b14h_auth
	pbp_b14h_refer_yn
	pbp_b14i_maxenr_yn
	pbp_b14i_maxenr_type
	pbp_b14i_maxenr_amt
	pbp_b14i_maxenr_per
	pbp_b14i_coins_yn
	pbp_b14i_coins_pct
	pbp_b14i_coins_max_pct
	pbp_b14i_ded_yn
	pbp_b14i_ded_amt
	pbp_b14i_copay_yn
	pbp_b14i_copay_mc_min_amt
	pbp_b14i_copay_mc_max_amt
	pbp_b14i_cost_share
	pbp_b14i_auth
	pbp_b14i_refer_yn
	pbp_b14j_maxenr_yn
	pbp_b14j_maxenr_type
	pbp_b14j_maxenr_amt
	pbp_b14j_maxenr_per
	pbp_b14j_coins_yn
	pbp_b14j_coins_pct
	pbp_b14j_coins_max_pct
	pbp_b14j_ded_yn
	pbp_b14j_ded_amt
	pbp_b14j_copay_yn
	pbp_b14j_copay_mc_amt
	pbp_b14j_copay_mc_max_amt
	pbp_b14j_auth
	pbp_b14j_refer_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b14e_bendesc_yn              = 'Prostate Scrn Ben Desc YN'
	pbp_b14e_bendesc                 = 'Prostate Scrn Ben Desc Enhance'
	pbp_b14e_bendesc_amo             = 'Prostate Scrn Ben Desc MO'
	pbp_b14e_bendesc_lim_ps_yn       = 'Prostate Scrn Ben Desc Lim YN'
	pbp_b14e_bendesc_numps           = 'Prostate Scrn Ben Desc Num'
	pbp_b14e_bendesc_as_per          = 'Prostate Scrn Ben Desc Per'
	pbp_b14e_maxplan_yn              = 'Prostate Scrn Max Plan YN'
	pbp_b14e_maxplan_type            = 'Prostate Scrn Max Plan Type'
	pbp_b14e_maxplan_amt             = 'Prostate Scrn Max Plan Amt'
	pbp_b14e_maxplan_per             = 'Prostate Scrn Max Plan Per'
	pbp_b14e_maxenr_yn               = 'Prostate Scrn Max Enr YN'
	pbp_b14e_maxenr_type             = 'Prostate Scrn Max Enr Type'
	pbp_b14e_maxenr_amt              = 'Prostate Scrn Max Enr Amt'
	pbp_b14e_maxenr_per              = 'Prostate Scrn Max Enr Per'
	pbp_b14e_coins_yn                = 'Prostate Scrn Coinsurance YN'
	pbp_b14e_coins_pct               = 'Prostate Scrn MC Coins Pct'
	pbp_b14e_ad_coins_pct            = 'Prostate Scrn AS Coins Pct'
	pbp_b14e_ded_yn                  = 'Prostate Scrn Deductible YN'
	pbp_b14e_ded_amt                 = 'Prostate Scrn Deductible Amt'
	pbp_b14e_copay_yn                = 'Prostate Scrn Copayment YN'
	pbp_b14e_copay_amt               = 'Prostate Scrn MC Copay Amt'
	pbp_b14e_as_copay_amt            = 'Prostate Scrn AS Copay Amt'
	pbp_b14e_cost_share_yn           = 'Prostate Scrn Cost Share'
	pbp_b14e_auth                    = 'Prostate Scrn Enrollee Auth'
	pbp_b14e_refer_yn                = 'Prostate Scrn Referral YN'
	pbp_b14f_bendesc_yn              = 'Colorctl Scrn Ben Desc YN'
	pbp_b14f_bendesc                 = 'Colorctl Scrn Ben Desc Enhance'
	pbp_b14f_bendesc_amo             = 'Colorctl Scrn Ben Desc MO'
	pbp_b14f_bendesc_lim_cs_yn       = 'Colorctl Scrn Ben Desc Lim YN'
	pbp_b14f_bendesc_numps           = 'Colorctl Scrn Ben Desc Num'
	pbp_b14f_bendesc_as_per          = 'Colorctl Scrn Ben Desc Per'
	pbp_b14f_maxplan_yn              = 'Colorctl Scrn Max Plan YN'
	pbp_b14f_maxplan_type            = 'Colorctl Scrn Max Plan Type'
	pbp_b14f_maxplan_amt             = 'Colorctl Scrn Max Plan Amt'
	pbp_b14f_maxplan_per             = 'Colorctl Scrn Max Plan Per'
	pbp_b14f_maxenr_yn               = 'Colorctl Scrn Max Enr YN'
	pbp_b14f_maxenr_type             = 'Colorctl Scrn Max Enr Type'
	pbp_b14f_maxenr_amt              = 'Colorctl Scrn Max Enr Amt'
	pbp_b14f_maxenr_per              = 'Colorctl Scrn Max Enr Per'
	pbp_b14f_coins_yn                = 'Colorctl Scrn Coinsurance YN'
	pbp_b14f_coins_pct               = 'Colorctl Scrn MC Min Coins Pct'
	pbp_b14f_coins_max_pct           = 'Colorctl Scrn MC Max Coins Pct'
	pbp_b14f_as_coins_pct            = 'Colorctl Scrn AS Min Coins Pct'
	pbp_b14f_as_coins_max_pct        = 'Colorctl Scrn AS Max Coins Pct'
	pbp_b14f_ded_yn                  = 'Colorctl Scrn Deductible YN'
	pbp_b14f_ded_amt                 = 'Colorctl Scrn Deductible Amt'
	pbp_b14f_copay_yn                = 'Colorctl Scrn Copayment YN'
	pbp_b14f_copay_mc_min_amt        = 'Colorctl Scrn MC Min Copay Amt'
	pbp_b14f_copay_mc_max_amt        = 'Colorctl Scrn MC Max Copay Amt'
	pbp_b14f_copay_as_min_amt        = 'Colorctl Scrn AS Min Copay Amt'
	pbp_b14f_copay_as_max_amt        = 'Colorctl Scrn AS Max Copay Amt'
	pbp_b14f_cost_share_yn           = 'Colorctl Scrn Cost Share'
	pbp_b14f_auth                    = 'Colorctl Scrn Enrollee Auth'
	pbp_b14f_refer_yn                = 'Colorctl Scrn Referral YN'
	pbp_b14g_maxenr_yn               = 'Bone Mass Meas Max Enr YN'
	pbp_b14g_maxenr_type             = 'Bone Mass Meas Max Enr Type'
	pbp_b14g_maxenr_amt              = 'Bone Mass Meas Max Enr Amt'
	pbp_b14g_maxenr_per              = 'Bone Mass Meas. Max Enr Per'
	pbp_b14g_coins_yn                = 'Bone Mass Meas Coinsurance YN'
	pbp_b14g_coins_pct_min           = 'Bone Mass Meas Coins Pct Min'
	pbp_b14g_coins_pct_max           = 'Bone Mass Meas Coins Pct Max'
	pbp_b14g_ded_yn                  = 'Bone Mass Meas Deductible YN'
	pbp_b14g_ded_amt                 = 'Bone Mass Meas Deductible Amt'
	pbp_b14g_copay_yn                = 'Bone Mass Meas Copayment YN'
	pbp_b14g_copay_amt_min           = 'Bone Mass Meas Copay Amt Min'
	pbp_b14g_copay_amt_max           = 'Bone Mass Meas Copay Amt Max'
	pbp_b14g_cost_share_yn           = 'Bone Mass Meas Cost Share'
	pbp_b14g_auth                    = 'Bone Mass Meas Enrollee Auth'
	pbp_b14g_refer_yn                = 'Bone Mass Meas Referral YN'
	pbp_b14h_bendesc_yn              = 'Mammography Ben Desc YN'
	pbp_b14h_bendesc                 = 'Mammography Ben Desc Enhance'
	pbp_b14h_bendesc_amo             = 'Mammography Ben Desc MO'
	pbp_b14h_bendesc_lim_ms_yn       = 'Mammography Ben Desc Lim YN'
	pbp_b14h_bendesc_numps           = 'Mammography Ben Desc Num'
	pbp_b14h_bendesc_as_per          = 'Mammography Ben Desc Per'
	pbp_b14h_maxplan_yn              = 'Mammography Max Plan YN'
	pbp_b14h_maxplan_type            = 'Mammography Max Plan Type'
	pbp_b14h_maxplan_amt             = 'Mammography Max Plan Amt'
	pbp_b14h_maxplan_per             = 'Mammography Max Plan Per'
	pbp_b14h_maxenr_yn               = 'Mammography Max Enr YN'
	pbp_b14h_maxenr_type             = 'Mammography Max Enr Type'
	pbp_b14h_maxenr_amt              = 'Mammography Max Enr Amt'
	pbp_b14h_maxenr_per              = 'Mammography Max Enr Per'
	pbp_b14h_coins_yn                = 'Mammography Coinsurance YN'
	pbp_b14h_coins_pct               = 'Mammography MC Coins Pct'
	pbp_b14h_ad_coins_pct            = 'Mammography AS Coins Pct'
	pbp_b14h_ded_yn                  = 'Mammography Deductible YN'
	pbp_b14h_ded_amt                 = 'Mammography Deductible Amt'
	pbp_b14h_copay_yn                = 'Mammography Copayment YN'
	pbp_b14h_copay_min_amt           = 'Mammography MC Min Copay Amt'
	pbp_b14h_copay_max_amt           = 'Mammography MC Max Copay Amt'
	pbp_b14h_as_copay_amt            = 'Mammography AS Copay Amt'
	pbp_b14h_cost_share_yn           = 'Mammography Cost Share'
	pbp_b14h_auth                    = 'Mammography Enrollee Auth'
	pbp_b14h_refer_yn                = 'Mammography Referral YN'
	pbp_b14i_maxenr_yn               = 'Diabetes Mon Max Enr YN'
	pbp_b14i_maxenr_type             = 'Diabetes Mon Max Enr Type'
	pbp_b14i_maxenr_amt              = 'Diabetes Mon Max Enr Amt'
	pbp_b14i_maxenr_per              = 'Diabetes Mon Max Enr Per'
	pbp_b14i_coins_yn                = 'Diabetes Mon Coinsurance YN'
	pbp_b14i_coins_pct               = 'Diabetes Mon MC Min Coins Pct'
	pbp_b14i_coins_max_pct           = 'Diabetes Mon MC Max Coins Pct'
	pbp_b14i_ded_yn                  = 'Diabetes Mon Deductible YN'
	pbp_b14i_ded_amt                 = 'Diabetes Mon Deductible Amt'
	pbp_b14i_copay_yn                = 'Diabetes Mon Copayment YN'
	pbp_b14i_copay_mc_min_amt        = 'Diabetes Mon MC Min Copay Amt'
	pbp_b14i_copay_mc_max_amt        = 'Diabetes Mon MC Max Copay Amt'
	pbp_b14i_cost_share              = 'Diabetes Mon Cost Share'
	pbp_b14i_auth                    = 'Diabetes Mon Enrollee Auth'
	pbp_b14i_refer_yn                = 'Diabetes Mon Referral YN'
	pbp_b14j_maxenr_yn               = 'Nutrtn Ther Max Enr YN'
	pbp_b14j_maxenr_type             = 'Nutrtn Ther Max Enr Type'
	pbp_b14j_maxenr_amt              = 'Nutrtn Ther Max Enr Amt'
	pbp_b14j_maxenr_per              = 'Nutrtn Ther Max Enr Per'
	pbp_b14j_coins_yn                = 'Nutrtn Ther Coinsurance YN'
	pbp_b14j_coins_pct               = 'Nutrtn Ther MC Min Coins Pct'
	pbp_b14j_coins_max_pct           = 'Nutrtn Ther MC Max Coins Pct'
	pbp_b14j_ded_yn                  = 'Nutrtn Ther Deductible YN'
	pbp_b14j_ded_amt                 = 'Nutrtn Ther Deductible Amt'
	pbp_b14j_copay_yn                = 'Nutrtn Ther Copayment YN'
	pbp_b14j_copay_mc_amt            = 'Nutrtn Ther MC Min Copay Amt'
	pbp_b14j_copay_mc_max_amt        = 'Nutrtn Ther MC Max Copay Amt'
	pbp_b14j_auth                    = 'Nutrtn Ther Enrollee Auth'
	pbp_b14j_refer_yn                = 'Nutrtn Ther Referral YN'
;

run;

proc sort data = pbp_b14ej out=out.pbp_b14ej;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b14ej(obs = 10);
  title 'pbp_b14_preventive_2 file ';
run;

proc means data = out.pbp_b14ej;
  title 'pbp_b14_preventive_2 file ';
run;

proc freq data = out.pbp_b14ej;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b14e_bendesc_yn
	pbp_b14e_bendesc
	pbp_b14e_bendesc_amo
	pbp_b14e_bendesc_lim_ps_yn
	pbp_b14e_bendesc_as_per
	pbp_b14e_maxplan_yn
	pbp_b14e_maxplan_type
	pbp_b14e_maxplan_per
	pbp_b14e_maxenr_yn
	pbp_b14e_maxenr_type
	pbp_b14e_maxenr_per
	pbp_b14e_coins_yn
	pbp_b14e_ded_yn
	pbp_b14e_copay_yn
	pbp_b14e_cost_share_yn
	pbp_b14e_auth
	pbp_b14e_refer_yn
	pbp_b14f_bendesc_yn
	pbp_b14f_bendesc
	pbp_b14f_bendesc_amo
	pbp_b14f_bendesc_lim_cs_yn
	pbp_b14f_bendesc_as_per
	pbp_b14f_maxplan_yn
	pbp_b14f_maxplan_type
	pbp_b14f_maxplan_per
	pbp_b14f_maxenr_yn
	pbp_b14f_maxenr_type
	pbp_b14f_maxenr_per
	pbp_b14f_coins_yn
	pbp_b14f_ded_yn
	pbp_b14f_copay_yn
	pbp_b14f_cost_share_yn
	pbp_b14f_auth
	pbp_b14f_refer_yn
	pbp_b14g_maxenr_yn
	pbp_b14g_maxenr_type
	pbp_b14g_maxenr_per
	pbp_b14g_coins_yn
	pbp_b14g_ded_yn
	pbp_b14g_copay_yn
	pbp_b14g_cost_share_yn
	pbp_b14g_auth
	pbp_b14g_refer_yn
	pbp_b14h_bendesc_yn
	pbp_b14h_bendesc
	pbp_b14h_bendesc_amo
	pbp_b14h_bendesc_lim_ms_yn
	pbp_b14h_bendesc_as_per
	pbp_b14h_maxplan_yn
	pbp_b14h_maxplan_type
	pbp_b14h_maxplan_per
	pbp_b14h_maxenr_yn
	pbp_b14h_maxenr_type
	pbp_b14h_maxenr_per
	pbp_b14h_coins_yn
	pbp_b14h_ded_yn
	pbp_b14h_copay_yn
	pbp_b14h_cost_share_yn
	pbp_b14h_auth
	pbp_b14h_refer_yn
	pbp_b14i_maxenr_yn
	pbp_b14i_maxenr_type
	pbp_b14i_maxenr_per
	pbp_b14i_coins_yn
	pbp_b14i_ded_yn
	pbp_b14i_copay_yn
	pbp_b14i_cost_share
	pbp_b14i_auth
	pbp_b14i_refer_yn
	pbp_b14j_maxenr_yn
	pbp_b14j_maxenr_type
	pbp_b14j_maxenr_per
	pbp_b14j_coins_yn
	pbp_b14j_ded_yn
	pbp_b14j_copay_yn
	pbp_b14j_auth
	pbp_b14j_refer_yn
/ missing;
run;

proc contents data = out.pbp_b14ej;
  title 'pbp_b14ej data';
run;
