*pbp_b7fi.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b7fi;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b7f_bendecs_yn               $1
	pbp_b7f_bendesc_rf               $1
	pbp_b7f_bendesc_amo_rf           $1
	pbp_b7f_bendesc_lim_rf           $1
	pbp_b7f_bendesc_per_rf           $1
	pbp_b7f_maxplan_yn               $1
	pbp_b7f_maxplan_per              $1
	pbp_b7f_maxenr_yn                $1
	pbp_b7f_maxenr_per               $1
	pbp_b7f_coins_yn                 $1
	pbp_b7f_ded_yn                   $1
	pbp_b7f_copay_yn                 $1
	pbp_b7f_auth                     $5
	pbp_b7f_refer_yn                 $1
	pbp_b7g_maxenr_yn                $1
	pbp_b7g_maxenr_per               $1
	pbp_b7g_coins_yn                 $1
	pbp_b7g_ded_yn                   $1
	pbp_b7g_copay_yn                 $1
	pbp_b7g_auth                     $5
	pbp_b7g_refer_yn                 $1
	pbp_b7h_maxenr_yn                $1
	pbp_b7h_maxenr_per               $1
	pbp_b7h_coins_yn                 $1
	pbp_b7h_coins_mcis_intrvl_num    $1
	pbp_b7h_coins_mcgs_intrvl_num    $1
	pbp_b7h_ded_yn                   $1
	pbp_b7h_copay_yn                 $1
	pbp_b7h_copay_mcis_intrvl_num    $1
	pbp_b7h_copay_mcgs_intrvl_num    $1
	pbp_b7h_auth                     $5
	pbp_b7h_refer_yn                 $1
	pbp_b7i_mdcr_cov_lmt_yn          $1
	pbp_b7i_maxenr_yn                $1
	pbp_b7i_maxenr_per               $1
	pbp_b7i_coins_yn                 $1
	pbp_b7i_ded_yn                   $1
	pbp_b7i_copay_yn                 $1
	pbp_b7i_auth                     $5
	pbp_b7i_refer_yn                 $1
;

infile '.\pbp\pbp_b7_health_prof_2.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b7f_bendecs_yn
	pbp_b7f_bendesc_rf
	pbp_b7f_bendesc_amo_rf
	pbp_b7f_bendesc_lim_rf
	pbp_b7f_bendesc_amt_rf
	pbp_b7f_bendesc_per_rf
	pbp_b7f_maxplan_yn
	pbp_b7f_maxplan_amt
	pbp_b7f_maxplan_per
	pbp_b7f_maxenr_yn
	pbp_b7f_maxenr_amt
	pbp_b7f_maxenr_per
	pbp_b7f_coins_yn
	pbp_b7f_coins_pct_mc_min
	pbp_b7f_coins_pct_mc_max
	pbp_b7f_coins_pct_rf_min
	pbp_b7f_coins_pct_rf_max
	pbp_b7f_ded_yn
	pbp_b7f_ded_amt
	pbp_b7f_copay_yn
	pbp_b7f_copay_mc_amt_min
	pbp_b7f_copay_mc_amt_max
	pbp_b7f_copay_rf_amt_min
	pbp_b7f_copay_rf_amt_max
	pbp_b7f_auth
	pbp_b7f_refer_yn
	pbp_b7g_maxenr_yn
	pbp_b7g_maxenr_amt
	pbp_b7g_maxenr_per
	pbp_b7g_coins_yn
	pbp_b7g_coins_pct_mc
	pbp_b7g_coins_max_pct_mc
	pbp_b7g_ded_yn
	pbp_b7g_ded_amt
	pbp_b7g_copay_yn
	pbp_b7g_copay_mc_amt
	pbp_b7g_copay_mc_max_amt
	pbp_b7g_auth
	pbp_b7g_refer_yn
	pbp_b7h_maxenr_yn
	pbp_b7h_maxenr_amt
	pbp_b7h_maxenr_per
	pbp_b7h_coins_yn
	pbp_b7h_coins_mcis_intrvl_num
	pbp_b7h_coins_mcis_pct_intrvl1
	pbp_b7h_coins_mcis_bgns_ntrvl1
	pbp_b7h_coins_mcis_ends_ntrvl1
	pbp_b7h_coins_mcis_pct_intrvl2
	pbp_b7h_coins_mcis_bgns_ntrvl2
	pbp_b7h_coins_mcis_ends_ntrvl2
	pbp_b7h_coins_mcis_pct_intrvl3
	pbp_b7h_coins_mcis_bgns_ntrvl3
	pbp_b7h_coins_mcis_ends_ntrvl3
	pbp_b7h_coins_mcgs_intrvl_num
	pbp_b7h_coins_mcgs_pct_intrvl1
	pbp_b7h_coins_mcgs_bgns_ntrvl1
	pbp_b7h_coins_mcgs_ends_ntrvl1
	pbp_b7h_coins_mcgs_pct_intrvl2
	pbp_b7h_coins_mcgs_bgns_ntrvl2
	pbp_b7h_coins_mcgs_ends_ntrvl2
	pbp_b7h_coins_mcgs_pct_intrvl3
	pbp_b7h_coins_mcgs_bgns_ntrvl3
	pbp_b7h_coins_mcgs_ends_ntrvl3
	pbp_b7h_ded_yn
	pbp_b7h_ded_amt
	pbp_b7h_copay_yn
	pbp_b7h_copay_mcis_intrvl_num
	pbp_b7h_copay_mcis_amt_intrvl1
	pbp_b7h_copay_mcis_bgns_ntrvl1
	pbp_b7h_copay_mcis_ends_ntrvl1
	pbp_b7h_copay_mcis_amt_intrvl2
	pbp_b7h_copay_mcis_bgns_ntrvl2
	pbp_b7h_copay_mcis_ends_ntrvl2
	pbp_b7h_copay_mcis_amt_intrvl3
	pbp_b7h_copay_mcis_bgns_ntrvl3
	pbp_b7h_copay_mcis_ends_ntrvl3
	pbp_b7h_copay_mcgs_intrvl_num
	pbp_b7h_copay_mcgs_amt_intrvl1
	pbp_b7h_copay_mcgs_bgns_ntrvl1
	pbp_b7h_copay_mcgs_ends_ntrvl1
	pbp_b7h_copay_mcgs_amt_intrvl2
	pbp_b7h_copay_mcgs_bgns_ntrvl2
	pbp_b7h_copay_mcgs_ends_ntrvl2
	pbp_b7h_copay_mcgs_amt_intrvl3
	pbp_b7h_copay_mcgs_bgns_ntrvl3
	pbp_b7h_copay_mcgs_ends_ntrvl3
	pbp_b7h_auth
	pbp_b7h_refer_yn
	pbp_b7i_mdcr_cov_lmt_yn
	pbp_b7i_maxenr_yn
	pbp_b7i_maxenr_amt
	pbp_b7i_maxenr_per
	pbp_b7i_coins_yn
	pbp_b7i_coins_pct_mc
	pbp_b7i_coins_pct_mcmax
	pbp_b7i_ded_yn
	pbp_b7i_ded_amt
	pbp_b7i_copay_yn
	pbp_b7i_copay_mc_amt
	pbp_b7i_copay_mc_amt_max
	pbp_b7i_auth
	pbp_b7i_refer_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b7f_bendecs_yn               = 'Podiatrist Ben Desc YN'
	pbp_b7f_bendesc_rf               = 'Podiatrist RF Ben Desc Enhance'
	pbp_b7f_bendesc_amo_rf           = 'Podiatrist RF Ben Desc AMO'
	pbp_b7f_bendesc_lim_rf           = 'Podiatrist RF Ben Desc Lim YN'
	pbp_b7f_bendesc_amt_rf           = 'Podiatrist RF Ben Desc Amt'
	pbp_b7f_bendesc_per_rf           = 'Podiatrist RF Ben Desc Per'
	pbp_b7f_maxplan_yn               = 'Podiatrist Max Plan YN'
	pbp_b7f_maxplan_amt              = 'Podiatrist Max Plan Amt'
	pbp_b7f_maxplan_per              = 'Podiatrist Max Plan Per'
	pbp_b7f_maxenr_yn                = 'Podiatrist Max Enr YN'
	pbp_b7f_maxenr_amt               = 'Podiatrist Max Enr Amt'
	pbp_b7f_maxenr_per               = 'Podiatrist Max Enr Per'
	pbp_b7f_coins_yn                 = 'Podiatrist Coinsurance YN'
	pbp_b7f_coins_pct_mc_min         = 'Podiatrist MC Min Coins Pct'
	pbp_b7f_coins_pct_mc_max         = 'Podiatrist MC Max Coins Pct'
	pbp_b7f_coins_pct_rf_min         = 'Podiatry RF Min Coins Pct'
	pbp_b7f_coins_pct_rf_max         = 'Podiatry RF Max Coins Pct'
	pbp_b7f_ded_yn                   = 'Podiatrist Deductible YN'
	pbp_b7f_ded_amt                  = 'Podiatrist Deductible Amt'
	pbp_b7f_copay_yn                 = 'Podiatrist Copayment YN'
	pbp_b7f_copay_mc_amt_min         = 'Podiatrist MC Min Copay Amt'
	pbp_b7f_copay_mc_amt_max         = 'Podiatrist MC Max Copay Amt'
	pbp_b7f_copay_rf_amt_min         = 'Podiatrist RF Min Copay Amt'
	pbp_b7f_copay_rf_amt_max         = 'Podiatrist RF Max Copay Amt'
	pbp_b7f_auth                     = 'Podiatrist Enrollee Auth'
	pbp_b7f_refer_yn                 = 'Podiatrist Referral YN'
	pbp_b7g_maxenr_yn                = 'Oth Hlth Care Max Enr YN'
	pbp_b7g_maxenr_amt               = 'Oth Hlth Care Max Enr Amt'
	pbp_b7g_maxenr_per               = 'Oth Hlth Care Max Enr Per'
	pbp_b7g_coins_yn                 = 'Oth Hlth Care Coinsurance YN'
	pbp_b7g_coins_pct_mc             = 'Oth Hlth Care MC Min Coins Pct'
	pbp_b7g_coins_max_pct_mc         = 'Oth Hlth Care MC Max Coins Pct'
	pbp_b7g_ded_yn                   = 'Oth Hlth Care Deductible YN'
	pbp_b7g_ded_amt                  = 'Oth Hlth Care Deductible Amt'
	pbp_b7g_copay_yn                 = 'Oth Hlth Care Copayment YN'
	pbp_b7g_copay_mc_amt             = 'Oth Hlth Care MC Min Copay Amt'
	pbp_b7g_copay_mc_max_amt         = 'Oth Hlth Care MC Max Copay Amt'
	pbp_b7g_auth                     = 'Oth Hlth Care Enrollee Auth'
	pbp_b7g_refer_yn                 = 'Oth Hlth Care Referral YN'
	pbp_b7h_maxenr_yn                = 'Psych Max Enr YN'
	pbp_b7h_maxenr_amt               = 'Psych Max Enr Amt'
	pbp_b7h_maxenr_per               = 'Psych Max Enr Per'
	pbp_b7h_coins_yn                 = 'Psych Coinsurance YN'
	pbp_b7h_coins_mcis_intrvl_num    = 'Psych MCIS Coins Interval Num'
	pbp_b7h_coins_mcis_pct_intrvl1   = 'Psych MCIS Coins Pct Intrvl 1'
	pbp_b7h_coins_mcis_bgns_ntrvl1   = 'Psych MCIS Coins BgnS Intrvl 1'
	pbp_b7h_coins_mcis_ends_ntrvl1   = 'Psych MCIS Coins EndS Intrvl 1'
	pbp_b7h_coins_mcis_pct_intrvl2   = 'Psych MCIS Coins Pct Intrvl 2'
	pbp_b7h_coins_mcis_bgns_ntrvl2   = 'Psych MCIS Coins BgnS Intrvl 2'
	pbp_b7h_coins_mcis_ends_ntrvl2   = 'Psych MCIS Coins EndS Intrvl 2'
	pbp_b7h_coins_mcis_pct_intrvl3   = 'Psych MCIS Coins Pct Intrvl 3'
	pbp_b7h_coins_mcis_bgns_ntrvl3   = 'Psych MCIS Coins BgnS Intrvl 3'
	pbp_b7h_coins_mcis_ends_ntrvl3   = 'Psych MCIS Coins EndS Intrvl 3'
	pbp_b7h_coins_mcgs_intrvl_num    = 'Psych MCGS Coins Interval Num'
	pbp_b7h_coins_mcgs_pct_intrvl1   = 'Psych MCGS Coins Pct Intrvl 1'
	pbp_b7h_coins_mcgs_bgns_ntrvl1   = 'Psych MCGS Coins BgnS Intrvl 1'
	pbp_b7h_coins_mcgs_ends_ntrvl1   = 'Psych MCGS Coins EndS Intrvl 1'
	pbp_b7h_coins_mcgs_pct_intrvl2   = 'Psych MCGS Coins Pct Intrvl 2'
	pbp_b7h_coins_mcgs_bgns_ntrvl2   = 'Psych MCGS Coins BgnS Intrvl 2'
	pbp_b7h_coins_mcgs_ends_ntrvl2   = 'Psych MCGS Coins EndS Intrvl 2'
	pbp_b7h_coins_mcgs_pct_intrvl3   = 'Psych MCGS Coins Pct Intrvl 3'
	pbp_b7h_coins_mcgs_bgns_ntrvl3   = 'Psych MCGS Coins BgnS Intrvl 3'
	pbp_b7h_coins_mcgs_ends_ntrvl3   = 'Psych MCGS Coins EndS Intrvl 3'
	pbp_b7h_ded_yn                   = 'Psych Deductible YN'
	pbp_b7h_ded_amt                  = 'Psych Deductible Amt'
	pbp_b7h_copay_yn                 = 'Psych Copayment YN'
	pbp_b7h_copay_mcis_intrvl_num    = 'Psych MCIS Copay Interval Num'
	pbp_b7h_copay_mcis_amt_intrvl1   = 'Psych MCIS Copay Amt Intrvl 1'
	pbp_b7h_copay_mcis_bgns_ntrvl1   = 'Psych MCIS Copay BgnS Intrvl 1'
	pbp_b7h_copay_mcis_ends_ntrvl1   = 'Psych MCIS Copay EndS Intrvl 1'
	pbp_b7h_copay_mcis_amt_intrvl2   = 'Psych MCIS Copay Amt Intrvl 2'
	pbp_b7h_copay_mcis_bgns_ntrvl2   = 'Psych MCIS Copay BgnS Intrvl 2'
	pbp_b7h_copay_mcis_ends_ntrvl2   = 'Psych MCIS Copay EndS Intrvl 2'
	pbp_b7h_copay_mcis_amt_intrvl3   = 'Psych MCIS Copay Amt Intrvl 3'
	pbp_b7h_copay_mcis_bgns_ntrvl3   = 'Psych MCIS Copay BgnS Intrvl 3'
	pbp_b7h_copay_mcis_ends_ntrvl3   = 'Psych MCIS Copay EndS Intrvl 3'
	pbp_b7h_copay_mcgs_intrvl_num    = 'Psych MCGS Copay Interval Num'
	pbp_b7h_copay_mcgs_amt_intrvl1   = 'Psych MCGS Copay Amt Intrvl 1'
	pbp_b7h_copay_mcgs_bgns_ntrvl1   = 'Psych MCGS Copay BgnS Intrvl 1'
	pbp_b7h_copay_mcgs_ends_ntrvl1   = 'Psych MCGS Copay EndS Intrvl 1'
	pbp_b7h_copay_mcgs_amt_intrvl2   = 'Psych MCGS Copay Amt Intrvl 2'
	pbp_b7h_copay_mcgs_bgns_ntrvl2   = 'Psych MCGS Copay BgnS Intrvl 2'
	pbp_b7h_copay_mcgs_ends_ntrvl2   = 'Psych MCGS Copay EndS Intrvl 2'
	pbp_b7h_copay_mcgs_amt_intrvl3   = 'Psych MCGS Copay Amt Intrvl 3'
	pbp_b7h_copay_mcgs_bgns_ntrvl3   = 'Psych MCGS Copay BgnS Intrvl 3'
	pbp_b7h_copay_mcgs_ends_ntrvl3   = 'Psych MCGS Copay EndS Intrvl 3'
	pbp_b7h_auth                     = 'Psych Enrollee Auth'
	pbp_b7h_refer_yn                 = 'Psych Referral YN'
	pbp_b7i_mdcr_cov_lmt_yn          = 'PT/SP Srvs MED COVG LIM YN'
	pbp_b7i_maxenr_yn                = 'PT/SP Srvs Max Enr YN'
	pbp_b7i_maxenr_amt               = 'PT/SP Srvs Max Enr Amt'
	pbp_b7i_maxenr_per               = 'PT/SP Srvs Max Enr Per'
	pbp_b7i_coins_yn                 = 'PT/SP Srvs Coinsurance YN'
	pbp_b7i_coins_pct_mc             = 'PT/SP Srvs MC Min Coins Pct'
	pbp_b7i_coins_pct_mcmax          = 'PT/SP Srvs MC Max Coins Pct'
	pbp_b7i_ded_yn                   = 'PT/SP Srvs Deductible YN'
	pbp_b7i_ded_amt                  = 'PT/SP Srvs Deductible Amt'
	pbp_b7i_copay_yn                 = 'PT/SP Srvs Copayment YN'
	pbp_b7i_copay_mc_amt             = 'PT/SP Srvs MC Min Copay Amt'
	pbp_b7i_copay_mc_amt_max         = 'PT/SP Srvs MC Max Copay Amt'
	pbp_b7i_auth                     = 'PT/SP Srvs Enrollee Auth'
	pbp_b7i_refer_yn                 = 'PT/SP Srvs Referral YN'
;

run;

proc sort data = pbp_b7fi out=out.pbp_b7fi;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b7fi(obs = 10);
  title 'pbp_b7_health_prof_2 file ';
run;

proc means data = out.pbp_b7fi;
  title 'pbp_b7_health_prof_2 file ';
run;

proc freq data = out.pbp_b7fi;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b7f_bendecs_yn
	pbp_b7f_bendesc_rf
	pbp_b7f_bendesc_amo_rf
	pbp_b7f_bendesc_lim_rf
	pbp_b7f_bendesc_per_rf
	pbp_b7f_maxplan_yn
	pbp_b7f_maxplan_per
	pbp_b7f_maxenr_yn
	pbp_b7f_maxenr_per
	pbp_b7f_coins_yn
	pbp_b7f_ded_yn
	pbp_b7f_copay_yn
	pbp_b7f_auth
	pbp_b7f_refer_yn
	pbp_b7g_maxenr_yn
	pbp_b7g_maxenr_per
	pbp_b7g_coins_yn
	pbp_b7g_ded_yn
	pbp_b7g_copay_yn
	pbp_b7g_auth
	pbp_b7g_refer_yn
	pbp_b7h_maxenr_yn
	pbp_b7h_maxenr_per
	pbp_b7h_coins_yn
	pbp_b7h_coins_mcis_intrvl_num
	pbp_b7h_coins_mcgs_intrvl_num
	pbp_b7h_ded_yn
	pbp_b7h_copay_yn
	pbp_b7h_copay_mcis_intrvl_num
	pbp_b7h_copay_mcgs_intrvl_num
	pbp_b7h_auth
	pbp_b7h_refer_yn
	pbp_b7i_mdcr_cov_lmt_yn
	pbp_b7i_maxenr_yn
	pbp_b7i_maxenr_per
	pbp_b7i_coins_yn
	pbp_b7i_ded_yn
	pbp_b7i_copay_yn
	pbp_b7i_auth
	pbp_b7i_refer_yn
/ missing;
run;

proc contents data = out.pbp_b7fi;
  title 'pbp_b7fi data';
run;
