*pbp_mrx_fillFirst.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx_fillFirst;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	mrx_first_fill                   $1
;

infile '.\pbp\pbp_mrx_fillFirst.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	mrx_first_fill
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	mrx_first_fill                   = 'MRx First Fill'
;

run;

proc sort data = pbp_mrx_fillFirst out=out.pbp_mrx_fillFirst;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx_fillFirst(obs = 10);
  title 'pbp_mrx_fillFirst file ';
run;

proc means data = out.pbp_mrx_fillFirst;
  title 'pbp_mrx_fillFirst file ';
run;

proc freq data = out.pbp_mrx_fillFirst;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	mrx_first_fill
/ missing;
run;

proc contents data = out.pbp_mrx_fillFirst;
  title 'pbp_mrx_fillFirst data';
run;
