*pbp_mrx_gapCoverage.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx_gapCoverage;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	mrx_tier_id                      $2
	mrx_tier_lbl                     $50
	mrx_tier_gap_cost_share          $1
	mrx_tier_gap_all_drug_yn         $1
	mrx_tier_gap_drug_type_lmtd      $8
;

infile '.\pbp\pbp_mrx_gapCoverage.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	mrx_tier_id
	mrx_tier_lbl
	mrx_tier_gap_cost_share
	mrx_tier_gap_all_drug_yn
	mrx_tier_gap_drug_type_lmtd
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	mrx_tier_id                      = 'MRx Tier ID'
	mrx_tier_lbl                     = 'MRx Grp Tier Label'
	mrx_tier_gap_cost_share          = 'MRx Tier Gap Cost Share'
	mrx_tier_gap_all_drug_yn         = 'MRx Tier Gap Covg'
	mrx_tier_gap_drug_type_lmtd      = 'MRx Tier Gap Tier Drug Types'
;

run;

proc sort data = pbp_mrx_gapCoverage out=out.pbp_mrx_gapCoverage;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx_gapCoverage(obs = 10);
  title 'pbp_mrx_gapCoverage file ';
run;

proc means data = out.pbp_mrx_gapCoverage;
  title 'pbp_mrx_gapCoverage file ';
run;

proc freq data = out.pbp_mrx_gapCoverage;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	mrx_tier_id
	mrx_tier_gap_cost_share
	mrx_tier_gap_all_drug_yn
/ missing;
run;

proc contents data = out.pbp_mrx_gapCoverage;
  title 'pbp_mrx_gapCoverage data';
run;
