*pbp_mrx_p.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx_p;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	mrx_tier_post_id                 $2
	mrx_tier_post_benefit_type       $1
	mrx_tier_post_type_id            $2
	mrx_tier_post_lbl                $50
	mrx_tier_post_drug_type          $6
	mrx_tier_post_includes           $1
	mrx_tier_post_spec_yn            $1
	mrx_tier_post_cost_struct        $1
;

infile '.\pbp\pbp_mrx_p.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	mrx_tier_post_id
	mrx_tier_post_benefit_type
	mrx_tier_post_type_id
	mrx_tier_post_lbl
	mrx_tier_post_drug_type
	mrx_tier_post_includes
	mrx_tier_post_spec_yn
	mrx_tier_post_cost_struct
	mrx_tier_post_coins_pct
	mrx_tier_post_copay_amt
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	mrx_tier_post_id                 = 'MRx Post Tier ID - OOP'
	mrx_tier_post_benefit_type       = 'MRx Post Tier Drg Ben Type OOP'
	mrx_tier_post_type_id            = 'MRx Post Tier Type ID'
	mrx_tier_post_lbl                = 'MRx Post Tier Label'
	mrx_tier_post_drug_type          = 'MRx Post Tier Drug Type'
	mrx_tier_post_includes           = 'MRX Post Tier Includes'
	mrx_tier_post_spec_yn            = 'MRX Post Tier Special Tier YN'
	mrx_tier_post_cost_struct        = 'MRx Post Tier Cst Sh Grp Struc'
	mrx_tier_post_coins_pct          = 'MRx Post Tier Coinsurance Pct'
	mrx_tier_post_copay_amt          = 'MRx Post Tier Copay Amt'
;

run;

proc sort data = pbp_mrx_p out=out.pbp_mrx_p;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx_p(obs = 10);
  title 'pbp_mrx_p file ';
run;

proc means data = out.pbp_mrx_p;
  title 'pbp_mrx_p file ';
run;

proc freq data = out.pbp_mrx_p;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	mrx_tier_post_id
	mrx_tier_post_benefit_type
	mrx_tier_post_type_id
	mrx_tier_post_includes
	mrx_tier_post_spec_yn
	mrx_tier_post_cost_struct
/ missing;
run;

proc contents data = out.pbp_mrx_p;
  title 'pbp_mrx_p data';
run;
