*pbp_Section_C_VT.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_Section_C_VT;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_c_vt_grp_id                  $2
	pbp_c_vt_grp_type                $1
	pbp_c_vt_group_lbl               $40
	pbp_c_vt_outpt_bendesc_cats      $50
	pbp_c_vt_outpt_cstshr_yn         $1
	pbp_c_vt_outpt_coins_yn          $1
	pbp_c_vt_outpt_copay_yn          $1
;

infile '.\pbp\pbp_Section_C_VT.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_c_vt_grp_id
	pbp_c_vt_grp_type
	pbp_c_vt_group_lbl
	pbp_c_vt_outpt_bendesc_cats
	pbp_c_vt_outpt_cstshr_yn
	pbp_c_vt_outpt_coins_yn
	pbp_c_vt_outpt_coins_min_pct
	pbp_c_vt_outpt_coins_max_pct
	pbp_c_vt_outpt_copay_yn
	pbp_c_vt_outpt_copay_min_amt
	pbp_c_vt_outpt_copay_max_amt
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_c_vt_grp_id                  = 'V/T Group ID'
	pbp_c_vt_grp_type                = 'V/T Grp Type'
	pbp_c_vt_group_lbl               = 'V/T Grp Label'
	pbp_c_vt_outpt_bendesc_cats      = 'V/T Out Pt Grp Benefit Cats'
	pbp_c_vt_outpt_cstshr_yn         = 'V/T Out Pt Grp Cost Share'
	pbp_c_vt_outpt_coins_yn          = 'V/T Out Pt Grp Coinsurance YN'
	pbp_c_vt_outpt_coins_min_pct     = 'V/T Out Pt Grp Min Coins Pct'
	pbp_c_vt_outpt_coins_max_pct     = 'V/T Out Pt Grp Max Coins Pct'
	pbp_c_vt_outpt_copay_yn          = 'V/T Out Pt Grp Copay YN'
	pbp_c_vt_outpt_copay_min_amt     = 'V/T Out Pt Grp Copay Min Amt'
	pbp_c_vt_outpt_copay_max_amt     = 'V/T Out Pt Grp Copay Max Amt'
;

run;

proc sort data = pbp_Section_C_VT out=out.pbp_Section_C_VT;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_Section_C_VT(obs = 10);
  title 'pbp_Section_C_VT file ';
run;

proc means data = out.pbp_Section_C_VT;
  title 'pbp_Section_C_VT file ';
run;

proc freq data = out.pbp_Section_C_VT;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_c_vt_grp_id
	pbp_c_vt_grp_type
	pbp_c_vt_outpt_cstshr_yn
	pbp_c_vt_outpt_coins_yn
	pbp_c_vt_outpt_copay_yn
/ missing;
run;

proc contents data = out.pbp_Section_C_VT;
  title 'pbp_Section_C_VT data';
run;
