*pbp_b3.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b3;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b3_maxenr_yn                 $1
	pbp_b3_maxenr_per                $1
	pbp_b3_coins_yn                  $1
	pbp_b3_ded_yn                    $1
	pbp_b3_copay_yn                  $1
	pbp_b3_auth                      $5
	pbp_b3_refer_yn                  $1
;

infile '.\pbp\pbp_b3_corf.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b3_maxenr_yn
	pbp_b3_maxenr_amt
	pbp_b3_maxenr_per
	pbp_b3_coins_yn
	pbp_b3_coins_pct_mc
	pbp_b3_ded_yn
	pbp_b3_ded_amt
	pbp_b3_copay_yn
	pbp_b3_copay_amt
	pbp_b3_auth
	pbp_b3_refer_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b3_maxenr_yn                 = 'CORF Max Enr YN'
	pbp_b3_maxenr_amt                = 'CORF Max Enr Amt'
	pbp_b3_maxenr_per                = 'CORF Max Enr Per'
	pbp_b3_coins_yn                  = 'CORF Coinsurance YN'
	pbp_b3_coins_pct_mc              = 'CORF Medicare Coins Pct'
	pbp_b3_ded_yn                    = 'CORF Deductible YN'
	pbp_b3_ded_amt                   = 'CORF Deductible Amt'
	pbp_b3_copay_yn                  = 'CORF Copayment YN'
	pbp_b3_copay_amt                 = 'CORF Copay Amt'
	pbp_b3_auth                      = 'CORF Auth'
	pbp_b3_refer_yn                  = 'CORF Referral YN'
;

run;

proc sort data = pbp_b3 out=out.pbp_b3;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b3(obs = 10);
  title 'pbp_b3_corf file ';
run;

proc means data = out.pbp_b3;
  title 'pbp_b3_corf file ';
run;

proc freq data = out.pbp_b3;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b3_maxenr_yn
	pbp_b3_maxenr_per
	pbp_b3_coins_yn
	pbp_b3_ded_yn
	pbp_b3_copay_yn
	pbp_b3_auth
	pbp_b3_refer_yn
/ missing;
run;

proc contents data = out.pbp_b3;
  title 'pbp_b3 data';
run;
