*pbp_mrx.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	mrx_drug_ben_yn                  $1
	mrx_benefit_type                 $1
	mrx_basic_plan_yn                $1
	mrx_basic_plan_zero_prem_yn      $1
	mrx_partd_network_loc            $6
	mrx_quantity_limits              $1
	mrx_auth_ynba                    $1
	mrx_step_ther_drugs_yn           $1
	mrx_otc_meds_pay_ump_yn          $1
	mrx_otc_meds_attest_flag         $1
	mrx_first_fill                   $1
	mrx_pro_part_fill                $1
	mrx_nat_rx_cov_yn                $1
	mrx_otc_step_therapy_yn          $1
	mrx_ae_oon_cstshr_struct         $1
	mrx_ae_cstshr_apply              $1
	mrx_ae_ooptcs_apply              $1
	mrx_alt_ded_charge               $1
	mrx_alt_ded_type_yn              $1
	mrx_alt_no_ded_tier              $6
	mrx_alt_ded_tier_cstshr_yn       $1
	mrx_alt_gen_cstshr_struct        $1
	mrx_alt_oon_cstshr_struct        $1
	mrx_alt_excl_drugs_yn            $1
	mrx_alt_excl_drugs_maxplan_yn    $1
	mrx_alt_red_cost_sharing         $1
	mrx_alt_red_cost_sharing_items   $5
	mrx_alt_pre_icl_cost_share       $1
	mrx_alt_cov_lmt_yn               $1
	mrx_alt_gap_covg_yn              $1
	mrx_alt_gap_covg_tier            $6
	mrx_alt_cstshr_post_oopt         $1
	mrx_gen_loc                      $21
	mrx_tier_extd_days_gen_yn        $1
;

infile '.\pbp\pbp_mrx.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	mrx_drug_ben_yn
	mrx_benefit_type
	mrx_formulary_tiers_num
	mrx_basic_plan_yn
	mrx_basic_plan_zero_prem_yn
	mrx_partd_network_loc
	mrx_quantity_limits
	mrx_auth_ynba
	mrx_step_ther_drugs_yn
	mrx_otc_meds_pay_ump_yn
	mrx_otc_meds_attest_flag
	mrx_first_fill
	mrx_pro_part_fill
	mrx_nat_rx_cov_yn
	mrx_otc_step_therapy_yn
	mrx_ae_oon_cstshr_struct
	mrx_ae_cstshr_apply
	mrx_ae_ooptcs_apply
	mrx_alt_ded_charge
	mrx_alt_ded_amount
	mrx_alt_ded_type_yn
	mrx_alt_no_ded_tier
	mrx_alt_ded_tier_cstshr_yn
	mrx_alt_gen_cstshr_struct
	mrx_alt_gen_coins_pct
	mrx_alt_gen_copay_amt
	mrx_alt_oon_cstshr_struct
	mrx_alt_excl_drugs_yn
	mrx_alt_excl_drugs_maxplan_yn
	mrx_alt_excl_max_plan_amt
	mrx_alt_red_cost_sharing
	mrx_alt_red_cost_sharing_items
	mrx_alt_pre_icl_cost_share
	mrx_alt_cov_lmt_yn
	mrx_alt_cov_lmt_amt
	mrx_alt_gap_covg_yn
	mrx_alt_gap_covg_tier
	mrx_alt_cstshr_post_oopt
	mrx_gen_loc
	mrx_gen_inp_1m
	mrx_gen_inp_3m
	mrx_gen_inp_os
	mrx_gen_inpp_1m
	mrx_gen_inpp_3m
	mrx_gen_inpp_os
	mrx_gen_innpp_1m
	mrx_gen_innpp_3m
	mrx_gen_innpp_os
	mrx_gen_oonp_1m
	mrx_gen_oonp_os
	mrx_gen_mo_1m
	mrx_gen_mo_3m
	mrx_gen_mo_os
	mrx_gen_mopp_1m
	mrx_gen_mopp_3m
	mrx_gen_mopp_os
	mrx_gen_monpp_1m
	mrx_gen_monpp_3m
	mrx_gen_monpp_os
	mrx_gen_ltcp_1m
	mrx_tier_extd_days_gen_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	mrx_drug_ben_yn                  = 'MRx Drug Benefit YN'
	mrx_benefit_type                 = 'MRx Drug Benefit Type'
	mrx_formulary_tiers_num          = 'MRx Formulary Tiers Num'
	mrx_basic_plan_yn                = 'MRx Basic Plan YN'
	mrx_basic_plan_zero_prem_yn      = 'MRx Basic Plan Zero Prem YN'
	mrx_partd_network_loc            = 'MRx PartD Network Location'
	mrx_quantity_limits              = 'MRx Quantity limits YN'
	mrx_auth_ynba                    = 'MRx Authorization YN'
	mrx_step_ther_drugs_yn           = 'MRx Step Therapy Drugs YN'
	mrx_otc_meds_pay_ump_yn          = 'MRx OTC Util Mngmt Program'
	mrx_otc_meds_attest_flag         = 'MRx OTC Med Attest Flag'
	mrx_first_fill                   = 'MRx First Fill'
	mrx_pro_part_fill                = 'MRx Pro Part Fill'
	mrx_nat_rx_cov_yn                = 'MRx Nat Prescrip Cvg'
	mrx_otc_step_therapy_yn          = 'MRx OTC Step Therapy YN'
	mrx_ae_oon_cstshr_struct         = 'MRx AE Cstshr Structure'
	mrx_ae_cstshr_apply              = 'MRx AE Cstshr Pre-Intl Cov Lmt'
	mrx_ae_ooptcs_apply              = 'MRx AE OOP Threshold Applct'
	mrx_alt_ded_charge               = 'MRx Alt BA Deduct Charged YN'
	mrx_alt_ded_amount               = 'MRx Alt Deductible Amount'
	mrx_alt_ded_type_yn              = 'MRx Alt BA Ded Tier YN'
	mrx_alt_no_ded_tier              = 'MRx Alt Non-Deductible Tiers'
	mrx_alt_ded_tier_cstshr_yn       = 'MRx Alt Tier Deduct Cost Share'
	mrx_alt_gen_cstshr_struct        = 'MRx Alt BA Cstshr Structure'
	mrx_alt_gen_coins_pct            = 'MRx Alt Coins Pct'
	mrx_alt_gen_copay_amt            = 'MRx Alt Copay Amt'
	mrx_alt_oon_cstshr_struct        = 'MRx Alt BA OON Cstshr Struct'
	mrx_alt_excl_drugs_yn            = 'MRx Alt Excluded supp drugs'
	mrx_alt_excl_drugs_maxplan_yn    = 'MRx Alt Non PD Max Plan YN'
	mrx_alt_excl_max_plan_amt        = 'MRx Alt Max Plan Amt Exc Drugs'
	mrx_alt_red_cost_sharing         = 'MRx Alt Red Cost Sharing'
	mrx_alt_red_cost_sharing_items   = 'MRx Alt Red Cost Sharing Items'
	mrx_alt_pre_icl_cost_share       = 'MRx Alt Cstshr Pre-Int Cov Lmt'
	mrx_alt_cov_lmt_yn               = 'MRx Alt Cov Lmt YN'
	mrx_alt_cov_lmt_amt              = 'MRx Alt Cov Lmt Amt'
	mrx_alt_gap_covg_yn              = 'MRx Alt Gap Coverage'
	mrx_alt_gap_covg_tier            = 'MRx Alt Gap Tier Cov'
	mrx_alt_cstshr_post_oopt         = 'MRx Alt Cstshr Post OOPT'
	mrx_gen_loc                      = 'MRx General Location'
	mrx_gen_inp_1m                   = 'MRx Gen INP 1M Supply Days'
	mrx_gen_inp_3m                   = 'MRx Gen INP 3M Supply Days'
	mrx_gen_inp_os                   = 'MRx Gen INP Oth Supply Days'
	mrx_gen_inpp_1m                  = 'MRx Gen INPP 1M Supply Days'
	mrx_gen_inpp_3m                  = 'MRx Gen INPP 3M Supply Days'
	mrx_gen_inpp_os                  = 'MRx Gen INPP Oth Supply Days'
	mrx_gen_innpp_1m                 = 'MRx Gen INNPP 1M Supply Days'
	mrx_gen_innpp_3m                 = 'MRx Gen INNPP 3M Supply Days'
	mrx_gen_innpp_os                 = 'MRx Gen INNPP Oth Supply Days'
	mrx_gen_oonp_1m                  = 'MRx Gen OONP 1M Supply Days'
	mrx_gen_oonp_os                  = 'MRx Gen OONP Oth Supply Days'
	mrx_gen_mo_1m                    = 'MRx Gen MO 1M Supply Days'
	mrx_gen_mo_3m                    = 'MRx Gen MO 3M Supply Days'
	mrx_gen_mo_os                    = 'MRx Gen MO Oth Supply Days'
	mrx_gen_mopp_1m                  = 'MRx Gen MOPP 1M Supply Days'
	mrx_gen_mopp_3m                  = 'MRx Gen MOPP 3M Supply Days'
	mrx_gen_mopp_os                  = 'MRx Gen MOPP Oth Supply Days'
	mrx_gen_monpp_1m                 = 'MRx Gen MONPP 1M Supply Days'
	mrx_gen_monpp_3m                 = 'MRx Gen MONPP 3M Supply Days'
	mrx_gen_monpp_os                 = 'MRx Gen MONPP Oth Supply Days'
	mrx_gen_ltcp_1m                  = 'MRx Gen LTCP 1M Supply Days'
	mrx_tier_extd_days_gen_yn        = 'MRx Tier Extended Day Supply'
;

run;

proc sort data = pbp_mrx out=out.pbp_mrx;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx(obs = 10);
  title 'pbp_mrx file ';
run;

proc means data = out.pbp_mrx;
  title 'pbp_mrx file ';
run;

proc freq data = out.pbp_mrx;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	mrx_drug_ben_yn
	mrx_benefit_type
	mrx_basic_plan_yn
	mrx_basic_plan_zero_prem_yn
	mrx_quantity_limits
	mrx_auth_ynba
	mrx_step_ther_drugs_yn
	mrx_otc_meds_pay_ump_yn
	mrx_otc_meds_attest_flag
	mrx_first_fill
	mrx_pro_part_fill
	mrx_nat_rx_cov_yn
	mrx_otc_step_therapy_yn
	mrx_ae_oon_cstshr_struct
	mrx_ae_cstshr_apply
	mrx_ae_ooptcs_apply
	mrx_alt_ded_charge
	mrx_alt_ded_type_yn
	mrx_alt_ded_tier_cstshr_yn
	mrx_alt_gen_cstshr_struct
	mrx_alt_oon_cstshr_struct
	mrx_alt_excl_drugs_yn
	mrx_alt_excl_drugs_maxplan_yn
	mrx_alt_red_cost_sharing
	mrx_alt_red_cost_sharing_items
	mrx_alt_pre_icl_cost_share
	mrx_alt_cov_lmt_yn
	mrx_alt_gap_covg_yn
	mrx_alt_cstshr_post_oopt
	mrx_tier_extd_days_gen_yn
/ missing;
run;

proc contents data = out.pbp_mrx;
  title 'pbp_mrx data';
run;
