*pbp_step16b.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_step16b;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b16b_bendesc_yn              $1
	pbp_b16b_bendesc_ehc             $5
	pbp_b16b_bendesc_amo_es          $1
	pbp_b16b_bendesc_lim_es          $1
	pbp_b16b_bendesc_per_es          $1
	pbp_b16b_bendesc_amo_ds          $1
	pbp_b16b_bendesc_lim_ds          $1
	pbp_b16b_bendesc_per_ds          $1
	pbp_b16b_bendesc_amo_rs          $1
	pbp_b16b_bendesc_lim_rs          $1
	pbp_b16b_bendesc_per_rs          $1
	pbp_b16b_bendesc_amo_epe         $1
	pbp_b16b_bendesc_lim_epe         $1
	pbp_b16b_bendesc_per_epe         $1
	pbp_b16b_bendesc_amo_poo         $1
	pbp_b16b_bendesc_lim_poo         $1
	pbp_b16b_bendesc_per_poo         $1
	pbp_b16b_maxplan_yn              $1
	pbp_b16b_maxbene_type            $1
	pbp_b16b_maxplan_per             $1
	pbp_b16b_maxenr_yn               $1
	pbp_b16b_maxenr_type             $1
	pbp_b16b_maxenr_per              $1
	pbp_b16b_coins_yn                $1
	pbp_b16b_ded_yn                  $1
	pbp_b16b_copay_yn                $1
	pbp_b16b_cost_share              $1
	pbp_b16b_cost_share_coins_yn     $1
	pbp_b16b_cost_share_copay_yn     $1
	pbp_b16b_auth                    $5
	pbp_b16b_refer_yn                $1
	pbp_d_opt_identifier             $3
;

infile '.\pbp\pbp_step16b.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b16b_bendesc_yn
	pbp_b16b_bendesc_ehc
	pbp_b16b_bendesc_amo_es
	pbp_b16b_bendesc_lim_es
	pbp_b16b_bendesc_numv_es
	pbp_b16b_bendesc_per_es
	pbp_b16b_bendesc_amo_ds
	pbp_b16b_bendesc_lim_ds
	pbp_b16b_bendesc_numv_ds
	pbp_b16b_bendesc_per_ds
	pbp_b16b_bendesc_amo_rs
	pbp_b16b_bendesc_lim_rs
	pbp_b16b_bendesc_numv_rs
	pbp_b16b_bendesc_per_rs
	pbp_b16b_bendesc_amo_epe
	pbp_b16b_bendesc_lim_epe
	pbp_b16b_bendesc_numv_epe
	pbp_b16b_bendesc_per_epe
	pbp_b16b_bendesc_amo_poo
	pbp_b16b_bendesc_lim_poo
	pbp_b16b_bendesc_numv_poo
	pbp_b16b_bendesc_per_poo
	pbp_b16b_maxplan_yn
	pbp_b16b_maxbene_type
	pbp_b16b_maxplan_amt
	pbp_b16b_maxplan_per
	pbp_b16b_maxenr_yn
	pbp_b16b_maxenr_type
	pbp_b16b_maxenr_amt
	pbp_b16b_maxenr_per
	pbp_b16b_coins_yn
	pbp_b16b_coins_pct_mc
	pbp_b16b_coins_pct_max_mc
	pbp_b16b_coins_pct_es
	pbp_b16b_coins_pct_maxes
	pbp_b16b_coins_pct_ds
	pbp_b16b_coins_pct_maxds
	pbp_b16b_coins_pct_rs
	pbp_b16b_coins_pct_maxrs
	pbp_b16b_coins_pct_epe
	pbp_b16b_coins_pct_maxepe
	pbp_b16b_coins_pct_poo
	pbp_b16b_coins_pct_maxpoo
	pbp_b16b_ded_yn
	pbp_b16b_ded_amt
	pbp_b16b_copay_yn
	pbp_b16b_copay_mc_amt
	pbp_b16b_copay_mcmax_amt
	pbp_b16b_copay_amt_esmin
	pbp_b16b_copay_amt_esmax
	pbp_b16b_copay_amt_dsmin
	pbp_b16b_copay_amt_dsmax
	pbp_b16b_copay_amt_rsmin
	pbp_b16b_copay_amt_rsmax
	pbp_b16b_copay_amt_epemin
	pbp_b16b_copay_amt_epemax
	pbp_b16b_copay_amt_poomin
	pbp_b16b_copay_amt_poomax
	pbp_b16b_cost_share
	pbp_b16b_cost_share_coins_yn
	pbp_b16b_cost_share_coins_min
	pbp_b16b_cost_share_coins_max
	pbp_b16b_cost_share_copay_yn
	pbp_b16b_cost_share_copay_min
	pbp_b16b_cost_share_copay_max
	pbp_b16b_auth
	pbp_b16b_refer_yn
	pbp_d_opt_identifier
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b16b_bendesc_yn              = 'Dental Comp Ben Desc YN'
	pbp_b16b_bendesc_ehc             = 'Dental Comp Ben Desc Enhance'
	pbp_b16b_bendesc_amo_es          = 'Dental Comp NR Ben Desc AMO'
	pbp_b16b_bendesc_lim_es          = 'Dental Comp NR Ben Desc Lim YN'
	pbp_b16b_bendesc_numv_es         = 'Dental Comp NR Ben Desc Num'
	pbp_b16b_bendesc_per_es          = 'Dental Comp NR Ben Desc Per'
	pbp_b16b_bendesc_amo_ds          = 'Dental Comp DS Ben Desc AMO'
	pbp_b16b_bendesc_lim_ds          = 'Dental Comp DS Ben Desc Lim YN'
	pbp_b16b_bendesc_numv_ds         = 'Dental Comp DS Ben Desc Num'
	pbp_b16b_bendesc_per_ds          = 'Dental Comp DS Ben Desc Per'
	pbp_b16b_bendesc_amo_rs          = 'Dental Comp RS Ben Desc AMO'
	pbp_b16b_bendesc_lim_rs          = 'Dental Comp RS Ben Desc Lim YN'
	pbp_b16b_bendesc_numv_rs         = 'Dental Comp RS Ben Desc Num'
	pbp_b16b_bendesc_per_rs          = 'Dental Comp RS Ben Desc Per'
	pbp_b16b_bendesc_amo_epe         = 'Dental Comp EPE Ben Desc AMO'
	pbp_b16b_bendesc_lim_epe         = 'Dental Comp EPE Ben Dsc Lim YN'
	pbp_b16b_bendesc_numv_epe        = 'Dental Comp EPE Ben Desc Num'
	pbp_b16b_bendesc_per_epe         = 'Dental Comp EPE Ben Desc Per'
	pbp_b16b_bendesc_amo_poo         = 'Dental Comp POO Ben Desc AMO'
	pbp_b16b_bendesc_lim_poo         = 'Dental Comp POO Ben Dsc Lim YN'
	pbp_b16b_bendesc_numv_poo        = 'Dental Comp POO Ben Desc Num'
	pbp_b16b_bendesc_per_poo         = 'Dental Comp POO Ben Desc Per'
	pbp_b16b_maxplan_yn              = 'Dental Comp Max Plan YN'
	pbp_b16b_maxbene_type            = 'Dental Comp Max Plan Type'
	pbp_b16b_maxplan_amt             = 'Dental Comp Max Plan Amt'
	pbp_b16b_maxplan_per             = 'Dental Comp Max Plan Per'
	pbp_b16b_maxenr_yn               = 'Dental Comp Max Enr YN'
	pbp_b16b_maxenr_type             = 'Dental Comp Max Enr Type'
	pbp_b16b_maxenr_amt              = 'Dental Comp Max Enr Amt'
	pbp_b16b_maxenr_per              = 'Dental Comp Max Enr Per'
	pbp_b16b_coins_yn                = 'Dental Comp Coinsurance YN'
	pbp_b16b_coins_pct_mc            = 'Dental Comp MC Min Coins Pct'
	pbp_b16b_coins_pct_max_mc        = 'Dental Comp MC Max Coins Pct'
	pbp_b16b_coins_pct_es            = 'Dental Comp NR Min Coins Pct'
	pbp_b16b_coins_pct_maxes         = 'Dental Comp NR Max Coins Pct'
	pbp_b16b_coins_pct_ds            = 'Dental Comp DS Min Coins Pct'
	pbp_b16b_coins_pct_maxds         = 'Dental Comp DS Max Coins Pct'
	pbp_b16b_coins_pct_rs            = 'Dental Comp RS Min Coins Pct'
	pbp_b16b_coins_pct_maxrs         = 'Dental Comp RS Max Coins Pct'
	pbp_b16b_coins_pct_epe           = 'Dental Comp EPE Min Coins Pct'
	pbp_b16b_coins_pct_maxepe        = 'Dental Comp EPE Max Coins Pct'
	pbp_b16b_coins_pct_poo           = 'Dental Comp POO Min Coins Pct'
	pbp_b16b_coins_pct_maxpoo        = 'Dental Comp POO Max Coins Pct'
	pbp_b16b_ded_yn                  = 'Dental Comp Deductible YN'
	pbp_b16b_ded_amt                 = 'Dental Comp Deductible Amt'
	pbp_b16b_copay_yn                = 'Dental Comp Copayment YN'
	pbp_b16b_copay_mc_amt            = 'Dental Comp MC Min Copay Amt'
	pbp_b16b_copay_mcmax_amt         = 'Dental Comp MC Max Copay Amt'
	pbp_b16b_copay_amt_esmin         = 'Dental Comp NR Min Copay Amt'
	pbp_b16b_copay_amt_esmax         = 'Dental Comp NR Max Copay Amt'
	pbp_b16b_copay_amt_dsmin         = 'Dental Comp DS Min Copay Amt'
	pbp_b16b_copay_amt_dsmax         = 'Dental Comp DS Max Copay Amt'
	pbp_b16b_copay_amt_rsmin         = 'Dental Comp RS Min Copay Amt'
	pbp_b16b_copay_amt_rsmax         = 'Dental Comp RS Max Copay Amt'
	pbp_b16b_copay_amt_epemin        = 'Dental Comp EPE Min Copay Amt'
	pbp_b16b_copay_amt_epemax        = 'Dental Comp EPE Max Copay Amt'
	pbp_b16b_copay_amt_poomin        = 'Dental Comp POO Min Copay Amt'
	pbp_b16b_copay_amt_poomax        = 'Dental Comp POO Max Copay Amt'
	pbp_b16b_cost_share              = 'Dental Comp Cost Share YN'
	pbp_b16b_cost_share_coins_yn     = 'Dental Comp Cost Share Coin YN'
	pbp_b16b_cost_share_coins_min    = 'Dental Comp Cost Shr Coin Min'
	pbp_b16b_cost_share_coins_max    = 'Dental Comp Cost Shr Coin Max'
	pbp_b16b_cost_share_copay_yn     = 'Dental Comp Cost Shr Copay YN'
	pbp_b16b_cost_share_copay_min    = 'Dental Comp Cost Shr Copay Min'
	pbp_b16b_cost_share_copay_max    = 'Dental Comp Cost Shr Copay Max'
	pbp_b16b_auth                    = 'Dental Comp Enrollee Auth'
	pbp_b16b_refer_yn                = 'Dental Comp Referral YN'
	pbp_d_opt_identifier             = 'Opt Sup Benefits Identifier'
;

run;

proc sort data = pbp_step16b out=out.pbp_step16b;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_step16b(obs = 10);
  title 'pbp_step16b file ';
run;

proc means data = out.pbp_step16b;
  title 'pbp_step16b file ';
run;

proc freq data = out.pbp_step16b;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b16b_bendesc_yn
	pbp_b16b_bendesc_ehc
	pbp_b16b_bendesc_amo_es
	pbp_b16b_bendesc_lim_es
	pbp_b16b_bendesc_per_es
	pbp_b16b_bendesc_amo_ds
	pbp_b16b_bendesc_lim_ds
	pbp_b16b_bendesc_per_ds
	pbp_b16b_bendesc_amo_rs
	pbp_b16b_bendesc_lim_rs
	pbp_b16b_bendesc_per_rs
	pbp_b16b_bendesc_amo_epe
	pbp_b16b_bendesc_lim_epe
	pbp_b16b_bendesc_per_epe
	pbp_b16b_bendesc_amo_poo
	pbp_b16b_bendesc_lim_poo
	pbp_b16b_bendesc_per_poo
	pbp_b16b_maxplan_yn
	pbp_b16b_maxbene_type
	pbp_b16b_maxplan_per
	pbp_b16b_maxenr_yn
	pbp_b16b_maxenr_type
	pbp_b16b_maxenr_per
	pbp_b16b_coins_yn
	pbp_b16b_ded_yn
	pbp_b16b_copay_yn
	pbp_b16b_cost_share
	pbp_b16b_cost_share_coins_yn
	pbp_b16b_cost_share_copay_yn
	pbp_b16b_auth
	pbp_b16b_refer_yn
	pbp_d_opt_identifier
/ missing;
run;

proc contents data = out.pbp_step16b;
  title 'pbp_step16b data';
run;
