*pbp_b14.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b14;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b14a_mc_prevent_attest       $1
	pbp_b14b_bendesc_yn              $1
	pbp_b14b_bendesc_ehc             $7
	pbp_b14b_bendesc_oi_amo          $1
	pbp_b14b_bendesc_rpe_amo         $1
	pbp_b14b_bendesc_rpe_lim_yn      $1
	pbp_b14b_bendesc_rpe_per         $1
	pbp_b14b_bendesc_amo_ps          $1
	pbp_b14b_bendesc_lim_ps_yn       $1
	pbp_b14b_bendesc_ps_per          $1
	pbp_b14b_bendesc_amo_pe          $1
	pbp_b14b_bendesc_lim_pe_yn       $1
	pbp_b14b_bendesc_pe_per          $1
	pbp_b14b_bendesc_apr_amo         $1
	pbp_b14b_bendesc_lim_apr_yn      $1
	pbp_b14b_bendesc_apr_per         $1
	pbp_b14b_bendesc_ace_amo         $1
	pbp_b14b_bendesc_lim_ace_yn      $1
	pbp_b14b_bendesc_ace_per         $1
	pbp_b14b_bendesc_ame_amo         $1
	pbp_b14b_bendesc_lim_ame_yn      $1
	pbp_b14b_bendesc_ame_per         $1
	pbp_b14b_maxplan_yn              $1
	pbp_b14b_maxplan_per             $1
	pbp_b14b_maxenr_yn               $1
	pbp_b14b_maxenr_per              $1
	pbp_b14b_coins_yn                $1
	pbp_b14b_coins_ehc               $7
	pbp_b14b_ded_yn                  $1
	pbp_b14b_copay_yn                $1
	pbp_b14b_copay_ehc               $7
	pbp_b14b_cstshr_yn               $1
	pbp_b14b_cstshr_coins_ace_yn     $1
	pbp_b14b_cstshr_coins_ame_yn     $1
	pbp_b14b_cstshr_copay_ace_yn     $1
	pbp_b14b_cstshr_copay_ame_yn     $1
	pbp_b14b_auth                    $5
	pbp_b14b_refer_yn                $1
	pbp_b14c_bendesc_yn              $1
	pbp_b14c_bendesc_ehc             $5
	pbp_b14c_bendesc_amo_hec         $1
	pbp_b14c_bendesc_amo_ntb         $1
	pbp_b14c_bendesc_amo_sc          $1
	pbp_b14c_bendesc_amo_mhc         $1
	pbp_b14c_bendesc_amo_nhl         $1
	pbp_b14c_maxplan_yn              $1
	pbp_b14c_maxplan_per             $1
	pbp_b14c_maxenr_yn               $1
	pbp_b14c_maxenr_per              $1
	pbp_b14c_coins_yn                $1
	pbp_b14c_coins_ehc               $5
	pbp_b14c_ded_yn                  $1
	pbp_b14c_copay_yn                $1
	pbp_b14c_copay_ehc               $5
	pbp_b14c_auth                    $5
	pbp_b14c_refer_yn                $1
	pbp_b14d_maxenr_yn               $1
	pbp_b14d_maxenr_per              $1
	pbp_b14d_coins_yn                $1
	pbp_b14d_ded_yn                  $1
	pbp_b14d_copay_yn                $1
	pbp_b14d_auth                    $5
	pbp_b14d_refer_yn                $1
	pbp_b14e_maxenr_yn               $1
	pbp_b14e_maxenr_per              $1
	pbp_b14e_coins_yn                $1
	pbp_b14e_ded_yn                  $1
	pbp_b14e_copay_yn                $1
	pbp_b14e_cost_share              $1
	pbp_b14e_cost_share_coins_yn     $1
	pbp_b14e_cost_share_copay_yn     $1
	pbp_b14e_auth                    $5
	pbp_b14e_refer_yn                $1
;

infile '.\pbp\pbp_b14_preventive.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b14a_mc_prevent_attest
	pbp_b14b_bendesc_yn
	pbp_b14b_bendesc_ehc
	pbp_b14b_bendesc_oi_amo
	pbp_b14b_bendesc_rpe_amo
	pbp_b14b_bendesc_rpe_lim_yn
	pbp_b14b_bendesc_rpe_numv
	pbp_b14b_bendesc_rpe_per
	pbp_b14b_bendesc_amo_ps
	pbp_b14b_bendesc_lim_ps_yn
	pbp_b14b_bendesc_numps
	pbp_b14b_bendesc_ps_per
	pbp_b14b_bendesc_amo_pe
	pbp_b14b_bendesc_lim_pe_yn
	pbp_b14b_bendesc_numpe
	pbp_b14b_bendesc_pe_per
	pbp_b14b_bendesc_apr_amo
	pbp_b14b_bendesc_lim_apr_yn
	pbp_b14b_bendesc_numapr
	pbp_b14b_bendesc_apr_per
	pbp_b14b_bendesc_ace_amo
	pbp_b14b_bendesc_lim_ace_yn
	pbp_b14b_bendesc_numace
	pbp_b14b_bendesc_ace_per
	pbp_b14b_bendesc_ame_amo
	pbp_b14b_bendesc_lim_ame_yn
	pbp_b14b_bendesc_numame
	pbp_b14b_bendesc_ame_per
	pbp_b14b_maxplan_yn
	pbp_b14b_maxplan_amt
	pbp_b14b_maxplan_per
	pbp_b14b_maxenr_yn
	pbp_b14b_maxenr_amt
	pbp_b14b_maxenr_per
	pbp_b14b_coins_yn
	pbp_b14b_coins_ehc
	pbp_b14b_coins_pct_minoi
	pbp_b14b_coins_pct_maxoi
	pbp_b14b_coins_pct_rpe
	pbp_b14b_coins_pct_pap
	pbp_b14b_coins_pct_pe
	pbp_b14b_ape_coins_pct
	pbp_b14b_ace_coins_min_pct
	pbp_b14b_ace_coins_max_pct
	pbp_b14b_ame_coins_pct
	pbp_b14b_ded_yn
	pbp_b14b_ded_amt
	pbp_b14b_copay_yn
	pbp_b14b_copay_ehc
	pbp_b14b_copay_oi_min_amt
	pbp_b14b_copay_oi_max_amt
	pbp_b14b_copay_amt_rpe
	pbp_b14b_copay_amt_pap
	pbp_b14b_copay_amt_pe
	pbp_b14b_ape_copay_amt
	pbp_b14b_copay_ace_min_amt
	pbp_b14b_copay_ace_max_amt
	pbp_b14b_ame_copay_amt
	pbp_b14b_cstshr_yn
	pbp_b14b_cstshr_coins_ace_yn
	pbp_b14b_cstshr_coins_ace_min
	pbp_b14b_cstshr_coins_ace_max
	pbp_b14b_cstshr_coins_ame_yn
	pbp_b14b_cstshr_coins_ame_min
	pbp_b14b_cstshr_coins_ame_max
	pbp_b14b_cstshr_copay_ace_yn
	pbp_b14b_cstshr_copay_ace_min
	pbp_b14b_cstshr_copay_ace_max
	pbp_b14b_cstshr_copay_ame_yn
	pbp_b14b_cstshr_copay_ame_min
	pbp_b14b_cstshr_copay_ame_max
	pbp_b14b_auth
	pbp_b14b_refer_yn
	pbp_b14c_bendesc_yn
	pbp_b14c_bendesc_ehc
	pbp_b14c_bendesc_amo_hec
	pbp_b14c_bendesc_amo_ntb
	pbp_b14c_bendesc_amo_sc
	pbp_b14c_bendesc_amo_mhc
	pbp_b14c_bendesc_amo_nhl
	pbp_b14c_maxplan_yn
	pbp_b14c_maxplan_amt
	pbp_b14c_maxplan_per
	pbp_b14c_maxenr_yn
	pbp_b14c_maxenr_amt
	pbp_b14c_maxenr_per
	pbp_b14c_coins_yn
	pbp_b14c_coins_ehc
	pbp_b14c_coins_pct_min_hec
	pbp_b14c_coins_pct_max_hec
	pbp_b14c_coins_pct_ntb
	pbp_b14c_coins_pct_sc
	pbp_b14c_coins_pct_min_mhc
	pbp_b14c_coins_pct_max_mhc
	pbp_b14c_coins_pct_nhl
	pbp_b14c_ded_yn
	pbp_b14c_ded_amt
	pbp_b14c_copay_yn
	pbp_b14c_copay_ehc
	pbp_b14c_copay_hec_amt
	pbp_b14c_copay_ntb_amt
	pbp_b14c_copay_sc_amt
	pbp_b14c_copay_mhc_min_amt
	pbp_b14c_copay_mhc_max_amt
	pbp_b14c_copay_nhl_amt
	pbp_b14c_auth
	pbp_b14c_refer_yn
	pbp_b14d_maxenr_yn
	pbp_b14d_maxenr_amt
	pbp_b14d_maxenr_per
	pbp_b14d_coins_yn
	pbp_b14d_coins_mc_min_pct
	pbp_b14d_coins_mc_max_pct
	pbp_b14d_ded_yn
	pbp_b14d_ded_amt
	pbp_b14d_copay_yn
	pbp_b14d_copay_mc_min_amt
	pbp_b14d_copay_mc_max_amt
	pbp_b14d_auth
	pbp_b14d_refer_yn
	pbp_b14e_maxenr_yn
	pbp_b14e_maxenr_amt
	pbp_b14e_maxenr_per
	pbp_b14e_coins_yn
	pbp_b14e_coins_pct
	pbp_b14e_coins_max_pct
	pbp_b14e_ded_yn
	pbp_b14e_ded_amt
	pbp_b14e_copay_yn
	pbp_b14e_copay_mc_min_amt
	pbp_b14e_copay_mc_max_amt
	pbp_b14e_cost_share
	pbp_b14e_cost_share_coins_yn
	pbp_b14e_cost_share_coins_min
	pbp_b14e_cost_share_coins_max
	pbp_b14e_cost_share_copay_yn
	pbp_b14e_cost_share_copay_min
	pbp_b14e_cost_share_copay_max
	pbp_b14e_auth
	pbp_b14e_refer_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b14a_mc_prevent_attest       = '14A MC Prevent Srvcs attest'
	pbp_b14b_bendesc_yn              = 'Supp Prevent  Ben Desc YN'
	pbp_b14b_bendesc_ehc             = 'Sup Prevent Ben Desc Enhance'
	pbp_b14b_bendesc_oi_amo          = 'Immunizations Ben Desc MO'
	pbp_b14b_bendesc_rpe_amo         = 'Routine Phys Exams Ben Desc MO'
	pbp_b14b_bendesc_rpe_lim_yn      = 'Routine Phys Ben Desc Lim YN'
	pbp_b14b_bendesc_rpe_numv        = 'Routine Phys Ben Desc Num'
	pbp_b14b_bendesc_rpe_per         = 'Routine Phys Ben Desc Per'
	pbp_b14b_bendesc_amo_ps          = 'Pap Smears Ben Desc MO'
	pbp_b14b_bendesc_lim_ps_yn       = 'Pap Smears Ben Desc Lim YN'
	pbp_b14b_bendesc_numps           = 'Pap Smears Ben Desc Num'
	pbp_b14b_bendesc_ps_per          = 'Pap Smears Ben Desc Per'
	pbp_b14b_bendesc_amo_pe          = 'Pelvic Exams Ben Desc MO'
	pbp_b14b_bendesc_lim_pe_yn       = 'Pelvic Exm Ben Desc Lim YN'
	pbp_b14b_bendesc_numpe           = 'Pelvic Exams Ben Desc Num'
	pbp_b14b_bendesc_pe_per          = 'Pelvic Exams Ben Desc Per'
	pbp_b14b_bendesc_apr_amo         = 'Prostate Exam Ben Desc MO'
	pbp_b14b_bendesc_lim_apr_yn      = 'Prostate Exam Ben Desc Lim YN'
	pbp_b14b_bendesc_numapr          = 'Prostate Exam Ben Desc Num'
	pbp_b14b_bendesc_apr_per         = 'Prostate Exam Ben Desc Per'
	pbp_b14b_bendesc_ace_amo         = 'Colorctl Exam Ben Desc MO'
	pbp_b14b_bendesc_lim_ace_yn      = 'Colorctl Exam Ben Desc Lim YN'
	pbp_b14b_bendesc_numace          = 'Colorctl Exam Ben Desc Num'
	pbp_b14b_bendesc_ace_per         = 'Colorctl Exam Ben Desc Per'
	pbp_b14b_bendesc_ame_amo         = 'Mammography Ben Desc MO'
	pbp_b14b_bendesc_lim_ame_yn      = 'Mammography Ben Desc Lim YN'
	pbp_b14b_bendesc_numame          = 'Mammography Ben Desc Num'
	pbp_b14b_bendesc_ame_per         = 'Mammography Ben Desc Per'
	pbp_b14b_maxplan_yn              = 'Mammography Max Plan YN'
	pbp_b14b_maxplan_amt             = 'Mammography Max Plan Amt'
	pbp_b14b_maxplan_per             = 'Mammography Max Plan Per'
	pbp_b14b_maxenr_yn               = 'Immunizations Max Enr YN'
	pbp_b14b_maxenr_amt              = 'Immunizations Max Enr Amt'
	pbp_b14b_maxenr_per              = 'Immunizations Max Enr Per'
	pbp_b14b_coins_yn                = 'Immunizations Coinsurance YN'
	pbp_b14b_coins_ehc               = '14B Coins Enhanced Benefits'
	pbp_b14b_coins_pct_minoi         = 'Immunizations OI Min Coins Pct'
	pbp_b14b_coins_pct_maxoi         = 'Immunizations OI Max Coins Pct'
	pbp_b14b_coins_pct_rpe           = 'Routine Phys Coins Pct'
	pbp_b14b_coins_pct_pap           = 'Pap Smears Coins Pct'
	pbp_b14b_coins_pct_pe            = 'Pelvic Exams Coins Pct'
	pbp_b14b_ape_coins_pct           = 'Prostate Exam AS Coins Pct'
	pbp_b14b_ace_coins_min_pct       = 'Colorctl Exam AS Min Coins Pct'
	pbp_b14b_ace_coins_max_pct       = 'Colorctl Exam AS Max Coins Pct'
	pbp_b14b_ame_coins_pct           = 'Mammography AS Coins Pct'
	pbp_b14b_ded_yn                  = 'Immunizations Deductible YN'
	pbp_b14b_ded_amt                 = 'Immunizations Deductible Amt'
	pbp_b14b_copay_yn                = 'Immunizations Copayment YN'
	pbp_b14b_copay_ehc               = 'B14B Copay Enhanced Bens'
	pbp_b14b_copay_oi_min_amt        = 'Immunizations OI Min Copay Amt'
	pbp_b14b_copay_oi_max_amt        = 'Immunizations OI Max Copay Amt'
	pbp_b14b_copay_amt_rpe           = 'Routine Phys Copay Amt'
	pbp_b14b_copay_amt_pap           = 'Pap Smears Copay Amt'
	pbp_b14b_copay_amt_pe            = 'Pelvic Exams Copay Amt'
	pbp_b14b_ape_copay_amt           = 'Prostate Exam AS Copay Amt'
	pbp_b14b_copay_ace_min_amt       = 'Colorctl Exam AS Min Copay Amt'
	pbp_b14b_copay_ace_max_amt       = 'Colorctl Exam AS Max Copay Amt'
	pbp_b14b_ame_copay_amt           = 'Mammography AS Copay Amt'
	pbp_b14b_cstshr_yn               = 'Colorctl Scrn Cost Share'
	pbp_b14b_cstshr_coins_ace_yn     = 'Colorctl Cost Share Coin YN'
	pbp_b14b_cstshr_coins_ace_min    = 'Colorctl Cost Share Coin Min'
	pbp_b14b_cstshr_coins_ace_max    = 'Colorctl Cost Share Coin Max'
	pbp_b14b_cstshr_coins_ame_yn     = 'Mammography Cost Share Coin YN'
	pbp_b14b_cstshr_coins_ame_min    = 'Mammography Cost Shr Coin Min'
	pbp_b14b_cstshr_coins_ame_max    = 'Mammography Cost Shr Coin Max'
	pbp_b14b_cstshr_copay_ace_yn     = 'Colorctl Cost Share Copay YN'
	pbp_b14b_cstshr_copay_ace_min    = 'Colorctl Cost Share Copay Min'
	pbp_b14b_cstshr_copay_ace_max    = 'Colorctl Cost Share Copay Max'
	pbp_b14b_cstshr_copay_ame_yn     = 'Mammography Cost Shr Copay YN'
	pbp_b14b_cstshr_copay_ame_min    = 'Mammography Cost Shr Copay Min'
	pbp_b14b_cstshr_copay_ame_max    = 'Mammography Cost Shr Copay Max'
	pbp_b14b_auth                    = 'Supp Prev Srvcs Enrollee Auth'
	pbp_b14b_refer_yn                = 'Immunizations Referral YN'
	pbp_b14c_bendesc_yn              = 'Routine Phys Ben Desc YN'
	pbp_b14c_bendesc_ehc             = 'Health Ed Ben Desc Enhance'
	pbp_b14c_bendesc_amo_hec         = 'Health Ed HEC Ben Desc MO'
	pbp_b14c_bendesc_amo_ntb         = 'Health Ed NTB Ben Desc MO'
	pbp_b14c_bendesc_amo_sc          = 'Health Ed SC Ben Desc MO'
	pbp_b14c_bendesc_amo_mhc         = 'Health Ed MHC Ben Desc MO'
	pbp_b14c_bendesc_amo_nhl         = 'Health Ed NHL Ben Desc MO'
	pbp_b14c_maxplan_yn              = 'Routine Phys Max Plan YN'
	pbp_b14c_maxplan_amt             = 'Routine Phys Max Plan Amt'
	pbp_b14c_maxplan_per             = 'Routine Phys Max Plan Per'
	pbp_b14c_maxenr_yn               = 'Routine Phys Max Enr YN'
	pbp_b14c_maxenr_amt              = 'Routine Phys Max Enr Amt'
	pbp_b14c_maxenr_per              = 'Routine Phys Max Enr Per'
	pbp_b14c_coins_yn                = 'Routine Phys Coinsurance YN'
	pbp_b14c_coins_ehc               = 'B14C Coins Enhance Bens'
	pbp_b14c_coins_pct_min_hec       = 'Health Ed HEC Min Coins Pct'
	pbp_b14c_coins_pct_max_hec       = 'Health Ed HEC Max Coins Pct'
	pbp_b14c_coins_pct_ntb           = 'Health Ed NTB Coins Pct'
	pbp_b14c_coins_pct_sc            = 'Health Ed SC Coins Pct'
	pbp_b14c_coins_pct_min_mhc       = 'Health Ed MHC Min Coins Pct'
	pbp_b14c_coins_pct_max_mhc       = 'Health Ed MHC Max Coins Pct'
	pbp_b14c_coins_pct_nhl           = 'Health Ed NHL Coins Pct'
	pbp_b14c_ded_yn                  = 'Routine Phys Deductible YN'
	pbp_b14c_ded_amt                 = 'Routine Phys Deductible Amt'
	pbp_b14c_copay_yn                = 'Routine Phys Copayment YN'
	pbp_b14c_copay_ehc               = '14C Copay Enhanced Bens'
	pbp_b14c_copay_hec_amt           = 'Health Ed HEC Copay Min Amt'
	pbp_b14c_copay_ntb_amt           = 'Health Ed NTB Copay Amt'
	pbp_b14c_copay_sc_amt            = 'Health Ed SC Copay Amt'
	pbp_b14c_copay_mhc_min_amt       = 'Health Ed MHC Min Copay Amt'
	pbp_b14c_copay_mhc_max_amt       = 'Health Ed MHC Max Copay Amt'
	pbp_b14c_copay_nhl_amt           = 'Health Ed NHL Copay Amt'
	pbp_b14c_auth                    = 'Routine Phys Enrollee Auth'
	pbp_b14c_refer_yn                = 'Routine Phys Referral YN'
	pbp_b14d_maxenr_yn               = 'Pap/Pelvic Max Enr YN'
	pbp_b14d_maxenr_amt              = 'Pap/Pelvic Max Enr Amt'
	pbp_b14d_maxenr_per              = 'Pap/Pelvic Max Enr Per'
	pbp_b14d_coins_yn                = 'Pap/Pelvic Coinsurance YN'
	pbp_b14d_coins_mc_min_pct        = 'Nutrtn Ther MC Min Coins Pct'
	pbp_b14d_coins_mc_max_pct        = 'Nutrtn Ther MC Max Coins Pct'
	pbp_b14d_ded_yn                  = 'Pap/Pelvic Deductible YN'
	pbp_b14d_ded_amt                 = 'Pap/Pelvic Deductible Amt'
	pbp_b14d_copay_yn                = 'Pap/Pelvic Copayment YN'
	pbp_b14d_copay_mc_min_amt        = 'Nutrtn Ther MC Min Copay Amt'
	pbp_b14d_copay_mc_max_amt        = 'Nutrtn Ther MC Max Copay Amt'
	pbp_b14d_auth                    = 'Pap/Pelvic Enrollee Auth'
	pbp_b14d_refer_yn                = 'Pap/Pelvic Referral YN'
	pbp_b14e_maxenr_yn               = 'Diabetes Mon Max Enr YN'
	pbp_b14e_maxenr_amt              = 'Diabetes Mon Max Enr Amt'
	pbp_b14e_maxenr_per              = 'Diabetes Mon Max Enr Per'
	pbp_b14e_coins_yn                = 'Diabetes Mon Coinsurance YN'
	pbp_b14e_coins_pct               = 'Diabetes Mon MC Min Coins Pct'
	pbp_b14e_coins_max_pct           = 'Diabetes Mon MC Max Coins Pct'
	pbp_b14e_ded_yn                  = 'Diabetes Mon Deductible YN'
	pbp_b14e_ded_amt                 = 'Diabetes Mon Deductible Amt'
	pbp_b14e_copay_yn                = 'Diabetes Mon Copayment YN'
	pbp_b14e_copay_mc_min_amt        = 'Diabetes Mon MC Min Copay Amt'
	pbp_b14e_copay_mc_max_amt        = 'Diabetes Mon MC Max Copay Amt'
	pbp_b14e_cost_share              = 'Diabetes Mon Cost Share'
	pbp_b14e_cost_share_coins_yn     = 'Diabetes Cost Share Coin YN'
	pbp_b14e_cost_share_coins_min    = 'Diabetes Cost Share Coin Min'
	pbp_b14e_cost_share_coins_max    = 'Diabetes Cost Share Coin Max'
	pbp_b14e_cost_share_copay_yn     = 'Diabetes Cost Share Copay YN'
	pbp_b14e_cost_share_copay_min    = 'Diabetes Cost Share Copay Min'
	pbp_b14e_cost_share_copay_max    = 'Diabetes Cost Share Copay Max'
	pbp_b14e_auth                    = 'Diabetes Mon Enrollee Auth'
	pbp_b14e_refer_yn                = 'Diabetes Mon Referral YN'
;

run;

proc sort data = pbp_b14 out=out.pbp_b14;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b14(obs = 10);
  title 'pbp_b14_preventive file ';
run;

proc means data = out.pbp_b14;
  title 'pbp_b14_preventive file ';
run;

proc freq data = out.pbp_b14;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b14a_mc_prevent_attest
	pbp_b14b_bendesc_yn
	pbp_b14b_bendesc_oi_amo
	pbp_b14b_bendesc_rpe_amo
	pbp_b14b_bendesc_rpe_lim_yn
	pbp_b14b_bendesc_rpe_per
	pbp_b14b_bendesc_amo_ps
	pbp_b14b_bendesc_lim_ps_yn
	pbp_b14b_bendesc_ps_per
	pbp_b14b_bendesc_amo_pe
	pbp_b14b_bendesc_lim_pe_yn
	pbp_b14b_bendesc_pe_per
	pbp_b14b_bendesc_apr_amo
	pbp_b14b_bendesc_lim_apr_yn
	pbp_b14b_bendesc_apr_per
	pbp_b14b_bendesc_ace_amo
	pbp_b14b_bendesc_lim_ace_yn
	pbp_b14b_bendesc_ace_per
	pbp_b14b_bendesc_ame_amo
	pbp_b14b_bendesc_lim_ame_yn
	pbp_b14b_bendesc_ame_per
	pbp_b14b_maxplan_yn
	pbp_b14b_maxplan_per
	pbp_b14b_maxenr_yn
	pbp_b14b_maxenr_per
	pbp_b14b_coins_yn
	pbp_b14b_ded_yn
	pbp_b14b_copay_yn
	pbp_b14b_cstshr_yn
	pbp_b14b_cstshr_coins_ace_yn
	pbp_b14b_cstshr_coins_ame_yn
	pbp_b14b_cstshr_copay_ace_yn
	pbp_b14b_cstshr_copay_ame_yn
	pbp_b14b_auth
	pbp_b14b_refer_yn
	pbp_b14c_bendesc_yn
	pbp_b14c_bendesc_ehc
	pbp_b14c_bendesc_amo_hec
	pbp_b14c_bendesc_amo_ntb
	pbp_b14c_bendesc_amo_sc
	pbp_b14c_bendesc_amo_mhc
	pbp_b14c_bendesc_amo_nhl
	pbp_b14c_maxplan_yn
	pbp_b14c_maxplan_per
	pbp_b14c_maxenr_yn
	pbp_b14c_maxenr_per
	pbp_b14c_coins_yn
	pbp_b14c_coins_ehc
	pbp_b14c_ded_yn
	pbp_b14c_copay_yn
	pbp_b14c_copay_ehc
	pbp_b14c_auth
	pbp_b14c_refer_yn
	pbp_b14d_maxenr_yn
	pbp_b14d_maxenr_per
	pbp_b14d_coins_yn
	pbp_b14d_ded_yn
	pbp_b14d_copay_yn
	pbp_b14d_auth
	pbp_b14d_refer_yn
	pbp_b14e_maxenr_yn
	pbp_b14e_maxenr_per
	pbp_b14e_coins_yn
	pbp_b14e_ded_yn
	pbp_b14e_copay_yn
	pbp_b14e_cost_share
	pbp_b14e_cost_share_coins_yn
	pbp_b14e_cost_share_copay_yn
	pbp_b14e_auth
	pbp_b14e_refer_yn
/ missing;
run;

proc contents data = out.pbp_b14;
  title 'pbp_b14 data';
run;
