*pbp_mrx_gapCoverage.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx_gapCoverage;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	mrx_tier_id                      $1
	mrx_tier_drug_type               $6
	mrx_tier_label_list              $2
	mrx_tier_gap_cost_share          $1
	mrx_tier_alt_gap_covg_excl_yn    $1
	mrx_tier_gap_excluded_only_yn    $1
;

infile '.\pbp\pbp_mrx_gapCoverage.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	mrx_tier_id
	mrx_tier_drug_type
	mrx_tier_label_list
	mrx_tier_gap_cost_share
	mrx_tier_alt_gap_covg_excl_yn
	mrx_tier_gap_excluded_only_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	mrx_tier_id                      = 'MRx Tier ID'
	mrx_tier_drug_type               = 'MRx Tier Drug Types'
	mrx_tier_label_list              = 'MRx Tier Label Selection'
	mrx_tier_gap_cost_share          = 'MRx Tier Gap Cost Share'
	mrx_tier_alt_gap_covg_excl_yn    = 'MRx Alt Gap Cov Excl YN'
	mrx_tier_gap_excluded_only_yn    = 'MRx Alt Gap Cov Excl Only YN'
;

run;

proc sort data = pbp_mrx_gapCoverage out=out.pbp_mrx_gapCoverage;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx_gapCoverage(obs = 10);
  title 'pbp_mrx_gapCoverage file ';
run;

proc means data = out.pbp_mrx_gapCoverage;
  title 'pbp_mrx_gapCoverage file ';
run;

proc freq data = out.pbp_mrx_gapCoverage;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	mrx_tier_id
	mrx_tier_label_list
	mrx_tier_gap_cost_share
	mrx_tier_alt_gap_covg_excl_yn
	mrx_tier_gap_excluded_only_yn
/ missing;
run;

proc contents data = out.pbp_mrx_gapCoverage;
  title 'pbp_mrx_gapCoverage data';
run;
