*pbp_step16a.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_step16a;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b16a_bendesc_yn              $1
	pbp_b16a_bendesc_ehc             $4
	pbp_b16a_bendesc_amo_oe          $1
	pbp_b16a_bendesc_lim_oe          $1
	pbp_b16a_bendesc_per_oe          $1
	pbp_b16a_bendesc_amo_pc          $1
	pbp_b16a_bendesc_lim_pc          $1
	pbp_b16a_bendesc_per_pc          $1
	pbp_b16a_bendesc_amo_ft          $1
	pbp_b16a_bendesc_lim_ft          $1
	pbp_b16a_bendesc_per_ft          $1
	pbp_b16a_bendesc_amo_dx          $1
	pbp_b16a_bendesc_lim_dx          $1
	pbp_b16a_bendesc_per_dx          $1
	pbp_b16a_maxplan_yn              $1
	pbp_b16a_maxplan_in_oon          $1
	pbp_b16a_maxplan_per             $1
	pbp_b16a_maxenr_yn               $1
	pbp_b16a_maxenr_per              $1
	pbp_b16a_coins_yn                $1
	pbp_b16a_coins_cserv_sc_pov_yn   $1
	pbp_b16a_coins_cserv_sc_pov      $4
	pbp_b16a_ded_yn                  $1
	pbp_b16a_copay_yn                $1
	pbp_b16a_copay_cserv_sc_pov_yn   $1
	pbp_b16a_copay_cserv_sc_pov      $4
	pbp_b16a_auth                    $5
	pbp_b16a_refer_yn                $1
	pbp_d_opt_identifier             $3
;

infile '.\pbp\pbp_step16a.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b16a_bendesc_yn
	pbp_b16a_bendesc_ehc
	pbp_b16a_bendesc_amo_oe
	pbp_b16a_bendesc_lim_oe
	pbp_b16a_bendesc_numv_oe
	pbp_b16a_bendesc_per_oe
	pbp_b16a_bendesc_amo_pc
	pbp_b16a_bendesc_lim_pc
	pbp_b16a_bendesc_numv_pc
	pbp_b16a_bendesc_per_pc
	pbp_b16a_bendesc_amo_ft
	pbp_b16a_bendesc_lim_ft
	pbp_b16a_bendesc_numv_ft
	pbp_b16a_bendesc_per_ft
	pbp_b16a_bendesc_amo_dx
	pbp_b16a_bendesc_lim_dx
	pbp_b16a_bendesc_numv_dx
	pbp_b16a_bendesc_per_dx
	pbp_b16a_maxplan_yn
	pbp_b16a_maxplan_in_oon
	pbp_b16a_maxplan_amt
	pbp_b16a_maxplan_per
	pbp_b16a_maxenr_yn
	pbp_b16a_maxenr_amt
	pbp_b16a_maxenr_per
	pbp_b16a_coins_yn
	pbp_b16a_coins_cserv_sc_pov_yn
	pbp_b16a_coins_cserv_sc_pov
	pbp_b16a_coins_pct_ov
	pbp_b16a_coins_pct_oe
	pbp_b16a_coins_pct_maxoe
	pbp_b16a_coins_pct_pc
	pbp_b16a_coins_pct_maxpc
	pbp_b16a_coins_pct_ft
	pbp_b16a_coins_pct_maxft
	pbp_b16a_coins_pct_dx
	pbp_b16a_coins_pct_maxdx
	pbp_b16a_ded_yn
	pbp_b16a_ded_amt
	pbp_b16a_copay_yn
	pbp_b16a_copay_cserv_sc_pov_yn
	pbp_b16a_copay_cserv_sc_pov
	pbp_b16a_copay_ov_amt
	pbp_b16a_copay_amt_oemin
	pbp_b16a_copay_amt_oemax
	pbp_b16a_copay_amt_pcmin
	pbp_b16a_copay_amt_pcmax
	pbp_b16a_copay_amt_ftmin
	pbp_b16a_copay_amt_ftmax
	pbp_b16a_copay_amt_dxmin
	pbp_b16a_copay_amt_dxmax
	pbp_b16a_auth
	pbp_b16a_refer_yn
	pbp_d_opt_identifier
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b16a_bendesc_yn              = 'Dental Prev Ben Desc YN'
	pbp_b16a_bendesc_ehc             = 'Dental Prev Ben Desc Enhance'
	pbp_b16a_bendesc_amo_oe          = 'Dental Prev OE Ben Desc AMO'
	pbp_b16a_bendesc_lim_oe          = 'Dental Prev OE Ben Desc Lim YN'
	pbp_b16a_bendesc_numv_oe         = 'Dental Prev OE Ben Desc Num'
	pbp_b16a_bendesc_per_oe          = 'Dental Prev OE Ben Desc Per'
	pbp_b16a_bendesc_amo_pc          = 'Dental Prev PC Ben Desc AMO'
	pbp_b16a_bendesc_lim_pc          = 'Dental Prev PC Ben Desc Lim YN'
	pbp_b16a_bendesc_numv_pc         = 'Dental Prev PC Ben Desc Num'
	pbp_b16a_bendesc_per_pc          = 'Dental Prev PC Ben Desc Per'
	pbp_b16a_bendesc_amo_ft          = 'Dental Prev FT Ben Desc AMO'
	pbp_b16a_bendesc_lim_ft          = 'Dental Prev FT Ben Desc Lim YN'
	pbp_b16a_bendesc_numv_ft         = 'Dental Prev FT Ben Desc Num'
	pbp_b16a_bendesc_per_ft          = 'Dental Prev FT Ben Desc Per'
	pbp_b16a_bendesc_amo_dx          = 'Dental Prev DX Ben Desc AMO'
	pbp_b16a_bendesc_lim_dx          = 'Dental Prev DX Ben Desc Lim YN'
	pbp_b16a_bendesc_numv_dx         = 'Dental Prev DX Ben Desc Num'
	pbp_b16a_bendesc_per_dx          = 'Dental Prev DX Ben Desc Per'
	pbp_b16a_maxplan_yn              = 'Dental Prev Max Plan YN'
	pbp_b16a_maxplan_in_oon          = 'In or Out'
	pbp_b16a_maxplan_amt             = 'Dental Prev Max Plan Amt'
	pbp_b16a_maxplan_per             = 'Dental Prev Max Plan Per'
	pbp_b16a_maxenr_yn               = 'Dental Prev Max Enr YN'
	pbp_b16a_maxenr_amt              = 'Dental Prev Max Enr Amt'
	pbp_b16a_maxenr_per              = 'Dental Prev Max Enr Per'
	pbp_b16a_coins_yn                = 'Dental Prev Coinsurance YN'
	pbp_b16a_coins_cserv_sc_pov_yn   = 'Dental Prev CServ SC OV YN'
	pbp_b16a_coins_cserv_sc_pov      = 'Dental Prev CServ SC POV'
	pbp_b16a_coins_pct_ov            = 'Dental Prev OV Coins Pct'
	pbp_b16a_coins_pct_oe            = 'Dental Prev OE Min Coins Pct'
	pbp_b16a_coins_pct_maxoe         = 'Dental Prev OE Max Coins Pct'
	pbp_b16a_coins_pct_pc            = 'Dental Prev PC Min Coins Pct'
	pbp_b16a_coins_pct_maxpc         = 'Dental Prev PC Max Coins Pct'
	pbp_b16a_coins_pct_ft            = 'Dental Prev FT Min Coins Pct'
	pbp_b16a_coins_pct_maxft         = 'Dental Prev FT Max Coins Pct'
	pbp_b16a_coins_pct_dx            = 'Dental Prev DX Min Coins Pct'
	pbp_b16a_coins_pct_maxdx         = 'Dental Prev DX Max Coins Pct'
	pbp_b16a_ded_yn                  = 'Dental Prev Deductible YN'
	pbp_b16a_ded_amt                 = 'Dental Prev Deductible Amt'
	pbp_b16a_copay_yn                = 'Dental Prev Copayment YN'
	pbp_b16a_copay_cserv_sc_pov_yn   = 'Dental Prev CServ Copay OV YN'
	pbp_b16a_copay_cserv_sc_pov      = 'Dental Prev CServ Copay SC POV'
	pbp_b16a_copay_ov_amt            = 'Dental Prev OV Copay Amt'
	pbp_b16a_copay_amt_oemin         = 'Dental Prev OE Min Copay Amt'
	pbp_b16a_copay_amt_oemax         = 'Dental Prev OE Max Copay Amt'
	pbp_b16a_copay_amt_pcmin         = 'Dental Prev PC Min Copay Amt'
	pbp_b16a_copay_amt_pcmax         = 'Dental Prev PC Max Copay Amt'
	pbp_b16a_copay_amt_ftmin         = 'Dental Prev FT Min Copay Amt'
	pbp_b16a_copay_amt_ftmax         = 'Dental Prev FT Max Copay Amt'
	pbp_b16a_copay_amt_dxmin         = 'Dental Prev DX Min Copay Amt'
	pbp_b16a_copay_amt_dxmax         = 'Dental Prev DX Max Copay Amt'
	pbp_b16a_auth                    = 'Dental Prev Enrollee Auth'
	pbp_b16a_refer_yn                = 'Dental Prev Referral YN'
	pbp_d_opt_identifier             = 'Opt Sup Benefits Identifier'
;

run;

proc sort data = pbp_step16a out=out.pbp_step16a;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_step16a(obs = 10);
  title 'pbp_step16a file ';
run;

proc means data = out.pbp_step16a;
  title 'pbp_step16a file ';
run;

proc freq data = out.pbp_step16a;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b16a_bendesc_yn
	pbp_b16a_bendesc_ehc
	pbp_b16a_bendesc_amo_oe
	pbp_b16a_bendesc_lim_oe
	pbp_b16a_bendesc_per_oe
	pbp_b16a_bendesc_amo_pc
	pbp_b16a_bendesc_lim_pc
	pbp_b16a_bendesc_per_pc
	pbp_b16a_bendesc_amo_ft
	pbp_b16a_bendesc_lim_ft
	pbp_b16a_bendesc_per_ft
	pbp_b16a_bendesc_amo_dx
	pbp_b16a_bendesc_lim_dx
	pbp_b16a_bendesc_per_dx
	pbp_b16a_maxplan_yn
	pbp_b16a_maxplan_in_oon
	pbp_b16a_maxplan_per
	pbp_b16a_maxenr_yn
	pbp_b16a_maxenr_per
	pbp_b16a_coins_yn
	pbp_b16a_coins_cserv_sc_pov_yn
	pbp_b16a_coins_cserv_sc_pov
	pbp_b16a_ded_yn
	pbp_b16a_copay_yn
	pbp_b16a_copay_cserv_sc_pov_yn
	pbp_b16a_copay_cserv_sc_pov
	pbp_b16a_auth
	pbp_b16a_refer_yn
	pbp_d_opt_identifier
/ missing;
run;

proc contents data = out.pbp_step16a;
  title 'pbp_step16a data';
run;
