*pbp_b13.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b13;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b13a_bendesc_yn              $1
	pbp_b13a_bendesc_enhan           $1
	pbp_b13a_bendesc_amo             $1
	pbp_b13a_bendesc_lim             $1
	pbp_b13a_bendesc_per             $1
	pbp_b13a_maxplan_yn              $1
	pbp_b13a_maxplan_per             $1
	pbp_b13a_maxenr_yn               $1
	pbp_b13a_maxenr_per              $1
	pbp_b13a_coins_yn                $1
	pbp_b13a_ded_yn                  $1
	pbp_b13a_copay_yn                $1
	pbp_b13a_auth                    $5
	pbp_b13a_refer_yn                $1
	pbp_b13b_bendesc_otc             $1
	pbp_b13b_bendesc_amo             $1
	pbp_b13b_maxplan_yn              $1
	pbp_b13b_otc_maxplan_per         $1
	pbp_b13b_maxenr_yn               $1
	pbp_b13b_maxenr_per              $1
	pbp_b13b_coins_yn                $1
	pbp_b13b_ded_yn                  $1
	pbp_b13b_copay_yn                $1
	pbp_b13b_cms_otc_list_yn         $1
	pbp_b13c_bendesc_service         $1
	pbp_b13c_bendesc_amo             $1
	pbp_b13c_maxplan_yn              $1
	pbp_b13c_maxplan_per             $1
	pbp_b13c_maxenr_yn               $1
	pbp_b13c_maxenr_per              $1
	pbp_b13c_coins_yn                $1
	pbp_b13c_ded_yn                  $1
	pbp_b13c_copay_yn                $1
	pbp_b13c_auth                    $5
	pbp_b13c_refer_yn                $1
	pbp_b13d_bendesc_service         $55
	pbp_b13d_bendesc_amo             $1
	pbp_b13d_maxplan_yn              $1
	pbp_b13d_maxplan_per             $1
	pbp_b13d_maxenr_yn               $1
	pbp_b13d_maxenr_per              $1
	pbp_b13d_coins_yn                $1
	pbp_b13d_ded_yn                  $1
	pbp_b13d_copay_yn                $1
	pbp_b13d_auth                    $5
	pbp_b13d_refer_yn                $1
	pbp_b13e_bendesc_service         $55
	pbp_b13e_bendesc_amo             $1
	pbp_b13e_maxplan_yn              $1
	pbp_b13e_maxplan_per             $1
	pbp_b13e_maxenr_yn               $1
	pbp_b13e_maxenr_per              $1
	pbp_b13e_coins_yn                $1
	pbp_b13e_ded_yn                  $1
	pbp_b13e_copay_yn                $1
	pbp_b13e_auth                    $5
	pbp_b13e_refer_yn                $1
	pbp_b13f_bendesc_service         $55
	pbp_b13f_bendesc_amo             $1
	pbp_b13f_maxplan_yn              $1
	pbp_b13f_maxplan_per             $1
	pbp_b13f_maxenr_yn               $1
	pbp_b13f_maxenr_per              $1
	pbp_b13f_coins_yn                $1
	pbp_b13f_ded_yn                  $1
	pbp_b13f_copay_yn                $1
	pbp_b13f_auth                    $5
	pbp_b13f_refer_yn                $1
	pbp_b13g_attestation             $1
	pbp_b13g_bendesc_service         $55
	pbp_b13g_bendesc_amo             $1
	pbp_b13g_maxplan_yn              $1
	pbp_b13g_maxplan_per             $1
	pbp_b13g_maxenr_yn               $1
	pbp_b13g_maxenr_per              $1
	pbp_b13g_coins_yn                $1
	pbp_b13g_ded_yn                  $1
	pbp_b13g_copay_yn                $1
	pbp_b13g_auth                    $5
	pbp_b13g_refer_yn                $1
	pbp_b13h_addl_services           $17
	pbp_b13h_add_srvcs_yn            $1
	pbp_b13h_addl_service_other1     $55
	pbp_b13h_addl_service_other2     $55
	pbp_b13h_addl_service_other3     $55
	pbp_b13h_add_srvcs_coins_yn      $1
	pbp_b13h_add_srvcs_coins_items   $17
	pbp_b13h_add_srvcs_copay_yn      $1
	pbp_b13h_add_srvcs_copay_items   $17
;

infile '.\pbp\pbp_b13_other_services.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b13a_bendesc_yn
	pbp_b13a_bendesc_enhan
	pbp_b13a_bendesc_amo
	pbp_b13a_bendesc_lim
	pbp_b13a_bendesc_numv
	pbp_b13a_bendesc_per
	pbp_b13a_maxplan_yn
	pbp_b13a_maxplan_amt
	pbp_b13a_maxplan_per
	pbp_b13a_maxenr_yn
	pbp_b13a_maxenr_amt
	pbp_b13a_maxenr_per
	pbp_b13a_coins_yn
	pbp_b13a_coins_pct
	pbp_b13a_ded_yn
	pbp_b13a_ded_amt
	pbp_b13a_copay_yn
	pbp_b13a_copay_amt
	pbp_b13a_auth
	pbp_b13a_refer_yn
	pbp_b13b_bendesc_otc
	pbp_b13b_bendesc_amo
	pbp_b13b_maxplan_yn
	pbp_b13b_maxplan_amt
	pbp_b13b_otc_maxplan_per
	pbp_b13b_maxenr_yn
	pbp_b13b_maxenr_amt
	pbp_b13b_maxenr_per
	pbp_b13b_coins_yn
	pbp_b13b_coins_pct
	pbp_b13b_ded_yn
	pbp_b13b_ded_amt
	pbp_b13b_copay_yn
	pbp_b13b_copay_amt
	pbp_b13b_cms_otc_list_yn
	pbp_b13c_bendesc_service
	pbp_b13c_bendesc_amo
	pbp_b13c_maxplan_yn
	pbp_b13c_maxplan_amt
	pbp_b13c_maxplan_per
	pbp_b13c_maxenr_yn
	pbp_b13c_maxenr_amt
	pbp_b13c_maxenr_per
	pbp_b13c_coins_yn
	pbp_b13c_coins_pct
	pbp_b13c_ded_yn
	pbp_b13c_ded_amt
	pbp_b13c_copay_yn
	pbp_b13c_copay_amt
	pbp_b13c_auth
	pbp_b13c_refer_yn
	pbp_b13d_bendesc_service
	pbp_b13d_bendesc_amo
	pbp_b13d_maxplan_yn
	pbp_b13d_maxplan_amt
	pbp_b13d_maxplan_per
	pbp_b13d_maxenr_yn
	pbp_b13d_maxenr_amt
	pbp_b13d_maxenr_per
	pbp_b13d_coins_yn
	pbp_b13d_coins_pct
	pbp_b13d_ded_yn
	pbp_b13d_ded_amt
	pbp_b13d_copay_yn
	pbp_b13d_copay_amt
	pbp_b13d_auth
	pbp_b13d_refer_yn
	pbp_b13e_bendesc_service
	pbp_b13e_bendesc_amo
	pbp_b13e_maxplan_yn
	pbp_b13e_maxplan_amt
	pbp_b13e_maxplan_per
	pbp_b13e_maxenr_yn
	pbp_b13e_maxenr_amt
	pbp_b13e_maxenr_per
	pbp_b13e_coins_yn
	pbp_b13e_coins_pct
	pbp_b13e_ded_yn
	pbp_b13e_ded_amt
	pbp_b13e_copay_yn
	pbp_b13e_copay_amt
	pbp_b13e_auth
	pbp_b13e_refer_yn
	pbp_b13f_bendesc_service
	pbp_b13f_bendesc_amo
	pbp_b13f_maxplan_yn
	pbp_b13f_maxplan_amt
	pbp_b13f_maxplan_per
	pbp_b13f_maxenr_yn
	pbp_b13f_maxenr_amt
	pbp_b13f_maxenr_per
	pbp_b13f_coins_yn
	pbp_b13f_coins_pct
	pbp_b13f_ded_yn
	pbp_b13f_ded_amt
	pbp_b13f_copay_yn
	pbp_b13f_copay_amt
	pbp_b13f_auth
	pbp_b13f_refer_yn
	pbp_b13g_attestation
	pbp_b13g_bendesc_service
	pbp_b13g_bendesc_amo
	pbp_b13g_maxplan_yn
	pbp_b13g_maxplan_amt
	pbp_b13g_maxplan_per
	pbp_b13g_maxenr_yn
	pbp_b13g_maxenr_amt
	pbp_b13g_maxenr_per
	pbp_b13g_coins_yn
	pbp_b13g_coins_pct
	pbp_b13g_coins_max_pct
	pbp_b13g_ded_yn
	pbp_b13g_ded_amt
	pbp_b13g_copay_yn
	pbp_b13g_copay_amt
	pbp_b13g_copay_max_amt
	pbp_b13g_auth
	pbp_b13g_refer_yn
	pbp_b13h_addl_services
	pbp_b13h_add_srvcs_yn
	pbp_b13h_addl_service_other1
	pbp_b13h_addl_service_other2
	pbp_b13h_addl_service_other3
	pbp_b13h_add_srvcs_coins_yn
	pbp_b13h_add_srvcs_coins_items
	pbp_b13h_coins_epsdt_min
	pbp_b13h_coins_epsdt_max
	pbp_b13h_coins_tccpw_min
	pbp_b13h_coins_tccpw_max
	pbp_b13h_coins_fbcs_min
	pbp_b13h_coins_fbcs_max
	pbp_b13h_coins_rcs_min
	pbp_b13h_coins_rcs_max
	pbp_b13h_coins_fps_min
	pbp_b13h_coins_fps_max
	pbp_b13h_coins_nhs_min
	pbp_b13h_coins_nhs_max
	pbp_b13h_coins_hcbs_min
	pbp_b13h_coins_hcbs_max
	pbp_b13h_coins_pcs_min
	pbp_b13h_coins_pcs_max
	pbp_b13h_coins_sdpas_min
	pbp_b13h_coins_sdpas_max
	pbp_b13h_coins_pdns_min
	pbp_b13h_coins_pdns_max
	pbp_b13h_coins_cm_ltc_min
	pbp_b13h_coins_cm_ltc_max
	pbp_b13h_coins_imds_min
	pbp_b13h_coins_imds_max
	pbp_b13h_coins_icfmrs_min
	pbp_b13h_coins_icfmrs_max
	pbp_b13h_coins_cm_min
	pbp_b13h_coins_cm_max
	pbp_b13h_coins_other1_min
	pbp_b13h_coins_other1_max
	pbp_b13h_coins_other2_min
	pbp_b13h_coins_other2_max
	pbp_b13h_coins_other3_min
	pbp_b13h_coins_other3_max
	pbp_b13h_add_srvcs_copay_yn
	pbp_b13h_add_srvcs_copay_items
	pbp_b13h_copay_epsdt_min
	pbp_b13h_copay_epsdt_max
	pbp_b13h_copay_tccpw_min
	pbp_b13h_copay_tccpw_max
	pbp_b13h_copay_fbcs_min
	pbp_b13h_copay_fbcs_max
	pbp_b13h_copay_rcs_min
	pbp_b13h_copay_rcs_max
	pbp_b13h_copay_fps_min
	pbp_b13h_copay_fps_max
	pbp_b13h_copay_nhs_min
	pbp_b13h_copay_nhs_max
	pbp_b13h_copay_hcbs_min
	pbp_b13h_copay_hcbs_max
	pbp_b13h_copay_pcs_min
	pbp_b13h_copay_pcs_max
	pbp_b13h_copay_sdpas_min
	pbp_b13h_copay_sdpas_max
	pbp_b13h_copay_pdns_min
	pbp_b13h_copay_pdns_max
	pbp_b13h_copay_cm_ltc_min
	pbp_b13h_copay_cm_ltc_max
	pbp_b13h_copay_imds_min
	pbp_b13h_copay_imds_max
	pbp_b13h_copay_icfmrs_min
	pbp_b13h_copay_icfmrs_max
	pbp_b13h_copay_cm_min
	pbp_b13h_copay_cm_max
	pbp_b13h_copay_other1_min
	pbp_b13h_copay_other1_max
	pbp_b13h_copay_other2_min
	pbp_b13h_copay_other2_max
	pbp_b13h_copay_other3_min
	pbp_b13h_copay_other3_max
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b13a_bendesc_yn              = 'Acupuncture Ben Desc YN'
	pbp_b13a_bendesc_enhan           = 'Acupuncture Ben Desc Enhance'
	pbp_b13a_bendesc_amo             = 'Acupuncture Ben Desc MO'
	pbp_b13a_bendesc_lim             = 'Acupuncture Ben Desc Lim YN'
	pbp_b13a_bendesc_numv            = 'Acupuncture Ben Desc Num'
	pbp_b13a_bendesc_per             = 'Acupuncture Ben Desc Per'
	pbp_b13a_maxplan_yn              = 'Acupuncture Max Plan YN'
	pbp_b13a_maxplan_amt             = 'Acupuncture Max Plan Amt'
	pbp_b13a_maxplan_per             = 'Acupuncture Max Plan Per'
	pbp_b13a_maxenr_yn               = 'Acupuncture Max Enr YN'
	pbp_b13a_maxenr_amt              = 'Acupuncture Max Enr Amt'
	pbp_b13a_maxenr_per              = 'Acupuncture Max Enr Per'
	pbp_b13a_coins_yn                = 'Acupuncture Coinsurance YN'
	pbp_b13a_coins_pct               = 'Acupuncture Coins Pct'
	pbp_b13a_ded_yn                  = 'Acupuncture Deductible YN'
	pbp_b13a_ded_amt                 = 'Acupuncture Deductible Amt'
	pbp_b13a_copay_yn                = 'Acupuncture Copayment YN'
	pbp_b13a_copay_amt               = 'Acupuncture Copay Amt'
	pbp_b13a_auth                    = 'Acupuncture Enrollee Auth'
	pbp_b13a_refer_yn                = 'Acupuncture Referral YN'
	pbp_b13b_bendesc_otc             = 'OTC Drugs'
	pbp_b13b_bendesc_amo             = 'OTC Ben Desc MO'
	pbp_b13b_maxplan_yn              = 'OTC Max Plan YN'
	pbp_b13b_maxplan_amt             = 'OTC Max Plan Amt'
	pbp_b13b_otc_maxplan_per         = 'OTC Max Period'
	pbp_b13b_maxenr_yn               = 'OTC Max Enr YN'
	pbp_b13b_maxenr_amt              = 'OTC Max Enr Amt'
	pbp_b13b_maxenr_per              = 'OTC Max Enr Per'
	pbp_b13b_coins_yn                = 'OTC Coinsurance YN'
	pbp_b13b_coins_pct               = 'OTC Coins Pct'
	pbp_b13b_ded_yn                  = 'OTC Deductible YN'
	pbp_b13b_ded_amt                 = 'OTC Deductible Amt'
	pbp_b13b_copay_yn                = 'OTC Copayment YN'
	pbp_b13b_copay_amt               = 'OTC Copay Amt'
	pbp_b13b_cms_otc_list_yn         = 'CMS OTC List'
	pbp_b13c_bendesc_service         = 'Meal Benefit'
	pbp_b13c_bendesc_amo             = 'Meal Benefit Ben Desc MO'
	pbp_b13c_maxplan_yn              = 'Meal Benefit Max Plan YN'
	pbp_b13c_maxplan_amt             = 'Meal Benefit Max Plan Amt'
	pbp_b13c_maxplan_per             = 'Meal Benefit Max Plan Per'
	pbp_b13c_maxenr_yn               = 'Meal Benefit Max Enr YN'
	pbp_b13c_maxenr_amt              = 'Meal Benefit Max Enr Amt'
	pbp_b13c_maxenr_per              = 'Meal Benefit Max Enr Per'
	pbp_b13c_coins_yn                = 'Meal Benefit YN'
	pbp_b13c_coins_pct               = 'Meal Benefit Coins Pct'
	pbp_b13c_ded_yn                  = 'Meal Benefit Deductible YN'
	pbp_b13c_ded_amt                 = 'Meal Benefit Deductible Amt'
	pbp_b13c_copay_yn                = 'Meal Benefit Copayment YN'
	pbp_b13c_copay_amt               = 'Meal Benefit Copay Amt'
	pbp_b13c_auth                    = 'Meal Benefit Enrollee Auth'
	pbp_b13c_refer_yn                = 'Meal Benefit Referral YN'
	pbp_b13d_bendesc_service         = 'Other 1 Name of Service'
	pbp_b13d_bendesc_amo             = 'Other 1 Ben Desc MO'
	pbp_b13d_maxplan_yn              = 'Other 1 Max Plan YN'
	pbp_b13d_maxplan_amt             = 'Other 1 Max Plan Amt'
	pbp_b13d_maxplan_per             = 'Other 1 Max Plan Per'
	pbp_b13d_maxenr_yn               = 'Other 1 Max Enr YN'
	pbp_b13d_maxenr_amt              = 'Other 1 Max Enr Amt'
	pbp_b13d_maxenr_per              = 'Other 1 Max Enr Per'
	pbp_b13d_coins_yn                = 'Other 1 Coinsurance YN'
	pbp_b13d_coins_pct               = 'Other 1 Coins Pct'
	pbp_b13d_ded_yn                  = 'Other 1 Deductible YN'
	pbp_b13d_ded_amt                 = 'Other 1 Deductible Amt'
	pbp_b13d_copay_yn                = 'Other 1 Copayment YN'
	pbp_b13d_copay_amt               = 'Other 1 Copay Amt'
	pbp_b13d_auth                    = 'Other 1 Enrollee Auth'
	pbp_b13d_refer_yn                = 'Other 1 Referral YN'
	pbp_b13e_bendesc_service         = 'Other 2 Name of Service'
	pbp_b13e_bendesc_amo             = 'Other 2 Ben Desc MO'
	pbp_b13e_maxplan_yn              = 'Other 2 Max Plan YN'
	pbp_b13e_maxplan_amt             = 'Other 2 Max Plan Amt'
	pbp_b13e_maxplan_per             = 'Other 2 Max Plan Per'
	pbp_b13e_maxenr_yn               = 'Other 2 Max Enr YN'
	pbp_b13e_maxenr_amt              = 'Other 2 Max Enr Amt'
	pbp_b13e_maxenr_per              = 'Other 2 Max Enr Per'
	pbp_b13e_coins_yn                = 'Other 2 Coinsurance YN'
	pbp_b13e_coins_pct               = 'Other 2 Coins Pct'
	pbp_b13e_ded_yn                  = 'Other 2 Deductible YN'
	pbp_b13e_ded_amt                 = 'Other 2 Deductible Amt'
	pbp_b13e_copay_yn                = 'Other 2 Copayment YN'
	pbp_b13e_copay_amt               = 'Other 2 Copay Amt'
	pbp_b13e_auth                    = 'Other 2 Enrollee Auth'
	pbp_b13e_refer_yn                = 'Other 2 Referral YN'
	pbp_b13f_bendesc_service         = 'Other 3 Name of Service'
	pbp_b13f_bendesc_amo             = 'Other 3 Ben Desc MO'
	pbp_b13f_maxplan_yn              = 'Other 3 Max Plan YN'
	pbp_b13f_maxplan_amt             = 'Other 3 Max Plan Amt'
	pbp_b13f_maxplan_per             = 'Other 3 Max Plan Per'
	pbp_b13f_maxenr_yn               = 'Other 3 Max Enr YN'
	pbp_b13f_maxenr_amt              = 'Other 3 Max Enr Amt'
	pbp_b13f_maxenr_per              = 'Other 3 Max Enr Per'
	pbp_b13f_coins_yn                = 'Other 3 Coinsurance YN'
	pbp_b13f_coins_pct               = 'Other 3 Coins Pct'
	pbp_b13f_ded_yn                  = 'Other 3 Deductible YN'
	pbp_b13f_ded_amt                 = 'Other 3 Deductible Amt'
	pbp_b13f_copay_yn                = 'Other 3 Copayment YN'
	pbp_b13f_copay_amt               = 'Other 3 Copay Amt'
	pbp_b13f_auth                    = 'Other 3 Enrollee Auth'
	pbp_b13f_refer_yn                = 'Other 3 Referral YN'
	pbp_b13g_attestation             = 'High Integrat SNP  Attestation'
	pbp_b13g_bendesc_service         = 'Other 4 Name of Service'
	pbp_b13g_bendesc_amo             = 'Other 4 Ben Desc MO'
	pbp_b13g_maxplan_yn              = 'Other 4 Max Plan YN'
	pbp_b13g_maxplan_amt             = 'Other 4 Max Plan Amt'
	pbp_b13g_maxplan_per             = 'Other 4 Max Plan Per'
	pbp_b13g_maxenr_yn               = 'Other 4 Max Enr YN'
	pbp_b13g_maxenr_amt              = 'Other 4 Max Enr Amt'
	pbp_b13g_maxenr_per              = 'Other 4 Max Enr Per'
	pbp_b13g_coins_yn                = 'Other 4 Coinsurance YN'
	pbp_b13g_coins_pct               = 'High Quality SNP Min Coins Pct'
	pbp_b13g_coins_max_pct           = 'High Quali SNP Max Coins Pct'
	pbp_b13g_ded_yn                  = 'Other 4 Deductible YN'
	pbp_b13g_ded_amt                 = 'Other 4 Deductible Amt'
	pbp_b13g_copay_yn                = 'Other 4 Copayment YN'
	pbp_b13g_copay_amt               = 'Other 4 Min Copay Amt'
	pbp_b13g_copay_max_amt           = 'High Quality SNP Max Copy Amt'
	pbp_b13g_auth                    = 'Other 4 Enrollee Auth'
	pbp_b13g_refer_yn                = 'Other 4 Referral YN'
	pbp_b13h_addl_services           = 'Select Addl Srvcs'
	pbp_b13h_add_srvcs_yn            = 'Plan provide Addl Srvcs YN?'
	pbp_b13h_addl_service_other1     = 'Other 1 Service Name'
	pbp_b13h_addl_service_other2     = 'Other 2 Service Name'
	pbp_b13h_addl_service_other3     = 'Other 3 Service Name'
	pbp_b13h_add_srvcs_coins_yn      = 'Is there a Coins YN'
	pbp_b13h_add_srvcs_coins_items   = 'Select Add Srvs Coins'
	pbp_b13h_coins_epsdt_min         = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_epsdt_max         = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_tccpw_min         = 'Indicate minimum Coinsurance'
	pbp_b13h_coins_tccpw_max         = 'Indicate maximum Coinsurance'
	pbp_b13h_coins_fbcs_min          = 'Indicate minimum Coinsurance'
	pbp_b13h_coins_fbcs_max          = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_rcs_min           = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_rcs_max           = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_fps_min           = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_fps_max           = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_nhs_min           = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_nhs_max           = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_hcbs_min          = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_hcbs_max          = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_pcs_min           = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_pcs_max           = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_sdpas_min         = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_sdpas_max         = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_pdns_min          = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_pdns_max          = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_cm_ltc_min        = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_cm_ltc_max        = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_imds_min          = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_imds_max          = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_icfmrs_min        = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_icfmrs_max        = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_cm_min            = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_cm_max            = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_other1_min        = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_other1_max        = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_other2_min        = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_other2_max        = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_other3_min        = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_other3_max        = 'Indicate maximum Coinsurance:'
	pbp_b13h_add_srvcs_copay_yn      = 'Is there a Copayment?'
	pbp_b13h_add_srvcs_copay_items   = 'Select Add Srvs Copay'
	pbp_b13h_copay_epsdt_min         = 'Indicate minimum Copayment:'
	pbp_b13h_copay_epsdt_max         = 'Indicate maximum Copayment:'
	pbp_b13h_copay_tccpw_min         = 'Indicate minimum Copayment:'
	pbp_b13h_copay_tccpw_max         = 'Indicate maximum Copayment:'
	pbp_b13h_copay_fbcs_min          = 'Indicate minimum Copayment:'
	pbp_b13h_copay_fbcs_max          = 'Indicate maximum Copayment:'
	pbp_b13h_copay_rcs_min           = 'Indicate minimum Copayment:'
	pbp_b13h_copay_rcs_max           = 'Indicate maximum Copayment:'
	pbp_b13h_copay_fps_min           = 'Indicate minimum Copayment:'
	pbp_b13h_copay_fps_max           = 'Indicate maximum Copayment:'
	pbp_b13h_copay_nhs_min           = 'Indicate minimum Copayment:'
	pbp_b13h_copay_nhs_max           = 'Indicate maximum Copayment:'
	pbp_b13h_copay_hcbs_min          = 'Indicate minimum Copayment:'
	pbp_b13h_copay_hcbs_max          = 'Indicate maximum Copayment:'
	pbp_b13h_copay_pcs_min           = 'Indicate minimum Copayment:'
	pbp_b13h_copay_pcs_max           = 'Indicate maximum Copayment:'
	pbp_b13h_copay_sdpas_min         = 'Indicate minimum Copayment:'
	pbp_b13h_copay_sdpas_max         = 'Indicate maximum Copayment:'
	pbp_b13h_copay_pdns_min          = 'Indicate minimum Copayment:'
	pbp_b13h_copay_pdns_max          = 'Indicate maximum Copayment:'
	pbp_b13h_copay_cm_ltc_min        = 'Indicate minimum Copayment:'
	pbp_b13h_copay_cm_ltc_max        = 'Indicate maximum Copayment:'
	pbp_b13h_copay_imds_min          = 'Indicate minimum Copayment:'
	pbp_b13h_copay_imds_max          = 'Indicate maximum Copayment:'
	pbp_b13h_copay_icfmrs_min        = 'Indicate minimum Copayment:'
	pbp_b13h_copay_icfmrs_max        = 'Indicate maximum Copayment:'
	pbp_b13h_copay_cm_min            = 'Indicate minimum Copayment:'
	pbp_b13h_copay_cm_max            = 'Indicate maximum Copayment:'
	pbp_b13h_copay_other1_min        = 'Indicate minimum Copayment:'
	pbp_b13h_copay_other1_max        = 'Indicate maximum Copayment:'
	pbp_b13h_copay_other2_min        = 'Indicate minimum Copayment:'
	pbp_b13h_copay_other2_max        = 'Indicate maximum Copayment:'
	pbp_b13h_copay_other3_min        = 'Indicate minimum Copayment:'
	pbp_b13h_copay_other3_max        = 'Indicate maximum Copayment:'
;

run;

proc sort data = pbp_b13 out=out.pbp_b13;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b13(obs = 10);
  title 'pbp_b13_other_services file ';
run;

proc means data = out.pbp_b13;
  title 'pbp_b13_other_services file ';
run;

proc freq data = out.pbp_b13;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b13a_bendesc_yn
	pbp_b13a_bendesc_enhan
	pbp_b13a_bendesc_amo
	pbp_b13a_bendesc_lim
	pbp_b13a_bendesc_per
	pbp_b13a_maxplan_yn
	pbp_b13a_maxplan_per
	pbp_b13a_maxenr_yn
	pbp_b13a_maxenr_per
	pbp_b13a_coins_yn
	pbp_b13a_ded_yn
	pbp_b13a_copay_yn
	pbp_b13a_auth
	pbp_b13a_refer_yn
	pbp_b13b_bendesc_otc
	pbp_b13b_bendesc_amo
	pbp_b13b_maxplan_yn
	pbp_b13b_otc_maxplan_per
	pbp_b13b_maxenr_yn
	pbp_b13b_maxenr_per
	pbp_b13b_coins_yn
	pbp_b13b_ded_yn
	pbp_b13b_copay_yn
	pbp_b13b_cms_otc_list_yn
	pbp_b13c_bendesc_service
	pbp_b13c_bendesc_amo
	pbp_b13c_maxplan_yn
	pbp_b13c_maxplan_per
	pbp_b13c_maxenr_yn
	pbp_b13c_maxenr_per
	pbp_b13c_coins_yn
	pbp_b13c_ded_yn
	pbp_b13c_copay_yn
	pbp_b13c_auth
	pbp_b13c_refer_yn
	pbp_b13d_bendesc_amo
	pbp_b13d_maxplan_yn
	pbp_b13d_maxplan_per
	pbp_b13d_maxenr_yn
	pbp_b13d_maxenr_per
	pbp_b13d_coins_yn
	pbp_b13d_ded_yn
	pbp_b13d_copay_yn
	pbp_b13d_auth
	pbp_b13d_refer_yn
	pbp_b13e_bendesc_amo
	pbp_b13e_maxplan_yn
	pbp_b13e_maxplan_per
	pbp_b13e_maxenr_yn
	pbp_b13e_maxenr_per
	pbp_b13e_coins_yn
	pbp_b13e_ded_yn
	pbp_b13e_copay_yn
	pbp_b13e_auth
	pbp_b13e_refer_yn
	pbp_b13f_bendesc_amo
	pbp_b13f_maxplan_yn
	pbp_b13f_maxplan_per
	pbp_b13f_maxenr_yn
	pbp_b13f_maxenr_per
	pbp_b13f_coins_yn
	pbp_b13f_ded_yn
	pbp_b13f_copay_yn
	pbp_b13f_auth
	pbp_b13f_refer_yn
	pbp_b13g_attestation
	pbp_b13g_bendesc_amo
	pbp_b13g_maxplan_yn
	pbp_b13g_maxplan_per
	pbp_b13g_maxenr_yn
	pbp_b13g_maxenr_per
	pbp_b13g_coins_yn
	pbp_b13g_ded_yn
	pbp_b13g_copay_yn
	pbp_b13g_auth
	pbp_b13g_refer_yn
	pbp_b13h_add_srvcs_yn
	pbp_b13h_add_srvcs_coins_yn
	pbp_b13h_add_srvcs_copay_yn
/ missing;
run;

proc contents data = out.pbp_b13;
  title 'pbp_b13 data';
run;
