*pbp_b2.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b2;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b2_bendesc_yn                $1
	pbp_b2_bendesc_ad_nmcs           $2
	pbp_b2_bendesc_amo_ad            $1
	pbp_b2_benedesc_lim_ad           $1
	pbp_b2_bendesc_amo_nmcs          $1
	pbp_b2_bendesc_pr_hosp_yn        $1
	pbp_b2_bendesc_pr_hosp_num       $1
	pbp_b2_maxenr_yn                 $1
	pbp_b2_maxenr_per                $1
	pbp_b2_coins_yn                  $1
	pbp_b2_mdcr_coins_cstshrs_yn     $1
	pbp_b2_coins_mcs_intrvl_num      $1
	pbp_b2_coins_ad_intrvl_num       $1
	pbp_b2_coins_nmcs_struc_yn       $1
	pbp_b2_coins_nmcs_intrvl_num     $1
	pbp_b2_ded_yn                    $1
	pbp_b2_copay_yn                  $1
	pbp_b2_mdcr_copay_cstshrs_yn     $1
	pbp_b2_copay_mcs_intrvl_num      $1
	pbp_b2_copay_ad_intrvl_num       $1
	pbp_b2_copay_nmcs_struc_yn       $1
	pbp_b2_copay_nmcs_intrvl_num     $1
	pbp_b2_auth                      $5
	pbp_b2_refer_yn                  $1
	pbp_b2_bendesc_yn_bonly          $1
	pbp_b2_bendesc_amo_bonly         $1
	pbp_b2_bendesc_snf_unlm_bonly    $1
	pbp_b2_bendesc_snf_per_bonly     $1
	pbp_b2_bendesc_hostay_bonly_yn   $1
	pbp_b2_maxplan_yn_bonly          $1
	pbp_b2_maxplan_per_bonly         $1
	pbp_b2_maxenr_yn_bonly           $1
	pbp_b2_maxenr_per_bonly          $1
	pbp_b2_coins_yn_bonly            $1
	pbp_b2_coins_ps_num_bonly        $1
	pbp_b2_ded_yn_bonly              $1
	pbp_b2_copay_yn_bonly            $1
	pbp_b2_copay_ps_num_bonly        $1
	pbp_b2_auth_bonly                $5
	pbp_b2_refer_yn_bonly            $1
;

infile '.\pbp\pbp_b2_snf.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b2_bendesc_yn
	pbp_b2_bendesc_ad_nmcs
	pbp_b2_bendesc_amo_ad
	pbp_b2_benedesc_lim_ad
	pbp_b2_bendesc_ad
	pbp_b2_bendesc_amo_nmcs
	pbp_b2_bendesc_pr_hosp_yn
	pbp_b2_bendesc_pr_hosp_num
	pbp_b2_maxenr_yn
	pbp_b2_maxenr_amt
	pbp_b2_maxenr_per
	pbp_b2_coins_yn
	pbp_b2_mdcr_coins_cstshrs_yn
	pbp_b2_coins_mcs_pct
	pbp_b2_coins_mcs_intrvl_num
	pbp_b2_coins_mcs_pct_intrvl1
	pbp_b2_coins_mcs_bgnd_intrvl1
	pbp_b2_coins_mcs_endd_intrvl1
	pbp_b2_coins_mcs_pct_intrvl2
	pbp_b2_coins_mcs_bgnd_intrvl2
	pbp_b2_coins_mcs_endd_intrvl2
	pbp_b2_coins_mcs_pct_intrvl3
	pbp_b2_coins_mcs_bgnd_intrvl3
	pbp_b2_coins_mcs_endd_intrvl3
	pbp_b2_coins_ad_intrvl_num
	pbp_b2_coins_ad_pct_intrvl1
	pbp_b2_coins_ad_bgnd_intrvl1
	pbp_b2_coins_ad_endd_intrvl1
	pbp_b2_coins_ad_pct_intrvl2
	pbp_b2_coins_ad_bgnd_intrvl2
	pbp_b2_coins_ad_endd_intrvl2
	pbp_b2_coins_ad_pct_intrvl3
	pbp_b2_coins_ad_bgnd_intrvl3
	pbp_b2_coins_ad_endd_intrvl3
	pbp_b2_coins_nmcs_struc_yn
	pbp_b2_coins_nmcs_pct
	pbp_b2_coins_nmcs_intrvl_num
	pbp_b2_coins_nmcs_pct_intrvl1
	pbp_b2_coins_nmcs_bgnd_intrvl1
	pbp_b2_coins_nmcs_endd_intrvl1
	pbp_b2_coins_nmcs_pct_intrvl2
	pbp_b2_coins_nmcs_bgnd_intrvl2
	pbp_b2_coins_nmcs_endd_intrvl2
	pbp_b2_coins_nmcs_pct_intrvl3
	pbp_b2_coins_nmcs_bgnd_intrvl3
	pbp_b2_coins_nmcs_endd_intrvl3
	pbp_b2_ded_yn
	pbp_b2_ded_amt
	pbp_b2_copay_yn
	pbp_b2_mdcr_copay_cstshrs_yn
	pbp_b2_copay_mcs_amt
	pbp_b2_copay_mcs_intrvl_num
	pbp_b2_copay_mcs_amt_intrvl1
	pbp_b2_copay_mcs_bgnd_intrvl1
	pbp_b2_copay_mcs_endd_intrvl1
	pbp_b2_copay_mcs_amt_intrvl2
	pbp_b2_copay_mcs_bgnd_intrvl2
	pbp_b2_copay_mcs_endd_intrvl2
	pbp_b2_copay_mcs_amt_intrvl3
	pbp_b2_copay_mcs_bgnd_intrvl3
	pbp_b2_copay_mcs_endd_intrvl3
	pbp_b2_copay_ad_intrvl_num
	pbp_b2_copay_ad_amt_intrvl1
	pbp_b2_copay_ad_bgnd_intrvl1
	pbp_b2_copay_ad_endd_intrvl1
	pbp_b2_copay_ad_amt_intrvl2
	pbp_b2_copay_ad_bgnd_intrvl2
	pbp_b2_copay_ad_endd_intrvl2
	pbp_b2_copay_ad_amt_intrvl3
	pbp_b2_copay_ad_bgnd_intrvl3
	pbp_b2_copay_ad_endd_intrvl3
	pbp_b2_copay_nmcs_struc_yn
	pbp_b2_copay_nmcs_amt
	pbp_b2_copay_nmcs_intrvl_num
	pbp_b2_copay_nmcs_amt_intrvl1
	pbp_b2_copay_nmcs_bgnd_intrvl1
	pbp_b2_copay_nmcs_endd_intrvl1
	pbp_b2_copay_nmcs_amt_intrvl2
	pbp_b2_copay_nmcs_bgnd_intrvl2
	pbp_b2_copay_nmcs_endd_intrvl2
	pbp_b2_copay_nmcs_amt_intrvl3
	pbp_b2_copay_nmcs_bgnd_intrvl3
	pbp_b2_copay_nmcs_endd_intrvl3
	pbp_b2_auth
	pbp_b2_refer_yn
	pbp_b2_bendesc_yn_bonly
	pbp_b2_bendesc_amo_bonly
	pbp_b2_bendesc_snf_unlm_bonly
	pbp_b2_bende_al_ad_prior_bonly
	pbp_b2_bendesc_snf_per_bonly
	pbp_b2_bendesc_hostay_bonly_yn
	pbp_b2_bende_nmday_prior_bonly
	pbp_b2_maxplan_yn_bonly
	pbp_b2_maxplan_amt_bonly
	pbp_b2_maxplan_per_bonly
	pbp_b2_maxenr_yn_bonly
	pbp_b2_maxenr_amt_bonly
	pbp_b2_maxenr_per_bonly
	pbp_b2_coins_yn_bonly
	pbp_b2_coins_pct_bonly
	pbp_b2_coins_ps_num_bonly
	pbp_b2_coins_ps_pct1_bonly
	pbp_b2_coins_ps_bgnd1_bonly
	pbp_b2_coins_ps_endd1_bonly
	pbp_b2_coins_ps_pct2_bonly
	pbp_b2_coins_ps_bgnd2_bonly
	pbp_b2_coins_ps_endd2_bonly
	pbp_b2_coins_ps_pct3_bonly
	pbp_b2_coins_ps_bgnd3_bonly
	pbp_b2_coins_ps_endd3_bonly
	pbp_b2_ded_yn_bonly
	pbp_b2_ded_amt_bonly
	pbp_b2_copay_yn_bonly
	pbp_b2_copay_ps_amt_bonly
	pbp_b2_copay_ps_num_bonly
	pbp_b2_copay_ps_amt1_bonly
	pbp_b2_copay_ps_bgnd1_bonly
	pbp_b2_copay_ps_endd1_bonly
	pbp_b2_copay_ps_amt2_bonly
	pbp_b2_copay_ps_bgnd2_bonly
	pbp_b2_copay_ps_endd2_bonly
	pbp_b2_copay_ps_amt3_bonly
	pbp_b2_copay_ps_bgnd3_bonly
	pbp_b2_copay_ps_endd3_bonly
	pbp_b2_auth_bonly
	pbp_b2_refer_yn_bonly
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b2_bendesc_yn                = 'SNF Ben Desc MO YN'
	pbp_b2_bendesc_ad_nmcs           = 'SNF Ben Desc Enhance'
	pbp_b2_bendesc_amo_ad            = 'SNF Ben Desc MO AD'
	pbp_b2_benedesc_lim_ad           = 'SNF Ben Desc AD LIM YN'
	pbp_b2_bendesc_ad                = 'SNF Ben Desc AD Num'
	pbp_b2_bendesc_amo_nmcs          = 'SNF Ben Desc MO NMCS'
	pbp_b2_bendesc_pr_hosp_yn        = 'SNF Ben Desc <3 Day Prior YN'
	pbp_b2_bendesc_pr_hosp_num       = 'SNF Ben Desc Num of Days 0-2'
	pbp_b2_maxenr_yn                 = 'SNF Max Enr YN'
	pbp_b2_maxenr_amt                = 'SNF Max Enr Amt'
	pbp_b2_maxenr_per                = 'SNF Max Enr Per'
	pbp_b2_coins_yn                  = 'SNF Coinsurance YN'
	pbp_b2_mdcr_coins_cstshrs_yn     = 'SNF Med Def Coins Cost Shrs YN'
	pbp_b2_coins_mcs_pct             = 'SNF Coins MCS Pct'
	pbp_b2_coins_mcs_intrvl_num      = 'SNF MCS Coins Interval Num'
	pbp_b2_coins_mcs_pct_intrvl1     = 'SNF MCS Coins Pct Interval 1'
	pbp_b2_coins_mcs_bgnd_intrvl1    = 'SNF MCS Coins Bgn Day Intrvl 1'
	pbp_b2_coins_mcs_endd_intrvl1    = 'SNF MCS Coins End Day Intrvl 1'
	pbp_b2_coins_mcs_pct_intrvl2     = 'SNF MCS Coins Pct Interval 2'
	pbp_b2_coins_mcs_bgnd_intrvl2    = 'SNF MCS Coins Bgn Day Intrvl 2'
	pbp_b2_coins_mcs_endd_intrvl2    = 'SNF MCS Coins End Day Intrvl 2'
	pbp_b2_coins_mcs_pct_intrvl3     = 'SNF MCS Coins Pct Interval 3'
	pbp_b2_coins_mcs_bgnd_intrvl3    = 'SNF MCS Coins Bgn Day Intrvl 3'
	pbp_b2_coins_mcs_endd_intrvl3    = 'SNF MCS Coins End Day Intrvl 3'
	pbp_b2_coins_ad_intrvl_num       = 'SNF AD Coins Interval Num'
	pbp_b2_coins_ad_pct_intrvl1      = 'SNF AD Coins Pct Interval 1'
	pbp_b2_coins_ad_bgnd_intrvl1     = 'SNF AD Coins Bgn Day Intrvl 1'
	pbp_b2_coins_ad_endd_intrvl1     = 'SNF AD Coins End Day Intrvl 1'
	pbp_b2_coins_ad_pct_intrvl2      = 'SNF AD Coins Pct Interval 2'
	pbp_b2_coins_ad_bgnd_intrvl2     = 'SNF AD Coins Bgn Day Intrvl 2'
	pbp_b2_coins_ad_endd_intrvl2     = 'SNF AD Coins End Day Intrvl 2'
	pbp_b2_coins_ad_pct_intrvl3      = 'SNF AD Coins Pct Interval 3'
	pbp_b2_coins_ad_bgnd_intrvl3     = 'SNF AD Coins Bgn Day Intrvl 3'
	pbp_b2_coins_ad_endd_intrvl3     = 'SNF AD Coins End Day Intrvl 3'
	pbp_b2_coins_nmcs_struc_yn       = 'SNF NMCS Coins Structure YN'
	pbp_b2_coins_nmcs_pct            = 'SNF NMCS Coins Percent'
	pbp_b2_coins_nmcs_intrvl_num     = 'SNF NMCS Coins Interval Num'
	pbp_b2_coins_nmcs_pct_intrvl1    = 'SNF NMCS Coins Pct Interval 1'
	pbp_b2_coins_nmcs_bgnd_intrvl1   = 'SNF NMCS Coins BgnDay Intrvl 1'
	pbp_b2_coins_nmcs_endd_intrvl1   = 'SNF NMCS Coins EndDay Intrvl 1'
	pbp_b2_coins_nmcs_pct_intrvl2    = 'SNF NMCS Coins Pct Interval 2'
	pbp_b2_coins_nmcs_bgnd_intrvl2   = 'SNF NMCS Coins BgnDay Intrvl 2'
	pbp_b2_coins_nmcs_endd_intrvl2   = 'SNF NMCS Coins EndDay Intrvl 2'
	pbp_b2_coins_nmcs_pct_intrvl3    = 'SNF NMCS Coins Pct Interval 3'
	pbp_b2_coins_nmcs_bgnd_intrvl3   = 'SNF NMCS Coins BgnDay Intrvl 3'
	pbp_b2_coins_nmcs_endd_intrvl3   = 'SNF NMCS Coins EndDay Intrvl 3'
	pbp_b2_ded_yn                    = 'SNF Deductible YN'
	pbp_b2_ded_amt                   = 'SNF Deductible Amt'
	pbp_b2_copay_yn                  = 'SNF Copayment YN'
	pbp_b2_mdcr_copay_cstshrs_yn     = 'SNF Med Def Copay Cost Shrs YN'
	pbp_b2_copay_mcs_amt             = 'SNF Copay MC Stay Amt'
	pbp_b2_copay_mcs_intrvl_num      = 'SNF MCS Copay Interval Num'
	pbp_b2_copay_mcs_amt_intrvl1     = 'SNF MCS Copay Amt Interval 1'
	pbp_b2_copay_mcs_bgnd_intrvl1    = 'SNF MCS Copay Bgn Day Intrvl 1'
	pbp_b2_copay_mcs_endd_intrvl1    = 'SNF MCS Copay End Day Intrvl 1'
	pbp_b2_copay_mcs_amt_intrvl2     = 'SNF MCS Copay Amt Interval 2'
	pbp_b2_copay_mcs_bgnd_intrvl2    = 'SNF MCS Copay Bgn Day Intrvl 2'
	pbp_b2_copay_mcs_endd_intrvl2    = 'SNF MCS Copay End Day Intrvl 2'
	pbp_b2_copay_mcs_amt_intrvl3     = 'SNF MCS Copay Amt Interval 3'
	pbp_b2_copay_mcs_bgnd_intrvl3    = 'SNF MCS Copay Bgn Day Intrvl 3'
	pbp_b2_copay_mcs_endd_intrvl3    = 'SNF MCS Copay End Day Intrvl 3'
	pbp_b2_copay_ad_intrvl_num       = 'SNF AD Copay Interval Num'
	pbp_b2_copay_ad_amt_intrvl1      = 'SNF AD Copay Amt Interval 1'
	pbp_b2_copay_ad_bgnd_intrvl1     = 'SNF AD Copay Bgn Day Intrvl 1'
	pbp_b2_copay_ad_endd_intrvl1     = 'SNF AD Copay End Day Intrvl 1'
	pbp_b2_copay_ad_amt_intrvl2      = 'SNF AD Copay Amt Interval 2'
	pbp_b2_copay_ad_bgnd_intrvl2     = 'SNF AD Copay Bgn Day Intrvl 2'
	pbp_b2_copay_ad_endd_intrvl2     = 'SNF AD Copay End Day Intrvl 2'
	pbp_b2_copay_ad_amt_intrvl3      = 'SNF AD Copay Amt Interval 3'
	pbp_b2_copay_ad_bgnd_intrvl3     = 'SNF AD Copay Bgn Day Intrvl 3'
	pbp_b2_copay_ad_endd_intrvl3     = 'SNF AD Copay End Day Intrvl 3'
	pbp_b2_copay_nmcs_struc_yn       = 'SNF NMCS Copay Structure YN'
	pbp_b2_copay_nmcs_amt            = 'SNF NMCS Copay Amt'
	pbp_b2_copay_nmcs_intrvl_num     = 'SNF NMCS Copay Interval Num'
	pbp_b2_copay_nmcs_amt_intrvl1    = 'SNF NMCS Copay Amt Interval 1'
	pbp_b2_copay_nmcs_bgnd_intrvl1   = 'SNF NMCS Copay BgnDay Intrvl 1'
	pbp_b2_copay_nmcs_endd_intrvl1   = 'SNF NMCS Copay EndDay Intrvl 1'
	pbp_b2_copay_nmcs_amt_intrvl2    = 'SNF NMCS Copay Amt Interval 2'
	pbp_b2_copay_nmcs_bgnd_intrvl2   = 'SNF NMCS Copay BgnDay Intrvl 2'
	pbp_b2_copay_nmcs_endd_intrvl2   = 'SNF NMCS Copay EndDay Intrvl 2'
	pbp_b2_copay_nmcs_amt_intrvl3    = 'SNF NMCS Copay Amt Interval 3'
	pbp_b2_copay_nmcs_bgnd_intrvl3   = 'SNF NMCS Copay BgnDay Intrvl 3'
	pbp_b2_copay_nmcs_endd_intrvl3   = 'SNF NMCS Copay EndDay Intrvl 3'
	pbp_b2_auth                      = 'SNF Auth'
	pbp_b2_refer_yn                  = 'SNF Referral YN'
	pbp_b2_bendesc_yn_bonly          = 'SNF(B) Ben Desc YN'
	pbp_b2_bendesc_amo_bonly         = 'SNF(B) Ben Desc AMO'
	pbp_b2_bendesc_snf_unlm_bonly    = 'SNF(B) Ben Desc Unlimited Days'
	pbp_b2_bende_al_ad_prior_bonly   = 'SNF(B) Ben Desc Num of Days'
	pbp_b2_bendesc_snf_per_bonly     = 'SNF(B) Ben Desc Per'
	pbp_b2_bendesc_hostay_bonly_yn   = 'SNF(B) Ben Desc Hospital Stay'
	pbp_b2_bende_nmday_prior_bonly   = 'SNF(B) Ben Desc Num Days Prior'
	pbp_b2_maxplan_yn_bonly          = 'SNF(B) Max Plan YN'
	pbp_b2_maxplan_amt_bonly         = 'SNF(B) Max Plan Amt'
	pbp_b2_maxplan_per_bonly         = 'SNF(B) Max Plan Per'
	pbp_b2_maxenr_yn_bonly           = 'SNF(B) Max Enr YN'
	pbp_b2_maxenr_amt_bonly          = 'SNF(B) Max Enr Amt'
	pbp_b2_maxenr_per_bonly          = 'SNF(B) Max Enr Per'
	pbp_b2_coins_yn_bonly            = 'SNF(B) Coinsurance YN'
	pbp_b2_coins_pct_bonly           = 'SNF(B) Coins Pct'
	pbp_b2_coins_ps_num_bonly        = 'SNF(B) PS Coins Interval Num'
	pbp_b2_coins_ps_pct1_bonly       = 'SNF(B) PS Coins Pct Intrvl 1'
	pbp_b2_coins_ps_bgnd1_bonly      = 'SNF(B) PS Coin Bgn Day Intrv 1'
	pbp_b2_coins_ps_endd1_bonly      = 'SNF(B) PS Coin End Day Intrv 1'
	pbp_b2_coins_ps_pct2_bonly       = 'SNF(B) PS Coins Pct Intrvl 2'
	pbp_b2_coins_ps_bgnd2_bonly      = 'SNF(B) PS Coin Bgn Day Intrv 2'
	pbp_b2_coins_ps_endd2_bonly      = 'SNF(B) PS Coin End Day Intrv 2'
	pbp_b2_coins_ps_pct3_bonly       = 'SNF(B) PS Coins Pct Intrvl 3'
	pbp_b2_coins_ps_bgnd3_bonly      = 'SNF(B) PS Coin Bgn Day Intrv 3'
	pbp_b2_coins_ps_endd3_bonly      = 'SNF(B) PS Coin End Day Intrv 3'
	pbp_b2_ded_yn_bonly              = 'SNF(B) Deductible YN'
	pbp_b2_ded_amt_bonly             = 'SNF(B) Deductible Amt'
	pbp_b2_copay_yn_bonly            = 'SNF(B) Copayment YN'
	pbp_b2_copay_ps_amt_bonly        = 'SNF(B) PS Copay Amt'
	pbp_b2_copay_ps_num_bonly        = 'SNF(B) PS Copay Interval Num'
	pbp_b2_copay_ps_amt1_bonly       = 'SNF(B) PS Copay Amt Interval 1'
	pbp_b2_copay_ps_bgnd1_bonly      = 'SNF(B) PS Cpay Bgn Day Intrv 1'
	pbp_b2_copay_ps_endd1_bonly      = 'SNF(B) PS Cpay End Day Intrv 1'
	pbp_b2_copay_ps_amt2_bonly       = 'SNF(B) PS Copay Amt Interval 2'
	pbp_b2_copay_ps_bgnd2_bonly      = 'SNF(B) PS Cpay Bgn Day Intrv 2'
	pbp_b2_copay_ps_endd2_bonly      = 'SNF(B) PS Cpay End Day Intrv 2'
	pbp_b2_copay_ps_amt3_bonly       = 'SNF(B) PS Copay Amt Interval 3'
	pbp_b2_copay_ps_bgnd3_bonly      = 'SNF(B) PS Cpay Bgn Day Intrv 3'
	pbp_b2_copay_ps_endd3_bonly      = 'SNF(B) PS Cpay End Day Intrv 3'
	pbp_b2_auth_bonly                = 'SNF(B) Enrollee Auth'
	pbp_b2_refer_yn_bonly            = 'SNF(B) Referral YN'
;

run;

proc sort data = pbp_b2 out=out.pbp_b2;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b2(obs = 10);
  title 'pbp_b2_snf file ';
run;

proc means data = out.pbp_b2;
  title 'pbp_b2_snf file ';
run;

proc freq data = out.pbp_b2;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b2_bendesc_yn
	pbp_b2_bendesc_ad_nmcs
	pbp_b2_bendesc_amo_ad
	pbp_b2_benedesc_lim_ad
	pbp_b2_bendesc_amo_nmcs
	pbp_b2_bendesc_pr_hosp_yn
	pbp_b2_bendesc_pr_hosp_num
	pbp_b2_maxenr_yn
	pbp_b2_maxenr_per
	pbp_b2_coins_yn
	pbp_b2_mdcr_coins_cstshrs_yn
	pbp_b2_coins_mcs_intrvl_num
	pbp_b2_coins_ad_intrvl_num
	pbp_b2_coins_nmcs_struc_yn
	pbp_b2_coins_nmcs_intrvl_num
	pbp_b2_ded_yn
	pbp_b2_copay_yn
	pbp_b2_mdcr_copay_cstshrs_yn
	pbp_b2_copay_mcs_intrvl_num
	pbp_b2_copay_ad_intrvl_num
	pbp_b2_copay_nmcs_struc_yn
	pbp_b2_copay_nmcs_intrvl_num
	pbp_b2_auth
	pbp_b2_refer_yn
	pbp_b2_bendesc_yn_bonly
	pbp_b2_bendesc_amo_bonly
	pbp_b2_bendesc_snf_unlm_bonly
	pbp_b2_bendesc_snf_per_bonly
	pbp_b2_bendesc_hostay_bonly_yn
	pbp_b2_maxplan_yn_bonly
	pbp_b2_maxplan_per_bonly
	pbp_b2_maxenr_yn_bonly
	pbp_b2_maxenr_per_bonly
	pbp_b2_coins_yn_bonly
	pbp_b2_coins_ps_num_bonly
	pbp_b2_ded_yn_bonly
	pbp_b2_copay_yn_bonly
	pbp_b2_copay_ps_num_bonly
	pbp_b2_auth_bonly
	pbp_b2_refer_yn_bonly
/ missing;
run;

proc contents data = out.pbp_b2;
  title 'pbp_b2 data';
run;
