*pbp_b13_2.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b13_2;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b13h_add_srvcs_yn            $1
	pbp_b13h_addl_services           $27
	pbp_b13h_addl_service_other1     $55
	pbp_b13h_addl_service_other2     $55
	pbp_b13h_addl_service_other3     $55
	pbp_b13h_addl_service_other4     $55
	pbp_b13h_addl_service_other5     $55
	pbp_b13h_addl_service_other6     $55
	pbp_b13h_addl_service_other7     $55
	pbp_b13h_addl_service_other8     $55
	pbp_b13h_addl_service_other9     $55
	pbp_b13h_addl_service_other10    $55
	pbp_b13h_addl_service_other11    $55
	pbp_b13h_addl_service_other12    $55
	pbp_b13h_addl_service_other13    $55
	pbp_b13h_maxplan_yn              $1
	pbp_b13h_maxplan_services        $27
	pbp_b13h_maxplan_epsdt_per       $1
	pbp_b13h_maxplan_tccpw_per       $1
	pbp_b13h_maxplan_fbcs_per        $1
	pbp_b13h_maxplan_rcs_per         $1
	pbp_b13h_maxplan_fps_per         $1
	pbp_b13h_maxplan_nhs_per         $1
	pbp_b13h_maxplan_hcbs_per        $1
	pbp_b13h_maxplan_pcs_per         $1
	pbp_b13h_maxplan_sdpas_per       $1
	pbp_b13h_maxplan_pdns_per        $1
	pbp_b13h_add_srvcs_coins_yn      $1
	pbp_b13h_add_srvcs_coins_items   $27
	pbp_b13h_add_srvcs_copay_yn      $1
	pbp_b13h_add_srvcs_copay_items   $27
	pbp_b13h_maxplan_cm_ltc_per      $1
	pbp_b13h_maxplan_imds_per        $1
	pbp_b13h_maxplan_icfmrs_per      $1
	pbp_b13h_maxplan_cm_per          $1
	pbp_b13h_maxplan_other1_per      $1
	pbp_b13h_maxplan_other2_per      $1
	pbp_b13h_maxplan_other3_per      $1
	pbp_b13h_maxplan_other4_per      $1
	pbp_b13h_maxplan_other5_per      $1
	pbp_b13h_maxplan_other6_per      $1
	pbp_b13h_maxplan_other7_per      $1
	pbp_b13h_maxplan_other8_per      $1
	pbp_b13h_maxplan_other9_per      $1
	pbp_b13h_maxplan_other10_per     $1
	pbp_b13h_maxplan_other11_per     $1
	pbp_b13h_maxplan_other12_per     $1
	pbp_b13h_maxplan_other13_per     $1
	pbp_b13h_auth_yn                 $1
	pbp_b13h_auth_epsdt              $5
	pbp_b13h_auth_tccpw              $5
	pbp_b13h_auth_fbcs               $5
	pbp_b13h_auth_rcs                $5
	pbp_b13h_auth_fps                $5
	pbp_b13h_auth_nhs                $5
	pbp_b13h_auth_hcbs               $5
	pbp_b13h_auth_pcs                $5
	pbp_b13h_auth_sdpas              $5
	pbp_b13h_auth_pdns               $5
	pbp_b13h_auth_cm_ltc             $5
	pbp_b13h_auth_imds               $5
	pbp_b13h_auth_icfmrs             $5
	pbp_b13h_auth_cm                 $5
	pbp_b13h_auth_other1             $5
	pbp_b13h_auth_other2             $5
	pbp_b13h_auth_other3             $5
	pbp_b13h_auth_other4             $5
	pbp_b13h_auth_other5             $5
	pbp_b13h_auth_other6             $5
	pbp_b13h_auth_other7             $5
	pbp_b13h_auth_other8             $5
	pbp_b13h_auth_other9             $5
	pbp_b13h_auth_other10            $5
	pbp_b13h_auth_other11            $5
	pbp_b13h_auth_other12            $5
	pbp_b13h_auth_other13            $5
	pbp_b13h_ref_yn                  $1
	pbp_b13h_ref_services            $27
;

infile '.\pbp\pbp_b13_other_services_2.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b13h_add_srvcs_yn
	pbp_b13h_addl_services
	pbp_b13h_addl_service_other1
	pbp_b13h_addl_service_other2
	pbp_b13h_addl_service_other3
	pbp_b13h_addl_service_other4
	pbp_b13h_addl_service_other5
	pbp_b13h_addl_service_other6
	pbp_b13h_addl_service_other7
	pbp_b13h_addl_service_other8
	pbp_b13h_addl_service_other9
	pbp_b13h_addl_service_other10
	pbp_b13h_addl_service_other11
	pbp_b13h_addl_service_other12
	pbp_b13h_addl_service_other13
	pbp_b13h_maxplan_yn
	pbp_b13h_maxplan_services
	pbp_b13h_maxplan_epsdt_amt
	pbp_b13h_maxplan_epsdt_per
	pbp_b13h_maxplan_tccpw_amt
	pbp_b13h_maxplan_tccpw_per
	pbp_b13h_maxplan_fbcs_amt
	pbp_b13h_maxplan_fbcs_per
	pbp_b13h_maxplan_rcs_amt
	pbp_b13h_maxplan_rcs_per
	pbp_b13h_maxplan_fps_amt
	pbp_b13h_maxplan_fps_per
	pbp_b13h_maxplan_nhs_amt
	pbp_b13h_maxplan_nhs_per
	pbp_b13h_maxplan_hcbs_amt
	pbp_b13h_maxplan_hcbs_per
	pbp_b13h_maxplan_pcs_amt
	pbp_b13h_maxplan_pcs_per
	pbp_b13h_maxplan_sdpas_amt
	pbp_b13h_maxplan_sdpas_per
	pbp_b13h_maxplan_pdns_amt
	pbp_b13h_maxplan_pdns_per
	pbp_b13h_maxplan_cm_ltc_amt
	pbp_b13h_maxplan_imds_amt
	pbp_b13h_maxplan_icfmrs_amt
	pbp_b13h_maxplan_cm_amt
	pbp_b13h_maxplan_other1_amt
	pbp_b13h_maxplan_other2_amt
	pbp_b13h_maxplan_other3_amt
	pbp_b13h_maxplan_other4_amt
	pbp_b13h_maxplan_other5_amt
	pbp_b13h_maxplan_other6_amt
	pbp_b13h_maxplan_other7_amt
	pbp_b13h_maxplan_other8_amt
	pbp_b13h_maxplan_other9_amt
	pbp_b13h_maxplan_other10_amt
	pbp_b13h_maxplan_other11_amt
	pbp_b13h_maxplan_other12_amt
	pbp_b13h_maxplan_other13_amt
	pbp_b13h_add_srvcs_coins_yn
	pbp_b13h_add_srvcs_coins_items
	pbp_b13h_coins_epsdt_min
	pbp_b13h_coins_epsdt_max
	pbp_b13h_coins_tccpw_min
	pbp_b13h_coins_tccpw_max
	pbp_b13h_coins_fbcs_min
	pbp_b13h_coins_fbcs_max
	pbp_b13h_coins_rcs_min
	pbp_b13h_coins_rcs_max
	pbp_b13h_coins_fps_min
	pbp_b13h_coins_fps_max
	pbp_b13h_coins_nhs_min
	pbp_b13h_coins_nhs_max
	pbp_b13h_coins_hcbs_min
	pbp_b13h_coins_hcbs_max
	pbp_b13h_coins_pcs_min
	pbp_b13h_coins_pcs_max
	pbp_b13h_coins_sdpas_min
	pbp_b13h_coins_sdpas_max
	pbp_b13h_coins_pdns_min
	pbp_b13h_coins_pdns_max
	pbp_b13h_coins_cm_ltc_min
	pbp_b13h_coins_cm_ltc_max
	pbp_b13h_coins_imds_min
	pbp_b13h_coins_imds_max
	pbp_b13h_coins_icfmrs_min
	pbp_b13h_coins_icfmrs_max
	pbp_b13h_coins_cm_min
	pbp_b13h_coins_cm_max
	pbp_b13h_coins_other1_min
	pbp_b13h_coins_other1_max
	pbp_b13h_coins_other2_min
	pbp_b13h_coins_other2_max
	pbp_b13h_coins_other3_min
	pbp_b13h_coins_other3_max
	pbp_b13h_add_srvcs_copay_yn
	pbp_b13h_add_srvcs_copay_items
	pbp_b13h_copay_epsdt_min
	pbp_b13h_copay_epsdt_max
	pbp_b13h_copay_tccpw_min
	pbp_b13h_copay_tccpw_max
	pbp_b13h_copay_fbcs_min
	pbp_b13h_copay_fbcs_max
	pbp_b13h_copay_rcs_min
	pbp_b13h_copay_rcs_max
	pbp_b13h_copay_fps_min
	pbp_b13h_copay_fps_max
	pbp_b13h_copay_nhs_min
	pbp_b13h_copay_nhs_max
	pbp_b13h_copay_hcbs_min
	pbp_b13h_copay_hcbs_max
	pbp_b13h_copay_pcs_min
	pbp_b13h_copay_pcs_max
	pbp_b13h_copay_sdpas_min
	pbp_b13h_copay_sdpas_max
	pbp_b13h_copay_pdns_min
	pbp_b13h_copay_pdns_max
	pbp_b13h_copay_cm_ltc_min
	pbp_b13h_copay_cm_ltc_max
	pbp_b13h_copay_imds_min
	pbp_b13h_copay_imds_max
	pbp_b13h_copay_icfmrs_min
	pbp_b13h_copay_icfmrs_max
	pbp_b13h_copay_cm_min
	pbp_b13h_copay_cm_max
	pbp_b13h_copay_other1_min
	pbp_b13h_copay_other1_max
	pbp_b13h_copay_other2_min
	pbp_b13h_copay_other2_max
	pbp_b13h_copay_other3_min
	pbp_b13h_copay_other3_max
	pbp_b13h_maxplan_cm_ltc_per
	pbp_b13h_maxplan_imds_per
	pbp_b13h_maxplan_icfmrs_per
	pbp_b13h_maxplan_cm_per
	pbp_b13h_maxplan_other1_per
	pbp_b13h_maxplan_other2_per
	pbp_b13h_maxplan_other3_per
	pbp_b13h_maxplan_other4_per
	pbp_b13h_maxplan_other5_per
	pbp_b13h_maxplan_other6_per
	pbp_b13h_maxplan_other7_per
	pbp_b13h_maxplan_other8_per
	pbp_b13h_maxplan_other9_per
	pbp_b13h_maxplan_other10_per
	pbp_b13h_maxplan_other11_per
	pbp_b13h_maxplan_other12_per
	pbp_b13h_maxplan_other13_per
	pbp_b13h_coins_other4_min
	pbp_b13h_coins_other4_max
	pbp_b13h_coins_other5_min
	pbp_b13h_coins_other5_max
	pbp_b13h_coins_other6_min
	pbp_b13h_coins_other6_max
	pbp_b13h_coins_other7_min
	pbp_b13h_coins_other7_max
	pbp_b13h_coins_other8_min
	pbp_b13h_coins_other8_max
	pbp_b13h_coins_other9_min
	pbp_b13h_coins_other9_max
	pbp_b13h_coins_other10_min
	pbp_b13h_coins_other10_max
	pbp_b13h_coins_other11_min
	pbp_b13h_coins_other11_max
	pbp_b13h_coins_other12_min
	pbp_b13h_coins_other12_max
	pbp_b13h_coins_other13_min
	pbp_b13h_coins_other13_max
	pbp_b13h_copay_other4_min
	pbp_b13h_copay_other4_max
	pbp_b13h_copay_other5_min
	pbp_b13h_copay_other5_max
	pbp_b13h_copay_other6_min
	pbp_b13h_copay_other6_max
	pbp_b13h_copay_other7_min
	pbp_b13h_copay_other7_max
	pbp_b13h_copay_other8_min
	pbp_b13h_copay_other8_max
	pbp_b13h_copay_other9_min
	pbp_b13h_copay_other9_max
	pbp_b13h_copay_other10_min
	pbp_b13h_copay_other10_max
	pbp_b13h_copay_other11_min
	pbp_b13h_copay_other11_max
	pbp_b13h_copay_other12_min
	pbp_b13h_copay_other12_max
	pbp_b13h_copay_other13_min
	pbp_b13h_copay_other13_max
	pbp_b13h_auth_yn
	pbp_b13h_auth_epsdt
	pbp_b13h_auth_tccpw
	pbp_b13h_auth_fbcs
	pbp_b13h_auth_rcs
	pbp_b13h_auth_fps
	pbp_b13h_auth_nhs
	pbp_b13h_auth_hcbs
	pbp_b13h_auth_pcs
	pbp_b13h_auth_sdpas
	pbp_b13h_auth_pdns
	pbp_b13h_auth_cm_ltc
	pbp_b13h_auth_imds
	pbp_b13h_auth_icfmrs
	pbp_b13h_auth_cm
	pbp_b13h_auth_other1
	pbp_b13h_auth_other2
	pbp_b13h_auth_other3
	pbp_b13h_auth_other4
	pbp_b13h_auth_other5
	pbp_b13h_auth_other6
	pbp_b13h_auth_other7
	pbp_b13h_auth_other8
	pbp_b13h_auth_other9
	pbp_b13h_auth_other10
	pbp_b13h_auth_other11
	pbp_b13h_auth_other12
	pbp_b13h_auth_other13
	pbp_b13h_ref_yn
	pbp_b13h_ref_services
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b13h_add_srvcs_yn            = 'Plan provide Addl Srvcs YN?'
	pbp_b13h_addl_services           = 'Select Addl Srvcs'
	pbp_b13h_addl_service_other1     = 'Other 1 Service Name'
	pbp_b13h_addl_service_other2     = 'Other 2 Service Name'
	pbp_b13h_addl_service_other3     = 'Other 3 Service Name'
	pbp_b13h_addl_service_other4     = 'Other 4 Service Name'
	pbp_b13h_addl_service_other5     = 'Other 5 Service Name'
	pbp_b13h_addl_service_other6     = 'Other 6 Service Name'
	pbp_b13h_addl_service_other7     = 'Other 7 Service Name'
	pbp_b13h_addl_service_other8     = 'Other 8 Service Name'
	pbp_b13h_addl_service_other9     = 'Other 9 Service Name'
	pbp_b13h_addl_service_other10    = 'Other 10 Service Name'
	pbp_b13h_addl_service_other11    = 'Other 11 Service Name'
	pbp_b13h_addl_service_other12    = 'Other 12 Service Name'
	pbp_b13h_addl_service_other13    = 'Other 13 Service Name'
	pbp_b13h_maxplan_yn              = 'Add Srvcs Max Plan Amt YN'
	pbp_b13h_maxplan_services        = 'Add Srvcs Max Plan Services'
	pbp_b13h_maxplan_epsdt_amt       = 'Add Srvcs Max Plan Amt EPSDT'
	pbp_b13h_maxplan_epsdt_per       = 'Add Srvcs Max Plan Per EPSDT'
	pbp_b13h_maxplan_tccpw_amt       = 'Add Srvcs Max Plan Amt TCCPW'
	pbp_b13h_maxplan_tccpw_per       = 'Add Srvcs Max Plan Per TCCPW'
	pbp_b13h_maxplan_fbcs_amt        = 'Add Srvcs Max Plan Amt FBCS'
	pbp_b13h_maxplan_fbcs_per        = 'Add Srvcs Max Plan Per FBCS'
	pbp_b13h_maxplan_rcs_amt         = 'Add Srvcs Max Plan Amt RCS'
	pbp_b13h_maxplan_rcs_per         = 'Add Srvcs Max Plan Per RCS'
	pbp_b13h_maxplan_fps_amt         = 'Add Srvcs Max Plan Amt FPS'
	pbp_b13h_maxplan_fps_per         = 'Add Srvcs Max Plan Per FPS'
	pbp_b13h_maxplan_nhs_amt         = 'Add Srvcs Max Plan Amt NHS'
	pbp_b13h_maxplan_nhs_per         = 'Add Srvcs Max Plan Per NHS'
	pbp_b13h_maxplan_hcbs_amt        = 'Add Srvcs Max Plan Amt HCBS'
	pbp_b13h_maxplan_hcbs_per        = 'Add Srvcs Max Plan Per HCBS'
	pbp_b13h_maxplan_pcs_amt         = 'Add Srvcs Max Plan Amt PCS'
	pbp_b13h_maxplan_pcs_per         = 'Add Srvcs Max Plan Per PCS'
	pbp_b13h_maxplan_sdpas_amt       = 'Add Srvcs Max Plan Amt SDPAS'
	pbp_b13h_maxplan_sdpas_per       = 'Add Srvcs Max Plan Per SDPAS'
	pbp_b13h_maxplan_pdns_amt        = 'Add Srvcs Max Plan Amt PDNS'
	pbp_b13h_maxplan_pdns_per        = 'Add Srvcs Max Plan Per PDNS'
	pbp_b13h_maxplan_cm_ltc_amt      = 'Add Srvcs Max Plan Amt CM_LTC'
	pbp_b13h_maxplan_imds_amt        = 'Add Srvcs Max Plan Amt IMDS'
	pbp_b13h_maxplan_icfmrs_amt      = 'Add Srvcs Max Plan Amt ICFMRS'
	pbp_b13h_maxplan_cm_amt          = 'Add Srvcs Max Plan Amt CM'
	pbp_b13h_maxplan_other1_amt      = 'Add Srvcs Max Plan Amt OTHER1'
	pbp_b13h_maxplan_other2_amt      = 'Add Srvcs Max Plan Amt OTHER2'
	pbp_b13h_maxplan_other3_amt      = 'Add Srvcs Max Plan Amt OTHER3'
	pbp_b13h_maxplan_other4_amt      = 'Add Srvcs Max Plan Amt OTHER4'
	pbp_b13h_maxplan_other5_amt      = 'Add Srvcs Max Plan Amt OTHER5'
	pbp_b13h_maxplan_other6_amt      = 'Add Srvcs Max Plan Amt OTHER6'
	pbp_b13h_maxplan_other7_amt      = 'Add Srvcs Max Plan Amt OTHER7'
	pbp_b13h_maxplan_other8_amt      = 'Add Srvcs Max Plan Amt OTHER8'
	pbp_b13h_maxplan_other9_amt      = 'Add Srvcs Max Plan Amt OTHER9'
	pbp_b13h_maxplan_other10_amt     = 'Add Srvcs Max Plan Amt OTHER10'
	pbp_b13h_maxplan_other11_amt     = 'Add Srvcs Max Plan Amt OTHER11'
	pbp_b13h_maxplan_other12_amt     = 'Add Srvcs Max Plan Amt OTHER12'
	pbp_b13h_maxplan_other13_amt     = 'Add Srvcs Max Plan Amt OTHER13'
	pbp_b13h_add_srvcs_coins_yn      = 'Is there a Coins YN'
	pbp_b13h_add_srvcs_coins_items   = 'Select Add Srvs Coins'
	pbp_b13h_coins_epsdt_min         = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_epsdt_max         = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_tccpw_min         = 'Indicate minimum Coinsurance'
	pbp_b13h_coins_tccpw_max         = 'Indicate maximum Coinsurance'
	pbp_b13h_coins_fbcs_min          = 'Indicate minimum Coinsurance'
	pbp_b13h_coins_fbcs_max          = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_rcs_min           = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_rcs_max           = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_fps_min           = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_fps_max           = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_nhs_min           = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_nhs_max           = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_hcbs_min          = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_hcbs_max          = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_pcs_min           = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_pcs_max           = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_sdpas_min         = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_sdpas_max         = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_pdns_min          = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_pdns_max          = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_cm_ltc_min        = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_cm_ltc_max        = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_imds_min          = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_imds_max          = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_icfmrs_min        = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_icfmrs_max        = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_cm_min            = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_cm_max            = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_other1_min        = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_other1_max        = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_other2_min        = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_other2_max        = 'Indicate maximum Coinsurance:'
	pbp_b13h_coins_other3_min        = 'Indicate minimum Coinsurance:'
	pbp_b13h_coins_other3_max        = 'Indicate maximum Coinsurance:'
	pbp_b13h_add_srvcs_copay_yn      = 'Is there a Copayment?'
	pbp_b13h_add_srvcs_copay_items   = 'Select Add Srvs Copay'
	pbp_b13h_copay_epsdt_min         = 'Indicate minimum Copayment:'
	pbp_b13h_copay_epsdt_max         = 'Indicate maximum Copayment:'
	pbp_b13h_copay_tccpw_min         = 'Indicate minimum Copayment:'
	pbp_b13h_copay_tccpw_max         = 'Indicate maximum Copayment:'
	pbp_b13h_copay_fbcs_min          = 'Indicate minimum Copayment:'
	pbp_b13h_copay_fbcs_max          = 'Indicate maximum Copayment:'
	pbp_b13h_copay_rcs_min           = 'Indicate minimum Copayment:'
	pbp_b13h_copay_rcs_max           = 'Indicate maximum Copayment:'
	pbp_b13h_copay_fps_min           = 'Indicate minimum Copayment:'
	pbp_b13h_copay_fps_max           = 'Indicate maximum Copayment:'
	pbp_b13h_copay_nhs_min           = 'Indicate minimum Copayment:'
	pbp_b13h_copay_nhs_max           = 'Indicate maximum Copayment:'
	pbp_b13h_copay_hcbs_min          = 'Indicate minimum Copayment:'
	pbp_b13h_copay_hcbs_max          = 'Indicate maximum Copayment:'
	pbp_b13h_copay_pcs_min           = 'Indicate minimum Copayment:'
	pbp_b13h_copay_pcs_max           = 'Indicate maximum Copayment:'
	pbp_b13h_copay_sdpas_min         = 'Indicate minimum Copayment:'
	pbp_b13h_copay_sdpas_max         = 'Indicate maximum Copayment:'
	pbp_b13h_copay_pdns_min          = 'Indicate minimum Copayment:'
	pbp_b13h_copay_pdns_max          = 'Indicate maximum Copayment:'
	pbp_b13h_copay_cm_ltc_min        = 'Indicate minimum Copayment:'
	pbp_b13h_copay_cm_ltc_max        = 'Indicate maximum Copayment:'
	pbp_b13h_copay_imds_min          = 'Indicate minimum Copayment:'
	pbp_b13h_copay_imds_max          = 'Indicate maximum Copayment:'
	pbp_b13h_copay_icfmrs_min        = 'Indicate minimum Copayment:'
	pbp_b13h_copay_icfmrs_max        = 'Indicate maximum Copayment:'
	pbp_b13h_copay_cm_min            = 'Indicate minimum Copayment:'
	pbp_b13h_copay_cm_max            = 'Indicate maximum Copayment:'
	pbp_b13h_copay_other1_min        = 'Indicate minimum Copayment:'
	pbp_b13h_copay_other1_max        = 'Indicate maximum Copayment:'
	pbp_b13h_copay_other2_min        = 'Indicate minimum Copayment:'
	pbp_b13h_copay_other2_max        = 'Indicate maximum Copayment:'
	pbp_b13h_copay_other3_min        = 'Indicate minimum Copayment:'
	pbp_b13h_copay_other3_max        = 'Indicate maximum Copayment:'
	pbp_b13h_maxplan_cm_ltc_per      = 'Add Srvcs Max Plan Per CM_LTC'
	pbp_b13h_maxplan_imds_per        = 'Add Srvcs Max Plan Per IMDS'
	pbp_b13h_maxplan_icfmrs_per      = 'Add Srvcs Max Plan Per ICFMRS'
	pbp_b13h_maxplan_cm_per          = 'Add Srvcs Max Plan Per CM'
	pbp_b13h_maxplan_other1_per      = 'Add Srvcs Max Plan Per OTHER1'
	pbp_b13h_maxplan_other2_per      = 'Add Srvcs Max Plan Per OTHER2'
	pbp_b13h_maxplan_other3_per      = 'Add Srvcs Max Plan Per OTHER3'
	pbp_b13h_maxplan_other4_per      = 'Add Srvcs Max Plan Per OTHER4'
	pbp_b13h_maxplan_other5_per      = 'Add Srvcs Max Plan Per OTHER5'
	pbp_b13h_maxplan_other6_per      = 'Add Srvcs Max Plan Per OTHER6'
	pbp_b13h_maxplan_other7_per      = 'Add Srvcs Max Plan Per OTHER7'
	pbp_b13h_maxplan_other8_per      = 'Add Srvcs Max Plan Per OTHER8'
	pbp_b13h_maxplan_other9_per      = 'Add Srvcs Max Plan Per OTHER9'
	pbp_b13h_maxplan_other10_per     = 'Add Srvcs Max Plan Per OTHER10'
	pbp_b13h_maxplan_other11_per     = 'Add Srvcs Max Plan Per OTHER11'
	pbp_b13h_maxplan_other12_per     = 'Add Srvcs Max Plan Per OTHER12'
	pbp_b13h_maxplan_other13_per     = 'Add Srvcs Max Plan Per OTHER13'
	pbp_b13h_coins_other4_min        = 'Add Srvcs Min Coins Pct OTHER4'
	pbp_b13h_coins_other4_max        = 'Add Srvcs Max Coins Pct OTHER4'
	pbp_b13h_coins_other5_min        = 'Add Srvcs Min Coins Pct OTHER5'
	pbp_b13h_coins_other5_max        = 'Add Srvcs Max Coins Pct OTHER5'
	pbp_b13h_coins_other6_min        = 'Add Srvcs Min Coins Pct OTHER6'
	pbp_b13h_coins_other6_max        = 'Add Srvcs Max Coins Pct OTHER6'
	pbp_b13h_coins_other7_min        = 'Add Srvcs Min Coins Pct OTHER7'
	pbp_b13h_coins_other7_max        = 'Add Srvcs Max Coins Pct OTHER7'
	pbp_b13h_coins_other8_min        = 'Add Srvcs Min Coins Pct OTHER8'
	pbp_b13h_coins_other8_max        = 'Add Srvcs Max Coins Pct OTHER8'
	pbp_b13h_coins_other9_min        = 'Add Srvcs Min Coins Pct OTHER9'
	pbp_b13h_coins_other9_max        = 'Add Srvcs Max Coins Pct OTHER9'
	pbp_b13h_coins_other10_min       = 'Add Srvcs Min Coins Pct OTHER1'
	pbp_b13h_coins_other10_max       = 'Add Srvcs Max Coins Pct OTHER1'
	pbp_b13h_coins_other11_min       = 'Add Srvcs Min Coins Pct OTHER1'
	pbp_b13h_coins_other11_max       = 'Add Srvcs Max Coins Pct OTHER1'
	pbp_b13h_coins_other12_min       = 'Add Srvcs Min Coins Pct OTHER1'
	pbp_b13h_coins_other12_max       = 'Add Srvcs Max Coins Pct OTHER1'
	pbp_b13h_coins_other13_min       = 'Add Srvcs Min Coins Pct OTHER1'
	pbp_b13h_coins_other13_max       = 'Add Srvcs Max Coins Pct OTHER1'
	pbp_b13h_copay_other4_min        = 'Add Srvcs Min Copay Amt OTHER4'
	pbp_b13h_copay_other4_max        = 'Add Srvcs Max Copay Amt OTHER4'
	pbp_b13h_copay_other5_min        = 'Add Srvcs Min Copay Amt OTHER5'
	pbp_b13h_copay_other5_max        = 'Add Srvcs Max Copay Amt OTHER5'
	pbp_b13h_copay_other6_min        = 'Add Srvcs Min Copay Amt OTHER6'
	pbp_b13h_copay_other6_max        = 'Add Srvcs Max Copay Amt OTHER6'
	pbp_b13h_copay_other7_min        = 'Add Srvcs Min Copay Amt OTHER7'
	pbp_b13h_copay_other7_max        = 'Add Srvcs Max Copay Amt OTHER7'
	pbp_b13h_copay_other8_min        = 'Add Srvcs Min Copay Amt OTHER8'
	pbp_b13h_copay_other8_max        = 'Add Srvcs Max Copay Amt OTHER8'
	pbp_b13h_copay_other9_min        = 'Add Srvcs Min Copay Amt OTHER9'
	pbp_b13h_copay_other9_max        = 'Add Srvcs Max Copay Amt OTHER9'
	pbp_b13h_copay_other10_min       = 'Add Srvcs Min Copay Amt OTHER1'
	pbp_b13h_copay_other10_max       = 'Add Srvcs Max Copay Amt OTHER1'
	pbp_b13h_copay_other11_min       = 'Add Srvcs Min Copay Amt OTHER1'
	pbp_b13h_copay_other11_max       = 'Add Srvcs Max Copay Amt OTHER1'
	pbp_b13h_copay_other12_min       = 'Add Srvcs Min Copay Amt OTHER1'
	pbp_b13h_copay_other12_max       = 'Add Srvcs Max Copay Amt OTHER1'
	pbp_b13h_copay_other13_min       = 'Add Srvcs Min Copay Amt OTHER1'
	pbp_b13h_copay_other13_max       = 'Add Srvcs Max Copay Amt OTHER1'
	pbp_b13h_auth_yn                 = 'Add Srvcs Max Enr Amt'
	pbp_b13h_auth_epsdt              = 'Add Srvcs Auth EPSDT'
	pbp_b13h_auth_tccpw              = 'Add Srvcs Auth TCCPW'
	pbp_b13h_auth_fbcs               = 'Add Srvcs Auth FBCS'
	pbp_b13h_auth_rcs                = 'Add Srvcs Auth RCS'
	pbp_b13h_auth_fps                = 'Add Srvcs Auth FPS'
	pbp_b13h_auth_nhs                = 'Add Srvcs Auth NHS'
	pbp_b13h_auth_hcbs               = 'Add Srvcs Auth HCBS'
	pbp_b13h_auth_pcs                = 'Add Srvcs Auth PCS'
	pbp_b13h_auth_sdpas              = 'Add Srvcs Auth SDPAS'
	pbp_b13h_auth_pdns               = 'Add Srvcs Auth PDNS'
	pbp_b13h_auth_cm_ltc             = 'Add Srvcs Auth CM_LTC'
	pbp_b13h_auth_imds               = 'Add Srvcs Auth IMDS'
	pbp_b13h_auth_icfmrs             = 'Add Srvcs Auth ICFMRS'
	pbp_b13h_auth_cm                 = 'Add Srvcs Auth CM'
	pbp_b13h_auth_other1             = 'Add Srvcs Auth OTHER1'
	pbp_b13h_auth_other2             = 'Add Srvcs Auth OTHER2'
	pbp_b13h_auth_other3             = 'Add Srvcs Auth OTHER3'
	pbp_b13h_auth_other4             = 'Add Srvcs Auth OTHER4'
	pbp_b13h_auth_other5             = 'Add Srvcs Auth OTHER5'
	pbp_b13h_auth_other6             = 'Add Srvcs Auth OTHER6'
	pbp_b13h_auth_other7             = 'Add Srvcs Auth OTHER7'
	pbp_b13h_auth_other8             = 'Add Srvcs Auth OTHER8'
	pbp_b13h_auth_other9             = 'Add Srvcs Auth OTHER9'
	pbp_b13h_auth_other10            = 'Add Srvcs Auth OTHER10'
	pbp_b13h_auth_other11            = 'Add Srvcs Auth OTHER11'
	pbp_b13h_auth_other12            = 'Add Srvcs Auth OTHER12'
	pbp_b13h_auth_other13            = 'Add Srvcs Auth OTHER13'
	pbp_b13h_ref_yn                  = 'Add Srvcs Referral YN'
	pbp_b13h_ref_services            = 'Add Srvcs Referral Selections'
;

run;

proc sort data = pbp_b13_2 out=out.pbp_b13_2;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b13_2(obs = 10);
  title 'pbp_b13_other_services_2 file ';
run;

proc means data = out.pbp_b13_2;
  title 'pbp_b13_other_services_2 file ';
run;

proc freq data = out.pbp_b13_2;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b13h_add_srvcs_yn
	pbp_b13h_maxplan_yn
	pbp_b13h_maxplan_epsdt_per
	pbp_b13h_maxplan_tccpw_per
	pbp_b13h_maxplan_fbcs_per
	pbp_b13h_maxplan_rcs_per
	pbp_b13h_maxplan_fps_per
	pbp_b13h_maxplan_nhs_per
	pbp_b13h_maxplan_hcbs_per
	pbp_b13h_maxplan_pcs_per
	pbp_b13h_maxplan_sdpas_per
	pbp_b13h_maxplan_pdns_per
	pbp_b13h_add_srvcs_coins_yn
	pbp_b13h_add_srvcs_copay_yn
	pbp_b13h_maxplan_cm_ltc_per
	pbp_b13h_maxplan_imds_per
	pbp_b13h_maxplan_icfmrs_per
	pbp_b13h_maxplan_cm_per
	pbp_b13h_maxplan_other1_per
	pbp_b13h_maxplan_other2_per
	pbp_b13h_maxplan_other3_per
	pbp_b13h_maxplan_other4_per
	pbp_b13h_maxplan_other5_per
	pbp_b13h_maxplan_other6_per
	pbp_b13h_maxplan_other7_per
	pbp_b13h_maxplan_other8_per
	pbp_b13h_maxplan_other9_per
	pbp_b13h_maxplan_other10_per
	pbp_b13h_maxplan_other11_per
	pbp_b13h_maxplan_other12_per
	pbp_b13h_maxplan_other13_per
	pbp_b13h_auth_yn
	pbp_b13h_auth_epsdt
	pbp_b13h_auth_tccpw
	pbp_b13h_auth_fbcs
	pbp_b13h_auth_rcs
	pbp_b13h_auth_fps
	pbp_b13h_auth_nhs
	pbp_b13h_auth_hcbs
	pbp_b13h_auth_pcs
	pbp_b13h_auth_sdpas
	pbp_b13h_auth_pdns
	pbp_b13h_auth_cm_ltc
	pbp_b13h_auth_imds
	pbp_b13h_auth_icfmrs
	pbp_b13h_auth_cm
	pbp_b13h_auth_other1
	pbp_b13h_auth_other2
	pbp_b13h_auth_other3
	pbp_b13h_auth_other4
	pbp_b13h_auth_other5
	pbp_b13h_auth_other6
	pbp_b13h_auth_other7
	pbp_b13h_auth_other8
	pbp_b13h_auth_other9
	pbp_b13h_auth_other10
	pbp_b13h_auth_other11
	pbp_b13h_auth_other12
	pbp_b13h_auth_other13
	pbp_b13h_ref_yn
/ missing;
run;

proc contents data = out.pbp_b13_2;
  title 'pbp_b13_2 data';
run;