*pbp_b4.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b4;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b4a_maxenr_yn                $1
	pbp_b4a_maxenr_per               $1
	pbp_b4a_coins_yn                 $1
	pbp_b4a_coins_wavdia_yn          $1
	pbp_b4a_coins_wavdia_dh          $1
	pbp_b4a_ded_yn                   $1
	pbp_b4a_copay_yn                 $1
	pbp_b4a_copay_wavdia_yn          $1
	pbp_b4a_copay_wavdia_mi_dh       $1
	pbp_b4a_ded_er_cstshrs_yn        $1
	pbp_b4a_ded_er_cstshrs           $3
	pbp_b4b_maxenr_yn                $1
	pbp_b4b_maxenr_type              $1
	pbp_b4b_maxenr_per               $1
	pbp_b4b_coins_yn                 $1
	pbp_b4b_coins_wavdmc_yn          $1
	pbp_b4b_coins_wavd_mcdh          $1
	pbp_b4b_ded_yn                   $1
	pbp_b4b_copay_yn                 $1
	pbp_b4b_copay_wavdia_yn          $1
	pbp_b4b_copay_wavd_mcdh          $1
	pbp_b4c_bendesc_yn               $1
	pbp_b4c_bendesc_amo              $1
	pbp_b4c_wwc_maxplan_yn           $1
	pbp_b4c_wwc_maxplan_per          $1
	pbp_b4c_maxenr_yn                $1
	pbp_b4c_maxenr_per               $1
	pbp_b4c_coins_yn                 $1
	pbp_b4c_coins_wavdww_yn          $1
	pbp_b4c_ded_yn                   $1
	pbp_b4c_copay_yn                 $1
	pbp_b4c_copay_wavdww_yn          $1
;

infile '.\pbp\pbp_b4_emerg_urgent.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b4a_maxenr_yn
	pbp_b4a_maxenr_amt
	pbp_b4a_maxenr_per
	pbp_b4a_coins_yn
	pbp_b4a_coins_pct_mc_min
	pbp_b4a_coins_pct_mc_max
	pbp_b4a_coins_wavdia_yn
	pbp_b4a_coins_wavdia_dh
	pbp_b4a_coins_wavd_dh
	pbp_b4a_ded_yn
	pbp_b4a_ded_amt
	pbp_b4a_copay_yn
	pbp_b4a_copay_amt_mc_min
	pbp_b4a_copay_amt_mc_max
	pbp_b4a_copay_wavdia_yn
	pbp_b4a_copay_wavdia_mi_dh
	pbp_b4a_copay_wavd_dh
	pbp_b4a_ded_er_cstshrs_yn
	pbp_b4a_ded_er_cstshrs
	pbp_b4b_maxenr_yn
	pbp_b4b_maxenr_type
	pbp_b4b_maxenr_amt
	pbp_b4b_maxenr_per
	pbp_b4b_coins_yn
	pbp_b4b_coins_pct_mc_min
	pbp_b4b_coins_pct_mc_max
	pbp_b4b_coins_wavdmc_yn
	pbp_b4b_coins_wavd_mcdh
	pbp_b4b_coins_wavdmc_dh
	pbp_b4b_ded_yn
	pbp_b4b_ded_amt
	pbp_b4b_copay_yn
	pbp_b4b_copay_amt_mc_min
	pbp_b4b_copay_amt_mc_max
	pbp_b4b_copay_wavdia_yn
	pbp_b4b_copay_wavd_mcdh
	pbp_b4b_copay_wavdmc_dh
	pbp_b4c_bendesc_yn
	pbp_b4c_bendesc_amo
	pbp_b4c_wwc_maxplan_yn
	pbp_b4c_wwc_maxplan_amt
	pbp_b4c_wwc_maxplan_per
	pbp_b4c_maxenr_yn
	pbp_b4c_maxenr_amt
	pbp_b4c_maxenr_per
	pbp_b4c_coins_yn
	pbp_b4c_coins_pct_ww
	pbp_b4c_coins_wavdww_yn
	pbp_b4c_ded_yn
	pbp_b4c_ded_amt
	pbp_b4c_copay_yn
	pbp_b4c_copay_amt_ww
	pbp_b4c_copay_wavdww_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b4a_maxenr_yn                = 'Emerg Care Max Enr YN'
	pbp_b4a_maxenr_amt               = 'Emerg Care Max Enr Amt'
	pbp_b4a_maxenr_per               = 'Emerg Care Max Enr Per'
	pbp_b4a_coins_yn                 = 'Emerg Care Coinsurance YN'
	pbp_b4a_coins_pct_mc_min         = 'Emerg Care MC Min Coins Pct'
	pbp_b4a_coins_pct_mc_max         = 'Emerg Care MC Max Coins Pct'
	pbp_b4a_coins_wavdia_yn          = 'Emerg Care MC Coins Waived YN'
	pbp_b4a_coins_wavdia_dh          = 'Emerg Care Coins Waived D/H'
	pbp_b4a_coins_wavd_dh            = 'Emerg Care Coins Waived D/H'
	pbp_b4a_ded_yn                   = 'Emerg Care Deductible YN'
	pbp_b4a_ded_amt                  = 'Emerg Care Deductible Amt'
	pbp_b4a_copay_yn                 = 'Emerg Care Copayment YN'
	pbp_b4a_copay_amt_mc_min         = 'Emerg Care MC Min Copay Amt'
	pbp_b4a_copay_amt_mc_max         = 'Emerg Care MC Max Copay Amt'
	pbp_b4a_copay_wavdia_yn          = 'Emerg Care MC Copay Waived YN'
	pbp_b4a_copay_wavdia_mi_dh       = 'Emerg Care Copay Waived D/H'
	pbp_b4a_copay_wavd_dh            = 'Emerg Care Copay Waived D/H'
	pbp_b4a_ded_er_cstshrs_yn        = 'Emerg ER Cst Shr Deductible YN'
	pbp_b4a_ded_er_cstshrs           = 'Emerg ER Cost Shr Deductibles'
	pbp_b4b_maxenr_yn                = 'Urg Care Max Enr YN'
	pbp_b4b_maxenr_type              = 'Urg Care Max Enr Type'
	pbp_b4b_maxenr_amt               = 'Urg Care Max Enr Amt'
	pbp_b4b_maxenr_per               = 'Urg Care Max Enr Per'
	pbp_b4b_coins_yn                 = 'Urg Care Coinsurance YN'
	pbp_b4b_coins_pct_mc_min         = 'Urg Care MC Min Coins Pct'
	pbp_b4b_coins_pct_mc_max         = 'Urg Care MC Max Coins Pct'
	pbp_b4b_coins_wavdmc_yn          = 'Urg Care MC Coins Waived YN'
	pbp_b4b_coins_wavd_mcdh          = 'Urg Care MC Coins Waived D/H'
	pbp_b4b_coins_wavdmc_dh          = 'Urg Care MC Coins Waived D/H'
	pbp_b4b_ded_yn                   = 'Urg Care Deductible YN'
	pbp_b4b_ded_amt                  = 'Urg Care Deductible Amt'
	pbp_b4b_copay_yn                 = 'Urg Care Copayment YN'
	pbp_b4b_copay_amt_mc_min         = 'Urg Care MC Min Copay Amt'
	pbp_b4b_copay_amt_mc_max         = 'Urg Care MC Max Copay Amt'
	pbp_b4b_copay_wavdia_yn          = 'Urg Care Copay Waived (IA) YN'
	pbp_b4b_copay_wavd_mcdh          = 'Urg Care MC Copay Waived D/H'
	pbp_b4b_copay_wavdmc_dh          = 'Urg Care MC Copay Waived D/H'
	pbp_b4c_bendesc_yn               = 'Worldwide Cov Desc YN'
	pbp_b4c_bendesc_amo              = 'Worldwide Cov Desc AMO'
	pbp_b4c_wwc_maxplan_yn           = 'Worldwide Cov MaxPlan YN'
	pbp_b4c_wwc_maxplan_amt          = 'Worldwide Cov MaxPlan Amt'
	pbp_b4c_wwc_maxplan_per          = 'Worldwide Cov MaxPlan Per'
	pbp_b4c_maxenr_yn                = 'Emerg Care Max Enr YN'
	pbp_b4c_maxenr_amt               = 'Emerg Care Max Enr Amt'
	pbp_b4c_maxenr_per               = 'Emerg Care Max Enr Per'
	pbp_b4c_coins_yn                 = 'Emerg Care Coinsurance YN'
	pbp_b4c_coins_pct_ww             = 'Emerg Care WW Coins Pct'
	pbp_b4c_coins_wavdww_yn          = 'WW Coins Waived YN'
	pbp_b4c_ded_yn                   = 'Emerg Care Deductible YN'
	pbp_b4c_ded_amt                  = 'Emerg Care Deductible Amt'
	pbp_b4c_copay_yn                 = 'Emerg Care Copayment YN'
	pbp_b4c_copay_amt_ww             = 'Emerg Care WW Copay Amt'
	pbp_b4c_copay_wavdww_yn          = 'WW Copay Waived YN'
;

run;

proc sort data = pbp_b4 out=out.pbp_b4;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b4(obs = 10);
  title 'pbp_b4_emerg_urgent file ';
run;

proc means data = out.pbp_b4;
  title 'pbp_b4_emerg_urgent file ';
run;

proc freq data = out.pbp_b4;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b4a_maxenr_yn
	pbp_b4a_maxenr_per
	pbp_b4a_coins_yn
	pbp_b4a_coins_wavdia_yn
	pbp_b4a_coins_wavdia_dh
	pbp_b4a_ded_yn
	pbp_b4a_copay_yn
	pbp_b4a_copay_wavdia_yn
	pbp_b4a_copay_wavdia_mi_dh
	pbp_b4a_ded_er_cstshrs_yn
	pbp_b4a_ded_er_cstshrs
	pbp_b4b_maxenr_yn
	pbp_b4b_maxenr_type
	pbp_b4b_maxenr_per
	pbp_b4b_coins_yn
	pbp_b4b_coins_wavdmc_yn
	pbp_b4b_coins_wavd_mcdh
	pbp_b4b_ded_yn
	pbp_b4b_copay_yn
	pbp_b4b_copay_wavdia_yn
	pbp_b4b_copay_wavd_mcdh
	pbp_b4c_bendesc_yn
	pbp_b4c_bendesc_amo
	pbp_b4c_wwc_maxplan_yn
	pbp_b4c_wwc_maxplan_per
	pbp_b4c_maxenr_yn
	pbp_b4c_maxenr_per
	pbp_b4c_coins_yn
	pbp_b4c_coins_wavdww_yn
	pbp_b4c_ded_yn
	pbp_b4c_copay_yn
	pbp_b4c_copay_wavdww_yn
/ missing;
run;

proc contents data = out.pbp_b4;
  title 'pbp_b4 data';
run;