*pbp_mrx_tier.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx_tier;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	mrx_tier_id                      $1
	mrx_tier_label_list              $50
	mrx_tier_type_id                 $1
	mrx_tier_benefit_type            $1
	mrx_tier_drug_type               $6
	mrx_tier_includes                $1
	mrx_tier_cstshr_struct_type      $1
	mrx_tier_locat_in                $3
	mrx_tier_locat_inp               $3
	mrx_tier_locat_oon               $2
	mrx_tier_locat_mo                $3
	mrx_tier_locat_mop               $3
	mrx_tier_locat_ltc               $1
	mrx_tier_extd_days_yn            $1
	mrx_tier_form_model_desc         $255
	mrx_tier_includes_mmp            $1
	mrx_tier_gap_cost_share          $1
	mrx_tier_gap_part_drugs          $1
	mrx_tier_gap_part_includes       $1
;

infile '.\pbp\pbp_mrx_tier.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	mrx_tier_id
	mrx_tier_label_list
	mrx_tier_type_id
	mrx_tier_benefit_type
	mrx_tier_drug_type
	mrx_tier_includes
	mrx_tier_cstshr_struct_type
	mrx_tier_locat_in
	mrx_tier_locat_inp
	mrx_tier_locat_oon
	mrx_tier_locat_mo
	mrx_tier_locat_mop
	mrx_tier_locat_ltc
	mrx_tier_inp_1m_num
	mrx_tier_inp_2m_num
	mrx_tier_inp_3m_num
	mrx_tier_inpp_1m_num
	mrx_tier_inpp_2m_num
	mrx_tier_inpp_3m_num
	mrx_tier_extd_days_yn
	mrx_tier_mo_1m_num
	mrx_tier_mo_2m_num
	mrx_tier_mo_3m_num
	mrx_tier_mopp_1m_num
	mrx_tier_mopp_2m_num
	mrx_tier_mopp_3m_num
	mrx_tier_oonp_1m_num
	mrx_tier_oonp_othnumn
	mrx_tier_ltcp_1m
	mrx_tier_inp_copay_daily
	mrx_tier_inp_copay_1m
	mrx_tier_inp_copay_2m
	mrx_tier_inp_copay_3m
	mrx_tier_inp_coins_avg_1m
	mrx_tier_inp_coins_1m
	mrx_tier_inp_coins_2m
	mrx_tier_inp_coins_3m
	mrx_tier_inpp_copay_daily
	mrx_tier_inpp_copay_1m
	mrx_tier_inpp_copay_2m
	mrx_tier_inpp_copay_3m
	mrx_tier_inpp_coins_avg_1m
	mrx_tier_inpp_coins_1m
	mrx_tier_inpp_coins_2m
	mrx_tier_inpp_coins_3m
	mrx_tier_innpp_copay_daily
	mrx_tier_innpp_copay_1m
	mrx_tier_innpp_copay_2m
	mrx_tier_innpp_copay_3m
	mrx_tier_innpp_coins_avg_1m
	mrx_tier_innpp_coins_1m
	mrx_tier_innpp_coins_2m
	mrx_tier_innpp_coins_3m
	mrx_tier_mo_copay_daily
	mrx_tier_mo_copay_1m
	mrx_tier_mo_copay_2m
	mrx_tier_mo_copay_3m
	mrx_tier_mo_coins_1m
	mrx_tier_mo_coins_2m
	mrx_tier_mo_coins_3m
	mrx_tier_mopp_copay_daily
	mrx_tier_mopp_copay_1m
	mrx_tier_mopp_copay_2m
	mrx_tier_mopp_copay_3m
	mrx_tier_mopp_coins_1m
	mrx_tier_mopp_coins_2m
	mrx_tier_mopp_coins_3m
	mrx_tier_monpp_copay_daily
	mrx_tier_monpp_copay_1m
	mrx_tier_monpp_copay_2m
	mrx_tier_monpp_copay_3m
	mrx_tier_monpp_coins_1m
	mrx_tier_monpp_coins_2m
	mrx_tier_monpp_coins_3m
	mrx_tier_oonp_copay_1m
	mrx_tier_oonp_copay_othnum
	mrx_tier_oonp_coins_1m
	mrx_tier_oonp_coins_othnum
	mrx_tier_ltcp_copay_daily
	mrx_tier_ltcp_copay_1m
	mrx_tier_ltcp_coins_1m
	mrx_tier_form_model_desc
	mrx_tier_includes_mmp
	mrx_tier_copay_amt_inp_mmpmin
	mrx_tier_copay_amt_inp_mmpmax
	mrx_tier_copay_amt_oon_mmpmin
	mrx_tier_copay_amt_oon_mmpmax
	mrx_tier_copay_amt_mo_mmpmin
	mrx_tier_copay_amt_mo_mmpmax
	mrx_tier_copay_amt_ltc_mmpmin
	mrx_tier_copay_amt_ltc_mmpmax
	mrx_tier_gap_cost_share
	mrx_tier_gap_part_drugs
	mrx_tier_gap_part_includes
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	mrx_tier_id                      = 'MRx Tier ID'
	mrx_tier_label_list              = 'MRx Tier Label Description'
	mrx_tier_type_id                 = 'MRx Tier Type ID'
	mrx_tier_benefit_type            = 'MRx Drug Benefit Type - Tier'
	mrx_tier_drug_type               = 'MRx Tier Drug Types'
	mrx_tier_includes                = 'MRx Tier Includes'
	mrx_tier_cstshr_struct_type      = 'MRx Cost Share Tier Struct'
	mrx_tier_locat_in                = 'In-Network Retail Pharmacy Loc'
	mrx_tier_locat_inp               = 'In-Ntwk Pef/NonPref Retail Loc'
	mrx_tier_locat_oon               = 'Out-of-Network Loc'
	mrx_tier_locat_mo                = 'MO Pharmacy Locations'
	mrx_tier_locat_mop               = 'MO Pre/Non-Pref Pharmacy Locat'
	mrx_tier_locat_ltc               = 'LTC Pharmacy Locations'
	mrx_tier_inp_1m_num              = 'MRx Tier INP 1M Supply Days'
	mrx_tier_inp_2m_num              = 'MRx Tier INP 2M Supply Days'
	mrx_tier_inp_3m_num              = 'MRx Tier INP 3M Supply Days'
	mrx_tier_inpp_1m_num             = 'MRx Tier INPP 1M Supply Days'
	mrx_tier_inpp_2m_num             = 'MRx Tier INPP 2M Supply Days'
	mrx_tier_inpp_3m_num             = 'MRx Tier INPP 3M Supply Days'
	mrx_tier_extd_days_yn            = 'MRx Tier Extended Day Supply'
	mrx_tier_mo_1m_num               = 'MRx Tier MO 1M Supply Days'
	mrx_tier_mo_2m_num               = 'MRx Tier MO 2M Supply Days'
	mrx_tier_mo_3m_num               = 'MRx Tier MO 3M Supply Days'
	mrx_tier_mopp_1m_num             = 'MRx Tier MOPP 1M Supply Days'
	mrx_tier_mopp_2m_num             = 'MRx Tier MOPP 2M Supply Days'
	mrx_tier_mopp_3m_num             = 'MRx Tier MOPP 3M Supply Days'
	mrx_tier_oonp_1m_num             = 'MRx Tier OONP 1M Supply Days'
	mrx_tier_oonp_othnumn            = 'MRx Tier OONP Oth Supply Days'
	mrx_tier_ltcp_1m                 = 'LTC Tier 1M Num Days'
	mrx_tier_inp_copay_daily         = 'INP Daily Copay'
	mrx_tier_inp_copay_1m            = 'MRx Tier INP Copay 1M'
	mrx_tier_inp_copay_2m            = 'MRx Tier INP Copay 2M'
	mrx_tier_inp_copay_3m            = 'MRx Tier INP Copay 3M'
	mrx_tier_inp_coins_avg_1m        = 'INP Avg Expect 1M Coins'
	mrx_tier_inp_coins_1m            = 'MRx Tier INP Coins 1M'
	mrx_tier_inp_coins_2m            = 'MRx Tier INP Coins 2M'
	mrx_tier_inp_coins_3m            = 'MRx Tier INP Coins 3M'
	mrx_tier_inpp_copay_daily        = 'INPP Daily Copay'
	mrx_tier_inpp_copay_1m           = 'MRx Tier INPP Copay 1M'
	mrx_tier_inpp_copay_2m           = 'MRx Tier INPP Copay 2M'
	mrx_tier_inpp_copay_3m           = 'MRx Tier INPP Copay 3M'
	mrx_tier_inpp_coins_avg_1m       = 'INPP Avg Expect 1M Coins'
	mrx_tier_inpp_coins_1m           = 'MRx Tier INPP Coins 1M'
	mrx_tier_inpp_coins_2m           = 'MRx Tier INPP Coins 2M'
	mrx_tier_inpp_coins_3m           = 'MRx Tier INPP Coins 3M'
	mrx_tier_innpp_copay_daily       = 'INNPP Daily Copay'
	mrx_tier_innpp_copay_1m          = 'MRx Tier INNPP Copay 1M'
	mrx_tier_innpp_copay_2m          = 'MRx Tier INNPP Copay 2M'
	mrx_tier_innpp_copay_3m          = 'MRx Tier INNPP Copay 3M'
	mrx_tier_innpp_coins_avg_1m      = 'INNPP Avg Expect 1M Coins'
	mrx_tier_innpp_coins_1m          = 'MRx Tier INNPP Coins 1M'
	mrx_tier_innpp_coins_2m          = 'MRx Tier INNPP Coins 2M'
	mrx_tier_innpp_coins_3m          = 'MRx Tier INNPP Coins 3M'
	mrx_tier_mo_copay_daily          = 'MO Daily Copay'
	mrx_tier_mo_copay_1m             = 'MRx Tier MO Copay 1M'
	mrx_tier_mo_copay_2m             = 'MRx Tier MO Copay 2M'
	mrx_tier_mo_copay_3m             = 'MRx Tier MO Copay 3M'
	mrx_tier_mo_coins_1m             = 'MRx Tier MO Coins 1M'
	mrx_tier_mo_coins_2m             = 'MRx Tier MO Coins 2M'
	mrx_tier_mo_coins_3m             = 'MRx Tier MO Coins 3M'
	mrx_tier_mopp_copay_daily        = 'MOPP Daily Copay'
	mrx_tier_mopp_copay_1m           = 'MRx Tier MOPP Copay 1M'
	mrx_tier_mopp_copay_2m           = 'MRx Tier MOPP Copay 2M'
	mrx_tier_mopp_copay_3m           = 'MRx Tier MOPP Copay 3M'
	mrx_tier_mopp_coins_1m           = 'MRx Tier MOPP Coins 1M'
	mrx_tier_mopp_coins_2m           = 'MRx Tier MOPP Coins 2M'
	mrx_tier_mopp_coins_3m           = 'MRx Tier MOPP Coins 3M'
	mrx_tier_monpp_copay_daily       = 'MONPP Daily Copay'
	mrx_tier_monpp_copay_1m          = 'MRx Tier MONPP Copay 1M'
	mrx_tier_monpp_copay_2m          = 'MRx Tier MONPP Copay 2M'
	mrx_tier_monpp_copay_3m          = 'MRx Tier MONPP Copay 3M'
	mrx_tier_monpp_coins_1m          = 'MRx Tier MONPP Coins 1M'
	mrx_tier_monpp_coins_2m          = 'MRx Tier MONPP Coins 2M'
	mrx_tier_monpp_coins_3m          = 'MRx Tier MONPP Coins 3M'
	mrx_tier_oonp_copay_1m           = 'MRx Tier OONP Copay 1M'
	mrx_tier_oonp_copay_othnum       = 'MRx Tier OONP Copay Oth'
	mrx_tier_oonp_coins_1m           = 'MRx Tier OONP Coins 1M'
	mrx_tier_oonp_coins_othnum       = 'MRx Tier OONP Coins Oth'
	mrx_tier_ltcp_copay_daily        = 'LTCP Brand Daily Copay'
	mrx_tier_ltcp_copay_1m           = 'LTCP Brand Copay 1M'
	mrx_tier_ltcp_coins_1m           = 'LTC Pharmacy Coins 1M'
	mrx_tier_form_model_desc         = 'Tier Label Description(s)'
	mrx_tier_includes_mmp            = 'MMP Pre-ICL Tier Includes'
	mrx_tier_copay_amt_inp_mmpmin    = 'MMP INP Retail Copay Min Amt'
	mrx_tier_copay_amt_inp_mmpmax    = 'MMP INP Retail Copay Max Amt'
	mrx_tier_copay_amt_oon_mmpmin    = 'MMP OON Copay Min Amt'
	mrx_tier_copay_amt_oon_mmpmax    = 'MMP OON Copay Max Amt'
	mrx_tier_copay_amt_mo_mmpmin     = 'MMP MO Copay Min Amt'
	mrx_tier_copay_amt_mo_mmpmax     = 'MMP MO Copay Max Amt'
	mrx_tier_copay_amt_ltc_mmpmin    = 'MMP LTC Copay Min Amt'
	mrx_tier_copay_amt_ltc_mmpmax    = 'MMP LTC Copay Max Amt'
	mrx_tier_gap_cost_share          = 'MRx Tier Gap Cost Share'
	mrx_tier_gap_part_drugs          = 'Part Gap Tier Drug Types'
	mrx_tier_gap_part_includes       = 'Part Gap Tier Includes'
;

run;

proc sort data = pbp_mrx_tier out=out.pbp_mrx_tier;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx_tier(obs = 10);
  title 'pbp_mrx_tier file ';
run;

proc means data = out.pbp_mrx_tier;
  title 'pbp_mrx_tier file ';
run;

proc freq data = out.pbp_mrx_tier;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	mrx_tier_id
	mrx_tier_type_id
	mrx_tier_benefit_type
	mrx_tier_includes
	mrx_tier_cstshr_struct_type
	mrx_tier_locat_in
	mrx_tier_locat_inp
	mrx_tier_locat_oon
	mrx_tier_locat_mo
	mrx_tier_locat_mop
	mrx_tier_locat_ltc
	mrx_tier_extd_days_yn
	mrx_tier_includes_mmp
	mrx_tier_gap_cost_share
	mrx_tier_gap_part_drugs
	mrx_tier_gap_part_includes
/ missing;
run;

proc contents data = out.pbp_mrx_tier;
  title 'pbp_mrx_tier data';
run;