*pbp_step18b.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_step18b;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b18b_bendesc_yn              $1
	pbp_b18b_bendesc_enh             $4
	pbp_b18b_bendesc_amo_at          $1
	pbp_b18b_bendesc_lim_at          $1
	pbp_b18b_bendesc_per_at          $1
	pbp_b18b_bendesc_amo_ie          $1
	pbp_b18b_bendesc_lim_ie          $1
	pbp_b18b_bendesc_per_ie          $1
	pbp_b18b_bendesc_amo_oe          $1
	pbp_b18b_bendesc_lim_oe          $1
	pbp_b18b_bendesc_per_oe          $1
	pbp_b18b_bendesc_amo_ote         $1
	pbp_b18b_bendesc_lim_ote         $1
	pbp_b18b_bendesc_per_ote         $1
	pbp_b18b_maxplan_yn              $1
	pbp_b18b_maxplan_in_oon          $1
	pbp_b18b_maxplan_type            $1
	pbp_b18b_maxplan_per             $1
	pbp_b18b_maxenr_yn               $1
	pbp_b18b_maxenr_type             $1
	pbp_b18b_maxenr_per              $1
	pbp_b18b_coins_yn                $1
	pbp_b18b_coins_ehc               $3
	pbp_b18b_copay_yn                $1
	pbp_b18b_copay_ehc               $3
	pbp_b18b_ded_yn                  $1
	pbp_b18b_auth                    $5
	pbp_b18b_refer_yn                $1
	pbp_d_opt_identifier             $3
;

infile '.\pbp\pbp_step18b.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b18b_bendesc_yn
	pbp_b18b_bendesc_enh
	pbp_b18b_bendesc_amo_at
	pbp_b18b_bendesc_lim_at
	pbp_b18b_bendesc_numv_at
	pbp_b18b_bendesc_per_at
	pbp_b18b_bendesc_amo_ie
	pbp_b18b_bendesc_lim_ie
	pbp_b18b_bendesc_numv_ie
	pbp_b18b_bendesc_per_ie
	pbp_b18b_bendesc_amo_oe
	pbp_b18b_bendesc_lim_oe
	pbp_b18b_bendesc_numv_oe
	pbp_b18b_bendesc_per_oe
	pbp_b18b_bendesc_amo_ote
	pbp_b18b_bendesc_lim_ote
	pbp_b18b_bendesc_numv_ote
	pbp_b18b_bendesc_per_ote
	pbp_b18b_maxplan_yn
	pbp_b18b_maxplan_in_oon
	pbp_b18b_maxplan_type
	pbp_b18b_maxplan_amt
	pbp_b18b_maxplan_per
	pbp_b18b_maxenr_yn
	pbp_b18b_maxenr_type
	pbp_b18b_maxenr_amt
	pbp_b18b_maxenr_per
	pbp_b18b_coins_yn
	pbp_b18b_coins_pct_at
	pbp_b18b_coins_ehc
	pbp_b18b_coins_pct_ie
	pbp_b18b_coins_pct_oe
	pbp_b18b_coins_pct_ote
	pbp_b18b_copay_yn
	pbp_b18b_copay_at_min_amt
	pbp_b18b_copay_at_max_amt
	pbp_b18b_copay_ehc
	pbp_b18b_copay_amt_per_ie
	pbp_b18b_copay_amt_per2_ie
	pbp_b18b_copay_amt_per_oe
	pbp_b18b_copay_amt_per2_oe
	pbp_b18b_copay_amt_per_ote
	pbp_b18b_copay_amt_per2_ote
	pbp_b18b_ded_yn
	pbp_b18b_ded_amt
	pbp_b18b_auth
	pbp_b18b_refer_yn
	pbp_d_opt_identifier
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b18b_bendesc_yn              = 'Hearing Aids Ben Desc YN'
	pbp_b18b_bendesc_enh             = 'Hearing Aids Ben Desc Enhance'
	pbp_b18b_bendesc_amo_at          = 'Hearing Aids AT Ben Desc AMO'
	pbp_b18b_bendesc_lim_at          = 'Hearing Aids AT Ben Desc Lim'
	pbp_b18b_bendesc_numv_at         = 'Hearing Aids AT Ben Desc Num'
	pbp_b18b_bendesc_per_at          = 'Hearing Aids AT Ben Desc Per'
	pbp_b18b_bendesc_amo_ie          = 'Hearing Aids IE Ben Desc AMO'
	pbp_b18b_bendesc_lim_ie          = 'Hearing Aids IE Ben Desc Lim'
	pbp_b18b_bendesc_numv_ie         = 'Hearing Aids IE Ben Desc Num'
	pbp_b18b_bendesc_per_ie          = 'Hearing Aids IE Ben Desc Per'
	pbp_b18b_bendesc_amo_oe          = 'Hearing Aids OE Ben Desc AMO'
	pbp_b18b_bendesc_lim_oe          = 'Hearing Aids OE Ben Desc Lim'
	pbp_b18b_bendesc_numv_oe         = 'Hearing Aids OE Ben Desc Num'
	pbp_b18b_bendesc_per_oe          = 'Hearing Aids OE Ben Desc Per'
	pbp_b18b_bendesc_amo_ote         = 'Hearing Aids OTE Ben Desc AMO'
	pbp_b18b_bendesc_lim_ote         = 'Hearing Aids OTE Ben Desc Lim'
	pbp_b18b_bendesc_numv_ote        = 'Hearing Aids OTE Ben Desc Num'
	pbp_b18b_bendesc_per_ote         = 'Hearing Aids OTE Ben Desc Per'
	pbp_b18b_maxplan_yn              = 'Hearing Aids Max Plan YN'
	pbp_b18b_maxplan_in_oon          = 'In or Out'
	pbp_b18b_maxplan_type            = 'Hearing Aids Max Plan Type'
	pbp_b18b_maxplan_amt             = 'Hearing Aids Max Plan Amt'
	pbp_b18b_maxplan_per             = 'Hearing Aids Max Plan Per'
	pbp_b18b_maxenr_yn               = 'Hearing Aids Max Enr YN'
	pbp_b18b_maxenr_type             = 'Hearing Aids Max Enr Type'
	pbp_b18b_maxenr_amt              = 'Hearing Aids Max Enr Amt'
	pbp_b18b_maxenr_per              = 'Hearing Aids Max Enr Per'
	pbp_b18b_coins_yn                = 'Hearing Aids Coinsurance YN'
	pbp_b18b_coins_pct_at            = 'Hearing Aids AT Coins Pct'
	pbp_b18b_coins_ehc               = 'Hearing Aids Benefits Coins'
	pbp_b18b_coins_pct_ie            = 'Hearing Aids IE Coins Pct'
	pbp_b18b_coins_pct_oe            = 'Hearing Aids OE Coins Pct'
	pbp_b18b_coins_pct_ote           = 'Hearing Aids OTE Coins Pct'
	pbp_b18b_copay_yn                = 'Hearing Aids Copayment YN'
	pbp_b18b_copay_at_min_amt        = 'Hearing Aids AT Min Copay Amt'
	pbp_b18b_copay_at_max_amt        = 'Hearing Aids AT Max Copay Amt'
	pbp_b18b_copay_ehc               = 'Hearing Aids Benefits Copay'
	pbp_b18b_copay_amt_per_ie        = 'Hearing Aids IE Copay Amt'
	pbp_b18b_copay_amt_per2_ie       = 'Hearing Aids 2 IE Copay Amt'
	pbp_b18b_copay_amt_per_oe        = 'Hearing Aids OE Copay Amt'
	pbp_b18b_copay_amt_per2_oe       = 'Hearing Aids 2 OE Copay Amt'
	pbp_b18b_copay_amt_per_ote       = 'Hearing Aids OTE Copay Amt'
	pbp_b18b_copay_amt_per2_ote      = 'Hearing Aids 2 OTE Copay Amt'
	pbp_b18b_ded_yn                  = 'Hearing Aids Deductible YN'
	pbp_b18b_ded_amt                 = 'Hearing Aids Deductible Amt'
	pbp_b18b_auth                    = 'Hearing Aids Enrollee Auth'
	pbp_b18b_refer_yn                = 'Hearing Aids Referral YN'
	pbp_d_opt_identifier             = 'Opt Sup Benefits Identifier'
;

run;

proc sort data = pbp_step18b out=out.pbp_step18b;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_step18b(obs = 10);
  title 'pbp_step18b file ';
run;

proc means data = out.pbp_step18b;
  title 'pbp_step18b file ';
run;

proc freq data = out.pbp_step18b;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b18b_bendesc_yn
	pbp_b18b_bendesc_enh
	pbp_b18b_bendesc_amo_at
	pbp_b18b_bendesc_lim_at
	pbp_b18b_bendesc_per_at
	pbp_b18b_bendesc_amo_ie
	pbp_b18b_bendesc_lim_ie
	pbp_b18b_bendesc_per_ie
	pbp_b18b_bendesc_amo_oe
	pbp_b18b_bendesc_lim_oe
	pbp_b18b_bendesc_per_oe
	pbp_b18b_bendesc_amo_ote
	pbp_b18b_bendesc_lim_ote
	pbp_b18b_bendesc_per_ote
	pbp_b18b_maxplan_yn
	pbp_b18b_maxplan_in_oon
	pbp_b18b_maxplan_type
	pbp_b18b_maxplan_per
	pbp_b18b_maxenr_yn
	pbp_b18b_maxenr_type
	pbp_b18b_maxenr_per
	pbp_b18b_coins_yn
	pbp_b18b_coins_ehc
	pbp_b18b_copay_yn
	pbp_b18b_copay_ehc
	pbp_b18b_ded_yn
	pbp_b18b_auth
	pbp_b18b_refer_yn
	pbp_d_opt_identifier
/ missing;
run;

proc contents data = out.pbp_step18b;
  title 'pbp_step18b data';
run;