*pbp_step7b.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_step7b;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b7b_bendesc_yn               $1
	pbp_b7b_bendesc_rc               $1
	pbp_b7b_bendesc_amo              $1
	pbp_b7b_bendesc_lim_rc           $1
	pbp_b7b_bendesc_per              $1
	pbp_b7b_maxplan_yn               $1
	pbp_b7b_maxplan_per              $1
	pbp_b7b_maxenr_yn                $1
	pbp_b7b_maxenr_per               $1
	pbp_b7b_coins_yn                 $1
	pbp_b7b_coins_ehc                $2
	pbp_b7b_ded_yn                   $1
	pbp_b7b_copay_yn                 $1
	pbp_b7b_copay_ehc                $2
	pbp_b7b_auth                     $5
	pbp_b7b_refer_yn                 $1
	pbp_d_opt_identifier             $3
;

infile '.\pbp\pbp_step7b.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b7b_bendesc_yn
	pbp_b7b_bendesc_rc
	pbp_b7b_bendesc_amo
	pbp_b7b_bendesc_lim_rc
	pbp_b7b_bendesc_num_rc
	pbp_b7b_bendesc_per
	pbp_b7b_maxplan_yn
	pbp_b7b_maxplan_amt
	pbp_b7b_maxplan_per
	pbp_b7b_maxenr_yn
	pbp_b7b_maxenr_amt
	pbp_b7b_maxenr_per
	pbp_b7b_coins_yn
	pbp_b7b_coins_ehc
	pbp_b7b_coins_pct_mc_min
	pbp_b7b_coins_pct_mc_max
	pbp_b7b_coins_pct_cc_min
	pbp_b7b_coins_pct_cc_max
	pbp_b7b_ded_yn
	pbp_b7b_ded_amt
	pbp_b7b_copay_yn
	pbp_b7b_copay_ehc
	pbp_b7b_copay_mc_amt_min
	pbp_b7b_copay_mc_amt_max
	pbp_b7b_copay_rc_amt_min
	pbp_b7b_copay_rc_amt_max
	pbp_b7b_auth
	pbp_b7b_refer_yn
	pbp_d_opt_identifier
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b7b_bendesc_yn               = 'Chiropractic Ben Desc YN'
	pbp_b7b_bendesc_rc               = 'Chiropractic Ben Desc Enhance'
	pbp_b7b_bendesc_amo              = 'Chiropractic Ben Desc AMO'
	pbp_b7b_bendesc_lim_rc           = 'Chiropractic Ben Desc Lim'
	pbp_b7b_bendesc_num_rc           = 'Chiropractic Ben Desc Num'
	pbp_b7b_bendesc_per              = 'Chiropractic Ben Desc Per'
	pbp_b7b_maxplan_yn               = 'Chiropractic Max Plan YN'
	pbp_b7b_maxplan_amt              = 'Chiropractic Max Plan Amt'
	pbp_b7b_maxplan_per              = 'Chiropractic Max Plan Per'
	pbp_b7b_maxenr_yn                = 'Chiropractic Max Enr YN'
	pbp_b7b_maxenr_amt               = 'Chiropractic Max Enr Amt'
	pbp_b7b_maxenr_per               = 'Chiropractic Max Enr Per'
	pbp_b7b_coins_yn                 = 'Chiropractic Coinsurance YN'
	pbp_b7b_coins_ehc                = 'Chiro Coins Enhance Benefits'
	pbp_b7b_coins_pct_mc_min         = 'Chiropractic MC Min Coins Pct'
	pbp_b7b_coins_pct_mc_max         = 'Chiropractic MC Max Coins Pct'
	pbp_b7b_coins_pct_cc_min         = 'Chiropractic RC Min Coins Pct'
	pbp_b7b_coins_pct_cc_max         = 'Chiropractic RC Max Coins Pct'
	pbp_b7b_ded_yn                   = 'Chiropractic Deductible YN'
	pbp_b7b_ded_amt                  = 'Chiropractic Deductible Amt'
	pbp_b7b_copay_yn                 = 'Chiropractic Copayment YN'
	pbp_b7b_copay_ehc                = 'Chiro Copay Enhanc Benefits'
	pbp_b7b_copay_mc_amt_min         = 'Chiropractic MC Min Copay Amt'
	pbp_b7b_copay_mc_amt_max         = 'Chiropractic MC Max Copay Amt'
	pbp_b7b_copay_rc_amt_min         = 'Chiropractic RC Min Copay Amt'
	pbp_b7b_copay_rc_amt_max         = 'Chiropractic RC Max Copay Amt'
	pbp_b7b_auth                     = 'Chiropractic Auth'
	pbp_b7b_refer_yn                 = 'Chiropractic Referral YN'
	pbp_d_opt_identifier             = 'Opt Sup Benefits Identifier'
;

run;

proc sort data = pbp_step7b out=out.pbp_step7b;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_step7b(obs = 10);
  title 'pbp_step7b file ';
run;

proc means data = out.pbp_step7b;
  title 'pbp_step7b file ';
run;

proc freq data = out.pbp_step7b;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b7b_bendesc_yn
	pbp_b7b_bendesc_rc
	pbp_b7b_bendesc_amo
	pbp_b7b_bendesc_lim_rc
	pbp_b7b_bendesc_per
	pbp_b7b_maxplan_yn
	pbp_b7b_maxplan_per
	pbp_b7b_maxenr_yn
	pbp_b7b_maxenr_per
	pbp_b7b_coins_yn
	pbp_b7b_coins_ehc
	pbp_b7b_ded_yn
	pbp_b7b_copay_yn
	pbp_b7b_copay_ehc
	pbp_b7b_auth
	pbp_b7b_refer_yn
	pbp_d_opt_identifier
/ missing;
run;

proc contents data = out.pbp_step7b;
  title 'pbp_step7b data';
run;