*pbp_b14.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b14;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b14a_mc_prevent_attest       $1
	pbp_b14a_auth                    $5
	pbp_b14a_refer_yn                $1
	pbp_b14b_bendesc_yn              $1
	pbp_b14b_bendesc_rpe_amo         $1
	pbp_b14b_maxplan_yn              $1
	pbp_b14b_maxenr_yn               $1
	pbp_b14b_coins_yn                $1
	pbp_b14b_ded_yn                  $1
	pbp_b14b_copay_yn                $1
	pbp_b14b_auth                    $5
	pbp_b14b_refer_yn                $1
	pbp_b14c_bendesc_yn              $1
	pbp_b14c_bendesc_ehc             $16
	pbp_b14c_bendesc_amo_hec         $1
	pbp_b14c_bendesc_amo_ntb         $1
	pbp_b14c_bendesc_amo_sc          $1
	pbp_b14c_bendesc_amo_mhc         $1
	pbp_b14c_bendesc_amo_nhl         $1
	pbp_b14c_bendesc_amo_edm         $1
	pbp_b14c_bendesc_amo_tm          $1
	pbp_b14c_bendesc_amo_wpt         $1
	pbp_b14c_bendesc_amo_bsd         $1
	pbp_b14c_bendesc_amo_cs          $1
	pbp_b14c_bendesc_amo_isa         $1
	pbp_b14c_bendesc_amo_prs         $1
	pbp_b14c_bendesc_amo_mnt         $1
	pbp_b14c_bendesc_amo_imr         $1
	pbp_b14c_bendesc_amo_rp          $1
	pbp_b14c_bendesc_amo_wig         $1
	pbp_b14c_maxplan_yn              $1
	pbp_b14c_maxplan_per             $1
	pbp_b14c_maxenr_yn               $1
	pbp_b14c_maxenr_per              $1
	pbp_b14c_coins_yn                $1
	pbp_b14c_coins_ehc               $16
	pbp_b14c_ded_yn                  $1
	pbp_b14c_copay_yn                $1
	pbp_b14c_copay_ehc               $16
	pbp_b14c_auth                    $5
	pbp_b14c_refer_yn                $1
	pbp_b14d_maxenr_yn               $1
	pbp_b14d_maxenr_per              $1
	pbp_b14d_coins_yn                $1
	pbp_b14d_ded_yn                  $1
	pbp_b14d_copay_yn                $1
	pbp_b14d_auth                    $5
	pbp_b14d_refer_yn                $1
	pbp_b14e_maxenr_yn               $1
	pbp_b14e_maxenr_per              $1
	pbp_b14e_coins_yn                $1
	pbp_b14e_ded_yn                  $1
	pbp_b14e_copay_yn                $1
	pbp_b14e_cost_share              $1
	pbp_b14e_cost_share_coins_yn     $1
	pbp_b14e_cost_share_copay_yn     $1
	pbp_b14e_auth                    $5
	pbp_b14e_refer_yn                $1
;

infile '.\pbp\pbp_b14_preventive.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b14a_mc_prevent_attest
	pbp_b14a_auth
	pbp_b14a_refer_yn
	pbp_b14b_bendesc_yn
	pbp_b14b_bendesc_rpe_amo
	pbp_b14b_maxplan_yn
	pbp_b14b_maxplan_amt
	pbp_b14b_maxenr_yn
	pbp_b14b_maxenr_amt
	pbp_b14b_coins_yn
	pbp_b14b_coins_pct_rpe
	pbp_b14b_ded_yn
	pbp_b14b_ded_amt
	pbp_b14b_copay_yn
	pbp_b14b_copay_amt_rpe
	pbp_b14b_auth
	pbp_b14b_refer_yn
	pbp_b14c_bendesc_yn
	pbp_b14c_bendesc_ehc
	pbp_b14c_bendesc_amo_hec
	pbp_b14c_bendesc_amo_ntb
	pbp_b14c_bendesc_amo_sc
	pbp_b14c_bendesc_amo_mhc
	pbp_b14c_bendesc_amo_nhl
	pbp_b14c_bendesc_amo_edm
	pbp_b14c_bendesc_amo_tm
	pbp_b14c_bendesc_amo_wpt
	pbp_b14c_bendesc_amo_bsd
	pbp_b14c_bendesc_amo_cs
	pbp_b14c_bendesc_amo_isa
	pbp_b14c_bendesc_amo_prs
	pbp_b14c_bendesc_amo_mnt
	pbp_b14c_bendesc_amo_imr
	pbp_b14c_bendesc_amo_rp
	pbp_b14c_bendesc_amo_wig
	pbp_b14c_maxplan_yn
	pbp_b14c_maxplan_amt
	pbp_b14c_maxplan_per
	pbp_b14c_maxenr_yn
	pbp_b14c_maxenr_amt
	pbp_b14c_maxenr_per
	pbp_b14c_coins_yn
	pbp_b14c_coins_ehc
	pbp_b14c_coins_pct_min_hec
	pbp_b14c_coins_pct_max_hec
	pbp_b14c_coins_pct_ntb
	pbp_b14c_coins_pct_sc
	pbp_b14c_coins_pct_min_mhc
	pbp_b14c_coins_pct_max_mhc
	pbp_b14c_coins_pct_nhl
	pbp_b14c_coins_pct_edm
	pbp_b14c_coins_pct_tm
	pbp_b14c_coins_pct_wpt
	pbp_b14c_coins_pct_min_bsd
	pbp_b14c_coins_pct_max_bsd
	pbp_b14c_coins_pct_min_cs
	pbp_b14c_coins_pct_max_cs
	pbp_b14c_coins_pct_min_isa
	pbp_b14c_coins_pct_max_isa
	pbp_b14c_coins_pct_min_prs
	pbp_b14c_coins_pct_max_prs
	pbp_b14c_coins_pct_min_mnt
	pbp_b14c_coins_pct_max_mnt
	pbp_b14c_coins_pct_min_imr
	pbp_b14c_coins_pct_max_imr
	pbp_b14c_coins_pct_min_rp
	pbp_b14c_coins_pct_max_rp
	pbp_b14c_coins_pct_min_wig
	pbp_b14c_coins_pct_max_wig
	pbp_b14c_ded_yn
	pbp_b14c_ded_amt
	pbp_b14c_copay_yn
	pbp_b14c_copay_ehc
	pbp_b14c_copay_hec_amt
	pbp_b14c_copay_ntb_amt
	pbp_b14c_copay_sc_amt
	pbp_b14c_copay_mhc_min_amt
	pbp_b14c_copay_mhc_max_amt
	pbp_b14c_copay_nhl_amt
	pbp_b14c_copay_edm_amt
	pbp_b14c_copay_tm_amt
	pbp_b14c_copay_wpt_amt
	pbp_b14c_copay_bsd_min_amt
	pbp_b14c_copay_bsd_max_amt
	pbp_b14c_copay_cs_min_amt
	pbp_b14c_copay_cs_max_amt
	pbp_b14c_copay_isa_min_amt
	pbp_b14c_copay_isa_max_amt
	pbp_b14c_copay_prs_min_amt
	pbp_b14c_copay_prs_max_amt
	pbp_b14c_copay_mnt_min_amt
	pbp_b14c_copay_mnt_max_amt
	pbp_b14c_copay_imr_min_amt
	pbp_b14c_copay_imr_max_amt
	pbp_b14c_copay_rp_min_amt
	pbp_b14c_copay_rp_max_amt
	pbp_b14c_copay_wig_min_amt
	pbp_b14c_copay_wig_max_amt
	pbp_b14c_auth
	pbp_b14c_refer_yn
	pbp_b14d_maxenr_yn
	pbp_b14d_maxenr_amt
	pbp_b14d_maxenr_per
	pbp_b14d_coins_yn
	pbp_b14d_coins_mc_min_pct
	pbp_b14d_coins_mc_max_pct
	pbp_b14d_ded_yn
	pbp_b14d_ded_amt
	pbp_b14d_copay_yn
	pbp_b14d_copay_mc_min_amt
	pbp_b14d_copay_mc_max_amt
	pbp_b14d_auth
	pbp_b14d_refer_yn
	pbp_b14e_maxenr_yn
	pbp_b14e_maxenr_amt
	pbp_b14e_maxenr_per
	pbp_b14e_coins_yn
	pbp_b14e_coins_pct
	pbp_b14e_coins_max_pct
	pbp_b14e_ded_yn
	pbp_b14e_ded_amt
	pbp_b14e_copay_yn
	pbp_b14e_copay_mc_min_amt
	pbp_b14e_copay_mc_max_amt
	pbp_b14e_cost_share
	pbp_b14e_cost_share_coins_yn
	pbp_b14e_cost_share_coins_min
	pbp_b14e_cost_share_coins_max
	pbp_b14e_cost_share_copay_yn
	pbp_b14e_cost_share_copay_min
	pbp_b14e_cost_share_copay_max
	pbp_b14e_auth
	pbp_b14e_refer_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b14a_mc_prevent_attest       = '14A MC Prevent Srvcs attest'
	pbp_b14a_auth                    = 'Auth required?'
	pbp_b14a_refer_yn                = 'Referral required?'
	pbp_b14b_bendesc_yn              = 'Supp Prevent  Ben Desc YN'
	pbp_b14b_bendesc_rpe_amo         = 'Annual Phys Exams Ben Desc MO'
	pbp_b14b_maxplan_yn              = 'Mammography Max Plan YN'
	pbp_b14b_maxplan_amt             = 'Mammography Max Plan Amt'
	pbp_b14b_maxenr_yn               = 'Immunizations Max Enr YN'
	pbp_b14b_maxenr_amt              = 'Immunizations Max Enr Amt'
	pbp_b14b_coins_yn                = 'Immunizations Coinsurance YN'
	pbp_b14b_coins_pct_rpe           = 'Routine Phys Coins Pct'
	pbp_b14b_ded_yn                  = 'Immunizations Deductible YN'
	pbp_b14b_ded_amt                 = 'Immunizations Deductible Amt'
	pbp_b14b_copay_yn                = 'Immunizations Copayment YN'
	pbp_b14b_copay_amt_rpe           = 'Routine Phys Copay Amt'
	pbp_b14b_auth                    = 'Supp Prev Srvcs Enrollee Auth'
	pbp_b14b_refer_yn                = 'Immunizations Referral YN'
	pbp_b14c_bendesc_yn              = 'Routine Phys Ben Desc YN'
	pbp_b14c_bendesc_ehc             = 'Health Ed Ben Desc Enhance'
	pbp_b14c_bendesc_amo_hec         = 'Health Ed HEC Ben Desc MO'
	pbp_b14c_bendesc_amo_ntb         = 'Health Ed NTB Ben Desc MO'
	pbp_b14c_bendesc_amo_sc          = 'Health Ed SC Ben Desc MO'
	pbp_b14c_bendesc_amo_mhc         = 'Health Ed MHC Ben Desc MO'
	pbp_b14c_bendesc_amo_nhl         = 'Health Ed NHL Ben Desc MO'
	pbp_b14c_bendesc_amo_edm         = 'Health Ed EDM AMO'
	pbp_b14c_bendesc_amo_tm          = 'Health Ed TM AMO'
	pbp_b14c_bendesc_amo_wpt         = 'Health Ed WPT AMO'
	pbp_b14c_bendesc_amo_bsd         = 'BSD BENDESC_AMO Label'
	pbp_b14c_bendesc_amo_cs          = 'CS BENDESC_AMO Label'
	pbp_b14c_bendesc_amo_isa         = 'ISA BENDESC_AMO Label'
	pbp_b14c_bendesc_amo_prs         = 'PRS BENDESC_AMO Label'
	pbp_b14c_bendesc_amo_mnt         = 'MNT BENDESC_AMO Label'
	pbp_b14c_bendesc_amo_imr         = 'IMR BENDESC_AMO Label'
	pbp_b14c_bendesc_amo_rp          = 'RP BENDESC_AMO Label'
	pbp_b14c_bendesc_amo_wig         = 'WIG BENDESC_AMO Label'
	pbp_b14c_maxplan_yn              = 'Routine Phys Max Plan YN'
	pbp_b14c_maxplan_amt             = 'Routine Phys Max Plan Amt'
	pbp_b14c_maxplan_per             = 'Routine Phys Max Plan Per'
	pbp_b14c_maxenr_yn               = 'Routine Phys Max Enr YN'
	pbp_b14c_maxenr_amt              = 'Routine Phys Max Enr Amt'
	pbp_b14c_maxenr_per              = 'Routine Phys Max Enr Per'
	pbp_b14c_coins_yn                = 'Routine Phys Coinsurance YN'
	pbp_b14c_coins_ehc               = 'B14C Coins Enhance Bens'
	pbp_b14c_coins_pct_min_hec       = 'Health Ed HEC Min Coins Pct'
	pbp_b14c_coins_pct_max_hec       = 'Health Ed HEC Max Coins Pct'
	pbp_b14c_coins_pct_ntb           = 'Health Ed NTB Coins Pct'
	pbp_b14c_coins_pct_sc            = 'Health Ed SC Coins Pct'
	pbp_b14c_coins_pct_min_mhc       = 'Health Ed MHC Min Coins Pct'
	pbp_b14c_coins_pct_max_mhc       = 'Health Ed MHC Max Coins Pct'
	pbp_b14c_coins_pct_nhl           = 'Health Ed NHL Coins Pct'
	pbp_b14c_coins_pct_edm           = 'B14C EDM Coinsurance Pct'
	pbp_b14c_coins_pct_tm            = 'B14C TM Coinsurance Pct'
	pbp_b14c_coins_pct_wpt           = 'B14C WPT Coinsurance Pct'
	pbp_b14c_coins_pct_min_bsd       = 'BSD COINS_PCT_MIN Label'
	pbp_b14c_coins_pct_max_bsd       = 'BSD COINS_PCT_MAX Label'
	pbp_b14c_coins_pct_min_cs        = 'CS COINS_PCT_MIN Label'
	pbp_b14c_coins_pct_max_cs        = 'CS COINS_PCT_MAX Label'
	pbp_b14c_coins_pct_min_isa       = 'ISA COINS_PCT_MIN Label'
	pbp_b14c_coins_pct_max_isa       = 'ISA COINS_PCT_MAX Label'
	pbp_b14c_coins_pct_min_prs       = 'PRS COINS_PCT_MIN Label'
	pbp_b14c_coins_pct_max_prs       = 'PRS COINS_PCT_MAX Label'
	pbp_b14c_coins_pct_min_mnt       = 'MNT COINS_PCT_MIN Label'
	pbp_b14c_coins_pct_max_mnt       = 'MNT COINS_PCT_MAX Label'
	pbp_b14c_coins_pct_min_imr       = 'IMR COINS_PCT_MIN Label'
	pbp_b14c_coins_pct_max_imr       = 'IMR COINS_PCT_MAX Label'
	pbp_b14c_coins_pct_min_rp        = 'RP COINS_PCT_MIN Label'
	pbp_b14c_coins_pct_max_rp        = 'RP COINS_PCT_MAX Label'
	pbp_b14c_coins_pct_min_wig       = 'WIG COINS_PCT_MIN Label'
	pbp_b14c_coins_pct_max_wig       = 'WIG COINS_PCT_MAX Label'
	pbp_b14c_ded_yn                  = 'Routine Phys Deductible YN'
	pbp_b14c_ded_amt                 = 'Routine Phys Deductible Amt'
	pbp_b14c_copay_yn                = 'Routine Phys Copayment YN'
	pbp_b14c_copay_ehc               = '14C Copay Enhanced Bens'
	pbp_b14c_copay_hec_amt           = 'Health Ed HEC Copay Min Amt'
	pbp_b14c_copay_ntb_amt           = 'Health Ed NTB Copay Amt'
	pbp_b14c_copay_sc_amt            = 'Health Ed SC Copay Amt'
	pbp_b14c_copay_mhc_min_amt       = 'Health Ed MHC Min Copay Amt'
	pbp_b14c_copay_mhc_max_amt       = 'Health Ed MHC Max Copay Amt'
	pbp_b14c_copay_nhl_amt           = 'Health Ed NHL Copay Amt'
	pbp_b14c_copay_edm_amt           = 'B14C EDM Copayment Amt'
	pbp_b14c_copay_tm_amt            = 'B14C TM Copayment Amt'
	pbp_b14c_copay_wpt_amt           = 'B14C WPT Copayment Amt'
	pbp_b14c_copay_bsd_min_amt       = 'BSD COPAY_MIN Label'
	pbp_b14c_copay_bsd_max_amt       = 'BSD COPAY_MAX Label'
	pbp_b14c_copay_cs_min_amt        = 'CS COPAY_MIN Label'
	pbp_b14c_copay_cs_max_amt        = 'CS COPAY_MAX Label'
	pbp_b14c_copay_isa_min_amt       = 'ISA COPAY_MIN Label'
	pbp_b14c_copay_isa_max_amt       = 'ISA COPAY_MAX Label'
	pbp_b14c_copay_prs_min_amt       = 'PRS COPAY_MIN Label'
	pbp_b14c_copay_prs_max_amt       = 'PRS COPAY_MAX Label'
	pbp_b14c_copay_mnt_min_amt       = 'MNT COPAY_MIN Label'
	pbp_b14c_copay_mnt_max_amt       = 'MNT COPAY_MAX Label'
	pbp_b14c_copay_imr_min_amt       = 'IMR COPAY_MIN Label'
	pbp_b14c_copay_imr_max_amt       = 'IMR COPAY_MAX Label'
	pbp_b14c_copay_rp_min_amt        = 'RP COPAY_MIN Label'
	pbp_b14c_copay_rp_max_amt        = 'RP COPAY_MAX Label'
	pbp_b14c_copay_wig_min_amt       = 'WIG COPAY_MIN Label'
	pbp_b14c_copay_wig_max_amt       = 'WIG COPAY_MAX Label'
	pbp_b14c_auth                    = 'Routine Phys Enrollee Auth'
	pbp_b14c_refer_yn                = 'Routine Phys Referral YN'
	pbp_b14d_maxenr_yn               = 'Kidney Disease Max Enr YN'
	pbp_b14d_maxenr_amt              = 'Kidney Disease Max Enr Amt'
	pbp_b14d_maxenr_per              = 'Kidney Disease Max Enr Per'
	pbp_b14d_coins_yn                = 'Kideny Dis Coinsurance YN'
	pbp_b14d_coins_mc_min_pct        = 'Kideny Dis MC Min Coins Pct'
	pbp_b14d_coins_mc_max_pct        = 'Kideny Dis MC Max Coins Pct'
	pbp_b14d_ded_yn                  = 'Kideny Dis Deductible YN'
	pbp_b14d_ded_amt                 = 'Kideny Dis Deductible Amt'
	pbp_b14d_copay_yn                = 'Kideny Dis Copayment YN'
	pbp_b14d_copay_mc_min_amt        = 'Kideny Dis MC Min Copay Amt'
	pbp_b14d_copay_mc_max_amt        = 'Kideny DisMC Max Copay Amt'
	pbp_b14d_auth                    = 'Kideny Dis Enrollee Auth'
	pbp_b14d_refer_yn                = 'Kideny Dis Referral YN'
	pbp_b14e_maxenr_yn               = 'Diabetes Mon Max Enr YN'
	pbp_b14e_maxenr_amt              = 'Diabetes Mon Max Enr Amt'
	pbp_b14e_maxenr_per              = 'Diabetes Mon Max Enr Per'
	pbp_b14e_coins_yn                = 'Diabetes Mon Coinsurance YN'
	pbp_b14e_coins_pct               = 'Diabetes Mon MC Min Coins Pct'
	pbp_b14e_coins_max_pct           = 'Diabetes Mon MC Max Coins Pct'
	pbp_b14e_ded_yn                  = 'Diabetes Mon Deductible YN'
	pbp_b14e_ded_amt                 = 'Diabetes Mon Deductible Amt'
	pbp_b14e_copay_yn                = 'Diabetes Mon Copayment YN'
	pbp_b14e_copay_mc_min_amt        = 'Diabetes Mon MC Min Copay Amt'
	pbp_b14e_copay_mc_max_amt        = 'Diabetes Mon MC Max Copay Amt'
	pbp_b14e_cost_share              = 'Diabetes Mon Cost Share'
	pbp_b14e_cost_share_coins_yn     = 'Diabetes Cost Share Coin YN'
	pbp_b14e_cost_share_coins_min    = 'Diabetes Cost Share Coin Min'
	pbp_b14e_cost_share_coins_max    = 'Diabetes Cost Share Coin Max'
	pbp_b14e_cost_share_copay_yn     = 'Diabetes Cost Share Copay YN'
	pbp_b14e_cost_share_copay_min    = 'Diabetes Cost Share Copay Min'
	pbp_b14e_cost_share_copay_max    = 'Diabetes Cost Share Copay Max'
	pbp_b14e_auth                    = 'Diabetes Mon Enrollee Auth'
	pbp_b14e_refer_yn                = 'Diabetes Mon Referral YN'
;

run;

proc sort data = pbp_b14 out=out.pbp_b14;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b14(obs = 10);
  title 'pbp_b14_preventive file ';
run;

proc means data = out.pbp_b14;
  title 'pbp_b14_preventive file ';
run;

proc freq data = out.pbp_b14;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b14a_mc_prevent_attest
	pbp_b14a_auth
	pbp_b14a_refer_yn
	pbp_b14b_bendesc_yn
	pbp_b14b_bendesc_rpe_amo
	pbp_b14b_maxplan_yn
	pbp_b14b_maxenr_yn
	pbp_b14b_coins_yn
	pbp_b14b_ded_yn
	pbp_b14b_copay_yn
	pbp_b14b_auth
	pbp_b14b_refer_yn
	pbp_b14c_bendesc_yn
	pbp_b14c_bendesc_amo_hec
	pbp_b14c_bendesc_amo_ntb
	pbp_b14c_bendesc_amo_sc
	pbp_b14c_bendesc_amo_mhc
	pbp_b14c_bendesc_amo_nhl
	pbp_b14c_bendesc_amo_edm
	pbp_b14c_bendesc_amo_tm
	pbp_b14c_bendesc_amo_wpt
	pbp_b14c_bendesc_amo_bsd
	pbp_b14c_bendesc_amo_cs
	pbp_b14c_bendesc_amo_isa
	pbp_b14c_bendesc_amo_prs
	pbp_b14c_bendesc_amo_mnt
	pbp_b14c_bendesc_amo_imr
	pbp_b14c_bendesc_amo_rp
	pbp_b14c_bendesc_amo_wig
	pbp_b14c_maxplan_yn
	pbp_b14c_maxplan_per
	pbp_b14c_maxenr_yn
	pbp_b14c_maxenr_per
	pbp_b14c_coins_yn
	pbp_b14c_ded_yn
	pbp_b14c_copay_yn
	pbp_b14c_auth
	pbp_b14c_refer_yn
	pbp_b14d_maxenr_yn
	pbp_b14d_maxenr_per
	pbp_b14d_coins_yn
	pbp_b14d_ded_yn
	pbp_b14d_copay_yn
	pbp_b14d_auth
	pbp_b14d_refer_yn
	pbp_b14e_maxenr_yn
	pbp_b14e_maxenr_per
	pbp_b14e_coins_yn
	pbp_b14e_ded_yn
	pbp_b14e_copay_yn
	pbp_b14e_cost_share
	pbp_b14e_cost_share_coins_yn
	pbp_b14e_cost_share_copay_yn
	pbp_b14e_auth
	pbp_b14e_refer_yn
/ missing;
run;

proc contents data = out.pbp_b14;
  title 'pbp_b14 data';
run;
