*pbp_b1a_2.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b1a_2;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b1a_bendesc_yn_bonly         $1
	pbp_b1a_bendesc_amo_iact_bonly   $1
	pbp_b1a_bendesc_ulim_bonly       $1
	pbp_b1a_bendesc_per_bonly        $1
	pbp_b1a_maxplan_yn_bonly         $1
	pbp_b1a_maxplan_per_bonly        $1
	pbp_b1a_maxenr_yn_bonly          $1
	pbp_b1a_maxenr_per_bonly         $1
	pbp_b1a_coins_yn_bonly           $1
	pbp_b1a_coins_ps_num_bonly       $1
	pbp_b1a_ded_yn_bonly             $1
	pbp_b1a_copay_yn_bonly           $1
	pbp_b1a_copay_ps_num_bonly       $1
	pbp_b1a_auth_bonly               $5
	pbp_b1a_refer_yn_bonly           $1
;

infile '.\pbp\pbp_b1a_inpat_hosp_2.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b1a_bendesc_yn_bonly
	pbp_b1a_bendesc_amo_iact_bonly
	pbp_b1a_bendesc_ulim_bonly
	pbp_b1a_bendesc_amt_days_bonly
	pbp_b1a_bendesc_per_bonly
	pbp_b1a_maxplan_yn_bonly
	pbp_b1a_maxplan_amt_bonly
	pbp_b1a_maxplan_per_bonly
	pbp_b1a_maxenr_yn_bonly
	pbp_b1a_maxenr_amt_bonly
	pbp_b1a_maxenr_per_bonly
	pbp_b1a_coins_yn_bonly
	pbp_b1a_coins_pct_bonly
	pbp_b1a_coins_ps_num_bonly
	pbp_b1a_coins_ps_pct1_bonly
	pbp_b1a_coins_ps_bgnd1_bonly
	pbp_b1a_coins_ps_endd1_bonly
	pbp_b1a_coins_ps_pct2_bonly
	pbp_b1a_coins_ps_bgnd2_bonly
	pbp_b1a_coins_ps_endd2_bonly
	pbp_b1a_coins_ps_pct3_bonly
	pbp_b1a_coins_ps_bgnd3_bonly
	pbp_b1a_coins_ps_endd3_bonly
	pbp_b1a_ded_yn_bonly
	pbp_b1a_ded_amt_bonly
	pbp_b1a_copay_yn_bonly
	pbp_b1a_copay_amt_ps_bonly
	pbp_b1a_copay_ps_num_bonly
	pbp_b1a_copay_ps_amt1_bonly
	pbp_b1a_copay_ps_bgnd1_bonly
	pbp_b1a_copay_ps_endd1_bonly
	pbp_b1a_copay_ps_amt2_bonly
	pbp_b1a_copay_ps_bgnd2_bonly
	pbp_b1a_copay_ps_endd2_bonly
	pbp_b1a_copay_ps_amt3_bonly
	pbp_b1a_copay_ps_bgnd3_bonly
	pbp_b1a_copay_ps_endd3_bonly
	pbp_b1a_auth_bonly
	pbp_b1a_refer_yn_bonly
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b1a_bendesc_yn_bonly         = 'IHA(B) Ben Desc YN'
	pbp_b1a_bendesc_amo_iact_bonly   = 'IHA(B) Ben Desc AMO'
	pbp_b1a_bendesc_ulim_bonly       = 'IHA(B) Ben Desc Lim YN'
	pbp_b1a_bendesc_amt_days_bonly   = 'IHA(B) Ben Desc Num'
	pbp_b1a_bendesc_per_bonly        = 'IHA(B) Ben Desc Per'
	pbp_b1a_maxplan_yn_bonly         = 'IHA(B) Max Plan YN'
	pbp_b1a_maxplan_amt_bonly        = 'IHA(B) Max Plan Amt'
	pbp_b1a_maxplan_per_bonly        = 'IHA(B) Max Plan Per'
	pbp_b1a_maxenr_yn_bonly          = 'IHA(B) Max Enr YN'
	pbp_b1a_maxenr_amt_bonly         = 'IHA(B) Max Enr Amt'
	pbp_b1a_maxenr_per_bonly         = 'IHA(B) Max Enr Per'
	pbp_b1a_coins_yn_bonly           = 'IHA(B) Coinsurance YN'
	pbp_b1a_coins_pct_bonly          = 'IHA(B) Coins Pct'
	pbp_b1a_coins_ps_num_bonly       = 'IHA(B) PS Coins Interval Num'
	pbp_b1a_coins_ps_pct1_bonly      = 'IHA(B) PS Coins Pct Intrvl 1'
	pbp_b1a_coins_ps_bgnd1_bonly     = 'IHA(B) PS Coin Bgn Day Intrv 1'
	pbp_b1a_coins_ps_endd1_bonly     = 'IHA(B) PS Coin End Day Intrv 1'
	pbp_b1a_coins_ps_pct2_bonly      = 'IHA(B) PS Coins Pct Intrvl 2'
	pbp_b1a_coins_ps_bgnd2_bonly     = 'IHA(B) PS Coin Bgn Day Intrv 2'
	pbp_b1a_coins_ps_endd2_bonly     = 'IHA(B) PS Coin End Day Intrv 2'
	pbp_b1a_coins_ps_pct3_bonly      = 'IHA(B) PS Coins Pct Intrvl 3'
	pbp_b1a_coins_ps_bgnd3_bonly     = 'IHA(B) PS Coin Bgn Day Intrv 3'
	pbp_b1a_coins_ps_endd3_bonly     = 'IHA(B) PS Coin End Day Intrv 3'
	pbp_b1a_ded_yn_bonly             = 'IHA(B) Deductible YN'
	pbp_b1a_ded_amt_bonly            = 'IHA(B) Deductible Amt'
	pbp_b1a_copay_yn_bonly           = 'IHA(B) Copayment YN'
	pbp_b1a_copay_amt_ps_bonly       = 'IHA(B) PS Copay Amt'
	pbp_b1a_copay_ps_num_bonly       = 'IHA(B) PS Copay Interval Num'
	pbp_b1a_copay_ps_amt1_bonly      = 'IHA(B) PS Copay Amt Interval 1'
	pbp_b1a_copay_ps_bgnd1_bonly     = 'IHA(B) PS Cpay Beg Day Intrv 1'
	pbp_b1a_copay_ps_endd1_bonly     = 'IHA(B) PS Cpay End Day Intrv 1'
	pbp_b1a_copay_ps_amt2_bonly      = 'IHA(B) PS Copay Amt Interval 2'
	pbp_b1a_copay_ps_bgnd2_bonly     = 'IHA(B) PS Cpay Bgn Day Intrv 2'
	pbp_b1a_copay_ps_endd2_bonly     = 'IHA(B) PS Cpay End Day Intrv 2'
	pbp_b1a_copay_ps_amt3_bonly      = 'IHA(B) PS Copay Amt Interval 3'
	pbp_b1a_copay_ps_bgnd3_bonly     = 'IHA(B) PS Cpay Bgn Day Intrv 3'
	pbp_b1a_copay_ps_endd3_bonly     = 'IHA(B) PS Cpay End Day Intrv 3'
	pbp_b1a_auth_bonly               = 'IHA(B) Enrollee Auth'
	pbp_b1a_refer_yn_bonly           = 'IHA(B) Referral YN'
;

run;

proc sort data = pbp_b1a_2 out=out.pbp_b1a_2;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b1a_2(obs = 10);
  title 'pbp_b1a_inpat_hosp_2 file ';
run;

proc means data = out.pbp_b1a_2;
  title 'pbp_b1a_inpat_hosp_2 file ';
run;

proc freq data = out.pbp_b1a_2;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b1a_bendesc_yn_bonly
	pbp_b1a_bendesc_amo_iact_bonly
	pbp_b1a_bendesc_ulim_bonly
	pbp_b1a_bendesc_per_bonly
	pbp_b1a_maxplan_yn_bonly
	pbp_b1a_maxplan_per_bonly
	pbp_b1a_maxenr_yn_bonly
	pbp_b1a_maxenr_per_bonly
	pbp_b1a_coins_yn_bonly
	pbp_b1a_coins_ps_num_bonly
	pbp_b1a_ded_yn_bonly
	pbp_b1a_copay_yn_bonly
	pbp_b1a_copay_ps_num_bonly
	pbp_b1a_auth_bonly
	pbp_b1a_refer_yn_bonly
/ missing;
run;

proc contents data = out.pbp_b1a_2;
  title 'pbp_b1a_2 data';
run;