*pbp_b3.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b3;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b3_bendesc_yn                $1
	pbp_b3_bendesc_ehc               $3
	pbp_b3_bendesc_amo_crs           $1
	pbp_b3_bendesc_lim_crs           $1
	pbp_b3_bendesc_per_crs           $1
	pbp_b3_bendesc_amo_icrs          $1
	pbp_b3_bendesc_lim_icrs          $1
	pbp_b3_bendesc_per_icrs          $1
	pbp_b3_bendesc_amo_prs           $1
	pbp_b3_bendesc_lim_prs           $1
	pbp_b3_bendesc_per_prs           $1
	pbp_b3_maxenr_yn                 $1
	pbp_b3_maxenr_per                $1
	pbp_b3_coins_yn                  $1
	pbp_b3_coins_ehc                 $6
	pbp_b3_ded_yn                    $1
	pbp_b3_copay_yn                  $1
	pbp_b3_copay_ehc                 $6
	pbp_b3_auth                      $5
;

infile '.\pbp\pbp_b3_corf.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b3_bendesc_yn
	pbp_b3_bendesc_ehc
	pbp_b3_bendesc_amo_crs
	pbp_b3_bendesc_lim_crs
	pbp_b3_bendesc_numv_crs
	pbp_b3_bendesc_per_crs
	pbp_b3_bendesc_amo_icrs
	pbp_b3_bendesc_lim_icrs
	pbp_b3_bendesc_numv_icrs
	pbp_b3_bendesc_per_icrs
	pbp_b3_bendesc_amo_prs
	pbp_b3_bendesc_lim_prs
	pbp_b3_bendesc_numv_prs
	pbp_b3_bendesc_per_prs
	pbp_b3_maxenr_yn
	pbp_b3_maxenr_amt
	pbp_b3_maxenr_per
	pbp_b3_coins_yn
	pbp_b3_coins_ehc
	pbp_b3_coins_pct_mc_min_crs
	pbp_b3_coins_pct_mc_max_crs
	pbp_b3_coins_pct_mc_min_icrs
	pbp_b3_coins_pct_mc_max_icrs
	pbp_b3_coins_pct_mc_min_prs
	pbp_b3_coins_pct_mc_max_prs
	pbp_b3_coins_pct_min_crs
	pbp_b3_coins_pct_max_crs
	pbp_b3_coins_pct_min_icrs
	pbp_b3_coins_pct_max_icrs
	pbp_b3_coins_pct_min_prs
	pbp_b3_coins_pct_max_prs
	pbp_b3_ded_yn
	pbp_b3_ded_amt
	pbp_b3_copay_yn
	pbp_b3_copay_ehc
	pbp_b3_copay_amt_mc_min_crs
	pbp_b3_copay_amt_mc_max_crs
	pbp_b3_copay_amt_mc_min_icrs
	pbp_b3_copay_amt_mc_max_icrs
	pbp_b3_copay_amt_mc_min_prs
	pbp_b3_copay_amt_mc_max_prs
	pbp_b3_copay_amt_min_crs
	pbp_b3_copay_amt_max_crs
	pbp_b3_copay_amt_min_icrs
	pbp_b3_copay_amt_max_icrs
	pbp_b3_copay_amt_min_prs
	pbp_b3_copay_amt_max_prs
	pbp_b3_auth
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b3_bendesc_yn                = 'Cardiac Pulm Rehab Ben Desc YN'
	pbp_b3_bendesc_ehc               = 'Select enhanced benefits'
	pbp_b3_bendesc_amo_crs           = 'Cardiac Rehab Srvcs AMO'
	pbp_b3_bendesc_lim_crs           = 'benefit unlimited CHS?'
	pbp_b3_bendesc_numv_crs          = 'Num of Vists for CRS'
	pbp_b3_bendesc_per_crs           = 'CRS Num Visits Periodicity'
	pbp_b3_bendesc_amo_icrs          = 'Select  ICRS AMO'
	pbp_b3_bendesc_lim_icrs          = 'Benefit Unlimited ICRS?'
	pbp_b3_bendesc_numv_icrs         = 'Indicate num of visits ICRS'
	pbp_b3_bendesc_per_icrs          = 'Select ICRS periodicity'
	pbp_b3_bendesc_amo_prs           = 'Select benefit for AMO PRS'
	pbp_b3_bendesc_lim_prs           = 'Is benefit unlimited PRS?'
	pbp_b3_bendesc_numv_prs          = 'Indicate Num of Visits PRS'
	pbp_b3_bendesc_per_prs           = 'Select PRS periodicity'
	pbp_b3_maxenr_yn                 = 'Cardiac Rehab Max Enr YN'
	pbp_b3_maxenr_amt                = 'Cardiac Rehab Max Enr Amt'
	pbp_b3_maxenr_per                = 'Cardiac Rehab Max Enr Per'
	pbp_b3_coins_yn                  = 'Cardiac Rehab Coinsurance YN'
	pbp_b3_coins_ehc                 = 'Select Cardiac Srvcs Coin Enha'
	pbp_b3_coins_pct_mc_min_crs      = 'Cardiac Rehab MC Min Coins Pct'
	pbp_b3_coins_pct_mc_max_crs      = 'Cardiac Rehab MC Max Coins Pct'
	pbp_b3_coins_pct_mc_min_icrs     = 'Indicate Min Coins PCT MC ICRS'
	pbp_b3_coins_pct_mc_max_icrs     = 'Max Coins pct  MC ICRS'
	pbp_b3_coins_pct_mc_min_prs      = 'Indicate Min Coins Pct MC PRS'
	pbp_b3_coins_pct_mc_max_prs      = 'Indicate Max Coins PCT MC PRS'
	pbp_b3_coins_pct_min_crs         = 'Indicate Min Coins Pct Add CRS'
	pbp_b3_coins_pct_max_crs         = 'Indicate Max Coins PCT Add ICR'
	pbp_b3_coins_pct_min_icrs        = 'Indicate Min Coins PCT ICRS'
	pbp_b3_coins_pct_max_icrs        = 'Indicate Max Coins Pct ICRS'
	pbp_b3_coins_pct_min_prs         = 'Indicate Min Coins PCT PRS'
	pbp_b3_coins_pct_max_prs         = 'Indicate Max Coins PCT Add PRS'
	pbp_b3_ded_yn                    = 'Cardiac Rehab Deductible YN'
	pbp_b3_ded_amt                   = 'Cardiac Rehab Deductible Amt'
	pbp_b3_copay_yn                  = 'Cardiac Rehab Copayment YN'
	pbp_b3_copay_ehc                 = 'Cardiac Srvcs Copay Enhan'
	pbp_b3_copay_amt_mc_min_crs      = 'Cardiac Rehab MC Min Copay Amt'
	pbp_b3_copay_amt_mc_max_crs      = 'Cardiac Rehab MC Max Copay Amt'
	pbp_b3_copay_amt_mc_min_icrs     = 'Min Copay Amt MC ICRS'
	pbp_b3_copay_amt_mc_max_icrs     = 'Max Copay Amt MC ICRS'
	pbp_b3_copay_amt_mc_min_prs      = 'Min Copay Amount MC PRS'
	pbp_b3_copay_amt_mc_max_prs      = 'Max Copay Amt MC PRS'
	pbp_b3_copay_amt_min_crs         = 'Min Copay Amt Add CRS'
	pbp_b3_copay_amt_max_crs         = 'Max Copay Amt Add CRS'
	pbp_b3_copay_amt_min_icrs        = 'Min Copay Amt Add ICRS'
	pbp_b3_copay_amt_max_icrs        = 'Max Copay Amt Add ICRS'
	pbp_b3_copay_amt_min_prs         = 'Min Copay Amt Add PRS'
	pbp_b3_copay_amt_max_prs         = 'Max Copay Amt Add PRS'
	pbp_b3_auth                      = 'Cardiac Rehab Enrollee Auth'
;

run;

proc sort data = pbp_b3 out=out.pbp_b3;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b3(obs = 10);
  title 'pbp_b3_corf file ';
run;

proc means data = out.pbp_b3;
  title 'pbp_b3_corf file ';
run;

proc freq data = out.pbp_b3;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b3_bendesc_yn
	pbp_b3_bendesc_ehc
	pbp_b3_bendesc_amo_crs
	pbp_b3_bendesc_lim_crs
	pbp_b3_bendesc_per_crs
	pbp_b3_bendesc_amo_icrs
	pbp_b3_bendesc_lim_icrs
	pbp_b3_bendesc_per_icrs
	pbp_b3_bendesc_amo_prs
	pbp_b3_bendesc_lim_prs
	pbp_b3_bendesc_per_prs
	pbp_b3_maxenr_yn
	pbp_b3_maxenr_per
	pbp_b3_coins_yn
	pbp_b3_ded_yn
	pbp_b3_copay_yn
	pbp_b3_auth
/ missing;
run;

proc contents data = out.pbp_b3;
  title 'pbp_b3 data';
run;