*pbp_b15.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b15;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	mrx_b_max_oop_yn                 $1
	mrx_b_max_oop_per                $1
	mrx_b_coins_yn                   $1
	mrx_b_coins_ehc                  $2
	mrx_b_ded_yn                     $1
	mrx_b_copay_yn                   $1
	mrx_b_copay_ehc                  $2
	mrx_b_auth_yn                    $1
	mrx_b_hi_yn                      $1
	mrx_b_hi_mcaid_yn                $1
;

infile '.\pbp\pbp_b15_partb_rx_drugs.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	mrx_b_max_oop_yn
	mrx_b_max_oop_amt
	mrx_b_max_oop_per
	mrx_b_coins_yn
	mrx_b_coins_ehc
	mrx_b_chemo_coins_pct
	mrx_b_chemo_coins_max_pct
	mrx_b_coins_pct
	mrx_b_coins_max_pct
	mrx_b_ded_yn
	mrx_b_ded_amt
	mrx_b_copay_yn
	mrx_b_copay_ehc
	mrx_b_chemo_copay_amt
	mrx_b_chemo_copay_amt_max
	mrx_b_copay_min_amt
	mrx_b_copay_max_amt
	mrx_b_auth_yn
	mrx_b_hi_yn
	mrx_b_hi_mcaid_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	mrx_b_max_oop_yn                 = 'Part AB Max OOP YN'
	mrx_b_max_oop_amt                = 'Part AB Max OOP Amt'
	mrx_b_max_oop_per                = 'Part AB Max OOP Periodicity'
	mrx_b_coins_yn                   = 'Part AB Coinsurance YN'
	mrx_b_coins_ehc                  = 'Medicare PartB RX Drugs Coins'
	mrx_b_chemo_coins_pct            = 'Part AB Min Coinsurance Pct'
	mrx_b_chemo_coins_max_pct        = 'Part AB Max Coinsurance Pct'
	mrx_b_coins_pct                  = 'Part AB Min Coinsurance Pct'
	mrx_b_coins_max_pct              = 'Part AB Max Coinsurance Pct'
	mrx_b_ded_yn                     = 'Part AB Deductible YN'
	mrx_b_ded_amt                    = 'Part AB Deductible Amt'
	mrx_b_copay_yn                   = 'Part AB Copayment YN'
	mrx_b_copay_ehc                  = 'Medicare Part B Rx Drugs Copay'
	mrx_b_chemo_copay_amt            = 'Part AB Copay Min Amt'
	mrx_b_chemo_copay_amt_max        = 'Part AB Copay Max Amt'
	mrx_b_copay_min_amt              = 'Part AB Copay Min Amt'
	mrx_b_copay_max_amt              = 'Part AB Copay Max Amt'
	mrx_b_auth_yn                    = 'Part AB Authorization YN'
	mrx_b_hi_yn                      = 'Home Infusion'
	mrx_b_hi_mcaid_yn                = 'Home Infusion Medicaid'
;

run;

proc sort data = pbp_b15 out=out.pbp_b15;
  by pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b15(obs = 10);
  title 'pbp_b15_partb_rx_drugs file ';
run;

proc means data = out.pbp_b15;
  title 'pbp_b15_partb_rx_drugs file ';
run;

proc freq data = out.pbp_b15;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	mrx_b_max_oop_yn
	mrx_b_max_oop_per
	mrx_b_coins_yn
	mrx_b_coins_ehc
	mrx_b_ded_yn
	mrx_b_copay_yn
	mrx_b_copay_ehc
	mrx_b_auth_yn
	mrx_b_hi_yn
	mrx_b_hi_mcaid_yn
/ missing;
run;

proc contents data = out.pbp_b15;
  title 'pbp_b15 data';
run;