*pbp_b19b_vbid.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b19b_vbid;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_vbid_group_id                $2
	pbp_b19b_add_disease_state       $7
	pbp_b19b_add_prereq_yn           $1
	pbp_b19b_add_prereq              $3
	pbp_b19b_add_nmc_bendesc_cats    $550
	pbp_b19b_add_exempt_yn           $1
	pbp_b19b_add_apply_yn            $1
	pbp_b19b_add_exempt_nmc_cats     $550
;

infile '.\pbp\pbp_b19b_model_test_vbid.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_vbid_group_id
	pbp_b19b_add_disease_state
	pbp_b19b_add_prereq_yn
	pbp_b19b_add_prereq
	pbp_b19b_add_nmc_bendesc_cats
	pbp_b19b_add_exempt_yn
	pbp_b19b_add_apply_yn
	pbp_b19b_add_exempt_nmc_cats
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_vbid_group_id                = 'B19 VBID Group (Package) ID'
	pbp_b19b_add_disease_state       = 'Reduction Disease states'
	pbp_b19b_add_prereq_yn           = 'Additional prerequisite YN'
	pbp_b19b_add_prereq              = 'Additional prerequisite'
	pbp_b19b_add_nmc_bendesc_cats    = 'NMC Rdc Coin Benft Categories'
	pbp_b19b_add_exempt_yn           = 'Exempt deduct YN'
	pbp_b19b_add_apply_yn            = 'Apply OON/POS YN'
	pbp_b19b_add_exempt_nmc_cats     = 'NMC Rdc Coin Benft Categories'
;

run;

proc sort data = pbp_b19b_vbid out=out.pbp_b19b_vbid;
  by pbp_a_hnumber pbp_a_plan_identifier segment_id pbp_vbid_group_id;
run;

proc print data = out.pbp_b19b_vbid(obs = 10);
  title 'pbp_b19b_model_test_vbid file ';
run;

proc means data = out.pbp_b19b_vbid;
  title 'pbp_b19b_model_test_vbid file ';
run;

proc freq data = out.pbp_b19b_vbid;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_vbid_group_id
	pbp_b19b_add_prereq_yn
	pbp_b19b_add_prereq
	pbp_b19b_add_exempt_yn
	pbp_b19b_add_apply_yn
/ missing;
run;

proc contents data = out.pbp_b19b_vbid;
  title 'pbp_b19b_vbid data';
run;
