*pbp_mrx_p_vbid.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx_p_vbid;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	mrx_tier_group_id                $2
	mrx_tier_post_id                 $1
	mrx_tier_post_type_id            $1
	mrx_group_tiers_oop              $6
	mrx_tier_post_cost_struct_vb     $1
	mrx_tier_post_cost_share_vb      $1
	mrx_tier_post_part_drugs_vb      $1
	mrx_tier_post_part_includes_vb   $1
;

infile '.\pbp\pbp_mrx_p_vbid.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	mrx_tier_group_id
	mrx_tier_post_id
	mrx_tier_post_type_id
	mrx_group_tiers_oop
	mrx_tier_post_cost_struct_vb
	mrx_tier_post_cost_share_vb
	mrx_tier_post_part_drugs_vb
	mrx_tier_post_part_includes_vb
	mrx_tier_post_copay_min
	mrx_tier_post_copay_max
	mrx_tier_post_coins_min
	mrx_tier_post_coins_max
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	mrx_tier_group_id                = 'MRX VBID Group (Package) ID'
	mrx_tier_post_id                 = 'MRx Post Tier ID - OOP'
	mrx_tier_post_type_id            = 'MRx Post Tier Type ID'
	mrx_group_tiers_oop              = 'Rx vbid oopc tiers'
	mrx_tier_post_cost_struct_vb     = 'MRx Cost Share Tier Struct'
	mrx_tier_post_cost_share_vb      = 'MRx VBID Cost Share'
	mrx_tier_post_part_drugs_vb      = 'VBID Part Tier Drug Types'
	mrx_tier_post_part_includes_vb   = 'VBID Part Tier Includes'
	mrx_tier_post_copay_min          = 'MRx vbid post min Copay'
	mrx_tier_post_copay_max          = 'MRx vbid post max Copay'
	mrx_tier_post_coins_min          = 'MRx vbid post min coins'
	mrx_tier_post_coins_max          = 'MRx vbid post max coins'
;

run;

proc sort data = pbp_mrx_p_vbid out=out.pbp_mrx_p_vbid;
  by pbp_a_hnumber pbp_a_plan_identifier segment_id mrx_tier_group_id;
run;

proc print data = out.pbp_mrx_p_vbid(obs = 10);
  title 'pbp_mrx_p_vbid file ';
run;

proc means data = out.pbp_mrx_p_vbid;
  title 'pbp_mrx_p_vbid file ';
run;

proc freq data = out.pbp_mrx_p_vbid;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	mrx_tier_group_id
	mrx_tier_post_id
	mrx_tier_post_type_id
	mrx_tier_post_cost_struct_vb
	mrx_tier_post_cost_share_vb
	mrx_tier_post_part_drugs_vb
	mrx_tier_post_part_includes_vb
/ missing;
run;

proc contents data = out.pbp_mrx_p_vbid;
  title 'pbp_mrx_p_vbid data';
run;
