*pbp_mrx.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	part_d_model_demo                $1
	orgtype                          $2
	bid_id                           $13
	mrx_form_model_type              $5
	mrx_drug_ben_yn                  $1
	mrx_benefit_type                 $1
	mrx_partd_network_loc            $6
	mrx_ltc_attest_flag              $1
	mrx_floor_price_yn               $1
	mrx_ceiling_price_yn             $1
	mrx_first_fill                   $1
	mrx_quantity_limits              $1
	mrx_auth_ynba                    $1
	mrx_limit_ofc_yn                 $1
	mrx_step_ther_drugs_yn           $1
	mrx_otc_meds_pay_ump_yn          $1
	mrx_otc_meds_attest_flag         $1
	mrx_otc_step_therapy_yn          $1
	mrx_tier_form_ex                 $1
	mrx_tier_form_ex_2_yn            $1
	mrx_ae_oon_cstshr_struct         $1
	mrx_ae_cstshr_apply              $1
	mrx_form_model_desc              $255
	mrx_ae_ooptcs_apply              $1
	mrx_alt_ded_charge               $1
	mrx_alt_ded_type_yn              $1
	mrx_alt_no_ded_tier              $6
	mrx_alt_ded_tier_cstshr_yn       $1
	mrx_alt_gen_cstshr_struct        $1
	mrx_alt_oon_cstshr_struct        $1
	mrx_alt_red_cost_sharing         $1
	mrx_alt_red_cost_sharing_items   $4
	mrx_alt_excl_drugs_yn            $1
	mrx_alt_gap_covg_yn              $1
	mrx_alt_pre_icl_cost_share       $1
	mrx_alt_pre_icl_exclud_only_yn   $1
	mrx_alt_pre_icl_cost_share_mmp   $1
	mrx_alt_pre_icl_lis_mmp_yn       $1
	mrx_alt_pre_icl_lis_mmp_tiers    $6
	mrx_alt_cov_lmt_yn               $1
	mrx_alt_gap_covg_tier            $6
	mrx_alt_cstshr_post_oopt         $1
	mrx_post_exclud_only_yn          $1
	mrx_alt_cstshr_post_oopt_mmp     $1
	mrx_gen_loc_rstd                 $3
	mrx_gen_loc_oon                  $2
	mrx_gen_loc_mostd                $3
	mrx_gen_loc_ltc                  $1
	mrx_tier_extd_days_gen_yn        $1
	mrx_gen_extd_first_fill          $1
	mrx_avg_exp_cost_share_attest    $1
	mrx_snp_zerocost_attest          $1
	mrx_reduct_cost_yn               $1
	mrx_v_bid_attestation            $1
;

infile '.\pbp\pbp_mrx.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	part_d_model_demo
	mrx_form_model_type
	mrx_drug_ben_yn
	mrx_benefit_type
	mrx_partd_network_loc
	mrx_ltc_attest_flag
	mrx_floor_price_yn
	mrx_ceiling_price_yn
	mrx_first_fill
	mrx_quantity_limits
	mrx_auth_ynba
	mrx_limit_ofc_yn
	mrx_step_ther_drugs_yn
	mrx_otc_meds_pay_ump_yn
	mrx_otc_meds_attest_flag
	mrx_otc_step_therapy_yn
	mrx_formulary_tiers_num
	mrx_tier_form_ex
	mrx_tier_form_ex_2_yn
	mrx_tier_form_ex_2
	mrx_ae_oon_cstshr_struct
	mrx_ae_cstshr_apply
	mrx_form_model_desc
	mrx_ae_ooptcs_apply
	mrx_alt_ded_charge
	mrx_alt_ded_amount
	mrx_alt_ded_type_yn
	mrx_alt_no_ded_tier
	mrx_alt_ded_tier_cstshr_yn
	mrx_alt_gen_cstshr_struct
	mrx_alt_gen_coins_pct
	mrx_alt_gen_copay_amt
	mrx_alt_oon_cstshr_struct
	mrx_alt_red_cost_sharing
	mrx_alt_red_cost_sharing_items
	mrx_alt_excl_drugs_yn
	mrx_alt_gap_covg_yn
	mrx_alt_pre_icl_cost_share
	mrx_alt_pre_icl_exclud_only_yn
	mrx_alt_pre_icl_cost_share_mmp
	mrx_alt_pre_icl_lis_mmp_yn
	mrx_alt_pre_icl_lis_mmp_tiers
	mrx_alt_cov_lmt_yn
	mrx_alt_cov_lmt_amt
	mrx_alt_gap_covg_tier
	mrx_alt_cstshr_post_oopt
	mrx_post_exclud_only_yn
	mrx_alt_cstshr_post_oopt_mmp
	mrx_gen_loc_rstd
	mrx_gen_rstd_1m
	mrx_gen_rstd_2m
	mrx_gen_rstd_3m
	mrx_gen_loc_oon
	mrx_gen_oon_1m
	mrx_gen_oon_os
	mrx_gen_loc_mostd
	mrx_gen_mostd_1m
	mrx_gen_mostd_2m
	mrx_gen_mostd_3m
	mrx_gen_loc_ltc
	mrx_gen_ltc_1m
	mrx_tier_extd_days_gen_yn
	mrx_gen_extd_first_fill
	mrx_avg_exp_cost_share_attest
	mrx_snp_zerocost_attest
	mrx_reduct_cost_yn
	mrx_tier_group_num
	mrx_v_bid_attestation
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	part_d_model_demo                = 'Part D Model demonstration (CAT-D)'
	mrx_form_model_type              = 'MRX Tier Model Select'
	mrx_drug_ben_yn                  = 'MRx Drug Benefit YN'
	mrx_benefit_type                 = 'MRx Drug Benefit Type'
	mrx_partd_network_loc            = 'MRx PartD Network Location'
	mrx_ltc_attest_flag              = 'LTC Attest Flag'
	mrx_floor_price_yn               = 'Floor Pricing'
	mrx_ceiling_price_yn             = 'Does plan utilize ceiling pric'
	mrx_first_fill                   = 'MRx First Fill'
	mrx_quantity_limits              = 'MRx Quantity limits YN'
	mrx_auth_ynba                    = 'MRx Authorization YN'
	mrx_limit_ofc_yn                 = 'MRx Limit OnForm Covg YN'
	mrx_step_ther_drugs_yn           = 'MRx Step Therapy Drugs YN'
	mrx_otc_meds_pay_ump_yn          = 'MRx OTC Util Mngmt Program'
	mrx_otc_meds_attest_flag         = 'MRx OTC Med Attest Flag'
	mrx_otc_step_therapy_yn          = 'MRx OTC Step Therapy YN'
	mrx_formulary_tiers_num          = 'MRx Formulary Tiers Num'
	mrx_tier_form_ex                 = 'Form Ex Tier'
	mrx_tier_form_ex_2_yn            = 'MRX_EX_2_YN'
	mrx_tier_form_ex_2               = 'MRX_FORM_EX_2_NUM'
	mrx_ae_oon_cstshr_struct         = 'MRx AE Cstshr Structure'
	mrx_ae_cstshr_apply              = 'MRx AE Cstshr Pre-Intl Cov Lmt'
	mrx_form_model_desc              = 'Tier Label Description(s)'
	mrx_ae_ooptcs_apply              = 'MRx AE OOP Threshold Applct'
	mrx_alt_ded_charge               = 'MRx Alt BA Deduct Charged YN'
	mrx_alt_ded_amount               = 'MRx Alt Deductible Amount'
	mrx_alt_ded_type_yn              = 'MRx Alt BA Ded Tier YN'
	mrx_alt_no_ded_tier              = 'MRx Alt Non-Deductible Tiers'
	mrx_alt_ded_tier_cstshr_yn       = 'MRx Alt Tier Deduct Cost Share'
	mrx_alt_gen_cstshr_struct        = 'MRx Alt BA Cstshr Structure'
	mrx_alt_gen_coins_pct            = 'MRx Alt Coins Pct'
	mrx_alt_gen_copay_amt            = 'MRx Alt Copay Amt'
	mrx_alt_oon_cstshr_struct        = 'MRx Alt BA OON Cstshr Struct'
	mrx_alt_red_cost_sharing         = 'MRx Alt Red Cost Sharing'
	mrx_alt_red_cost_sharing_items   = 'MRx Alt Red Cost Sharing Items'
	mrx_alt_excl_drugs_yn            = 'MRx Alt Excluded supp drugs'
	mrx_alt_gap_covg_yn              = 'MRx Alt Add Gap Coverage'
	mrx_alt_pre_icl_cost_share       = 'MRx Alt Cstshr Pre-Int Cov Lmt'
	mrx_alt_pre_icl_exclud_only_yn   = 'Pre ICL Exclud drug only YN'
	mrx_alt_pre_icl_cost_share_mmp   = 'MMP Pre-ICL Cost Share Type'
	mrx_alt_pre_icl_lis_mmp_yn       = 'MMP LIS Cost Sharing YN'
	mrx_alt_pre_icl_lis_mmp_tiers    = 'MMP LIS Cost Share Tiers'
	mrx_alt_cov_lmt_yn               = 'MRx Alt Cov Lmt YN'
	mrx_alt_cov_lmt_amt              = 'MRx Alt Cov Lmt Amt'
	mrx_alt_gap_covg_tier            = 'MRx Alt Gap Tier Cov'
	mrx_alt_cstshr_post_oopt         = 'MRx Alt Cstshr Post OOPT'
	mrx_post_exclud_only_yn          = 'POST OOP Excluded only tier YN'
	mrx_alt_cstshr_post_oopt_mmp     = 'MRx Alt Cstshr Post OOPT MMP'
	mrx_gen_loc_rstd                 = 'MRx Gen INP Location'
	mrx_gen_rstd_1m                  = 'MRx Gen IN 1M Supply Days'
	mrx_gen_rstd_2m                  = 'MRx Gen IN 2M Supply Days'
	mrx_gen_rstd_3m                  = 'MRx Gen IN 3M Supply Days'
	mrx_gen_loc_oon                  = 'Out-of-Network Gen Loc'
	mrx_gen_oon_1m                   = 'MRx Gen OONP 1M Supply Days'
	mrx_gen_oon_os                   = 'MRx Gen OONP Oth Supply Days'
	mrx_gen_loc_mostd                = 'MO Pharmacy Gen Locations'
	mrx_gen_mostd_1m                 = 'MRx Gen MO 1M Supply Days'
	mrx_gen_mostd_2m                 = 'MRx Gen MO 2M Supply Days'
	mrx_gen_mostd_3m                 = 'MRx Gen MO 3M Supply Days'
	mrx_gen_loc_ltc                  = 'LTC Pharmacy 1M Location'
	mrx_gen_ltc_1m                   = 'LTC 1M Day Supply'
	mrx_tier_extd_days_gen_yn        = 'MRx Tier Extended Day Supply'
	mrx_gen_extd_first_fill          = 'MRX DS Extend First Fill'
	mrx_avg_exp_cost_share_attest    = 'MRX Avg Exp Cost Attest'
	mrx_snp_zerocost_attest          = 'MRX SNP Zero Cost Attest'
	mrx_reduct_cost_yn               = 'Rx Vbid YN'
	mrx_tier_group_num               = 'Rx Vbid Num Grps'
	mrx_v_bid_attestation            = 'VBID  Attestation'
;

run;

proc sort data = pbp_mrx out=out.pbp_mrx;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx(obs = 10);
  title 'pbp_mrx file ';
run;

proc means data = out.pbp_mrx;
  title 'pbp_mrx file ';
run;

proc freq data = out.pbp_mrx;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	mrx_drug_ben_yn
	mrx_benefit_type
	mrx_ltc_attest_flag
	mrx_floor_price_yn
	mrx_ceiling_price_yn
	mrx_first_fill
	mrx_quantity_limits
	mrx_auth_ynba
	mrx_limit_ofc_yn
	mrx_step_ther_drugs_yn
	mrx_otc_meds_pay_ump_yn
	mrx_otc_meds_attest_flag
	mrx_otc_step_therapy_yn
	mrx_tier_form_ex
	mrx_tier_form_ex_2_yn
	mrx_ae_oon_cstshr_struct
	mrx_ae_cstshr_apply
	mrx_ae_ooptcs_apply
	mrx_alt_ded_charge
	mrx_alt_ded_type_yn
	mrx_alt_ded_tier_cstshr_yn
	mrx_alt_gen_cstshr_struct
	mrx_alt_oon_cstshr_struct
	mrx_alt_red_cost_sharing
	mrx_alt_red_cost_sharing_items
	mrx_alt_excl_drugs_yn
	mrx_alt_gap_covg_yn
	mrx_alt_pre_icl_cost_share
	mrx_alt_pre_icl_exclud_only_yn
	mrx_alt_pre_icl_cost_share_mmp
	mrx_alt_pre_icl_lis_mmp_yn
	mrx_alt_cov_lmt_yn
	mrx_alt_cstshr_post_oopt
	mrx_post_exclud_only_yn
	mrx_alt_cstshr_post_oopt_mmp
	mrx_gen_loc_rstd
	mrx_gen_loc_oon
	mrx_gen_loc_mostd
	mrx_gen_loc_ltc
	mrx_tier_extd_days_gen_yn
	mrx_gen_extd_first_fill
	mrx_avg_exp_cost_share_attest
	mrx_snp_zerocost_attest
	mrx_reduct_cost_yn
	mrx_v_bid_attestation
/ missing;
run;

proc contents data = out.pbp_mrx;
  title 'pbp_mrx data';
run;
